# -*- coding: utf-8 -*-


class PlannedRunPollStatus(object):

    """Implementation of the 'PlannedRunPollStatus' model.

    Specifies whether run has been scheduled or not and also returns the
    unique run id along with failoverId upon scheduling the run.

    Attributes:
        failover_id (string): Specifies the unique failover Id which will be
            generated by orchestrator. This Id will be used to uniquely
            identify current failover operation.
        waiting_on_other_run_cancellations (bool): If cancelNonFailoverRuns
            was passed as true during creation of run for current failover
            then this will return the status of other run cacellations. If
            other runs are still pending for cancellations then this will be
            returned as true otherwise it will be return as false.
        run_id (string): If run has been scheduled then this field will be
            populated with unique run id.
        protection_group_id (string): Specifies the protection group id to
            which this run belongs.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "failover_id":'failoverId',
        "waiting_on_other_run_cancellations":'waitingOnOtherRunCancellations',
        "run_id":'runId',
        "protection_group_id":'protectionGroupId'
    }

    def __init__(self,
                 failover_id=None,
                 waiting_on_other_run_cancellations=None,
                 run_id=None,
                 protection_group_id=None):
        """Constructor for the PlannedRunPollStatus class"""

        # Initialize members of the class
        self.failover_id = failover_id
        self.waiting_on_other_run_cancellations = waiting_on_other_run_cancellations
        self.run_id = run_id
        self.protection_group_id = protection_group_id


    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object as
            obtained from the deserialization of the server's response. The keys
            MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary
        failover_id = dictionary.get('failoverId')
        waiting_on_other_run_cancellations = dictionary.get('waitingOnOtherRunCancellations')
        run_id = dictionary.get('runId')
        protection_group_id = dictionary.get('protectionGroupId')

        # Return an object of this model
        return cls(failover_id,
                   waiting_on_other_run_cancellations,
                   run_id,
                   protection_group_id)


