# -*- coding: utf-8 -*-
# Copyright 2021 Cohesity Inc.


class TenantProtectionPolicyUpdate(object):

    """Implementation of the 'TenantProtectionPolicyUpdate' model.

    Specifies protection policy update details response about a tenant.

    Attributes:
        policy_ids (list of string): Specifies the PolicyIds for respective
            tenant.
        tenant_id (string): Specifies the unique id of the tenant.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "policy_ids":'policyIds',
        "tenant_id":'tenantId'
    }

    def __init__(self,
                 policy_ids=None,
                 tenant_id=None):
        """Constructor for the TenantProtectionPolicyUpdate class"""

        # Initialize members of the class
        self.policy_ids = policy_ids
        self.tenant_id = tenant_id


    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object as
            obtained from the deserialization of the server's response. The keys
            MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary
        policy_ids = dictionary.get('policyIds')
        tenant_id = dictionary.get('tenantId')

        # Return an object of this model
        return cls(policy_ids,
                   tenant_id)


