# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['RadiusArgs', 'Radius']

@pulumi.input_type
class RadiusArgs:
    def __init__(__self__, *,
                 accounting_enabled: Optional[pulumi.Input[bool]] = None,
                 accounting_port: Optional[pulumi.Input[int]] = None,
                 auth_port: Optional[pulumi.Input[int]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 interim_update_interval: Optional[pulumi.Input[int]] = None,
                 secret: Optional[pulumi.Input[str]] = None,
                 site: Optional[pulumi.Input[str]] = None,
                 tunneled_reply: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a Radius resource.
        :param pulumi.Input[bool] accounting_enabled: Enable RADIUS accounting Defaults to `false`.
        :param pulumi.Input[int] accounting_port: The port for accounting communications. Defaults to `1813`.
        :param pulumi.Input[int] auth_port: The port for authentication communications. Defaults to `1812`.
        :param pulumi.Input[bool] enabled: RAIDUS server enabled. Defaults to `true`.
        :param pulumi.Input[int] interim_update_interval: Statistics will be collected from connected clients at this interval. Defaults to `3600`.
        :param pulumi.Input[str] secret: RAIDUS secret passphrase. Defaults to ``.
        :param pulumi.Input[str] site: The name of the site to associate the settings with.
        :param pulumi.Input[bool] tunneled_reply: Encrypt communication between the server and the client. Defaults to `true`.
        """
        if accounting_enabled is not None:
            pulumi.set(__self__, "accounting_enabled", accounting_enabled)
        if accounting_port is not None:
            pulumi.set(__self__, "accounting_port", accounting_port)
        if auth_port is not None:
            pulumi.set(__self__, "auth_port", auth_port)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if interim_update_interval is not None:
            pulumi.set(__self__, "interim_update_interval", interim_update_interval)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)
        if site is not None:
            pulumi.set(__self__, "site", site)
        if tunneled_reply is not None:
            pulumi.set(__self__, "tunneled_reply", tunneled_reply)

    @property
    @pulumi.getter(name="accountingEnabled")
    def accounting_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable RADIUS accounting Defaults to `false`.
        """
        return pulumi.get(self, "accounting_enabled")

    @accounting_enabled.setter
    def accounting_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "accounting_enabled", value)

    @property
    @pulumi.getter(name="accountingPort")
    def accounting_port(self) -> Optional[pulumi.Input[int]]:
        """
        The port for accounting communications. Defaults to `1813`.
        """
        return pulumi.get(self, "accounting_port")

    @accounting_port.setter
    def accounting_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "accounting_port", value)

    @property
    @pulumi.getter(name="authPort")
    def auth_port(self) -> Optional[pulumi.Input[int]]:
        """
        The port for authentication communications. Defaults to `1812`.
        """
        return pulumi.get(self, "auth_port")

    @auth_port.setter
    def auth_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "auth_port", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        RAIDUS server enabled. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="interimUpdateInterval")
    def interim_update_interval(self) -> Optional[pulumi.Input[int]]:
        """
        Statistics will be collected from connected clients at this interval. Defaults to `3600`.
        """
        return pulumi.get(self, "interim_update_interval")

    @interim_update_interval.setter
    def interim_update_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "interim_update_interval", value)

    @property
    @pulumi.getter
    def secret(self) -> Optional[pulumi.Input[str]]:
        """
        RAIDUS secret passphrase. Defaults to ``.
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret", value)

    @property
    @pulumi.getter
    def site(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the site to associate the settings with.
        """
        return pulumi.get(self, "site")

    @site.setter
    def site(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "site", value)

    @property
    @pulumi.getter(name="tunneledReply")
    def tunneled_reply(self) -> Optional[pulumi.Input[bool]]:
        """
        Encrypt communication between the server and the client. Defaults to `true`.
        """
        return pulumi.get(self, "tunneled_reply")

    @tunneled_reply.setter
    def tunneled_reply(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "tunneled_reply", value)


@pulumi.input_type
class _RadiusState:
    def __init__(__self__, *,
                 accounting_enabled: Optional[pulumi.Input[bool]] = None,
                 accounting_port: Optional[pulumi.Input[int]] = None,
                 auth_port: Optional[pulumi.Input[int]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 interim_update_interval: Optional[pulumi.Input[int]] = None,
                 secret: Optional[pulumi.Input[str]] = None,
                 site: Optional[pulumi.Input[str]] = None,
                 tunneled_reply: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering Radius resources.
        :param pulumi.Input[bool] accounting_enabled: Enable RADIUS accounting Defaults to `false`.
        :param pulumi.Input[int] accounting_port: The port for accounting communications. Defaults to `1813`.
        :param pulumi.Input[int] auth_port: The port for authentication communications. Defaults to `1812`.
        :param pulumi.Input[bool] enabled: RAIDUS server enabled. Defaults to `true`.
        :param pulumi.Input[int] interim_update_interval: Statistics will be collected from connected clients at this interval. Defaults to `3600`.
        :param pulumi.Input[str] secret: RAIDUS secret passphrase. Defaults to ``.
        :param pulumi.Input[str] site: The name of the site to associate the settings with.
        :param pulumi.Input[bool] tunneled_reply: Encrypt communication between the server and the client. Defaults to `true`.
        """
        if accounting_enabled is not None:
            pulumi.set(__self__, "accounting_enabled", accounting_enabled)
        if accounting_port is not None:
            pulumi.set(__self__, "accounting_port", accounting_port)
        if auth_port is not None:
            pulumi.set(__self__, "auth_port", auth_port)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if interim_update_interval is not None:
            pulumi.set(__self__, "interim_update_interval", interim_update_interval)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)
        if site is not None:
            pulumi.set(__self__, "site", site)
        if tunneled_reply is not None:
            pulumi.set(__self__, "tunneled_reply", tunneled_reply)

    @property
    @pulumi.getter(name="accountingEnabled")
    def accounting_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable RADIUS accounting Defaults to `false`.
        """
        return pulumi.get(self, "accounting_enabled")

    @accounting_enabled.setter
    def accounting_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "accounting_enabled", value)

    @property
    @pulumi.getter(name="accountingPort")
    def accounting_port(self) -> Optional[pulumi.Input[int]]:
        """
        The port for accounting communications. Defaults to `1813`.
        """
        return pulumi.get(self, "accounting_port")

    @accounting_port.setter
    def accounting_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "accounting_port", value)

    @property
    @pulumi.getter(name="authPort")
    def auth_port(self) -> Optional[pulumi.Input[int]]:
        """
        The port for authentication communications. Defaults to `1812`.
        """
        return pulumi.get(self, "auth_port")

    @auth_port.setter
    def auth_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "auth_port", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        RAIDUS server enabled. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="interimUpdateInterval")
    def interim_update_interval(self) -> Optional[pulumi.Input[int]]:
        """
        Statistics will be collected from connected clients at this interval. Defaults to `3600`.
        """
        return pulumi.get(self, "interim_update_interval")

    @interim_update_interval.setter
    def interim_update_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "interim_update_interval", value)

    @property
    @pulumi.getter
    def secret(self) -> Optional[pulumi.Input[str]]:
        """
        RAIDUS secret passphrase. Defaults to ``.
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret", value)

    @property
    @pulumi.getter
    def site(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the site to associate the settings with.
        """
        return pulumi.get(self, "site")

    @site.setter
    def site(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "site", value)

    @property
    @pulumi.getter(name="tunneledReply")
    def tunneled_reply(self) -> Optional[pulumi.Input[bool]]:
        """
        Encrypt communication between the server and the client. Defaults to `true`.
        """
        return pulumi.get(self, "tunneled_reply")

    @tunneled_reply.setter
    def tunneled_reply(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "tunneled_reply", value)


class Radius(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accounting_enabled: Optional[pulumi.Input[bool]] = None,
                 accounting_port: Optional[pulumi.Input[int]] = None,
                 auth_port: Optional[pulumi.Input[int]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 interim_update_interval: Optional[pulumi.Input[int]] = None,
                 secret: Optional[pulumi.Input[str]] = None,
                 site: Optional[pulumi.Input[str]] = None,
                 tunneled_reply: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        `setting.Radius` manages settings for the built-in RADIUS server.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] accounting_enabled: Enable RADIUS accounting Defaults to `false`.
        :param pulumi.Input[int] accounting_port: The port for accounting communications. Defaults to `1813`.
        :param pulumi.Input[int] auth_port: The port for authentication communications. Defaults to `1812`.
        :param pulumi.Input[bool] enabled: RAIDUS server enabled. Defaults to `true`.
        :param pulumi.Input[int] interim_update_interval: Statistics will be collected from connected clients at this interval. Defaults to `3600`.
        :param pulumi.Input[str] secret: RAIDUS secret passphrase. Defaults to ``.
        :param pulumi.Input[str] site: The name of the site to associate the settings with.
        :param pulumi.Input[bool] tunneled_reply: Encrypt communication between the server and the client. Defaults to `true`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[RadiusArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `setting.Radius` manages settings for the built-in RADIUS server.

        :param str resource_name: The name of the resource.
        :param RadiusArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RadiusArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accounting_enabled: Optional[pulumi.Input[bool]] = None,
                 accounting_port: Optional[pulumi.Input[int]] = None,
                 auth_port: Optional[pulumi.Input[int]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 interim_update_interval: Optional[pulumi.Input[int]] = None,
                 secret: Optional[pulumi.Input[str]] = None,
                 site: Optional[pulumi.Input[str]] = None,
                 tunneled_reply: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RadiusArgs.__new__(RadiusArgs)

            __props__.__dict__["accounting_enabled"] = accounting_enabled
            __props__.__dict__["accounting_port"] = accounting_port
            __props__.__dict__["auth_port"] = auth_port
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["interim_update_interval"] = interim_update_interval
            __props__.__dict__["secret"] = None if secret is None else pulumi.Output.secret(secret)
            __props__.__dict__["site"] = site
            __props__.__dict__["tunneled_reply"] = tunneled_reply
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["secret"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Radius, __self__).__init__(
            'unifi:setting/radius:Radius',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accounting_enabled: Optional[pulumi.Input[bool]] = None,
            accounting_port: Optional[pulumi.Input[int]] = None,
            auth_port: Optional[pulumi.Input[int]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            interim_update_interval: Optional[pulumi.Input[int]] = None,
            secret: Optional[pulumi.Input[str]] = None,
            site: Optional[pulumi.Input[str]] = None,
            tunneled_reply: Optional[pulumi.Input[bool]] = None) -> 'Radius':
        """
        Get an existing Radius resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] accounting_enabled: Enable RADIUS accounting Defaults to `false`.
        :param pulumi.Input[int] accounting_port: The port for accounting communications. Defaults to `1813`.
        :param pulumi.Input[int] auth_port: The port for authentication communications. Defaults to `1812`.
        :param pulumi.Input[bool] enabled: RAIDUS server enabled. Defaults to `true`.
        :param pulumi.Input[int] interim_update_interval: Statistics will be collected from connected clients at this interval. Defaults to `3600`.
        :param pulumi.Input[str] secret: RAIDUS secret passphrase. Defaults to ``.
        :param pulumi.Input[str] site: The name of the site to associate the settings with.
        :param pulumi.Input[bool] tunneled_reply: Encrypt communication between the server and the client. Defaults to `true`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RadiusState.__new__(_RadiusState)

        __props__.__dict__["accounting_enabled"] = accounting_enabled
        __props__.__dict__["accounting_port"] = accounting_port
        __props__.__dict__["auth_port"] = auth_port
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["interim_update_interval"] = interim_update_interval
        __props__.__dict__["secret"] = secret
        __props__.__dict__["site"] = site
        __props__.__dict__["tunneled_reply"] = tunneled_reply
        return Radius(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountingEnabled")
    def accounting_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable RADIUS accounting Defaults to `false`.
        """
        return pulumi.get(self, "accounting_enabled")

    @property
    @pulumi.getter(name="accountingPort")
    def accounting_port(self) -> pulumi.Output[Optional[int]]:
        """
        The port for accounting communications. Defaults to `1813`.
        """
        return pulumi.get(self, "accounting_port")

    @property
    @pulumi.getter(name="authPort")
    def auth_port(self) -> pulumi.Output[Optional[int]]:
        """
        The port for authentication communications. Defaults to `1812`.
        """
        return pulumi.get(self, "auth_port")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        RAIDUS server enabled. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="interimUpdateInterval")
    def interim_update_interval(self) -> pulumi.Output[Optional[int]]:
        """
        Statistics will be collected from connected clients at this interval. Defaults to `3600`.
        """
        return pulumi.get(self, "interim_update_interval")

    @property
    @pulumi.getter
    def secret(self) -> pulumi.Output[Optional[str]]:
        """
        RAIDUS secret passphrase. Defaults to ``.
        """
        return pulumi.get(self, "secret")

    @property
    @pulumi.getter
    def site(self) -> pulumi.Output[str]:
        """
        The name of the site to associate the settings with.
        """
        return pulumi.get(self, "site")

    @property
    @pulumi.getter(name="tunneledReply")
    def tunneled_reply(self) -> pulumi.Output[Optional[bool]]:
        """
        Encrypt communication between the server and the client. Defaults to `true`.
        """
        return pulumi.get(self, "tunneled_reply")

