# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'DevicePortOverride',
    'RadiusProfileAcctServer',
    'RadiusProfileAuthServer',
    'WlanSchedule',
]

@pulumi.output_type
class DevicePortOverride(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "portProfileId":
            suggest = "port_profile_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DevicePortOverride. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DevicePortOverride.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DevicePortOverride.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 number: int,
                 name: Optional[str] = None,
                 port_profile_id: Optional[str] = None):
        """
        :param int number: Switch port number.
        :param str name: Human-readable name of the port.
        :param str port_profile_id: ID of the Port Profile used on this port.
        """
        pulumi.set(__self__, "number", number)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port_profile_id is not None:
            pulumi.set(__self__, "port_profile_id", port_profile_id)

    @property
    @pulumi.getter
    def number(self) -> int:
        """
        Switch port number.
        """
        return pulumi.get(self, "number")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Human-readable name of the port.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="portProfileId")
    def port_profile_id(self) -> Optional[str]:
        """
        ID of the Port Profile used on this port.
        """
        return pulumi.get(self, "port_profile_id")


@pulumi.output_type
class RadiusProfileAcctServer(dict):
    def __init__(__self__, *,
                 ip: str,
                 xsecret: str,
                 port: Optional[int] = None):
        """
        :param str ip: IP address of accounting service server.
        :param str xsecret: RADIUS secret.
        :param int port: Port of accounting service. Defaults to `1813`.
        """
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "xsecret", xsecret)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def ip(self) -> str:
        """
        IP address of accounting service server.
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def xsecret(self) -> str:
        """
        RADIUS secret.
        """
        return pulumi.get(self, "xsecret")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        Port of accounting service. Defaults to `1813`.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class RadiusProfileAuthServer(dict):
    def __init__(__self__, *,
                 ip: str,
                 xsecret: str,
                 port: Optional[int] = None):
        """
        :param str ip: IP address of authentication service server.
        :param str xsecret: RADIUS secret.
        :param int port: Port of authentication service. Defaults to `1812`.
        """
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "xsecret", xsecret)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def ip(self) -> str:
        """
        IP address of authentication service server.
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def xsecret(self) -> str:
        """
        RADIUS secret.
        """
        return pulumi.get(self, "xsecret")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        Port of authentication service. Defaults to `1812`.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class WlanSchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dayOfWeek":
            suggest = "day_of_week"
        elif key == "startHour":
            suggest = "start_hour"
        elif key == "startMinute":
            suggest = "start_minute"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WlanSchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WlanSchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WlanSchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 day_of_week: str,
                 duration: int,
                 start_hour: int,
                 name: Optional[str] = None,
                 start_minute: Optional[int] = None):
        """
        :param str day_of_week: Day of week for the block. Valid values are `sun`, `mon`, `tue`, `wed`, `thu`, `fri`, `sat`.
        :param int duration: Length of the block in minutes.
        :param int start_hour: Start hour for the block (0-23).
        :param str name: Name of the block.
        :param int start_minute: Start minute for the block (0-59). Defaults to `0`.
        """
        pulumi.set(__self__, "day_of_week", day_of_week)
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "start_hour", start_hour)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if start_minute is not None:
            pulumi.set(__self__, "start_minute", start_minute)

    @property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> str:
        """
        Day of week for the block. Valid values are `sun`, `mon`, `tue`, `wed`, `thu`, `fri`, `sat`.
        """
        return pulumi.get(self, "day_of_week")

    @property
    @pulumi.getter
    def duration(self) -> int:
        """
        Length of the block in minutes.
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="startHour")
    def start_hour(self) -> int:
        """
        Start hour for the block (0-23).
        """
        return pulumi.get(self, "start_hour")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the block.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="startMinute")
    def start_minute(self) -> Optional[int]:
        """
        Start minute for the block (0-59). Defaults to `0`.
        """
        return pulumi.get(self, "start_minute")


