# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AccountArgs', 'Account']

@pulumi.input_type
class AccountArgs:
    def __init__(__self__, *,
                 password: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 site: Optional[pulumi.Input[str]] = None,
                 tunnel_medium_type: Optional[pulumi.Input[int]] = None,
                 tunnel_type: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a Account resource.
        :param pulumi.Input[str] password: The password of the account.
        :param pulumi.Input[str] name: The name of the account.
        :param pulumi.Input[str] network_id: ID of the network for this account
        :param pulumi.Input[str] site: The name of the site to associate the account with.
        :param pulumi.Input[int] tunnel_medium_type: See [RFC 2868](https://www.rfc-editor.org/rfc/rfc2868) section 3.2 Defaults to `6`.
        :param pulumi.Input[int] tunnel_type: See [RFC 2868](https://www.rfc-editor.org/rfc/rfc2868) section 3.1 Defaults to `13`.
        """
        pulumi.set(__self__, "password", password)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if site is not None:
            pulumi.set(__self__, "site", site)
        if tunnel_medium_type is not None:
            pulumi.set(__self__, "tunnel_medium_type", tunnel_medium_type)
        if tunnel_type is not None:
            pulumi.set(__self__, "tunnel_type", tunnel_type)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        The password of the account.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the network for this account
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter
    def site(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the site to associate the account with.
        """
        return pulumi.get(self, "site")

    @site.setter
    def site(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "site", value)

    @property
    @pulumi.getter(name="tunnelMediumType")
    def tunnel_medium_type(self) -> Optional[pulumi.Input[int]]:
        """
        See [RFC 2868](https://www.rfc-editor.org/rfc/rfc2868) section 3.2 Defaults to `6`.
        """
        return pulumi.get(self, "tunnel_medium_type")

    @tunnel_medium_type.setter
    def tunnel_medium_type(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "tunnel_medium_type", value)

    @property
    @pulumi.getter(name="tunnelType")
    def tunnel_type(self) -> Optional[pulumi.Input[int]]:
        """
        See [RFC 2868](https://www.rfc-editor.org/rfc/rfc2868) section 3.1 Defaults to `13`.
        """
        return pulumi.get(self, "tunnel_type")

    @tunnel_type.setter
    def tunnel_type(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "tunnel_type", value)


@pulumi.input_type
class _AccountState:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 site: Optional[pulumi.Input[str]] = None,
                 tunnel_medium_type: Optional[pulumi.Input[int]] = None,
                 tunnel_type: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering Account resources.
        :param pulumi.Input[str] name: The name of the account.
        :param pulumi.Input[str] network_id: ID of the network for this account
        :param pulumi.Input[str] password: The password of the account.
        :param pulumi.Input[str] site: The name of the site to associate the account with.
        :param pulumi.Input[int] tunnel_medium_type: See [RFC 2868](https://www.rfc-editor.org/rfc/rfc2868) section 3.2 Defaults to `6`.
        :param pulumi.Input[int] tunnel_type: See [RFC 2868](https://www.rfc-editor.org/rfc/rfc2868) section 3.1 Defaults to `13`.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if site is not None:
            pulumi.set(__self__, "site", site)
        if tunnel_medium_type is not None:
            pulumi.set(__self__, "tunnel_medium_type", tunnel_medium_type)
        if tunnel_type is not None:
            pulumi.set(__self__, "tunnel_type", tunnel_type)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the network for this account
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The password of the account.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def site(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the site to associate the account with.
        """
        return pulumi.get(self, "site")

    @site.setter
    def site(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "site", value)

    @property
    @pulumi.getter(name="tunnelMediumType")
    def tunnel_medium_type(self) -> Optional[pulumi.Input[int]]:
        """
        See [RFC 2868](https://www.rfc-editor.org/rfc/rfc2868) section 3.2 Defaults to `6`.
        """
        return pulumi.get(self, "tunnel_medium_type")

    @tunnel_medium_type.setter
    def tunnel_medium_type(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "tunnel_medium_type", value)

    @property
    @pulumi.getter(name="tunnelType")
    def tunnel_type(self) -> Optional[pulumi.Input[int]]:
        """
        See [RFC 2868](https://www.rfc-editor.org/rfc/rfc2868) section 3.1 Defaults to `13`.
        """
        return pulumi.get(self, "tunnel_type")

    @tunnel_type.setter
    def tunnel_type(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "tunnel_type", value)


class Account(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 site: Optional[pulumi.Input[str]] = None,
                 tunnel_medium_type: Optional[pulumi.Input[int]] = None,
                 tunnel_type: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        `Account` manages a RADIUS user account

        To authenticate devices based on MAC address, use the MAC address as the username and password under client creation.
        Convert lowercase letters to uppercase, and also remove colons or periods from the MAC address.

        ATTENTION: If the user profile does not include a VLAN, the client will fall back to the untagged VLAN.

        NOTE: MAC-based authentication accounts can only be used for wireless and wired clients. L2TP remote access does not apply.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: The name of the account.
        :param pulumi.Input[str] network_id: ID of the network for this account
        :param pulumi.Input[str] password: The password of the account.
        :param pulumi.Input[str] site: The name of the site to associate the account with.
        :param pulumi.Input[int] tunnel_medium_type: See [RFC 2868](https://www.rfc-editor.org/rfc/rfc2868) section 3.2 Defaults to `6`.
        :param pulumi.Input[int] tunnel_type: See [RFC 2868](https://www.rfc-editor.org/rfc/rfc2868) section 3.1 Defaults to `13`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AccountArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `Account` manages a RADIUS user account

        To authenticate devices based on MAC address, use the MAC address as the username and password under client creation.
        Convert lowercase letters to uppercase, and also remove colons or periods from the MAC address.

        ATTENTION: If the user profile does not include a VLAN, the client will fall back to the untagged VLAN.

        NOTE: MAC-based authentication accounts can only be used for wireless and wired clients. L2TP remote access does not apply.

        :param str resource_name: The name of the resource.
        :param AccountArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccountArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 site: Optional[pulumi.Input[str]] = None,
                 tunnel_medium_type: Optional[pulumi.Input[int]] = None,
                 tunnel_type: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccountArgs.__new__(AccountArgs)

            __props__.__dict__["name"] = name
            __props__.__dict__["network_id"] = network_id
            if password is None and not opts.urn:
                raise TypeError("Missing required property 'password'")
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["site"] = site
            __props__.__dict__["tunnel_medium_type"] = tunnel_medium_type
            __props__.__dict__["tunnel_type"] = tunnel_type
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Account, __self__).__init__(
            'unifi:index/account:Account',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            name: Optional[pulumi.Input[str]] = None,
            network_id: Optional[pulumi.Input[str]] = None,
            password: Optional[pulumi.Input[str]] = None,
            site: Optional[pulumi.Input[str]] = None,
            tunnel_medium_type: Optional[pulumi.Input[int]] = None,
            tunnel_type: Optional[pulumi.Input[int]] = None) -> 'Account':
        """
        Get an existing Account resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: The name of the account.
        :param pulumi.Input[str] network_id: ID of the network for this account
        :param pulumi.Input[str] password: The password of the account.
        :param pulumi.Input[str] site: The name of the site to associate the account with.
        :param pulumi.Input[int] tunnel_medium_type: See [RFC 2868](https://www.rfc-editor.org/rfc/rfc2868) section 3.2 Defaults to `6`.
        :param pulumi.Input[int] tunnel_type: See [RFC 2868](https://www.rfc-editor.org/rfc/rfc2868) section 3.1 Defaults to `13`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AccountState.__new__(_AccountState)

        __props__.__dict__["name"] = name
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["password"] = password
        __props__.__dict__["site"] = site
        __props__.__dict__["tunnel_medium_type"] = tunnel_medium_type
        __props__.__dict__["tunnel_type"] = tunnel_type
        return Account(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the account.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[Optional[str]]:
        """
        ID of the network for this account
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[str]:
        """
        The password of the account.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def site(self) -> pulumi.Output[str]:
        """
        The name of the site to associate the account with.
        """
        return pulumi.get(self, "site")

    @property
    @pulumi.getter(name="tunnelMediumType")
    def tunnel_medium_type(self) -> pulumi.Output[Optional[int]]:
        """
        See [RFC 2868](https://www.rfc-editor.org/rfc/rfc2868) section 3.2 Defaults to `6`.
        """
        return pulumi.get(self, "tunnel_medium_type")

    @property
    @pulumi.getter(name="tunnelType")
    def tunnel_type(self) -> pulumi.Output[Optional[int]]:
        """
        See [RFC 2868](https://www.rfc-editor.org/rfc/rfc2868) section 3.1 Defaults to `13`.
        """
        return pulumi.get(self, "tunnel_type")

