#!/usr/bin/env python

import setuptools

with open("README.md", "rb") as fh:
    long_description = fh.read().decode('utf-8')

# See https://packaging.python.org/tutorials/packaging-projects/ for details
setuptools.setup(
    name="debuggingbook",
    version="0.9.0",
    author="Andreas Zeller",
    author_email="zeller@cispa.de",
    description="Code for 'The Debugging Book' (https://www.debuggingbook.org/)",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://www.debuggingbook.org/",
    packages=['debuggingbook', 'debuggingbook.bookutils'],
    # packages=setuptools.find_packages(),

    # See https://pypi.org/classifiers/
    classifiers=[
        "Development Status :: 3 - Alpha",
        "Framework :: Jupyter",
        "Intended Audience :: Developers",
        "Intended Audience :: Education",
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
        "Topic :: Software Development :: Debuggers",
        "Topic :: Software Development :: Testing",
        "Topic :: Education :: Testing",
        "Topic :: Software Development :: Quality Assurance",
        "Topic :: Security"
    ],
)
