#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# "Debugging Concurrent Programs" - a chapter of "The Debugging Book"
# Web site: https://www.debuggingbook.org/html/ThreadDebugger.html
# Last change: 2021-03-07 12:27:28+01:00
#
# Copyright (c) 2021 CISPA Helmholtz Center for Information Security
# Copyright (c) 2018-2020 Saarland University, authors, and contributors
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the
# "Software"), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, merge, publish,
# distribute, sublicense, and/or sell copies of the Software, and to
# permit persons to whom the Software is furnished to do so, subject to
# the following conditions:
#
# The above copyright notice and this permission notice shall be included
# in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
# OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
# IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
# CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
# TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
# SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

r'''
The Debugging Book - Debugging Concurrent Programs

This file can be _executed_ as a script, running all experiments:

    $ python ThreadDebugger.py

or _imported_ as a package, providing classes, functions, and constants:

    >>> from debuggingbook.ThreadDebugger import <identifier>
    
but before you do so, _read_ it and _interact_ with it at:

    https://www.debuggingbook.org/html/ThreadDebugger.html

_For those only interested in using the code in this chapter (without wanting to know how it works), give an example.  This will be copied to the beginning of the chapter (before the first section) as text with rendered input and output._


For more details, source, and documentation, see
"The Debugging Book - Debugging Concurrent Programs"
at https://www.debuggingbook.org/html/ThreadDebugger.html
'''


# Allow to use 'from . import <module>' when run as script (cf. PEP 366)
if __name__ == '__main__' and __package__ is None:
    __package__ = 'debuggingbook'


# Debugging Concurrent Programs
# =============================

if __name__ == '__main__':
    print('# Debugging Concurrent Programs')



if __name__ == '__main__':
    from .bookutils import YouTubeVideo
    YouTubeVideo("w4u5gCgPlmg")

if __name__ == '__main__':
    # We use the same fixed seed as the notebook to ensure consistency
    import random
    random.seed(2001)

## Synopsis
## --------

if __name__ == '__main__':
    print('\n## Synopsis')



## _Section 1_
## -----------

if __name__ == '__main__':
    print('\n## _Section 1_')



## Synopsis
## --------

if __name__ == '__main__':
    print('\n## Synopsis')



## Lessons Learned
## ---------------

if __name__ == '__main__':
    print('\n## Lessons Learned')



## Next Steps
## ----------

if __name__ == '__main__':
    print('\n## Next Steps')



## Background
## ----------

if __name__ == '__main__':
    print('\n## Background')



## Exercises
## ---------

if __name__ == '__main__':
    print('\n## Exercises')



### Exercise 1: _Title_

if __name__ == '__main__':
    print('\n### Exercise 1: _Title_')



if __name__ == '__main__':
    pass

if __name__ == '__main__':
    2 + 2

### Exercise 2: _Title_

if __name__ == '__main__':
    print('\n### Exercise 2: _Title_')


