"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnReportDefinition = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright 2012-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
// Generated from the AWS CloudFormation Resource Specification
// See: docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-resource-specification.html
// @cfn2ts:meta@ {"generated":"2022-09-28T17:21:55.911Z","fingerprint":"HIlqYGATYOaKGJYe0gn/bTs6VRtUNy1c7XXOzKtsTgg="}
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
const cdk = require("@aws-cdk/core");
const cfn_parse = require("@aws-cdk/core/lib/helpers-internal");
/**
 * Determine whether the given properties match those of a `CfnReportDefinitionProps`
 *
 * @param properties - the TypeScript properties of a `CfnReportDefinitionProps`
 *
 * @returns the result of the validation.
 */
function CfnReportDefinitionPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('additionalArtifacts', cdk.listValidator(cdk.validateString))(properties.additionalArtifacts));
    errors.collect(cdk.propertyValidator('additionalSchemaElements', cdk.listValidator(cdk.validateString))(properties.additionalSchemaElements));
    errors.collect(cdk.propertyValidator('billingViewArn', cdk.validateString)(properties.billingViewArn));
    errors.collect(cdk.propertyValidator('compression', cdk.requiredValidator)(properties.compression));
    errors.collect(cdk.propertyValidator('compression', cdk.validateString)(properties.compression));
    errors.collect(cdk.propertyValidator('format', cdk.requiredValidator)(properties.format));
    errors.collect(cdk.propertyValidator('format', cdk.validateString)(properties.format));
    errors.collect(cdk.propertyValidator('refreshClosedReports', cdk.requiredValidator)(properties.refreshClosedReports));
    errors.collect(cdk.propertyValidator('refreshClosedReports', cdk.validateBoolean)(properties.refreshClosedReports));
    errors.collect(cdk.propertyValidator('reportName', cdk.requiredValidator)(properties.reportName));
    errors.collect(cdk.propertyValidator('reportName', cdk.validateString)(properties.reportName));
    errors.collect(cdk.propertyValidator('reportVersioning', cdk.requiredValidator)(properties.reportVersioning));
    errors.collect(cdk.propertyValidator('reportVersioning', cdk.validateString)(properties.reportVersioning));
    errors.collect(cdk.propertyValidator('s3Bucket', cdk.requiredValidator)(properties.s3Bucket));
    errors.collect(cdk.propertyValidator('s3Bucket', cdk.validateString)(properties.s3Bucket));
    errors.collect(cdk.propertyValidator('s3Prefix', cdk.requiredValidator)(properties.s3Prefix));
    errors.collect(cdk.propertyValidator('s3Prefix', cdk.validateString)(properties.s3Prefix));
    errors.collect(cdk.propertyValidator('s3Region', cdk.requiredValidator)(properties.s3Region));
    errors.collect(cdk.propertyValidator('s3Region', cdk.validateString)(properties.s3Region));
    errors.collect(cdk.propertyValidator('timeUnit', cdk.requiredValidator)(properties.timeUnit));
    errors.collect(cdk.propertyValidator('timeUnit', cdk.validateString)(properties.timeUnit));
    return errors.wrap('supplied properties not correct for "CfnReportDefinitionProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::CUR::ReportDefinition` resource
 *
 * @param properties - the TypeScript properties of a `CfnReportDefinitionProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::CUR::ReportDefinition` resource.
 */
// @ts-ignore TS6133
function cfnReportDefinitionPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnReportDefinitionPropsValidator(properties).assertSuccess();
    return {
        Compression: cdk.stringToCloudFormation(properties.compression),
        Format: cdk.stringToCloudFormation(properties.format),
        RefreshClosedReports: cdk.booleanToCloudFormation(properties.refreshClosedReports),
        ReportName: cdk.stringToCloudFormation(properties.reportName),
        ReportVersioning: cdk.stringToCloudFormation(properties.reportVersioning),
        S3Bucket: cdk.stringToCloudFormation(properties.s3Bucket),
        S3Prefix: cdk.stringToCloudFormation(properties.s3Prefix),
        S3Region: cdk.stringToCloudFormation(properties.s3Region),
        TimeUnit: cdk.stringToCloudFormation(properties.timeUnit),
        AdditionalArtifacts: cdk.listMapper(cdk.stringToCloudFormation)(properties.additionalArtifacts),
        AdditionalSchemaElements: cdk.listMapper(cdk.stringToCloudFormation)(properties.additionalSchemaElements),
        BillingViewArn: cdk.stringToCloudFormation(properties.billingViewArn),
    };
}
// @ts-ignore TS6133
function CfnReportDefinitionPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('compression', 'Compression', cfn_parse.FromCloudFormation.getString(properties.Compression));
    ret.addPropertyResult('format', 'Format', cfn_parse.FromCloudFormation.getString(properties.Format));
    ret.addPropertyResult('refreshClosedReports', 'RefreshClosedReports', cfn_parse.FromCloudFormation.getBoolean(properties.RefreshClosedReports));
    ret.addPropertyResult('reportName', 'ReportName', cfn_parse.FromCloudFormation.getString(properties.ReportName));
    ret.addPropertyResult('reportVersioning', 'ReportVersioning', cfn_parse.FromCloudFormation.getString(properties.ReportVersioning));
    ret.addPropertyResult('s3Bucket', 'S3Bucket', cfn_parse.FromCloudFormation.getString(properties.S3Bucket));
    ret.addPropertyResult('s3Prefix', 'S3Prefix', cfn_parse.FromCloudFormation.getString(properties.S3Prefix));
    ret.addPropertyResult('s3Region', 'S3Region', cfn_parse.FromCloudFormation.getString(properties.S3Region));
    ret.addPropertyResult('timeUnit', 'TimeUnit', cfn_parse.FromCloudFormation.getString(properties.TimeUnit));
    ret.addPropertyResult('additionalArtifacts', 'AdditionalArtifacts', properties.AdditionalArtifacts != null ? cfn_parse.FromCloudFormation.getStringArray(properties.AdditionalArtifacts) : undefined);
    ret.addPropertyResult('additionalSchemaElements', 'AdditionalSchemaElements', properties.AdditionalSchemaElements != null ? cfn_parse.FromCloudFormation.getStringArray(properties.AdditionalSchemaElements) : undefined);
    ret.addPropertyResult('billingViewArn', 'BillingViewArn', properties.BillingViewArn != null ? cfn_parse.FromCloudFormation.getString(properties.BillingViewArn) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::CUR::ReportDefinition`
 *
 * The definition of AWS Cost and Usage Report. You can specify the report name, time unit, report format, compression format, S3 bucket, additional artifacts, and schema elements in the definition.
 *
 * @cloudformationResource AWS::CUR::ReportDefinition
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cur-reportdefinition.html
 */
class CfnReportDefinition extends cdk.CfnResource {
    /**
     * Create a new `AWS::CUR::ReportDefinition`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnReportDefinition.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_cur_CfnReportDefinitionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnReportDefinition);
            }
            throw error;
        }
        cdk.requireProperty(props, 'compression', this);
        cdk.requireProperty(props, 'format', this);
        cdk.requireProperty(props, 'refreshClosedReports', this);
        cdk.requireProperty(props, 'reportName', this);
        cdk.requireProperty(props, 'reportVersioning', this);
        cdk.requireProperty(props, 's3Bucket', this);
        cdk.requireProperty(props, 's3Prefix', this);
        cdk.requireProperty(props, 's3Region', this);
        cdk.requireProperty(props, 'timeUnit', this);
        this.compression = props.compression;
        this.format = props.format;
        this.refreshClosedReports = props.refreshClosedReports;
        this.reportName = props.reportName;
        this.reportVersioning = props.reportVersioning;
        this.s3Bucket = props.s3Bucket;
        this.s3Prefix = props.s3Prefix;
        this.s3Region = props.s3Region;
        this.timeUnit = props.timeUnit;
        this.additionalArtifacts = props.additionalArtifacts;
        this.additionalSchemaElements = props.additionalSchemaElements;
        this.billingViewArn = props.billingViewArn;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnReportDefinitionPropsFromCloudFormation(resourceProperties);
        const ret = new CfnReportDefinition(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnReportDefinition.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            compression: this.compression,
            format: this.format,
            refreshClosedReports: this.refreshClosedReports,
            reportName: this.reportName,
            reportVersioning: this.reportVersioning,
            s3Bucket: this.s3Bucket,
            s3Prefix: this.s3Prefix,
            s3Region: this.s3Region,
            timeUnit: this.timeUnit,
            additionalArtifacts: this.additionalArtifacts,
            additionalSchemaElements: this.additionalSchemaElements,
            billingViewArn: this.billingViewArn,
        };
    }
    renderProperties(props) {
        return cfnReportDefinitionPropsToCloudFormation(props);
    }
}
exports.CfnReportDefinition = CfnReportDefinition;
_a = JSII_RTTI_SYMBOL_1;
CfnReportDefinition[_a] = { fqn: "@aws-cdk/aws-cur.CfnReportDefinition", version: "1.175.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnReportDefinition.CFN_RESOURCE_TYPE_NAME = "AWS::CUR::ReportDefinition";
//# sourceMappingURL=data:application/json;base64,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