from pandas import Timestamp

# Chinese holidays are quite irregular because
# 1. some of the holidays are base on traditional Chinese calendar (lunisolar)
# 2. the government tries very hard to arrange multi-day holidays
# and is not consistent in ways of doing so.

# So instead of writing rules for them, it's much cleaner to just use
# all past holidays as ad hoc holidays.
#
# Records start from 1992. SSE was founded at the end of 1990.

all_holidays = [
    Timestamp('1991-01-01'),
    Timestamp('1991-02-15'),
    Timestamp('1991-02-18'),
    Timestamp('1991-05-01'),
    Timestamp('1991-10-01'),
    Timestamp('1991-10-02'),
    Timestamp('1992-01-01'),
    Timestamp('1992-02-04'),
    Timestamp('1992-02-05'),
    Timestamp('1992-02-06'),
    Timestamp('1992-05-01'),
    Timestamp('1992-10-01'),
    Timestamp('1992-10-02'),
    Timestamp('1993-01-01'),
    Timestamp('1993-01-25'),
    Timestamp('1993-01-26'),
    Timestamp('1993-10-01'),
    Timestamp('1994-02-07'),
    Timestamp('1994-02-08'),
    Timestamp('1994-02-09'),
    Timestamp('1994-02-10'),
    Timestamp('1994-02-11'),
    Timestamp('1994-05-02'),
    Timestamp('1994-10-03'),
    Timestamp('1994-10-04'),
    Timestamp('1995-01-02'),
    Timestamp('1995-01-30'),
    Timestamp('1995-01-31'),
    Timestamp('1995-02-01'),
    Timestamp('1995-02-02'),
    Timestamp('1995-02-03'),
    Timestamp('1995-05-01'),
    Timestamp('1995-10-02'),
    Timestamp('1995-10-03'),
    Timestamp('1996-01-01'),
    Timestamp('1996-02-19'),
    Timestamp('1996-02-20'),
    Timestamp('1996-02-21'),
    Timestamp('1996-02-22'),
    Timestamp('1996-02-23'),
    Timestamp('1996-02-26'),
    Timestamp('1996-02-27'),
    Timestamp('1996-02-28'),
    Timestamp('1996-02-29'),
    Timestamp('1996-03-01'),
    Timestamp('1996-05-01'),
    Timestamp('1996-09-30'),
    Timestamp('1996-10-01'),
    Timestamp('1996-10-02'),
    Timestamp('1997-01-01'),
    Timestamp('1997-02-03'),
    Timestamp('1997-02-04'),
    Timestamp('1997-02-05'),
    Timestamp('1997-02-06'),
    Timestamp('1997-02-07'),
    Timestamp('1997-02-10'),
    Timestamp('1997-02-11'),
    Timestamp('1997-02-12'),
    Timestamp('1997-02-13'),
    Timestamp('1997-02-14'),
    Timestamp('1997-05-01'),
    Timestamp('1997-05-02'),
    Timestamp('1997-06-30'),
    Timestamp('1997-07-01'),
    Timestamp('1997-10-01'),
    Timestamp('1997-10-02'),
    Timestamp('1997-10-03'),
    Timestamp('1998-01-01'),
    Timestamp('1998-01-02'),
    Timestamp('1998-01-26'),
    Timestamp('1998-01-27'),
    Timestamp('1998-01-28'),
    Timestamp('1998-01-29'),
    Timestamp('1998-01-30'),
    Timestamp('1998-02-02'),
    Timestamp('1998-02-03'),
    Timestamp('1998-02-04'),
    Timestamp('1998-02-05'),
    Timestamp('1998-02-06'),
    Timestamp('1998-05-01'),
    Timestamp('1998-10-01'),
    Timestamp('1998-10-02'),
    Timestamp('1999-01-01'),
    Timestamp('1999-02-10'),
    Timestamp('1999-02-11'),
    Timestamp('1999-02-12'),
    Timestamp('1999-02-15'),
    Timestamp('1999-02-16'),
    Timestamp('1999-02-17'),
    Timestamp('1999-02-18'),
    Timestamp('1999-02-19'),
    Timestamp('1999-02-22'),
    Timestamp('1999-02-23'),
    Timestamp('1999-02-24'),
    Timestamp('1999-02-25'),
    Timestamp('1999-02-26'),
    Timestamp('1999-05-03'),
    Timestamp('1999-10-01'),
    Timestamp('1999-10-04'),
    Timestamp('1999-10-05'),
    Timestamp('1999-10-06'),
    Timestamp('1999-10-07'),
    Timestamp('1999-12-20'),
    Timestamp('1999-12-31'),
    Timestamp('2000-01-03'),
    Timestamp('2000-01-31'),
    Timestamp('2000-02-01'),
    Timestamp('2000-02-02'),
    Timestamp('2000-02-03'),
    Timestamp('2000-02-04'),
    Timestamp('2000-02-07'),
    Timestamp('2000-02-08'),
    Timestamp('2000-02-09'),
    Timestamp('2000-02-10'),
    Timestamp('2000-02-11'),
    Timestamp('2000-05-01'),
    Timestamp('2000-05-02'),
    Timestamp('2000-05-03'),
    Timestamp('2000-05-04'),
    Timestamp('2000-05-05'),
    Timestamp('2000-10-02'),
    Timestamp('2000-10-03'),
    Timestamp('2000-10-04'),
    Timestamp('2000-10-05'),
    Timestamp('2000-10-06'),
    Timestamp('2001-01-01'),
    Timestamp('2001-01-22'),
    Timestamp('2001-01-23'),
    Timestamp('2001-01-24'),
    Timestamp('2001-01-25'),
    Timestamp('2001-01-26'),
    Timestamp('2001-01-29'),
    Timestamp('2001-01-30'),
    Timestamp('2001-01-31'),
    Timestamp('2001-02-01'),
    Timestamp('2001-02-02'),
    Timestamp('2001-05-01'),
    Timestamp('2001-05-02'),
    Timestamp('2001-05-03'),
    Timestamp('2001-05-04'),
    Timestamp('2001-05-07'),
    Timestamp('2001-10-01'),
    Timestamp('2001-10-02'),
    Timestamp('2001-10-03'),
    Timestamp('2001-10-04'),
    Timestamp('2001-10-05'),
    Timestamp('2002-01-01'),
    Timestamp('2002-01-02'),
    Timestamp('2002-01-03'),
    Timestamp('2002-02-11'),
    Timestamp('2002-02-12'),
    Timestamp('2002-02-13'),
    Timestamp('2002-02-14'),
    Timestamp('2002-02-15'),
    Timestamp('2002-02-18'),
    Timestamp('2002-02-19'),
    Timestamp('2002-02-20'),
    Timestamp('2002-02-21'),
    Timestamp('2002-02-22'),
    Timestamp('2002-05-01'),
    Timestamp('2002-05-02'),
    Timestamp('2002-05-03'),
    Timestamp('2002-05-06'),
    Timestamp('2002-05-07'),
    Timestamp('2002-09-30'),
    Timestamp('2002-10-01'),
    Timestamp('2002-10-02'),
    Timestamp('2002-10-03'),
    Timestamp('2002-10-04'),
    Timestamp('2002-10-07'),
    Timestamp('2003-01-01'),
    Timestamp('2003-01-30'),
    Timestamp('2003-01-31'),
    Timestamp('2003-02-03'),
    Timestamp('2003-02-04'),
    Timestamp('2003-02-05'),
    Timestamp('2003-02-06'),
    Timestamp('2003-02-07'),
    Timestamp('2003-05-01'),
    Timestamp('2003-05-02'),
    Timestamp('2003-05-05'),
    Timestamp('2003-05-06'),
    Timestamp('2003-05-07'),
    Timestamp('2003-05-08'),
    Timestamp('2003-05-09'),
    Timestamp('2003-10-01'),
    Timestamp('2003-10-02'),
    Timestamp('2003-10-03'),
    Timestamp('2003-10-06'),
    Timestamp('2003-10-07'),
    Timestamp('2004-01-01'),
    Timestamp('2004-01-19'),
    Timestamp('2004-01-20'),
    Timestamp('2004-01-21'),
    Timestamp('2004-01-22'),
    Timestamp('2004-01-23'),
    Timestamp('2004-01-26'),
    Timestamp('2004-01-27'),
    Timestamp('2004-01-28'),
    Timestamp('2004-05-03'),
    Timestamp('2004-05-04'),
    Timestamp('2004-05-05'),
    Timestamp('2004-05-06'),
    Timestamp('2004-05-07'),
    Timestamp('2004-10-01'),
    Timestamp('2004-10-04'),
    Timestamp('2004-10-05'),
    Timestamp('2004-10-06'),
    Timestamp('2004-10-07'),
    Timestamp('2005-01-03'),
    Timestamp('2005-02-07'),
    Timestamp('2005-02-08'),
    Timestamp('2005-02-09'),
    Timestamp('2005-02-10'),
    Timestamp('2005-02-11'),
    Timestamp('2005-02-14'),
    Timestamp('2005-02-15'),
    Timestamp('2005-05-02'),
    Timestamp('2005-05-03'),
    Timestamp('2005-05-04'),
    Timestamp('2005-05-05'),
    Timestamp('2005-05-06'),
    Timestamp('2005-10-03'),
    Timestamp('2005-10-04'),
    Timestamp('2005-10-05'),
    Timestamp('2005-10-06'),
    Timestamp('2005-10-07'),
    Timestamp('2006-01-02'),
    Timestamp('2006-01-03'),
    Timestamp('2006-01-26'),
    Timestamp('2006-01-27'),
    Timestamp('2006-01-30'),
    Timestamp('2006-01-31'),
    Timestamp('2006-02-01'),
    Timestamp('2006-02-02'),
    Timestamp('2006-02-03'),
    Timestamp('2006-05-01'),
    Timestamp('2006-05-02'),
    Timestamp('2006-05-03'),
    Timestamp('2006-05-04'),
    Timestamp('2006-05-05'),
    Timestamp('2006-10-02'),
    Timestamp('2006-10-03'),
    Timestamp('2006-10-04'),
    Timestamp('2006-10-05'),
    Timestamp('2006-10-06'),
    Timestamp('2007-01-01'),
    Timestamp('2007-01-02'),
    Timestamp('2007-01-03'),
    Timestamp('2007-02-19'),
    Timestamp('2007-02-20'),
    Timestamp('2007-02-21'),
    Timestamp('2007-02-22'),
    Timestamp('2007-02-23'),
    Timestamp('2007-05-01'),
    Timestamp('2007-05-02'),
    Timestamp('2007-05-03'),
    Timestamp('2007-05-04'),
    Timestamp('2007-05-07'),
    Timestamp('2007-10-01'),
    Timestamp('2007-10-02'),
    Timestamp('2007-10-03'),
    Timestamp('2007-10-04'),
    Timestamp('2007-10-05'),
    Timestamp('2007-12-31'),
    Timestamp('2008-01-01'),
    Timestamp('2008-02-06'),
    Timestamp('2008-02-07'),
    Timestamp('2008-02-08'),
    Timestamp('2008-02-11'),
    Timestamp('2008-02-12'),
    Timestamp('2008-04-04'),
    Timestamp('2008-05-01'),
    Timestamp('2008-05-02'),
    Timestamp('2008-06-09'),
    Timestamp('2008-09-15'),
    Timestamp('2008-09-29'),
    Timestamp('2008-09-30'),
    Timestamp('2008-10-01'),
    Timestamp('2008-10-02'),
    Timestamp('2008-10-03'),
    Timestamp('2009-01-01'),
    Timestamp('2009-01-02'),
    Timestamp('2009-01-26'),
    Timestamp('2009-01-27'),
    Timestamp('2009-01-28'),
    Timestamp('2009-01-29'),
    Timestamp('2009-01-30'),
    Timestamp('2009-04-06'),
    Timestamp('2009-05-01'),
    Timestamp('2009-05-28'),
    Timestamp('2009-05-29'),
    Timestamp('2009-10-01'),
    Timestamp('2009-10-02'),
    Timestamp('2009-10-05'),
    Timestamp('2009-10-06'),
    Timestamp('2009-10-07'),
    Timestamp('2009-10-08'),
    Timestamp('2010-01-01'),
    Timestamp('2010-02-15'),
    Timestamp('2010-02-16'),
    Timestamp('2010-02-17'),
    Timestamp('2010-02-18'),
    Timestamp('2010-02-19'),
    Timestamp('2010-04-05'),
    Timestamp('2010-05-03'),
    Timestamp('2010-06-14'),
    Timestamp('2010-06-15'),
    Timestamp('2010-06-16'),
    Timestamp('2010-09-22'),
    Timestamp('2010-09-23'),
    Timestamp('2010-09-24'),
    Timestamp('2010-10-01'),
    Timestamp('2010-10-04'),
    Timestamp('2010-10-05'),
    Timestamp('2010-10-06'),
    Timestamp('2010-10-07'),
    Timestamp('2011-01-03'),
    Timestamp('2011-02-02'),
    Timestamp('2011-02-03'),
    Timestamp('2011-02-04'),
    Timestamp('2011-02-07'),
    Timestamp('2011-02-08'),
    Timestamp('2011-04-04'),
    Timestamp('2011-04-05'),
    Timestamp('2011-05-02'),
    Timestamp('2011-06-06'),
    Timestamp('2011-09-12'),
    Timestamp('2011-10-03'),
    Timestamp('2011-10-04'),
    Timestamp('2011-10-05'),
    Timestamp('2011-10-06'),
    Timestamp('2011-10-07'),
    Timestamp('2012-01-02'),
    Timestamp('2012-01-03'),
    Timestamp('2012-01-23'),
    Timestamp('2012-01-24'),
    Timestamp('2012-01-25'),
    Timestamp('2012-01-26'),
    Timestamp('2012-01-27'),
    Timestamp('2012-04-02'),
    Timestamp('2012-04-03'),
    Timestamp('2012-04-04'),
    Timestamp('2012-04-30'),
    Timestamp('2012-05-01'),
    Timestamp('2012-06-22'),
    Timestamp('2012-10-01'),
    Timestamp('2012-10-02'),
    Timestamp('2012-10-03'),
    Timestamp('2012-10-04'),
    Timestamp('2012-10-05'),
    Timestamp('2013-01-01'),
    Timestamp('2013-01-02'),
    Timestamp('2013-01-03'),
    Timestamp('2013-02-11'),
    Timestamp('2013-02-12'),
    Timestamp('2013-02-13'),
    Timestamp('2013-02-14'),
    Timestamp('2013-02-15'),
    Timestamp('2013-04-04'),
    Timestamp('2013-04-05'),
    Timestamp('2013-04-29'),
    Timestamp('2013-04-30'),
    Timestamp('2013-05-01'),
    Timestamp('2013-06-10'),
    Timestamp('2013-06-11'),
    Timestamp('2013-06-12'),
    Timestamp('2013-09-19'),
    Timestamp('2013-09-20'),
    Timestamp('2013-10-01'),
    Timestamp('2013-10-02'),
    Timestamp('2013-10-03'),
    Timestamp('2013-10-04'),
    Timestamp('2013-10-07'),
    Timestamp('2014-01-01'),
    Timestamp('2014-01-31'),
    Timestamp('2014-02-03'),
    Timestamp('2014-02-04'),
    Timestamp('2014-02-05'),
    Timestamp('2014-02-06'),
    Timestamp('2014-04-07'),
    Timestamp('2014-05-01'),
    Timestamp('2014-05-02'),
    Timestamp('2014-06-02'),
    Timestamp('2014-09-08'),
    Timestamp('2014-10-01'),
    Timestamp('2014-10-02'),
    Timestamp('2014-10-03'),
    Timestamp('2014-10-06'),
    Timestamp('2014-10-07'),
    Timestamp('2015-01-01'),
    Timestamp('2015-01-02'),
    Timestamp('2015-02-18'),
    Timestamp('2015-02-19'),
    Timestamp('2015-02-20'),
    Timestamp('2015-02-23'),
    Timestamp('2015-02-24'),
    Timestamp('2015-04-06'),
    Timestamp('2015-05-01'),
    Timestamp('2015-06-22'),
    Timestamp('2015-09-03'),
    Timestamp('2015-09-04'),
    Timestamp('2015-10-01'),
    Timestamp('2015-10-02'),
    Timestamp('2015-10-05'),
    Timestamp('2015-10-06'),
    Timestamp('2015-10-07'),
    Timestamp('2016-01-01'),
    Timestamp('2016-02-08'),
    Timestamp('2016-02-09'),
    Timestamp('2016-02-10'),
    Timestamp('2016-02-11'),
    Timestamp('2016-02-12'),
    Timestamp('2016-04-04'),
    Timestamp('2016-05-02'),
    Timestamp('2016-06-09'),
    Timestamp('2016-06-10'),
    Timestamp('2016-09-15'),
    Timestamp('2016-09-16'),
    Timestamp('2016-10-03'),
    Timestamp('2016-10-04'),
    Timestamp('2016-10-05'),
    Timestamp('2016-10-06'),
    Timestamp('2016-10-07'),
    Timestamp('2017-01-02'),
    Timestamp('2017-01-27'),
    Timestamp('2017-01-30'),
    Timestamp('2017-01-31'),
    Timestamp('2017-02-01'),
    Timestamp('2017-02-02'),
    Timestamp('2017-04-03'),
    Timestamp('2017-04-04'),
    Timestamp('2017-05-01'),
    Timestamp('2017-05-29'),
    Timestamp('2017-05-30'),
    Timestamp('2017-10-02'),
    Timestamp('2017-10-03'),
    Timestamp('2017-10-04'),
    Timestamp('2017-10-05'),
    Timestamp('2017-10-06'),
    Timestamp('2018-01-01'),
    Timestamp('2018-02-15'),
    Timestamp('2018-02-16'),
    Timestamp('2018-02-19'),
    Timestamp('2018-02-20'),
    Timestamp('2018-02-21'),
    Timestamp('2018-04-05'),
    Timestamp('2018-04-06'),
    Timestamp('2018-04-30'),
    Timestamp('2018-05-01'),
    Timestamp('2018-06-18'),
    Timestamp('2018-09-24'),
    Timestamp('2018-10-01'),
    Timestamp('2018-10-02'),
    Timestamp('2018-10-03'),
    Timestamp('2018-10-04'),
    Timestamp('2018-10-05'),
    Timestamp('2018-12-30'),
    Timestamp('2018-12-31'),
    Timestamp('2019-01-01'),
    Timestamp('2019-02-04'),
    Timestamp('2019-02-05'),
    Timestamp('2019-02-06'),
    Timestamp('2019-02-07'),
    Timestamp('2019-02-08'),
    Timestamp('2019-02-09'),
    Timestamp('2019-02-10'),
    Timestamp('2019-04-05'),
    Timestamp('2019-05-01'),
    Timestamp('2019-05-02'),
    Timestamp('2019-05-03'),
    Timestamp('2019-06-07'),
    Timestamp('2019-09-13'),
    Timestamp('2019-10-01'),
    Timestamp('2019-10-02'),
    Timestamp('2019-10-03'),
    Timestamp('2019-10-04'),
    Timestamp('2019-10-05'),
    Timestamp('2019-10-06'),
    Timestamp('2019-10-07'),
    Timestamp('2020-01-31'),
    Timestamp('2020-05-04'),
    Timestamp('2020-05-05'),
]

# The following holidays are based on Solar terms or Chinese lunisolar calendar,
# so pre-calculated mappings to Gregorian calendar are kept here from 2019-2099

# Spring Festival
sf_mapping = {
    1960: Timestamp('1960-01-28'),
    1961: Timestamp('1961-02-15'),
    1962: Timestamp('1962-02-05'),
    1963: Timestamp('1963-01-25'),
    1964: Timestamp('1964-02-13'),
    1965: Timestamp('1965-02-02'),
    1966: Timestamp('1966-01-21'),
    1967: Timestamp('1967-02-09'),
    1968: Timestamp('1968-01-30'),
    1969: Timestamp('1969-02-17'),
    1970: Timestamp('1970-02-06'),
    1971: Timestamp('1971-01-27'),
    1972: Timestamp('1972-02-15'),
    1973: Timestamp('1973-02-03'),
    1974: Timestamp('1974-01-23'),
    1975: Timestamp('1975-02-11'),
    1976: Timestamp('1976-01-31'),
    1977: Timestamp('1977-02-18'),
    1978: Timestamp('1978-02-07'),
    1979: Timestamp('1979-01-28'),
    1980: Timestamp('1980-02-16'),
    1981: Timestamp('1981-02-05'),
    1982: Timestamp('1982-01-25'),
    1983: Timestamp('1983-02-13'),
    1984: Timestamp('1984-02-02'),
    1985: Timestamp('1985-02-20'),
    1986: Timestamp('1986-02-09'),
    1987: Timestamp('1987-01-29'),
    1988: Timestamp('1988-02-17'),
    1989: Timestamp('1989-02-06'),
    1990: Timestamp('1990-01-27'),
    1991: Timestamp('1991-02-15'),
    1992: Timestamp('1992-02-04'),
    1993: Timestamp('1993-01-23'),
    1994: Timestamp('1994-02-10'),
    1995: Timestamp('1995-01-31'),
    1996: Timestamp('1996-02-19'),
    1997: Timestamp('1997-02-07'),
    1998: Timestamp('1998-01-28'),
    1999: Timestamp('1999-02-16'),
    2000: Timestamp('2000-02-05'),
    2001: Timestamp('2001-01-24'),
    2002: Timestamp('2002-02-12'),
    2003: Timestamp('2003-02-01'),
    2004: Timestamp('2004-01-22'),
    2005: Timestamp('2005-02-09'),
    2006: Timestamp('2006-01-29'),
    2007: Timestamp('2007-02-18'),
    2008: Timestamp('2008-02-07'),
    2009: Timestamp('2009-01-26'),
    2010: Timestamp('2010-02-14'),
    2011: Timestamp('2011-02-03'),
    2012: Timestamp('2012-01-23'),
    2013: Timestamp('2013-02-10'),
    2014: Timestamp('2014-01-31'),
    2015: Timestamp('2015-02-19'),
    2016: Timestamp('2016-02-08'),
    2017: Timestamp('2017-01-28'),
    2018: Timestamp('2018-02-16'),
    2019: Timestamp('2019-02-05'),
    2020: Timestamp('2020-01-25'),
    2021: Timestamp('2021-02-12'),
    2022: Timestamp('2022-02-01'),
    2023: Timestamp('2023-01-22'),
    2024: Timestamp('2024-02-10'),
    2025: Timestamp('2025-01-29'),
    2026: Timestamp('2026-02-17'),
    2027: Timestamp('2027-02-06'),
    2028: Timestamp('2028-01-26'),
    2029: Timestamp('2029-02-13'),
    2030: Timestamp('2030-02-03'),
    2031: Timestamp('2031-01-23'),
    2032: Timestamp('2032-02-11'),
    2033: Timestamp('2033-01-31'),
    2034: Timestamp('2034-02-19'),
    2035: Timestamp('2035-02-08'),
    2036: Timestamp('2036-01-28'),
    2037: Timestamp('2037-02-15'),
    2038: Timestamp('2038-02-04'),
    2039: Timestamp('2039-01-24'),
    2040: Timestamp('2040-02-12'),
    2041: Timestamp('2041-02-01'),
    2042: Timestamp('2042-01-22'),
    2043: Timestamp('2043-02-10'),
    2044: Timestamp('2044-01-30'),
    2045: Timestamp('2045-02-17'),
    2046: Timestamp('2046-02-06'),
    2047: Timestamp('2047-01-26'),
    2048: Timestamp('2048-02-14'),
    2049: Timestamp('2049-02-02'),
    2050: Timestamp('2050-01-23'),
    2051: Timestamp('2051-02-11'),
    2052: Timestamp('2052-02-01'),
    2053: Timestamp('2053-02-19'),
    2054: Timestamp('2054-02-08'),
    2055: Timestamp('2055-01-28'),
    2056: Timestamp('2056-02-15'),
    2057: Timestamp('2057-02-04'),
    2058: Timestamp('2058-01-24'),
    2059: Timestamp('2059-02-12'),
    2060: Timestamp('2060-02-02'),
    2061: Timestamp('2061-01-21'),
    2062: Timestamp('2062-02-09'),
    2063: Timestamp('2063-01-29'),
    2064: Timestamp('2064-02-17'),
    2065: Timestamp('2065-02-05'),
    2066: Timestamp('2066-01-26'),
    2067: Timestamp('2067-02-14'),
    2068: Timestamp('2068-02-03'),
    2069: Timestamp('2069-01-23'),
    2070: Timestamp('2070-02-11'),
    2071: Timestamp('2071-01-31'),
    2072: Timestamp('2072-02-19'),
    2073: Timestamp('2073-02-07'),
    2074: Timestamp('2074-01-27'),
    2075: Timestamp('2075-02-15'),
    2076: Timestamp('2076-02-05'),
    2077: Timestamp('2077-01-24'),
    2078: Timestamp('2078-02-12'),
    2079: Timestamp('2079-02-02'),
    2080: Timestamp('2080-01-22'),
    2081: Timestamp('2081-02-09'),
    2082: Timestamp('2082-01-29'),
    2083: Timestamp('2083-02-17'),
    2084: Timestamp('2084-02-06'),
    2085: Timestamp('2085-01-26'),
    2086: Timestamp('2086-02-14'),
    2087: Timestamp('2087-02-03'),
    2088: Timestamp('2088-01-24'),
    2089: Timestamp('2089-02-10'),
    2090: Timestamp('2090-01-30'),
    2091: Timestamp('2091-02-18'),
    2092: Timestamp('2092-02-07'),
    2093: Timestamp('2093-01-27'),
    2094: Timestamp('2094-02-15'),
    2095: Timestamp('2095-02-05'),
    2096: Timestamp('2096-01-25'),
    2097: Timestamp('2097-02-12'),
    2098: Timestamp('2098-02-01'),
    2099: Timestamp('2099-01-21'),
}

# Tomb-sweeping Day, "Qingming"
tsd_mapping = {
    1960: Timestamp('1960-04-05'),
    1961: Timestamp('1961-04-05'),
    1962: Timestamp('1962-04-05'),
    1963: Timestamp('1963-04-05'),
    1964: Timestamp('1964-04-05'),
    1965: Timestamp('1965-04-05'),
    1966: Timestamp('1966-04-05'),
    1967: Timestamp('1967-04-05'),
    1968: Timestamp('1968-04-05'),
    1969: Timestamp('1969-04-05'),
    1970: Timestamp('1970-04-05'),
    1971: Timestamp('1971-04-05'),
    1972: Timestamp('1972-04-05'),
    1973: Timestamp('1973-04-05'),
    1974: Timestamp('1974-04-05'),
    1975: Timestamp('1975-04-05'),
    1976: Timestamp('1976-04-04'),
    1977: Timestamp('1977-04-05'),
    1978: Timestamp('1978-04-05'),
    1979: Timestamp('1979-04-05'),
    1980: Timestamp('1980-04-04'),
    1981: Timestamp('1981-04-05'),
    1982: Timestamp('1982-04-05'),
    1983: Timestamp('1983-04-05'),
    1984: Timestamp('1984-04-04'),
    1985: Timestamp('1985-04-05'),
    1986: Timestamp('1986-04-05'),
    1987: Timestamp('1987-04-05'),
    1988: Timestamp('1988-04-04'),
    1989: Timestamp('1989-04-05'),
    1990: Timestamp('1990-04-05'),
    1991: Timestamp('1991-04-05'),
    1992: Timestamp('1992-04-04'),
    1993: Timestamp('1993-04-05'),
    1994: Timestamp('1994-04-05'),
    1995: Timestamp('1995-04-05'),
    1996: Timestamp('1996-04-04'),
    1997: Timestamp('1997-04-05'),
    1998: Timestamp('1998-04-05'),
    1999: Timestamp('1999-04-05'),
    2000: Timestamp('2000-04-04'),
    2001: Timestamp('2001-04-05'),
    2002: Timestamp('2002-04-05'),
    2003: Timestamp('2003-04-05'),
    2004: Timestamp('2004-04-04'),
    2005: Timestamp('2005-04-05'),
    2006: Timestamp('2006-04-05'),
    2007: Timestamp('2007-04-05'),
    2008: Timestamp('2008-04-04'),
    2009: Timestamp('2009-04-04'),
    2010: Timestamp('2010-04-05'),
    2011: Timestamp('2011-04-05'),
    2012: Timestamp('2012-04-04'),
    2013: Timestamp('2013-04-04'),
    2014: Timestamp('2014-04-05'),
    2015: Timestamp('2015-04-05'),
    2016: Timestamp('2016-04-04'),
    2017: Timestamp('2017-04-04'),
    2018: Timestamp('2018-04-05'),
    2019: Timestamp('2019-04-05'),
    2020: Timestamp('2020-04-04'),
    2021: Timestamp('2021-04-04'),
    2022: Timestamp('2022-04-05'),
    2023: Timestamp('2023-04-05'),
    2024: Timestamp('2024-04-04'),
    2025: Timestamp('2025-04-04'),
    2026: Timestamp('2026-04-05'),
    2027: Timestamp('2027-04-05'),
    2028: Timestamp('2028-04-04'),
    2029: Timestamp('2029-04-04'),
    2030: Timestamp('2030-04-05'),
    2031: Timestamp('2031-04-05'),
    2032: Timestamp('2032-04-04'),
    2033: Timestamp('2033-04-04'),
    2034: Timestamp('2034-04-05'),
    2035: Timestamp('2035-04-05'),
    2036: Timestamp('2036-04-04'),
    2037: Timestamp('2037-04-04'),
    2038: Timestamp('2038-04-05'),
    2039: Timestamp('2039-04-05'),
    2040: Timestamp('2040-04-04'),
    2041: Timestamp('2041-04-04'),
    2042: Timestamp('2042-04-04'),
    2043: Timestamp('2043-04-05'),
    2044: Timestamp('2044-04-04'),
    2045: Timestamp('2045-04-04'),
    2046: Timestamp('2046-04-04'),
    2047: Timestamp('2047-04-05'),
    2048: Timestamp('2048-04-04'),
    2049: Timestamp('2049-04-04'),
    2050: Timestamp('2050-04-04'),
    2051: Timestamp('2051-04-05'),
    2052: Timestamp('2052-04-04'),
    2053: Timestamp('2053-04-04'),
    2054: Timestamp('2054-04-04'),
    2055: Timestamp('2055-04-05'),
    2056: Timestamp('2056-04-04'),
    2057: Timestamp('2057-04-04'),
    2058: Timestamp('2058-04-04'),
    2059: Timestamp('2059-04-05'),
    2060: Timestamp('2060-04-04'),
    2061: Timestamp('2061-04-04'),
    2062: Timestamp('2062-04-04'),
    2063: Timestamp('2063-04-05'),
    2064: Timestamp('2064-04-04'),
    2065: Timestamp('2065-04-04'),
    2066: Timestamp('2066-04-04'),
    2067: Timestamp('2067-04-05'),
    2068: Timestamp('2068-04-04'),
    2069: Timestamp('2069-04-04'),
    2070: Timestamp('2070-04-04'),
    2071: Timestamp('2071-04-05'),
    2072: Timestamp('2072-04-04'),
    2073: Timestamp('2073-04-04'),
    2074: Timestamp('2074-04-04'),
    2075: Timestamp('2075-04-04'),
    2076: Timestamp('2076-04-04'),
    2077: Timestamp('2077-04-04'),
    2078: Timestamp('2078-04-04'),
    2079: Timestamp('2079-04-04'),
    2080: Timestamp('2080-04-04'),
    2081: Timestamp('2081-04-04'),
    2082: Timestamp('2082-04-04'),
    2083: Timestamp('2083-04-04'),
    2084: Timestamp('2084-04-04'),
    2085: Timestamp('2085-04-04'),
    2086: Timestamp('2086-04-04'),
    2087: Timestamp('2087-04-04'),
    2088: Timestamp('2088-04-04'),
    2089: Timestamp('2089-04-04'),
    2090: Timestamp('2090-04-04'),
    2091: Timestamp('2091-04-04'),
    2092: Timestamp('2092-04-04'),
    2093: Timestamp('2093-04-04'),
    2094: Timestamp('2094-04-04'),
    2095: Timestamp('2095-04-04'),
    2096: Timestamp('2096-04-04'),
    2097: Timestamp('2097-04-04'),
    2098: Timestamp('2098-04-04'),
    2099: Timestamp('2099-04-04'),
}

# Dragon Boat Festival, "Duanwu"
dbf_mapping = {
    1960: Timestamp('1960-05-29'),
    1961: Timestamp('1961-06-17'),
    1962: Timestamp('1962-06-06'),
    1963: Timestamp('1963-06-25'),
    1964: Timestamp('1964-06-14'),
    1965: Timestamp('1965-06-04'),
    1966: Timestamp('1966-06-23'),
    1967: Timestamp('1967-06-12'),
    1968: Timestamp('1968-05-31'),
    1969: Timestamp('1969-06-19'),
    1970: Timestamp('1970-06-08'),
    1971: Timestamp('1971-05-28'),
    1972: Timestamp('1972-06-15'),
    1973: Timestamp('1973-06-05'),
    1974: Timestamp('1974-06-24'),
    1975: Timestamp('1975-06-14'),
    1976: Timestamp('1976-06-02'),
    1977: Timestamp('1977-06-21'),
    1978: Timestamp('1978-06-10'),
    1979: Timestamp('1979-05-30'),
    1980: Timestamp('1980-06-17'),
    1981: Timestamp('1981-06-06'),
    1982: Timestamp('1982-06-25'),
    1983: Timestamp('1983-06-15'),
    1984: Timestamp('1984-06-04'),
    1985: Timestamp('1985-06-22'),
    1986: Timestamp('1986-06-11'),
    1987: Timestamp('1987-05-31'),
    1988: Timestamp('1988-06-18'),
    1989: Timestamp('1989-06-08'),
    1990: Timestamp('1990-05-28'),
    1991: Timestamp('1991-06-16'),
    1992: Timestamp('1992-06-05'),
    1993: Timestamp('1993-06-24'),
    1994: Timestamp('1994-06-13'),
    1995: Timestamp('1995-06-02'),
    1996: Timestamp('1996-06-20'),
    1997: Timestamp('1997-06-09'),
    1998: Timestamp('1998-05-30'),
    1999: Timestamp('1999-06-18'),
    2000: Timestamp('2000-06-06'),
    2001: Timestamp('2001-06-25'),
    2002: Timestamp('2002-06-15'),
    2003: Timestamp('2003-06-04'),
    2004: Timestamp('2004-06-22'),
    2005: Timestamp('2005-06-11'),
    2006: Timestamp('2006-05-31'),
    2007: Timestamp('2007-06-19'),
    2008: Timestamp('2008-06-08'),
    2009: Timestamp('2009-05-28'),
    2010: Timestamp('2010-06-16'),
    2011: Timestamp('2011-06-06'),
    2012: Timestamp('2012-06-23'),
    2013: Timestamp('2013-06-12'),
    2014: Timestamp('2014-06-02'),
    2015: Timestamp('2015-06-20'),
    2016: Timestamp('2016-06-09'),
    2017: Timestamp('2017-05-30'),
    2018: Timestamp('2018-06-18'),
    2019: Timestamp('2019-06-07'),
    2020: Timestamp('2020-06-25'),
    2021: Timestamp('2021-06-14'),
    2022: Timestamp('2022-06-03'),
    2023: Timestamp('2023-06-22'),
    2024: Timestamp('2024-06-10'),
    2025: Timestamp('2025-05-31'),
    2026: Timestamp('2026-06-19'),
    2027: Timestamp('2027-06-09'),
    2028: Timestamp('2028-05-28'),
    2029: Timestamp('2029-06-16'),
    2030: Timestamp('2030-06-05'),
    2031: Timestamp('2031-06-24'),
    2032: Timestamp('2032-06-12'),
    2033: Timestamp('2033-06-01'),
    2034: Timestamp('2034-06-20'),
    2035: Timestamp('2035-06-10'),
    2036: Timestamp('2036-05-30'),
    2037: Timestamp('2037-06-18'),
    2038: Timestamp('2038-06-07'),
    2039: Timestamp('2039-05-27'),
    2040: Timestamp('2040-06-14'),
    2041: Timestamp('2041-06-03'),
    2042: Timestamp('2042-06-22'),
    2043: Timestamp('2043-06-11'),
    2044: Timestamp('2044-05-31'),
    2045: Timestamp('2045-06-19'),
    2046: Timestamp('2046-06-08'),
    2047: Timestamp('2047-05-29'),
    2048: Timestamp('2048-06-15'),
    2049: Timestamp('2049-06-04'),
    2050: Timestamp('2050-06-23'),
    2051: Timestamp('2051-06-13'),
    2052: Timestamp('2052-06-01'),
    2053: Timestamp('2053-06-20'),
    2054: Timestamp('2054-06-10'),
    2055: Timestamp('2055-05-30'),
    2056: Timestamp('2056-06-17'),
    2057: Timestamp('2057-06-06'),
    2058: Timestamp('2058-06-25'),
    2059: Timestamp('2059-06-14'),
    2060: Timestamp('2060-06-03'),
    2061: Timestamp('2061-06-22'),
    2062: Timestamp('2062-06-11'),
    2063: Timestamp('2063-06-01'),
    2064: Timestamp('2064-06-19'),
    2065: Timestamp('2065-06-08'),
    2066: Timestamp('2066-05-28'),
    2067: Timestamp('2067-06-16'),
    2068: Timestamp('2068-06-04'),
    2069: Timestamp('2069-06-23'),
    2070: Timestamp('2070-06-13'),
    2071: Timestamp('2071-06-02'),
    2072: Timestamp('2072-06-20'),
    2073: Timestamp('2073-06-10'),
    2074: Timestamp('2074-05-30'),
    2075: Timestamp('2075-06-17'),
    2076: Timestamp('2076-06-06'),
    2077: Timestamp('2077-06-24'),
    2078: Timestamp('2078-06-14'),
    2079: Timestamp('2079-06-04'),
    2080: Timestamp('2080-06-22'),
    2081: Timestamp('2081-06-11'),
    2082: Timestamp('2082-06-01'),
    2083: Timestamp('2083-06-19'),
    2084: Timestamp('2084-06-07'),
    2085: Timestamp('2085-05-27'),
    2086: Timestamp('2086-06-15'),
    2087: Timestamp('2087-06-05'),
    2088: Timestamp('2088-06-23'),
    2089: Timestamp('2089-06-13'),
    2090: Timestamp('2090-06-02'),
    2091: Timestamp('2091-06-21'),
    2092: Timestamp('2092-06-09'),
    2093: Timestamp('2093-05-29'),
    2094: Timestamp('2094-06-17'),
    2095: Timestamp('2095-06-06'),
    2096: Timestamp('2096-06-24'),
    2097: Timestamp('2097-06-14'),
    2098: Timestamp('2098-06-04'),
    2099: Timestamp('2099-06-23'),
}

# Mid-autumn Festival, "Zhongqiu"
maf_mapping = {
    1960: Timestamp('1960-10-05'),
    1961: Timestamp('1961-09-24'),
    1962: Timestamp('1962-09-13'),
    1963: Timestamp('1963-10-02'),
    1964: Timestamp('1964-09-20'),
    1965: Timestamp('1965-09-10'),
    1966: Timestamp('1966-09-29'),
    1967: Timestamp('1967-09-18'),
    1968: Timestamp('1968-10-06'),
    1969: Timestamp('1969-09-26'),
    1970: Timestamp('1970-09-15'),
    1971: Timestamp('1971-10-03'),
    1972: Timestamp('1972-09-22'),
    1973: Timestamp('1973-09-11'),
    1974: Timestamp('1974-09-30'),
    1975: Timestamp('1975-09-20'),
    1976: Timestamp('1976-09-08'),
    1977: Timestamp('1977-09-27'),
    1978: Timestamp('1978-09-17'),
    1979: Timestamp('1979-10-05'),
    1980: Timestamp('1980-09-23'),
    1981: Timestamp('1981-09-12'),
    1982: Timestamp('1982-10-01'),
    1983: Timestamp('1983-09-21'),
    1984: Timestamp('1984-09-10'),
    1985: Timestamp('1985-09-29'),
    1986: Timestamp('1986-09-18'),
    1987: Timestamp('1987-10-07'),
    1988: Timestamp('1988-09-25'),
    1989: Timestamp('1989-09-14'),
    1990: Timestamp('1990-10-03'),
    1991: Timestamp('1991-09-22'),
    1992: Timestamp('1992-09-11'),
    1993: Timestamp('1993-09-30'),
    1994: Timestamp('1994-09-20'),
    1995: Timestamp('1995-09-09'),
    1996: Timestamp('1996-09-27'),
    1997: Timestamp('1997-09-16'),
    1998: Timestamp('1998-10-05'),
    1999: Timestamp('1999-09-24'),
    2000: Timestamp('2000-09-12'),
    2001: Timestamp('2001-10-01'),
    2002: Timestamp('2002-09-21'),
    2003: Timestamp('2003-09-11'),
    2004: Timestamp('2004-09-28'),
    2005: Timestamp('2005-09-18'),
    2006: Timestamp('2006-10-06'),
    2007: Timestamp('2007-09-25'),
    2008: Timestamp('2008-09-14'),
    2009: Timestamp('2009-10-03'),
    2010: Timestamp('2010-09-22'),
    2011: Timestamp('2011-09-12'),
    2012: Timestamp('2012-09-30'),
    2013: Timestamp('2013-09-19'),
    2014: Timestamp('2014-09-08'),
    2015: Timestamp('2015-09-27'),
    2016: Timestamp('2016-09-15'),
    2017: Timestamp('2017-10-04'),
    2018: Timestamp('2018-09-24'),
    2019: Timestamp('2019-09-13'),
    2020: Timestamp('2020-10-01'),
    2021: Timestamp('2021-09-21'),
    2022: Timestamp('2022-09-10'),
    2023: Timestamp('2023-09-29'),
    2024: Timestamp('2024-09-17'),
    2025: Timestamp('2025-10-06'),
    2026: Timestamp('2026-09-25'),
    2027: Timestamp('2027-09-15'),
    2028: Timestamp('2028-10-03'),
    2029: Timestamp('2029-09-22'),
    2030: Timestamp('2030-09-12'),
    2031: Timestamp('2031-10-01'),
    2032: Timestamp('2032-09-19'),
    2033: Timestamp('2033-09-08'),
    2034: Timestamp('2034-09-27'),
    2035: Timestamp('2035-09-16'),
    2036: Timestamp('2036-10-04'),
    2037: Timestamp('2037-09-24'),
    2038: Timestamp('2038-09-13'),
    2039: Timestamp('2039-10-02'),
    2040: Timestamp('2040-09-20'),
    2041: Timestamp('2041-09-10'),
    2042: Timestamp('2042-09-28'),
    2043: Timestamp('2043-09-17'),
    2044: Timestamp('2044-10-05'),
    2045: Timestamp('2045-09-25'),
    2046: Timestamp('2046-09-15'),
    2047: Timestamp('2047-10-04'),
    2048: Timestamp('2048-09-22'),
    2049: Timestamp('2049-09-11'),
    2050: Timestamp('2050-09-30'),
    2051: Timestamp('2051-09-19'),
    2052: Timestamp('2052-09-07'),
    2053: Timestamp('2053-09-26'),
    2054: Timestamp('2054-09-16'),
    2055: Timestamp('2055-10-05'),
    2056: Timestamp('2056-09-24'),
    2057: Timestamp('2057-09-13'),
    2058: Timestamp('2058-10-02'),
    2059: Timestamp('2059-09-21'),
    2060: Timestamp('2060-09-09'),
    2061: Timestamp('2061-09-28'),
    2062: Timestamp('2062-09-17'),
    2063: Timestamp('2063-10-06'),
    2064: Timestamp('2064-09-25'),
    2065: Timestamp('2065-09-15'),
    2066: Timestamp('2066-10-03'),
    2067: Timestamp('2067-09-23'),
    2068: Timestamp('2068-09-11'),
    2069: Timestamp('2069-09-29'),
    2070: Timestamp('2070-09-19'),
    2071: Timestamp('2071-09-08'),
    2072: Timestamp('2072-09-26'),
    2073: Timestamp('2073-09-16'),
    2074: Timestamp('2074-10-05'),
    2075: Timestamp('2075-09-24'),
    2076: Timestamp('2076-09-12'),
    2077: Timestamp('2077-10-01'),
    2078: Timestamp('2078-09-20'),
    2079: Timestamp('2079-09-10'),
    2080: Timestamp('2080-09-28'),
    2081: Timestamp('2081-09-17'),
    2082: Timestamp('2082-10-06'),
    2083: Timestamp('2083-09-26'),
    2084: Timestamp('2084-09-14'),
    2085: Timestamp('2085-10-03'),
    2086: Timestamp('2086-09-22'),
    2087: Timestamp('2087-09-11'),
    2088: Timestamp('2088-09-29'),
    2089: Timestamp('2089-09-18'),
    2090: Timestamp('2090-09-08'),
    2091: Timestamp('2091-09-27'),
    2092: Timestamp('2092-09-16'),
    2093: Timestamp('2093-10-05'),
    2094: Timestamp('2094-09-24'),
    2095: Timestamp('2095-09-13'),
    2096: Timestamp('2096-09-30'),
    2097: Timestamp('2097-09-20'),
    2098: Timestamp('2098-09-09'),
    2099: Timestamp('2099-09-29'),
}

# Buddha Shakyamuni day
bsd_mapping = {
    1959: Timestamp('1959-5-15'),
    1960: Timestamp('1960-5-3'),
    1961: Timestamp('1961-5-22'),
    1962: Timestamp('1962-5-11'),
    1963: Timestamp('1963-5-1'),
    1964: Timestamp('1964-5-19'),
    1965: Timestamp('1965-5-8'),
    1966: Timestamp('1966-5-27'),
    1967: Timestamp('1967-5-16'),
    1968: Timestamp('1968-5-4'),
    1969: Timestamp('1969-5-23'),
    1970: Timestamp('1970-5-12'),
    1971: Timestamp('1971-5-2'),
    1972: Timestamp('1972-5-20'),
    1973: Timestamp('1973-5-10'),
    1974: Timestamp('1974-4-29'),
    1975: Timestamp('1975-5-18'),
    1976: Timestamp('1976-5-6'),
    1977: Timestamp('1977-5-25'),
    1978: Timestamp('1978-5-14'),
    1979: Timestamp('1979-5-3'),
    1980: Timestamp('1980-5-21'),
    1981: Timestamp('1981-5-11'),
    1982: Timestamp('1982-5-1'),
    1983: Timestamp('1983-5-20'),
    1984: Timestamp('1984-5-8'),
    1985: Timestamp('1985-5-27'),
    1986: Timestamp('1986-5-16'),
    1987: Timestamp('1987-5-5'),
    1988: Timestamp('1988-5-23'),
    1989: Timestamp('1989-5-12'),
    1990: Timestamp('1990-5-2'),
    1991: Timestamp('1991-5-21'),
    1992: Timestamp('1992-5-10'),
    1993: Timestamp('1993-5-28'),
    1994: Timestamp('1994-5-18'),
    1995: Timestamp('1995-5-7'),
    1996: Timestamp('1996-5-24'),
    1997: Timestamp('1997-5-14'),
    1998: Timestamp('1998-5-3'),
    1999: Timestamp('1999-5-22'),
    2000: Timestamp('2000-5-11'),
    2001: Timestamp('2001-4-30'),
    2002: Timestamp('2002-5-19'),
    2003: Timestamp('2003-5-8'),
    2004: Timestamp('2004-5-26'),
    2005: Timestamp('2005-5-15'),
    2006: Timestamp('2006-5-5'),
    2007: Timestamp('2007-5-24'),
    2008: Timestamp('2008-5-12'),
    2009: Timestamp('2009-5-2'),
    2010: Timestamp('2010-5-21'),
    2011: Timestamp('2011-5-10'),
    2012: Timestamp('2012-4-28'),
    2013: Timestamp('2013-5-17'),
    2014: Timestamp('2014-5-6'),
    2015: Timestamp('2015-5-25'),
    2016: Timestamp('2016-5-14'),
    2017: Timestamp('2017-5-3'),
    2018: Timestamp('2018-5-22'),
    2019: Timestamp('2019-5-12'),
    2020: Timestamp('2020-4-30'),
    2021: Timestamp('2021-5-19'),
    2022: Timestamp('2022-5-8'),
    2023: Timestamp('2023-5-26'),
    2024: Timestamp('2024-5-15'),
    2025: Timestamp('2025-5-5'),
    2026: Timestamp('2026-5-24'),
    2027: Timestamp('2027-5-13'),
    2028: Timestamp('2028-5-2'),
    2029: Timestamp('2029-5-20'),
    2030: Timestamp('2030-5-9'),
    2031: Timestamp('2031-5-28'),
    2032: Timestamp('2032-5-16'),
    2033: Timestamp('2033-5-6'),
    2034: Timestamp('2034-5-25'),
    2035: Timestamp('2035-5-15'),
    2036: Timestamp('2036-5-3'),
    2037: Timestamp('2037-5-22'),
    2038: Timestamp('2038-5-11'),
    2039: Timestamp('2039-4-30'),
    2040: Timestamp('2040-5-18'),
    2041: Timestamp('2041-5-7'),
    2042: Timestamp('2042-5-26'),
    2043: Timestamp('2043-5-16'),
    2044: Timestamp('2044-5-5'),
    2045: Timestamp('2045-5-24'),
    2046: Timestamp('2046-5-13'),
    2047: Timestamp('2047-5-2'),
    2048: Timestamp('2048-5-20'),
    2049: Timestamp('2049-5-9'),
    2050: Timestamp('2050-5-28'),
    2051: Timestamp('2051-5-17'),
    2052: Timestamp('2052-5-6'),
    2053: Timestamp('2053-5-25'),
    2054: Timestamp('2054-5-15'),
    2055: Timestamp('2055-5-4'),
    2056: Timestamp('2056-5-22'),
    2057: Timestamp('2057-5-11'),
    2058: Timestamp('2058-4-30'),
    2059: Timestamp('2059-5-19'),
    2060: Timestamp('2060-5-7'),
    2061: Timestamp('2061-5-26'),
    2062: Timestamp('2062-5-16'),
    2063: Timestamp('2063-5-5'),
    2064: Timestamp('2064-5-23'),
    2065: Timestamp('2065-5-12'),
    2066: Timestamp('2066-5-1'),
    2067: Timestamp('2067-5-20'),
    2068: Timestamp('2068-5-9'),
    2069: Timestamp('2069-4-28'),
    2070: Timestamp('2070-5-17'),
    2071: Timestamp('2071-5-7'),
    2072: Timestamp('2072-5-25'),
    2073: Timestamp('2073-5-14'),
    2074: Timestamp('2074-5-3'),
    2075: Timestamp('2075-5-22'),
    2076: Timestamp('2076-5-10'),
    2077: Timestamp('2077-4-30'),
    2078: Timestamp('2078-5-19'),
    2079: Timestamp('2079-5-8'),
    2080: Timestamp('2080-5-26'),
    2081: Timestamp('2081-5-16'),
    2082: Timestamp('2082-5-5'),
    2083: Timestamp('2083-5-24'),
    2084: Timestamp('2084-5-12'),
    2085: Timestamp('2085-5-1'),
    2086: Timestamp('2086-5-20'),
    2087: Timestamp('2087-5-10'),
    2088: Timestamp('2088-4-28'),
    2089: Timestamp('2089-5-17'),
    2090: Timestamp('2090-5-7'),
    2091: Timestamp('2091-5-25'),
    2092: Timestamp('2092-5-13'),
    2093: Timestamp('2093-5-3'),
    2094: Timestamp('2094-5-21'),
    2095: Timestamp('2095-5-11'),
    2096: Timestamp('2096-4-30'),
    2097: Timestamp('2097-5-19'),
    2098: Timestamp('2098-5-8'),
    2099: Timestamp('2099-5-27'),
}

# Double Ninth Festival
dnf_mapping = {
    1959: Timestamp('1959-10-10'),
    1960: Timestamp('1960-10-28'),
    1961: Timestamp('1961-10-18'),
    1962: Timestamp('1962-10-7'),
    1963: Timestamp('1963-10-25'),
    1964: Timestamp('1964-10-14'),
    1965: Timestamp('1965-10-3'),
    1966: Timestamp('1966-10-22'),
    1967: Timestamp('1967-10-12'),
    1968: Timestamp('1968-10-30'),
    1969: Timestamp('1969-10-19'),
    1970: Timestamp('1970-10-8'),
    1971: Timestamp('1971-10-27'),
    1972: Timestamp('1972-10-15'),
    1973: Timestamp('1973-10-4'),
    1974: Timestamp('1974-10-23'),
    1975: Timestamp('1975-10-13'),
    1976: Timestamp('1976-10-31'),
    1977: Timestamp('1977-10-21'),
    1978: Timestamp('1978-10-10'),
    1979: Timestamp('1979-10-29'),
    1980: Timestamp('1980-10-17'),
    1981: Timestamp('1981-10-6'),
    1982: Timestamp('1982-10-25'),
    1983: Timestamp('1983-10-14'),
    1984: Timestamp('1984-10-3'),
    1985: Timestamp('1985-10-22'),
    1986: Timestamp('1986-10-12'),
    1987: Timestamp('1987-10-31'),
    1988: Timestamp('1988-10-19'),
    1989: Timestamp('1989-10-8'),
    1990: Timestamp('1990-10-26'),
    1991: Timestamp('1991-10-16'),
    1992: Timestamp('1992-10-4'),
    1993: Timestamp('1993-10-23'),
    1994: Timestamp('1994-10-13'),
    1995: Timestamp('1995-11-1'),
    1996: Timestamp('1996-10-20'),
    1997: Timestamp('1997-10-10'),
    1998: Timestamp('1998-10-28'),
    1999: Timestamp('1999-10-17'),
    2000: Timestamp('2000-10-6'),
    2001: Timestamp('2001-10-25'),
    2002: Timestamp('2002-10-14'),
    2003: Timestamp('2003-10-4'),
    2004: Timestamp('2004-10-22'),
    2005: Timestamp('2005-10-11'),
    2006: Timestamp('2006-10-30'),
    2007: Timestamp('2007-10-19'),
    2008: Timestamp('2008-10-7'),
    2009: Timestamp('2009-10-26'),
    2010: Timestamp('2010-10-16'),
    2011: Timestamp('2011-10-5'),
    2012: Timestamp('2012-10-23'),
    2013: Timestamp('2013-10-13'),
    2014: Timestamp('2014-10-2'),
    2015: Timestamp('2015-10-21'),
    2016: Timestamp('2016-10-9'),
    2017: Timestamp('2017-10-28'),
    2018: Timestamp('2018-10-17'),
    2019: Timestamp('2019-10-7'),
    2020: Timestamp('2020-10-25'),
    2021: Timestamp('2021-10-14'),
    2022: Timestamp('2022-10-4'),
    2023: Timestamp('2023-10-23'),
    2024: Timestamp('2024-10-11'),
    2025: Timestamp('2025-10-29'),
    2026: Timestamp('2026-10-18'),
    2027: Timestamp('2027-10-8'),
    2028: Timestamp('2028-10-26'),
    2029: Timestamp('2029-10-16'),
    2030: Timestamp('2030-10-5'),
    2031: Timestamp('2031-10-24'),
    2032: Timestamp('2032-10-12'),
    2033: Timestamp('2033-10-1'),
    2034: Timestamp('2034-10-20'),
    2035: Timestamp('2035-10-9'),
    2036: Timestamp('2036-10-27'),
    2037: Timestamp('2037-10-17'),
    2038: Timestamp('2038-10-7'),
    2039: Timestamp('2039-10-26'),
    2040: Timestamp('2040-10-14'),
    2041: Timestamp('2041-10-3'),
    2042: Timestamp('2042-10-22'),
    2043: Timestamp('2043-10-11'),
    2044: Timestamp('2044-10-29'),
    2045: Timestamp('2045-10-18'),
    2046: Timestamp('2046-10-8'),
    2047: Timestamp('2047-10-27'),
    2048: Timestamp('2048-10-16'),
    2049: Timestamp('2049-10-5'),
    2050: Timestamp('2050-10-24'),
    2051: Timestamp('2051-10-13'),
    2052: Timestamp('2052-10-30'),
    2053: Timestamp('2053-10-20'),
    2054: Timestamp('2054-10-9'),
    2055: Timestamp('2055-10-28'),
    2056: Timestamp('2056-10-17'),
    2057: Timestamp('2057-10-6'),
    2058: Timestamp('2058-10-25'),
    2059: Timestamp('2059-10-14'),
    2060: Timestamp('2060-10-2'),
    2061: Timestamp('2061-10-21'),
    2062: Timestamp('2062-10-11'),
    2063: Timestamp('2063-10-30'),
    2064: Timestamp('2064-10-18'),
    2065: Timestamp('2065-10-8'),
    2066: Timestamp('2066-10-27'),
    2067: Timestamp('2067-10-16'),
    2068: Timestamp('2068-10-4'),
    2069: Timestamp('2069-10-23'),
    2070: Timestamp('2070-10-12'),
    2071: Timestamp('2071-10-31'),
    2072: Timestamp('2072-10-20'),
    2073: Timestamp('2073-10-9'),
    2074: Timestamp('2074-10-28'),
    2075: Timestamp('2075-10-18'),
    2076: Timestamp('2076-10-6'),
    2077: Timestamp('2077-10-25'),
    2078: Timestamp('2078-10-14'),
    2079: Timestamp('2079-10-3'),
    2080: Timestamp('2080-10-21'),
    2081: Timestamp('2081-10-11'),
    2082: Timestamp('2082-10-30'),
    2083: Timestamp('2083-10-19'),
    2084: Timestamp('2084-10-8'),
    2085: Timestamp('2085-10-27'),
    2086: Timestamp('2086-10-16'),
    2087: Timestamp('2087-10-5'),
    2088: Timestamp('2088-10-22'),
    2089: Timestamp('2089-10-12'),
    2090: Timestamp('2090-10-31'),
    2091: Timestamp('2091-10-21'),
    2092: Timestamp('2092-10-9'),
    2093: Timestamp('2093-10-28'),
    2094: Timestamp('2094-10-17'),
    2095: Timestamp('2095-10-6'),
    2096: Timestamp('2096-10-24'),
    2097: Timestamp('2097-10-13'),
    2098: Timestamp('2098-10-3'),
    2099: Timestamp('2099-10-22')
}
