"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TerraformStateBackend = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const iam = require("aws-cdk-lib/aws-iam");
const constructs_1 = require("constructs");
class TerraformStateBackend extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.bucket = new aws_cdk_lib_1.aws_s3.Bucket(this, 'bucket', {
            bucketName: props.bucketName,
            versioned: true,
            blockPublicAccess: aws_cdk_lib_1.aws_s3.BlockPublicAccess.BLOCK_ALL,
            enforceSSL: true,
            objectOwnership: aws_cdk_lib_1.aws_s3.ObjectOwnership.BUCKET_OWNER_ENFORCED,
            removalPolicy: aws_cdk_lib_1.RemovalPolicy.DESTROY,
            encryption: aws_cdk_lib_1.aws_s3.BucketEncryption.KMS_MANAGED,
            lifecycleRules: [
                {
                    enabled: true,
                    noncurrentVersionsToRetain: 1000,
                    noncurrentVersionTransitions: [
                        {
                            storageClass: aws_cdk_lib_1.aws_s3.StorageClass.INFREQUENT_ACCESS,
                            transitionAfter: aws_cdk_lib_1.Duration.days(30),
                        },
                        {
                            storageClass: aws_cdk_lib_1.aws_s3.StorageClass.GLACIER,
                            transitionAfter: aws_cdk_lib_1.Duration.days(90),
                        },
                        {
                            storageClass: aws_cdk_lib_1.aws_s3.StorageClass.DEEP_ARCHIVE,
                            transitionAfter: aws_cdk_lib_1.Duration.days(180),
                        },
                    ],
                },
            ],
        });
        this.table = new aws_cdk_lib_1.aws_dynamodb.Table(this, 'table', {
            tableName: props.tableName,
            billingMode: aws_cdk_lib_1.aws_dynamodb.BillingMode.PAY_PER_REQUEST,
            deletionProtection: props.tableDeletionProtection ?? false,
            partitionKey: {
                name: 'LockID',
                type: aws_cdk_lib_1.aws_dynamodb.AttributeType.STRING,
            },
            pointInTimeRecovery: true,
            removalPolicy: aws_cdk_lib_1.RemovalPolicy.DESTROY,
        });
        this.createIamPolicies();
        new aws_cdk_lib_1.CfnOutput(this, 'output-table', {
            description: 'ARN of the DynamoDB table',
            exportName: 'tableArn',
            value: this.table.tableArn,
        });
        new aws_cdk_lib_1.CfnOutput(this, 'output-bucket', {
            description: 'ARN of the S3 bucket',
            exportName: 'bucketArn',
            value: this.bucket.bucketArn,
        });
    }
    createIamPolicies() {
        // Policy Statement for reading/ writing DyanmoDB table
        const ddbStatement = new iam.PolicyStatement({
            sid: 'DynamoDBTable',
            effect: iam.Effect.ALLOW,
            actions: [
                'dynamodb:DescribeTable',
                'dynamodb:GetItem',
                'dynamodb:PutItem',
                'dynamodb:DeleteItem',
            ],
            resources: [this.table.tableArn],
        });
        // Policy Statement for reading/ writing to the S3 bucket and objects
        const s3Statement = new iam.PolicyStatement({
            sid: 'S3Bucket',
            effect: iam.Effect.ALLOW,
            actions: [
                's3:ListBucket',
                's3:GetObject',
                's3:PutObject',
                's3:DeleteObject',
            ],
            resources: [this.bucket.bucketArn, this.bucket.bucketArn + '/*'],
        });
        new iam.PolicyDocument({
            statements: [ddbStatement, s3Statement],
        });
        new iam.ManagedPolicy(this, 'managed-policy', {
            description: 'Managed policy for Terraform state backend',
            statements: [ddbStatement, s3Statement],
            managedPolicyName: 'TerraformStateBackendPolicy',
        });
    }
}
exports.TerraformStateBackend = TerraformStateBackend;
_a = JSII_RTTI_SYMBOL_1;
TerraformStateBackend[_a] = { fqn: "terraform-backend-s3-bucket.TerraformStateBackend", version: "0.0.33" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGVycmFmb3JtU3RhdGVCYWNrZW5kLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vc3JjL3RlcnJhZm9ybVN0YXRlQmFja2VuZC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLDZDQU1xQjtBQUNyQiwyQ0FBMkM7QUFDM0MsMkNBQXVDO0FBR3ZDLE1BQWEscUJBQXNCLFNBQVEsc0JBQVM7SUFJbEQsWUFDRSxLQUFnQixFQUNoQixFQUFVLEVBQ1YsS0FBc0M7UUFFdEMsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVqQixJQUFJLENBQUMsTUFBTSxHQUFHLElBQUksb0JBQUUsQ0FBQyxNQUFNLENBQUMsSUFBSSxFQUFFLFFBQVEsRUFBRTtZQUMxQyxVQUFVLEVBQUUsS0FBSyxDQUFDLFVBQVU7WUFDNUIsU0FBUyxFQUFFLElBQUk7WUFDZixpQkFBaUIsRUFBRSxvQkFBRSxDQUFDLGlCQUFpQixDQUFDLFNBQVM7WUFDakQsVUFBVSxFQUFFLElBQUk7WUFDaEIsZUFBZSxFQUFFLG9CQUFFLENBQUMsZUFBZSxDQUFDLHFCQUFxQjtZQUN6RCxhQUFhLEVBQUUsMkJBQWEsQ0FBQyxPQUFPO1lBQ3BDLFVBQVUsRUFBRSxvQkFBRSxDQUFDLGdCQUFnQixDQUFDLFdBQVc7WUFDM0MsY0FBYyxFQUFFO2dCQUNkO29CQUNFLE9BQU8sRUFBRSxJQUFJO29CQUNiLDBCQUEwQixFQUFFLElBQUk7b0JBQ2hDLDRCQUE0QixFQUFFO3dCQUM1Qjs0QkFDRSxZQUFZLEVBQUUsb0JBQUUsQ0FBQyxZQUFZLENBQUMsaUJBQWlCOzRCQUMvQyxlQUFlLEVBQUUsc0JBQVEsQ0FBQyxJQUFJLENBQUMsRUFBRSxDQUFDO3lCQUNuQzt3QkFDRDs0QkFDRSxZQUFZLEVBQUUsb0JBQUUsQ0FBQyxZQUFZLENBQUMsT0FBTzs0QkFDckMsZUFBZSxFQUFFLHNCQUFRLENBQUMsSUFBSSxDQUFDLEVBQUUsQ0FBQzt5QkFDbkM7d0JBQ0Q7NEJBQ0UsWUFBWSxFQUFFLG9CQUFFLENBQUMsWUFBWSxDQUFDLFlBQVk7NEJBQzFDLGVBQWUsRUFBRSxzQkFBUSxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUM7eUJBQ3BDO3FCQUNGO2lCQUNGO2FBQ0Y7U0FDRixDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsS0FBSyxHQUFHLElBQUksMEJBQVEsQ0FBQyxLQUFLLENBQUMsSUFBSSxFQUFFLE9BQU8sRUFBRTtZQUM3QyxTQUFTLEVBQUUsS0FBSyxDQUFDLFNBQVM7WUFDMUIsV0FBVyxFQUFFLDBCQUFRLENBQUMsV0FBVyxDQUFDLGVBQWU7WUFDakQsa0JBQWtCLEVBQUUsS0FBSyxDQUFDLHVCQUF1QixJQUFJLEtBQUs7WUFDMUQsWUFBWSxFQUFFO2dCQUNaLElBQUksRUFBRSxRQUFRO2dCQUNkLElBQUksRUFBRSwwQkFBUSxDQUFDLGFBQWEsQ0FBQyxNQUFNO2FBQ3BDO1lBQ0QsbUJBQW1CLEVBQUUsSUFBSTtZQUN6QixhQUFhLEVBQUUsMkJBQWEsQ0FBQyxPQUFPO1NBQ3JDLENBQUMsQ0FBQztRQUVILElBQUksQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO1FBRXpCLElBQUksdUJBQVMsQ0FBQyxJQUFJLEVBQUUsY0FBYyxFQUNoQztZQUNFLFdBQVcsRUFBRSwyQkFBMkI7WUFDeEMsVUFBVSxFQUFFLFVBQVU7WUFDdEIsS0FBSyxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsUUFBUTtTQUMzQixDQUFDLENBQUM7UUFFTCxJQUFJLHVCQUFTLENBQUMsSUFBSSxFQUFFLGVBQWUsRUFDakM7WUFDRSxXQUFXLEVBQUUsc0JBQXNCO1lBQ25DLFVBQVUsRUFBRSxXQUFXO1lBQ3ZCLEtBQUssRUFBRSxJQUFJLENBQUMsTUFBTSxDQUFDLFNBQVM7U0FDN0IsQ0FBQyxDQUFDO0lBRVAsQ0FBQztJQUVPLGlCQUFpQjtRQUN2Qix1REFBdUQ7UUFDdkQsTUFBTSxZQUFZLEdBQUcsSUFBSSxHQUFHLENBQUMsZUFBZSxDQUFDO1lBQzNDLEdBQUcsRUFBRSxlQUFlO1lBQ3BCLE1BQU0sRUFBRSxHQUFHLENBQUMsTUFBTSxDQUFDLEtBQUs7WUFDeEIsT0FBTyxFQUFFO2dCQUNQLHdCQUF3QjtnQkFDeEIsa0JBQWtCO2dCQUNsQixrQkFBa0I7Z0JBQ2xCLHFCQUFxQjthQUN0QjtZQUNELFNBQVMsRUFBRSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsUUFBUSxDQUFDO1NBQ2pDLENBQUMsQ0FBQztRQUNILHFFQUFxRTtRQUNyRSxNQUFNLFdBQVcsR0FBRyxJQUFJLEdBQUcsQ0FBQyxlQUFlLENBQUM7WUFDMUMsR0FBRyxFQUFFLFVBQVU7WUFDZixNQUFNLEVBQUUsR0FBRyxDQUFDLE1BQU0sQ0FBQyxLQUFLO1lBQ3hCLE9BQU8sRUFBRTtnQkFDUCxlQUFlO2dCQUNmLGNBQWM7Z0JBQ2QsY0FBYztnQkFDZCxpQkFBaUI7YUFDbEI7WUFDRCxTQUFTLEVBQUUsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLFNBQVMsRUFBRSxJQUFJLENBQUMsTUFBTSxDQUFDLFNBQVMsR0FBRyxJQUFJLENBQUM7U0FDakUsQ0FBQyxDQUFDO1FBRUgsSUFBSSxHQUFHLENBQUMsY0FBYyxDQUFDO1lBQ3JCLFVBQVUsRUFBRSxDQUFDLFlBQVksRUFBRSxXQUFXLENBQUM7U0FDeEMsQ0FBQyxDQUFDO1FBQ0gsSUFBSSxHQUFHLENBQUMsYUFBYSxDQUFDLElBQUksRUFBRSxnQkFBZ0IsRUFBRTtZQUM1QyxXQUFXLEVBQUUsNENBQTRDO1lBQ3pELFVBQVUsRUFBRSxDQUFDLFlBQVksRUFBRSxXQUFXLENBQUM7WUFDdkMsaUJBQWlCLEVBQUUsNkJBQTZCO1NBQ2pELENBQUMsQ0FBQztJQUdMLENBQUM7O0FBM0dILHNEQTRHQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7XG4gIGF3c19keW5hbW9kYiBhcyBkeW5hbW9kYixcbiAgYXdzX3MzIGFzIHMzLFxuICBEdXJhdGlvbixcbiAgUmVtb3ZhbFBvbGljeSxcbiAgQ2ZuT3V0cHV0LFxufSBmcm9tICdhd3MtY2RrLWxpYic7XG5pbXBvcnQgKiBhcyBpYW0gZnJvbSAnYXdzLWNkay1saWIvYXdzLWlhbSc7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCB7IFRlcnJhZm9ybVN0YXRlQmFja2VuZFByb3BlcnRpZXMgfSBmcm9tICcuL3RlcnJhZm9ybVN0YXRlQmFja2VuZFByb3BlcnRpZXMnO1xuXG5leHBvcnQgY2xhc3MgVGVycmFmb3JtU3RhdGVCYWNrZW5kIGV4dGVuZHMgQ29uc3RydWN0IHtcbiAgcmVhZG9ubHkgYnVja2V0OiBzMy5JQnVja2V0O1xuICByZWFkb25seSB0YWJsZTogZHluYW1vZGIuSVRhYmxlO1xuXG4gIHB1YmxpYyBjb25zdHJ1Y3RvcihcbiAgICBzY29wZTogQ29uc3RydWN0LFxuICAgIGlkOiBzdHJpbmcsXG4gICAgcHJvcHM6IFRlcnJhZm9ybVN0YXRlQmFja2VuZFByb3BlcnRpZXMsXG4gICkge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICB0aGlzLmJ1Y2tldCA9IG5ldyBzMy5CdWNrZXQodGhpcywgJ2J1Y2tldCcsIHtcbiAgICAgIGJ1Y2tldE5hbWU6IHByb3BzLmJ1Y2tldE5hbWUsXG4gICAgICB2ZXJzaW9uZWQ6IHRydWUsXG4gICAgICBibG9ja1B1YmxpY0FjY2VzczogczMuQmxvY2tQdWJsaWNBY2Nlc3MuQkxPQ0tfQUxMLFxuICAgICAgZW5mb3JjZVNTTDogdHJ1ZSxcbiAgICAgIG9iamVjdE93bmVyc2hpcDogczMuT2JqZWN0T3duZXJzaGlwLkJVQ0tFVF9PV05FUl9FTkZPUkNFRCxcbiAgICAgIHJlbW92YWxQb2xpY3k6IFJlbW92YWxQb2xpY3kuREVTVFJPWSxcbiAgICAgIGVuY3J5cHRpb246IHMzLkJ1Y2tldEVuY3J5cHRpb24uS01TX01BTkFHRUQsXG4gICAgICBsaWZlY3ljbGVSdWxlczogW1xuICAgICAgICB7XG4gICAgICAgICAgZW5hYmxlZDogdHJ1ZSxcbiAgICAgICAgICBub25jdXJyZW50VmVyc2lvbnNUb1JldGFpbjogMTAwMCxcbiAgICAgICAgICBub25jdXJyZW50VmVyc2lvblRyYW5zaXRpb25zOiBbXG4gICAgICAgICAgICB7XG4gICAgICAgICAgICAgIHN0b3JhZ2VDbGFzczogczMuU3RvcmFnZUNsYXNzLklORlJFUVVFTlRfQUNDRVNTLFxuICAgICAgICAgICAgICB0cmFuc2l0aW9uQWZ0ZXI6IER1cmF0aW9uLmRheXMoMzApLFxuICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIHtcbiAgICAgICAgICAgICAgc3RvcmFnZUNsYXNzOiBzMy5TdG9yYWdlQ2xhc3MuR0xBQ0lFUixcbiAgICAgICAgICAgICAgdHJhbnNpdGlvbkFmdGVyOiBEdXJhdGlvbi5kYXlzKDkwKSxcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgICB7XG4gICAgICAgICAgICAgIHN0b3JhZ2VDbGFzczogczMuU3RvcmFnZUNsYXNzLkRFRVBfQVJDSElWRSxcbiAgICAgICAgICAgICAgdHJhbnNpdGlvbkFmdGVyOiBEdXJhdGlvbi5kYXlzKDE4MCksXG4gICAgICAgICAgICB9LFxuICAgICAgICAgIF0sXG4gICAgICAgIH0sXG4gICAgICBdLFxuICAgIH0pO1xuXG4gICAgdGhpcy50YWJsZSA9IG5ldyBkeW5hbW9kYi5UYWJsZSh0aGlzLCAndGFibGUnLCB7XG4gICAgICB0YWJsZU5hbWU6IHByb3BzLnRhYmxlTmFtZSxcbiAgICAgIGJpbGxpbmdNb2RlOiBkeW5hbW9kYi5CaWxsaW5nTW9kZS5QQVlfUEVSX1JFUVVFU1QsXG4gICAgICBkZWxldGlvblByb3RlY3Rpb246IHByb3BzLnRhYmxlRGVsZXRpb25Qcm90ZWN0aW9uID8/IGZhbHNlLFxuICAgICAgcGFydGl0aW9uS2V5OiB7XG4gICAgICAgIG5hbWU6ICdMb2NrSUQnLFxuICAgICAgICB0eXBlOiBkeW5hbW9kYi5BdHRyaWJ1dGVUeXBlLlNUUklORyxcbiAgICAgIH0sXG4gICAgICBwb2ludEluVGltZVJlY292ZXJ5OiB0cnVlLFxuICAgICAgcmVtb3ZhbFBvbGljeTogUmVtb3ZhbFBvbGljeS5ERVNUUk9ZLFxuICAgIH0pO1xuXG4gICAgdGhpcy5jcmVhdGVJYW1Qb2xpY2llcygpO1xuXG4gICAgbmV3IENmbk91dHB1dCh0aGlzLCAnb3V0cHV0LXRhYmxlJyxcbiAgICAgIHtcbiAgICAgICAgZGVzY3JpcHRpb246ICdBUk4gb2YgdGhlIER5bmFtb0RCIHRhYmxlJyxcbiAgICAgICAgZXhwb3J0TmFtZTogJ3RhYmxlQXJuJyxcbiAgICAgICAgdmFsdWU6IHRoaXMudGFibGUudGFibGVBcm4sXG4gICAgICB9KTtcblxuICAgIG5ldyBDZm5PdXRwdXQodGhpcywgJ291dHB1dC1idWNrZXQnLFxuICAgICAge1xuICAgICAgICBkZXNjcmlwdGlvbjogJ0FSTiBvZiB0aGUgUzMgYnVja2V0JyxcbiAgICAgICAgZXhwb3J0TmFtZTogJ2J1Y2tldEFybicsXG4gICAgICAgIHZhbHVlOiB0aGlzLmJ1Y2tldC5idWNrZXRBcm4sXG4gICAgICB9KTtcblxuICB9XG5cbiAgcHJpdmF0ZSBjcmVhdGVJYW1Qb2xpY2llcygpIHtcbiAgICAvLyBQb2xpY3kgU3RhdGVtZW50IGZvciByZWFkaW5nLyB3cml0aW5nIER5YW5tb0RCIHRhYmxlXG4gICAgY29uc3QgZGRiU3RhdGVtZW50ID0gbmV3IGlhbS5Qb2xpY3lTdGF0ZW1lbnQoe1xuICAgICAgc2lkOiAnRHluYW1vREJUYWJsZScsXG4gICAgICBlZmZlY3Q6IGlhbS5FZmZlY3QuQUxMT1csXG4gICAgICBhY3Rpb25zOiBbXG4gICAgICAgICdkeW5hbW9kYjpEZXNjcmliZVRhYmxlJyxcbiAgICAgICAgJ2R5bmFtb2RiOkdldEl0ZW0nLFxuICAgICAgICAnZHluYW1vZGI6UHV0SXRlbScsXG4gICAgICAgICdkeW5hbW9kYjpEZWxldGVJdGVtJyxcbiAgICAgIF0sXG4gICAgICByZXNvdXJjZXM6IFt0aGlzLnRhYmxlLnRhYmxlQXJuXSxcbiAgICB9KTtcbiAgICAvLyBQb2xpY3kgU3RhdGVtZW50IGZvciByZWFkaW5nLyB3cml0aW5nIHRvIHRoZSBTMyBidWNrZXQgYW5kIG9iamVjdHNcbiAgICBjb25zdCBzM1N0YXRlbWVudCA9IG5ldyBpYW0uUG9saWN5U3RhdGVtZW50KHtcbiAgICAgIHNpZDogJ1MzQnVja2V0JyxcbiAgICAgIGVmZmVjdDogaWFtLkVmZmVjdC5BTExPVyxcbiAgICAgIGFjdGlvbnM6IFtcbiAgICAgICAgJ3MzOkxpc3RCdWNrZXQnLFxuICAgICAgICAnczM6R2V0T2JqZWN0JyxcbiAgICAgICAgJ3MzOlB1dE9iamVjdCcsXG4gICAgICAgICdzMzpEZWxldGVPYmplY3QnLFxuICAgICAgXSxcbiAgICAgIHJlc291cmNlczogW3RoaXMuYnVja2V0LmJ1Y2tldEFybiwgdGhpcy5idWNrZXQuYnVja2V0QXJuICsgJy8qJ10sXG4gICAgfSk7XG5cbiAgICBuZXcgaWFtLlBvbGljeURvY3VtZW50KHtcbiAgICAgIHN0YXRlbWVudHM6IFtkZGJTdGF0ZW1lbnQsIHMzU3RhdGVtZW50XSxcbiAgICB9KTtcbiAgICBuZXcgaWFtLk1hbmFnZWRQb2xpY3kodGhpcywgJ21hbmFnZWQtcG9saWN5Jywge1xuICAgICAgZGVzY3JpcHRpb246ICdNYW5hZ2VkIHBvbGljeSBmb3IgVGVycmFmb3JtIHN0YXRlIGJhY2tlbmQnLFxuICAgICAgc3RhdGVtZW50czogW2RkYlN0YXRlbWVudCwgczNTdGF0ZW1lbnRdLFxuICAgICAgbWFuYWdlZFBvbGljeU5hbWU6ICdUZXJyYWZvcm1TdGF0ZUJhY2tlbmRQb2xpY3knLFxuICAgIH0pO1xuXG5cbiAgfVxufVxuIl19