def negate_sequence_elements_at_indices(sequence, indices):
    '''.. versionadded:: 1.1.1

    Negate `sequence` elements at `indices`::

        abjad> from abjad.tools import seqtools

    ::

        abjad> sequence = [1, 2, 3, 4, 5, -6, -7, -8, -9, -10]

    ::

        abjad> seqtools.negate_sequence_elements_at_indices(sequence, [0, 1, 2])
        [-1, -2, -3, 4, 5, -6, -7, -8, -9, -10]

    Return newly constructed list.

    .. versionchanged:: 2.0
        renamed ``seqtools.negate_elements_at_indices( )`` to
        ``seqtools.negate_sequence_elements_at_indices( )``.
    '''

    if not isinstance(sequence, list):
        raise TypeError

    result = [ ]

    for i, element in enumerate(sequence):
        if (i in indices):
            result.append(-element)
        else:
            result.append(element)

    return result
