# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

from typing import Union
from typing_extensions import Literal, Required, TypeAlias, TypedDict

from .query_generator_config import QueryGeneratorConfig

__all__ = ["QueryConfig", "Ranker", "RankerRrfRanker", "RankerWeightedRanker"]


class RankerRrfRanker(TypedDict, total=False):
    impact_factor: Required[float]
    """The impact factor for RRF scoring.

    Higher values give more weight to higher-ranked results. Must be greater than 0.
    Default of 60 is from the original RRF paper (Cormack et al., 2009).
    """

    type: Required[Literal["rrf"]]
    """The type of ranker, always "rrf" """


class RankerWeightedRanker(TypedDict, total=False):
    alpha: Required[float]
    """Weight factor between 0 and 1.

    0 means only use keyword scores, 1 means only use vector scores, values in
    between blend both scores.
    """

    type: Required[Literal["weighted"]]
    """The type of ranker, always "weighted" """


Ranker: TypeAlias = Union[RankerRrfRanker, RankerWeightedRanker]


class QueryConfig(TypedDict, total=False):
    chunk_template: Required[str]
    """Template for formatting each retrieved chunk in the context.

    Available placeholders: {index} (1-based chunk ordinal), {chunk.content} (chunk
    content string), {metadata} (chunk metadata dict). Default: "Result
    {index}\nContent: {chunk.content}\nMetadata: {metadata}\n"
    """

    max_chunks: Required[int]
    """Maximum number of chunks to retrieve."""

    max_tokens_in_context: Required[int]
    """Maximum number of tokens in the context."""

    query_generator_config: Required[QueryGeneratorConfig]
    """Configuration for the query generator."""

    mode: str
    """Search mode for retrieval—either "vector", "keyword", or "hybrid".

    Default "vector".
    """

    ranker: Ranker
    """Configuration for the ranker to use in hybrid search. Defaults to RRF ranker."""
