# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

from typing import Dict, List, Union, Iterable
from typing_extensions import Required, TypedDict

__all__ = ["BenchmarkRegisterParams"]


class BenchmarkRegisterParams(TypedDict, total=False):
    benchmark_id: Required[str]
    """The ID of the benchmark to register."""

    dataset_id: Required[str]
    """The ID of the dataset to use for the benchmark."""

    scoring_functions: Required[List[str]]
    """The scoring functions to use for the benchmark."""

    metadata: Dict[str, Union[bool, float, str, Iterable[object], object, None]]
    """The metadata to use for the benchmark."""

    provider_benchmark_id: str
    """The ID of the provider benchmark to use for the benchmark."""

    provider_id: str
    """The ID of the provider to use for the benchmark."""
