# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

from typing import Dict, Type, Union, Iterable, cast
from typing_extensions import Literal

import httpx

from ..types import dataset_iterrows_params, dataset_register_params, dataset_appendrows_params
from .._types import NOT_GIVEN, Body, Query, Headers, NoneType, NotGiven
from .._utils import maybe_transform, async_maybe_transform
from .._compat import cached_property
from .._resource import SyncAPIResource, AsyncAPIResource
from .._response import (
    to_raw_response_wrapper,
    to_streamed_response_wrapper,
    async_to_raw_response_wrapper,
    async_to_streamed_response_wrapper,
)
from .._wrappers import DataWrapper
from .._base_client import make_request_options
from ..types.dataset_list_response import DatasetListResponse
from ..types.dataset_iterrows_response import DatasetIterrowsResponse
from ..types.dataset_register_response import DatasetRegisterResponse
from ..types.dataset_retrieve_response import DatasetRetrieveResponse

__all__ = ["DatasetsResource", "AsyncDatasetsResource"]


class DatasetsResource(SyncAPIResource):
    @cached_property
    def with_raw_response(self) -> DatasetsResourceWithRawResponse:
        """
        This property can be used as a prefix for any HTTP method call to return
        the raw response object instead of the parsed content.

        For more information, see https://www.github.com/llamastack/llama-stack-client-python#accessing-raw-response-data-eg-headers
        """
        return DatasetsResourceWithRawResponse(self)

    @cached_property
    def with_streaming_response(self) -> DatasetsResourceWithStreamingResponse:
        """
        An alternative to `.with_raw_response` that doesn't eagerly read the response body.

        For more information, see https://www.github.com/llamastack/llama-stack-client-python#with_streaming_response
        """
        return DatasetsResourceWithStreamingResponse(self)

    def retrieve(
        self,
        dataset_id: str,
        *,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> DatasetRetrieveResponse:
        """
        Get a dataset by its ID.

        Args:
          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        if not dataset_id:
            raise ValueError(f"Expected a non-empty value for `dataset_id` but received {dataset_id!r}")
        return self._get(
            f"/v1/datasets/{dataset_id}",
            options=make_request_options(
                extra_headers=extra_headers, extra_query=extra_query, extra_body=extra_body, timeout=timeout
            ),
            cast_to=DatasetRetrieveResponse,
        )

    def list(
        self,
        *,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> DatasetListResponse:
        """List all datasets."""
        return self._get(
            "/v1/datasets",
            options=make_request_options(
                extra_headers=extra_headers,
                extra_query=extra_query,
                extra_body=extra_body,
                timeout=timeout,
                post_parser=DataWrapper[DatasetListResponse]._unwrapper,
            ),
            cast_to=cast(Type[DatasetListResponse], DataWrapper[DatasetListResponse]),
        )

    def appendrows(
        self,
        dataset_id: str,
        *,
        rows: Iterable[Dict[str, Union[bool, float, str, Iterable[object], object, None]]],
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> None:
        """
        Append rows to a dataset.

        Args:
          rows: The rows to append to the dataset.

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        if not dataset_id:
            raise ValueError(f"Expected a non-empty value for `dataset_id` but received {dataset_id!r}")
        extra_headers = {"Accept": "*/*", **(extra_headers or {})}
        return self._post(
            f"/v1/datasetio/append-rows/{dataset_id}",
            body=maybe_transform({"rows": rows}, dataset_appendrows_params.DatasetAppendrowsParams),
            options=make_request_options(
                extra_headers=extra_headers, extra_query=extra_query, extra_body=extra_body, timeout=timeout
            ),
            cast_to=NoneType,
        )

    def iterrows(
        self,
        dataset_id: str,
        *,
        limit: int | NotGiven = NOT_GIVEN,
        start_index: int | NotGiven = NOT_GIVEN,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> DatasetIterrowsResponse:
        """Get a paginated list of rows from a dataset.

        Uses offset-based pagination where:

        - start_index: The starting index (0-based). If None, starts from beginning.
        - limit: Number of items to return. If None or -1, returns all items.

        The response includes:

        - data: List of items for the current page.
        - has_more: Whether there are more items available after this set.

        Args:
          limit: The number of rows to get.

          start_index: Index into dataset for the first row to get. Get all rows if None.

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        if not dataset_id:
            raise ValueError(f"Expected a non-empty value for `dataset_id` but received {dataset_id!r}")
        return self._get(
            f"/v1/datasetio/iterrows/{dataset_id}",
            options=make_request_options(
                extra_headers=extra_headers,
                extra_query=extra_query,
                extra_body=extra_body,
                timeout=timeout,
                query=maybe_transform(
                    {
                        "limit": limit,
                        "start_index": start_index,
                    },
                    dataset_iterrows_params.DatasetIterrowsParams,
                ),
            ),
            cast_to=DatasetIterrowsResponse,
        )

    def register(
        self,
        *,
        purpose: Literal["post-training/messages", "eval/question-answer", "eval/messages-answer"],
        source: dataset_register_params.Source,
        dataset_id: str | NotGiven = NOT_GIVEN,
        metadata: Dict[str, Union[bool, float, str, Iterable[object], object, None]] | NotGiven = NOT_GIVEN,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> DatasetRegisterResponse:
        """Register a new dataset.

        Args:
          purpose: The purpose of the dataset.

        One of: - "post-training/messages": The dataset
              contains a messages column with list of messages for post-training. {
              "messages": [ {"role": "user", "content": "Hello, world!"}, {"role":
              "assistant", "content": "Hello, world!"}, ] } - "eval/question-answer": The
              dataset contains a question column and an answer column for evaluation. {
              "question": "What is the capital of France?", "answer": "Paris" } -
              "eval/messages-answer": The dataset contains a messages column with list of
              messages and an answer column for evaluation. { "messages": [ {"role": "user",
              "content": "Hello, my name is John Doe."}, {"role": "assistant", "content":
              "Hello, John Doe. How can I help you today?"}, {"role": "user", "content":
              "What's my name?"}, ], "answer": "John Doe" }

          source: The data source of the dataset. Ensure that the data source schema is compatible
              with the purpose of the dataset. Examples: - { "type": "uri", "uri":
              "https://mywebsite.com/mydata.jsonl" } - { "type": "uri", "uri":
              "lsfs://mydata.jsonl" } - { "type": "uri", "uri":
              "data:csv;base64,{base64_content}" } - { "type": "uri", "uri":
              "huggingface://llamastack/simpleqa?split=train" } - { "type": "rows", "rows": [
              { "messages": [ {"role": "user", "content": "Hello, world!"}, {"role":
              "assistant", "content": "Hello, world!"}, ] } ] }

          dataset_id: The ID of the dataset. If not provided, an ID will be generated.

          metadata: The metadata for the dataset. - E.g. {"description": "My dataset"}.

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        return self._post(
            "/v1/datasets",
            body=maybe_transform(
                {
                    "purpose": purpose,
                    "source": source,
                    "dataset_id": dataset_id,
                    "metadata": metadata,
                },
                dataset_register_params.DatasetRegisterParams,
            ),
            options=make_request_options(
                extra_headers=extra_headers, extra_query=extra_query, extra_body=extra_body, timeout=timeout
            ),
            cast_to=DatasetRegisterResponse,
        )

    def unregister(
        self,
        dataset_id: str,
        *,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> None:
        """
        Unregister a dataset by its ID.

        Args:
          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        if not dataset_id:
            raise ValueError(f"Expected a non-empty value for `dataset_id` but received {dataset_id!r}")
        extra_headers = {"Accept": "*/*", **(extra_headers or {})}
        return self._delete(
            f"/v1/datasets/{dataset_id}",
            options=make_request_options(
                extra_headers=extra_headers, extra_query=extra_query, extra_body=extra_body, timeout=timeout
            ),
            cast_to=NoneType,
        )


class AsyncDatasetsResource(AsyncAPIResource):
    @cached_property
    def with_raw_response(self) -> AsyncDatasetsResourceWithRawResponse:
        """
        This property can be used as a prefix for any HTTP method call to return
        the raw response object instead of the parsed content.

        For more information, see https://www.github.com/llamastack/llama-stack-client-python#accessing-raw-response-data-eg-headers
        """
        return AsyncDatasetsResourceWithRawResponse(self)

    @cached_property
    def with_streaming_response(self) -> AsyncDatasetsResourceWithStreamingResponse:
        """
        An alternative to `.with_raw_response` that doesn't eagerly read the response body.

        For more information, see https://www.github.com/llamastack/llama-stack-client-python#with_streaming_response
        """
        return AsyncDatasetsResourceWithStreamingResponse(self)

    async def retrieve(
        self,
        dataset_id: str,
        *,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> DatasetRetrieveResponse:
        """
        Get a dataset by its ID.

        Args:
          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        if not dataset_id:
            raise ValueError(f"Expected a non-empty value for `dataset_id` but received {dataset_id!r}")
        return await self._get(
            f"/v1/datasets/{dataset_id}",
            options=make_request_options(
                extra_headers=extra_headers, extra_query=extra_query, extra_body=extra_body, timeout=timeout
            ),
            cast_to=DatasetRetrieveResponse,
        )

    async def list(
        self,
        *,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> DatasetListResponse:
        """List all datasets."""
        return await self._get(
            "/v1/datasets",
            options=make_request_options(
                extra_headers=extra_headers,
                extra_query=extra_query,
                extra_body=extra_body,
                timeout=timeout,
                post_parser=DataWrapper[DatasetListResponse]._unwrapper,
            ),
            cast_to=cast(Type[DatasetListResponse], DataWrapper[DatasetListResponse]),
        )

    async def appendrows(
        self,
        dataset_id: str,
        *,
        rows: Iterable[Dict[str, Union[bool, float, str, Iterable[object], object, None]]],
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> None:
        """
        Append rows to a dataset.

        Args:
          rows: The rows to append to the dataset.

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        if not dataset_id:
            raise ValueError(f"Expected a non-empty value for `dataset_id` but received {dataset_id!r}")
        extra_headers = {"Accept": "*/*", **(extra_headers or {})}
        return await self._post(
            f"/v1/datasetio/append-rows/{dataset_id}",
            body=await async_maybe_transform({"rows": rows}, dataset_appendrows_params.DatasetAppendrowsParams),
            options=make_request_options(
                extra_headers=extra_headers, extra_query=extra_query, extra_body=extra_body, timeout=timeout
            ),
            cast_to=NoneType,
        )

    async def iterrows(
        self,
        dataset_id: str,
        *,
        limit: int | NotGiven = NOT_GIVEN,
        start_index: int | NotGiven = NOT_GIVEN,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> DatasetIterrowsResponse:
        """Get a paginated list of rows from a dataset.

        Uses offset-based pagination where:

        - start_index: The starting index (0-based). If None, starts from beginning.
        - limit: Number of items to return. If None or -1, returns all items.

        The response includes:

        - data: List of items for the current page.
        - has_more: Whether there are more items available after this set.

        Args:
          limit: The number of rows to get.

          start_index: Index into dataset for the first row to get. Get all rows if None.

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        if not dataset_id:
            raise ValueError(f"Expected a non-empty value for `dataset_id` but received {dataset_id!r}")
        return await self._get(
            f"/v1/datasetio/iterrows/{dataset_id}",
            options=make_request_options(
                extra_headers=extra_headers,
                extra_query=extra_query,
                extra_body=extra_body,
                timeout=timeout,
                query=await async_maybe_transform(
                    {
                        "limit": limit,
                        "start_index": start_index,
                    },
                    dataset_iterrows_params.DatasetIterrowsParams,
                ),
            ),
            cast_to=DatasetIterrowsResponse,
        )

    async def register(
        self,
        *,
        purpose: Literal["post-training/messages", "eval/question-answer", "eval/messages-answer"],
        source: dataset_register_params.Source,
        dataset_id: str | NotGiven = NOT_GIVEN,
        metadata: Dict[str, Union[bool, float, str, Iterable[object], object, None]] | NotGiven = NOT_GIVEN,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> DatasetRegisterResponse:
        """Register a new dataset.

        Args:
          purpose: The purpose of the dataset.

        One of: - "post-training/messages": The dataset
              contains a messages column with list of messages for post-training. {
              "messages": [ {"role": "user", "content": "Hello, world!"}, {"role":
              "assistant", "content": "Hello, world!"}, ] } - "eval/question-answer": The
              dataset contains a question column and an answer column for evaluation. {
              "question": "What is the capital of France?", "answer": "Paris" } -
              "eval/messages-answer": The dataset contains a messages column with list of
              messages and an answer column for evaluation. { "messages": [ {"role": "user",
              "content": "Hello, my name is John Doe."}, {"role": "assistant", "content":
              "Hello, John Doe. How can I help you today?"}, {"role": "user", "content":
              "What's my name?"}, ], "answer": "John Doe" }

          source: The data source of the dataset. Ensure that the data source schema is compatible
              with the purpose of the dataset. Examples: - { "type": "uri", "uri":
              "https://mywebsite.com/mydata.jsonl" } - { "type": "uri", "uri":
              "lsfs://mydata.jsonl" } - { "type": "uri", "uri":
              "data:csv;base64,{base64_content}" } - { "type": "uri", "uri":
              "huggingface://llamastack/simpleqa?split=train" } - { "type": "rows", "rows": [
              { "messages": [ {"role": "user", "content": "Hello, world!"}, {"role":
              "assistant", "content": "Hello, world!"}, ] } ] }

          dataset_id: The ID of the dataset. If not provided, an ID will be generated.

          metadata: The metadata for the dataset. - E.g. {"description": "My dataset"}.

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        return await self._post(
            "/v1/datasets",
            body=await async_maybe_transform(
                {
                    "purpose": purpose,
                    "source": source,
                    "dataset_id": dataset_id,
                    "metadata": metadata,
                },
                dataset_register_params.DatasetRegisterParams,
            ),
            options=make_request_options(
                extra_headers=extra_headers, extra_query=extra_query, extra_body=extra_body, timeout=timeout
            ),
            cast_to=DatasetRegisterResponse,
        )

    async def unregister(
        self,
        dataset_id: str,
        *,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> None:
        """
        Unregister a dataset by its ID.

        Args:
          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        if not dataset_id:
            raise ValueError(f"Expected a non-empty value for `dataset_id` but received {dataset_id!r}")
        extra_headers = {"Accept": "*/*", **(extra_headers or {})}
        return await self._delete(
            f"/v1/datasets/{dataset_id}",
            options=make_request_options(
                extra_headers=extra_headers, extra_query=extra_query, extra_body=extra_body, timeout=timeout
            ),
            cast_to=NoneType,
        )


class DatasetsResourceWithRawResponse:
    def __init__(self, datasets: DatasetsResource) -> None:
        self._datasets = datasets

        self.retrieve = to_raw_response_wrapper(
            datasets.retrieve,
        )
        self.list = to_raw_response_wrapper(
            datasets.list,
        )
        self.appendrows = to_raw_response_wrapper(
            datasets.appendrows,
        )
        self.iterrows = to_raw_response_wrapper(
            datasets.iterrows,
        )
        self.register = to_raw_response_wrapper(
            datasets.register,
        )
        self.unregister = to_raw_response_wrapper(
            datasets.unregister,
        )


class AsyncDatasetsResourceWithRawResponse:
    def __init__(self, datasets: AsyncDatasetsResource) -> None:
        self._datasets = datasets

        self.retrieve = async_to_raw_response_wrapper(
            datasets.retrieve,
        )
        self.list = async_to_raw_response_wrapper(
            datasets.list,
        )
        self.appendrows = async_to_raw_response_wrapper(
            datasets.appendrows,
        )
        self.iterrows = async_to_raw_response_wrapper(
            datasets.iterrows,
        )
        self.register = async_to_raw_response_wrapper(
            datasets.register,
        )
        self.unregister = async_to_raw_response_wrapper(
            datasets.unregister,
        )


class DatasetsResourceWithStreamingResponse:
    def __init__(self, datasets: DatasetsResource) -> None:
        self._datasets = datasets

        self.retrieve = to_streamed_response_wrapper(
            datasets.retrieve,
        )
        self.list = to_streamed_response_wrapper(
            datasets.list,
        )
        self.appendrows = to_streamed_response_wrapper(
            datasets.appendrows,
        )
        self.iterrows = to_streamed_response_wrapper(
            datasets.iterrows,
        )
        self.register = to_streamed_response_wrapper(
            datasets.register,
        )
        self.unregister = to_streamed_response_wrapper(
            datasets.unregister,
        )


class AsyncDatasetsResourceWithStreamingResponse:
    def __init__(self, datasets: AsyncDatasetsResource) -> None:
        self._datasets = datasets

        self.retrieve = async_to_streamed_response_wrapper(
            datasets.retrieve,
        )
        self.list = async_to_streamed_response_wrapper(
            datasets.list,
        )
        self.appendrows = async_to_streamed_response_wrapper(
            datasets.appendrows,
        )
        self.iterrows = async_to_streamed_response_wrapper(
            datasets.iterrows,
        )
        self.register = async_to_streamed_response_wrapper(
            datasets.register,
        )
        self.unregister = async_to_streamed_response_wrapper(
            datasets.unregister,
        )
