"""init

Revision ID: f206d1283979
Revises: 
Create Date: 2017-06-07 15:40:25.536703+03:00

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = 'f206d1283979'
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
# ### commands auto generated by Alembic - please adjust! ###
    op.create_table('tle',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('norad_cat_id', sa.Integer(), nullable=False),
    sa.Column('dt', sa.DateTime(), nullable=False),
    sa.Column('tle_line1', sa.String(length=69), nullable=False),
    sa.Column('tle_line2', sa.String(length=69), nullable=False),
    sa.Column('extra_info', postgresql.JSONB(none_as_null=True, astext_type=sa.Text()), nullable=True),
    sa.Column('source', sa.Enum('space-track', 'nasa', name='tle_source_enum', schema='tle_storage_service'), server_default='space-track', nullable=False),
    sa.Column('created_at', sa.DateTime(), server_default=sa.text("(now() at time zone 'utc')"), nullable=False),
    sa.Column('updated_at', sa.DateTime(), server_default=sa.text("(now() at time zone 'utc')"), nullable=False),
    sa.Column('is_deleted', sa.Boolean(), server_default=sa.text('false'), nullable=False),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('norad_cat_id', 'dt', 'source', 'is_deleted'),
    schema='tle_storage_service'
    )
    # ### end Alembic commands ###


def downgrade():
# ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('tle', schema='tle_storage_service')
    # ### end Alembic commands ###
