# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BoardArgs', 'Board']

@pulumi.input_type
class BoardArgs:
    def __init__(__self__, *,
                 column_layout: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 queries: Optional[pulumi.Input[Sequence[pulumi.Input['BoardQueryArgs']]]] = None,
                 style: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Board resource.
        :param pulumi.Input[str] column_layout: the number of columns to layout on the board, either `multi` (the default) or `single`. Only `visual` style boards (see below) have a column layout.
        :param pulumi.Input[str] description: Description of the board. Supports markdown.
        :param pulumi.Input[str] name: Name of the board.
        :param pulumi.Input[Sequence[pulumi.Input['BoardQueryArgs']]] queries: Zero or more configurations blocks (described below) with the queries of the board.
        :param pulumi.Input[str] style: How the board should be displayed in the UI, either `list` (the default) or `visual`.
        """
        if column_layout is not None:
            pulumi.set(__self__, "column_layout", column_layout)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if queries is not None:
            pulumi.set(__self__, "queries", queries)
        if style is not None:
            pulumi.set(__self__, "style", style)

    @property
    @pulumi.getter(name="columnLayout")
    def column_layout(self) -> Optional[pulumi.Input[str]]:
        """
        the number of columns to layout on the board, either `multi` (the default) or `single`. Only `visual` style boards (see below) have a column layout.
        """
        return pulumi.get(self, "column_layout")

    @column_layout.setter
    def column_layout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "column_layout", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the board. Supports markdown.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the board.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def queries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BoardQueryArgs']]]]:
        """
        Zero or more configurations blocks (described below) with the queries of the board.
        """
        return pulumi.get(self, "queries")

    @queries.setter
    def queries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BoardQueryArgs']]]]):
        pulumi.set(self, "queries", value)

    @property
    @pulumi.getter
    def style(self) -> Optional[pulumi.Input[str]]:
        """
        How the board should be displayed in the UI, either `list` (the default) or `visual`.
        """
        return pulumi.get(self, "style")

    @style.setter
    def style(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "style", value)


@pulumi.input_type
class _BoardState:
    def __init__(__self__, *,
                 column_layout: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 queries: Optional[pulumi.Input[Sequence[pulumi.Input['BoardQueryArgs']]]] = None,
                 style: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Board resources.
        :param pulumi.Input[str] column_layout: the number of columns to layout on the board, either `multi` (the default) or `single`. Only `visual` style boards (see below) have a column layout.
        :param pulumi.Input[str] description: Description of the board. Supports markdown.
        :param pulumi.Input[str] name: Name of the board.
        :param pulumi.Input[Sequence[pulumi.Input['BoardQueryArgs']]] queries: Zero or more configurations blocks (described below) with the queries of the board.
        :param pulumi.Input[str] style: How the board should be displayed in the UI, either `list` (the default) or `visual`.
        """
        if column_layout is not None:
            pulumi.set(__self__, "column_layout", column_layout)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if queries is not None:
            pulumi.set(__self__, "queries", queries)
        if style is not None:
            pulumi.set(__self__, "style", style)

    @property
    @pulumi.getter(name="columnLayout")
    def column_layout(self) -> Optional[pulumi.Input[str]]:
        """
        the number of columns to layout on the board, either `multi` (the default) or `single`. Only `visual` style boards (see below) have a column layout.
        """
        return pulumi.get(self, "column_layout")

    @column_layout.setter
    def column_layout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "column_layout", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the board. Supports markdown.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the board.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def queries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BoardQueryArgs']]]]:
        """
        Zero or more configurations blocks (described below) with the queries of the board.
        """
        return pulumi.get(self, "queries")

    @queries.setter
    def queries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BoardQueryArgs']]]]):
        pulumi.set(self, "queries", value)

    @property
    @pulumi.getter
    def style(self) -> Optional[pulumi.Input[str]]:
        """
        How the board should be displayed in the UI, either `list` (the default) or `visual`.
        """
        return pulumi.get(self, "style")

    @style.setter
    def style(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "style", value)


class Board(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 column_layout: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 queries: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BoardQueryArgs']]]]] = None,
                 style: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## # Resource: Board

        Creates a board. For more information about boards, check out [Collaborate with Boards](https://docs.honeycomb.io/working-with-your-data/collaborating/boards/#docs-sidebar).

        ## Example Usage
        ### Simple Board

        ```python
        import pulumi
        import pulumi_honeycomb as honeycomb

        query_get_query_specification = honeycomb.get_query_specification(calculations=[honeycomb.GetQuerySpecificationCalculationArgs(
                op="P99",
                column="duration_ms",
            )],
            filters=[honeycomb.GetQuerySpecificationFilterArgs(
                column="trace.parent_id",
                op="does-not-exist",
            )],
            breakdowns=["app.tenant"])
        query_query = honeycomb.Query("queryQuery",
            dataset=var["dataset"],
            query_json=query_get_query_specification.json)
        board = honeycomb.Board("board", queries=[honeycomb.BoardQueryArgs(
            dataset=var["dataset"],
            query_id=query_query.id,
        )])
        ```
        ### Annotated Board

        ```python
        import pulumi
        import pulumi_honeycomb as honeycomb

        latency_by_userid_get_query_specification = honeycomb.get_query_specification(time_range=86400,
            breakdowns=["app.user_id"],
            calculations=[
                honeycomb.GetQuerySpecificationCalculationArgs(
                    op="HEATMAP",
                    column="duration_ms",
                ),
                honeycomb.GetQuerySpecificationCalculationArgs(
                    op="P99",
                    column="duration_ms",
                ),
            ],
            filters=[honeycomb.GetQuerySpecificationFilterArgs(
                column="trace.parent_id",
                op="does-not-exist",
            )],
            orders=[honeycomb.GetQuerySpecificationOrderArgs(
                column="duration_ms",
                op="P99",
                order="descending",
            )])
        latency_by_userid_query = honeycomb.Query("latencyByUseridQuery",
            dataset=var["dataset"],
            query_json=latency_by_userid_get_query_specification.json)
        latency_by_userid_query_annotation = honeycomb.QueryAnnotation("latencyByUseridQueryAnnotation",
            dataset=var["dataset"],
            query_id=latency_by_userid_query.id,
            description="A breakdown of trace latency by User over the last 24 hours")
        overview = honeycomb.Board("overview",
            style="visual",
            queries=[honeycomb.BoardQueryArgs(
                caption="Latency by User",
                query_id=latency_by_userid_query.id,
                query_annotation_id=latency_by_userid_query_annotation.id,
                graph_settings=honeycomb.BoardQueryGraphSettingsArgs(
                    utc_xaxis=True,
                ),
            )])
        ```

        ## Import

        Boards can be imported using their ID, e.g.

        ```sh
         $ pulumi import honeycomb:index/board:Board my_board AobW9oAZX71
        ```

         You can find the ID in the URL bar when visiting the board from the UI.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] column_layout: the number of columns to layout on the board, either `multi` (the default) or `single`. Only `visual` style boards (see below) have a column layout.
        :param pulumi.Input[str] description: Description of the board. Supports markdown.
        :param pulumi.Input[str] name: Name of the board.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BoardQueryArgs']]]] queries: Zero or more configurations blocks (described below) with the queries of the board.
        :param pulumi.Input[str] style: How the board should be displayed in the UI, either `list` (the default) or `visual`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[BoardArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # Resource: Board

        Creates a board. For more information about boards, check out [Collaborate with Boards](https://docs.honeycomb.io/working-with-your-data/collaborating/boards/#docs-sidebar).

        ## Example Usage
        ### Simple Board

        ```python
        import pulumi
        import pulumi_honeycomb as honeycomb

        query_get_query_specification = honeycomb.get_query_specification(calculations=[honeycomb.GetQuerySpecificationCalculationArgs(
                op="P99",
                column="duration_ms",
            )],
            filters=[honeycomb.GetQuerySpecificationFilterArgs(
                column="trace.parent_id",
                op="does-not-exist",
            )],
            breakdowns=["app.tenant"])
        query_query = honeycomb.Query("queryQuery",
            dataset=var["dataset"],
            query_json=query_get_query_specification.json)
        board = honeycomb.Board("board", queries=[honeycomb.BoardQueryArgs(
            dataset=var["dataset"],
            query_id=query_query.id,
        )])
        ```
        ### Annotated Board

        ```python
        import pulumi
        import pulumi_honeycomb as honeycomb

        latency_by_userid_get_query_specification = honeycomb.get_query_specification(time_range=86400,
            breakdowns=["app.user_id"],
            calculations=[
                honeycomb.GetQuerySpecificationCalculationArgs(
                    op="HEATMAP",
                    column="duration_ms",
                ),
                honeycomb.GetQuerySpecificationCalculationArgs(
                    op="P99",
                    column="duration_ms",
                ),
            ],
            filters=[honeycomb.GetQuerySpecificationFilterArgs(
                column="trace.parent_id",
                op="does-not-exist",
            )],
            orders=[honeycomb.GetQuerySpecificationOrderArgs(
                column="duration_ms",
                op="P99",
                order="descending",
            )])
        latency_by_userid_query = honeycomb.Query("latencyByUseridQuery",
            dataset=var["dataset"],
            query_json=latency_by_userid_get_query_specification.json)
        latency_by_userid_query_annotation = honeycomb.QueryAnnotation("latencyByUseridQueryAnnotation",
            dataset=var["dataset"],
            query_id=latency_by_userid_query.id,
            description="A breakdown of trace latency by User over the last 24 hours")
        overview = honeycomb.Board("overview",
            style="visual",
            queries=[honeycomb.BoardQueryArgs(
                caption="Latency by User",
                query_id=latency_by_userid_query.id,
                query_annotation_id=latency_by_userid_query_annotation.id,
                graph_settings=honeycomb.BoardQueryGraphSettingsArgs(
                    utc_xaxis=True,
                ),
            )])
        ```

        ## Import

        Boards can be imported using their ID, e.g.

        ```sh
         $ pulumi import honeycomb:index/board:Board my_board AobW9oAZX71
        ```

         You can find the ID in the URL bar when visiting the board from the UI.

        :param str resource_name: The name of the resource.
        :param BoardArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BoardArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 column_layout: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 queries: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BoardQueryArgs']]]]] = None,
                 style: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BoardArgs.__new__(BoardArgs)

            __props__.__dict__["column_layout"] = column_layout
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["queries"] = queries
            __props__.__dict__["style"] = style
        super(Board, __self__).__init__(
            'honeycomb:index/board:Board',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            column_layout: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            queries: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BoardQueryArgs']]]]] = None,
            style: Optional[pulumi.Input[str]] = None) -> 'Board':
        """
        Get an existing Board resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] column_layout: the number of columns to layout on the board, either `multi` (the default) or `single`. Only `visual` style boards (see below) have a column layout.
        :param pulumi.Input[str] description: Description of the board. Supports markdown.
        :param pulumi.Input[str] name: Name of the board.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BoardQueryArgs']]]] queries: Zero or more configurations blocks (described below) with the queries of the board.
        :param pulumi.Input[str] style: How the board should be displayed in the UI, either `list` (the default) or `visual`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BoardState.__new__(_BoardState)

        __props__.__dict__["column_layout"] = column_layout
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["queries"] = queries
        __props__.__dict__["style"] = style
        return Board(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="columnLayout")
    def column_layout(self) -> pulumi.Output[str]:
        """
        the number of columns to layout on the board, either `multi` (the default) or `single`. Only `visual` style boards (see below) have a column layout.
        """
        return pulumi.get(self, "column_layout")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of the board. Supports markdown.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the board.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def queries(self) -> pulumi.Output[Optional[Sequence['outputs.BoardQuery']]]:
        """
        Zero or more configurations blocks (described below) with the queries of the board.
        """
        return pulumi.get(self, "queries")

    @property
    @pulumi.getter
    def style(self) -> pulumi.Output[Optional[str]]:
        """
        How the board should be displayed in the UI, either `list` (the default) or `visual`.
        """
        return pulumi.get(self, "style")

