/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.internal.core;

import com.ibm.db2.cmx.internal.json4j.JSONArray;
import com.ibm.db2.cmx.runtime.internal.trace.DataLogger;
import com.ibm.db2.cmx.runtime.internal.trace.Log;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MulticastClient {
    final String ADDRESS = "239.255.255.253";
    final int TTL = 10;
    private static Logger logger__ = Log.getCMXClientLogger();
    static InetAddress localhostAddress__ = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String locate(int n2, String string) {
        Object object;
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.logAtLevelFiner(logger__, this, "locate", "ENTRY " + Arrays.deepToString(new Object[]{n2, string}));
        }
        String[] stringArray = new String[2];
        MulticastSocket multicastSocket = null;
        try {
            multicastSocket = new MulticastSocket(n2);
            multicastSocket.setTimeToLive(10);
            object = InetAddress.getByName("239.255.255.253");
            multicastSocket.joinGroup((InetAddress)object);
            JSONArray jSONArray = new JSONArray();
            jSONArray.add("multicastclient");
            jSONArray.add(string);
            String string2 = jSONArray.serialize();
            this.sendAndReceiveRequests(n2, stringArray, multicastSocket, (InetAddress)object, string2, 2000L);
            if (stringArray[0] == null && stringArray[1] == null) {
                this.sendAndReceiveRequests(n2, stringArray, multicastSocket, (InetAddress)object, string2, 8000L);
                if (stringArray[0] == null && stringArray[1] == null) {
                    this.sendAndReceiveRequests(n2, stringArray, multicastSocket, (InetAddress)object, string2, 10000L);
                }
            }
        }
        catch (Throwable throwable) {
            DataLogger.logTrappedMonitoringException(logger__, this, "locate", throwable, "unable to locate multicast server");
        }
        finally {
            try {
                if (null != multicastSocket) {
                    multicastSocket.close();
                }
            }
            catch (Throwable throwable) {}
        }
        Object object2 = object = stringArray[0] != null ? stringArray[0] : stringArray[1];
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.exit(logger__, this, "locate", object);
        }
        return object;
    }

    private void sendAndReceiveRequests(int n2, String[] stringArray, MulticastSocket multicastSocket, InetAddress inetAddress, String string, long l10) {
        try {
            DatagramPacket datagramPacket = new DatagramPacket(string.getBytes(), string.length(), inetAddress, n2);
            if (logger__.isLoggable(Level.FINE)) {
                DataLogger.logConnectedComponents(logger__, this, "sendAndReceiveRequests", "autodiscovery request sent: " + string);
            }
            multicastSocket.send(datagramPacket);
            long l11 = System.currentTimeMillis() + l10;
            while (l11 > System.currentTimeMillis()) {
                byte[] byArray = new byte[300];
                DatagramPacket datagramPacket2 = new DatagramPacket(byArray, byArray.length);
                long l12 = l11 - System.currentTimeMillis();
                int n3 = (int)(l12 < 0L ? 1L : l12);
                multicastSocket.setSoTimeout(n3);
                multicastSocket.receive(datagramPacket2);
                String string2 = new String(datagramPacket2.getData(), datagramPacket2.getOffset(), datagramPacket2.getLength(), "UTF-8");
                JSONArray jSONArray = JSONArray.parse(string2);
                if (!jSONArray.get(0).toString().equals("multicastserver")) continue;
                String string3 = jSONArray.get(1).toString();
                if (datagramPacket2.getAddress().equals(localhostAddress__)) {
                    if (logger__.isLoggable(Level.FINE)) {
                        DataLogger.logConnectedComponents(logger__, this, "sendAndReceiveRequests", "found local server at url=" + string3);
                    }
                    stringArray[0] = string3;
                    continue;
                }
                if (logger__.isLoggable(Level.FINE)) {
                    DataLogger.logConnectedComponents(logger__, this, "sendAndReceiveRequests", "found remote server at url=" + string3);
                }
                stringArray[1] = string3;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        localhostAddress__ = AccessController.doPrivileged(new PrivilegedAction<InetAddress>(){

            @Override
            public InetAddress run() {
                try {
                    return InetAddress.getLocalHost();
                }
                catch (UnknownHostException unknownHostException) {
                    DataLogger.logTrappedMonitoringException(logger__, "MulticastClient", "run", unknownHostException, "unable to obtain local host");
                    return null;
                }
            }
        });
    }
}

