/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng;

import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import org.firebirdsql.encodings.Encoding;
import org.firebirdsql.encodings.EncodingDefinition;
import org.firebirdsql.encodings.IEncodingFactory;
import org.firebirdsql.gds.ng.FbAttachment;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.IAttachProperties;
import org.firebirdsql.gds.ng.dbcrypt.DbCryptCallback;
import org.firebirdsql.gds.ng.dbcrypt.DbCryptCallbackSpi;
import org.firebirdsql.gds.ng.dbcrypt.simple.StaticValueDbCryptCallbackSpi;

public abstract class AbstractConnection<T extends IAttachProperties<T>, C extends FbAttachment> {
    private static final DbCryptCallbackSpi DEFAULT_DB_CRYPT_CALLBACK_SPI = new StaticValueDbCryptCallbackSpi();
    protected final T attachProperties;
    private final EncodingDefinition encodingDefinition;
    private final IEncodingFactory encodingFactory;

    protected AbstractConnection(T attachProperties, IEncodingFactory encodingFactory) throws SQLException {
        this.attachProperties = attachProperties.asNewMutable();
        String firebirdEncodingName = attachProperties.getEncoding();
        String javaCharsetAlias = attachProperties.getCharSet();
        EncodingDefinition tempEncodingDefinition = encodingFactory.getEncodingDefinition(firebirdEncodingName, javaCharsetAlias);
        if (tempEncodingDefinition == null || tempEncodingDefinition.isInformationOnly()) {
            if (firebirdEncodingName == null && javaCharsetAlias == null) {
                tempEncodingDefinition = encodingFactory.getEncodingDefinition("NONE", null);
            } else {
                throw new SQLNonTransientConnectionException(String.format("No valid encoding definition for Firebird encoding %s and/or Java charset %s", firebirdEncodingName, javaCharsetAlias), "08000");
            }
        }
        this.encodingDefinition = tempEncodingDefinition;
        this.encodingFactory = encodingFactory.withDefaultEncodingDefinition(this.encodingDefinition);
        this.attachProperties.setEncoding(this.encodingDefinition.getFirebirdEncodingName());
        this.attachProperties.setCharSet(this.encodingDefinition.getJavaEncodingName());
    }

    public abstract C identify() throws SQLException;

    public final String getServerName() {
        return this.attachProperties.getServerName();
    }

    public final int getPortNumber() {
        return this.attachProperties.getPortNumber();
    }

    public final String getAttachObjectName() {
        return this.attachProperties.getAttachObjectName();
    }

    public final T getAttachProperties() {
        return this.attachProperties.asImmutable();
    }

    public final EncodingDefinition getEncodingDefinition() {
        return this.encodingDefinition;
    }

    public final Encoding getEncoding() {
        return this.encodingDefinition.getEncoding();
    }

    public final IEncodingFactory getEncodingFactory() {
        return this.encodingFactory;
    }

    public final DbCryptCallback createDbCryptCallback() throws SQLException {
        try {
            String dbCryptConfig = this.getAttachProperties().getDbCryptConfig();
            return DEFAULT_DB_CRYPT_CALLBACK_SPI.createDbCryptCallback(dbCryptConfig);
        }
        catch (RuntimeException e) {
            throw new FbExceptionBuilder().nonTransientConnectionException(337248284).cause(e).toSQLException();
        }
    }
}

