/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds;

import java.io.IOException;
import java.io.OutputStream;

public final class VaxEncoding {
    private VaxEncoding() {
    }

    public static int iscVaxInteger(byte[] buffer, int startPosition, int length) {
        if (length > 4) {
            return 0;
        }
        int value = 0;
        int shift = 0;
        int index = startPosition;
        while (--length >= 0) {
            value += (buffer[index++] & 0xFF) << shift;
            shift += 8;
        }
        return value;
    }

    public static void encodeVaxInteger(OutputStream stream, int value) throws IOException {
        stream.write(4);
        VaxEncoding.encodeVaxIntegerWithoutLength(stream, value);
    }

    public static void encodeVaxIntegerWithoutLength(OutputStream stream, int value) throws IOException {
        stream.write(value);
        stream.write(value >> 8);
        stream.write(value >> 16);
        stream.write(value >> 24);
    }

    public static long iscVaxLong(byte[] buffer, int startPosition, int length) {
        if (length > 8) {
            return 0L;
        }
        long value = 0L;
        int shift = 0;
        int index = startPosition;
        while (--length >= 0) {
            value += ((long)buffer[index++] & 0xFFL) << shift;
            shift += 8;
        }
        return value;
    }

    public static void encodeVaxLong(OutputStream stream, long value) throws IOException {
        stream.write(8);
        VaxEncoding.encodeVaxLongWithoutLength(stream, value);
    }

    public static void encodeVaxLongWithoutLength(OutputStream stream, long value) throws IOException {
        stream.write((int)value);
        stream.write((int)(value >> 8));
        stream.write((int)(value >> 16));
        stream.write((int)(value >> 24));
        stream.write((int)(value >> 32));
        stream.write((int)(value >> 40));
        stream.write((int)(value >> 48));
        stream.write((int)(value >> 56));
    }

    public static int iscVaxInteger2(byte[] buffer, int startPosition) {
        return buffer[startPosition] & 0xFF | (buffer[startPosition + 1] & 0xFF) << 8;
    }

    public static void encodeVaxInteger2WithoutLength(OutputStream stream, int value) throws IOException {
        stream.write(value);
        stream.write(value >> 8);
    }
}

