/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.dsi.core.impl;

import com.simba.googlebigquery.dsi.core.impl.DSIDriver;
import com.simba.googlebigquery.dsi.core.impl.DSIDriverSingleton;
import com.simba.googlebigquery.dsi.core.interfaces.IConnection;
import com.simba.googlebigquery.dsi.core.interfaces.IDriver;
import com.simba.googlebigquery.dsi.core.interfaces.IEnvironment;
import com.simba.googlebigquery.dsi.core.interfaces.ITransactionStateListener;
import com.simba.googlebigquery.dsi.core.utilities.AttributeDataMap;
import com.simba.googlebigquery.dsi.core.utilities.ClientInfoData;
import com.simba.googlebigquery.dsi.core.utilities.ConnSettingRequestMap;
import com.simba.googlebigquery.dsi.core.utilities.ConnSettingResponseMap;
import com.simba.googlebigquery.dsi.core.utilities.ConnectionSetting;
import com.simba.googlebigquery.dsi.core.utilities.ConnectionSettingInfo;
import com.simba.googlebigquery.dsi.core.utilities.PromptType;
import com.simba.googlebigquery.dsi.core.utilities.Variant;
import com.simba.googlebigquery.dsi.dataengine.impl.DSISimpleArray;
import com.simba.googlebigquery.dsi.dataengine.interfaces.IArray;
import com.simba.googlebigquery.dsi.dataengine.interfaces.IColumn;
import com.simba.googlebigquery.dsi.dataengine.utilities.ColumnMetadata;
import com.simba.googlebigquery.dsi.dataengine.utilities.TypeMetadata;
import com.simba.googlebigquery.dsi.dataengine.utilities.TypeUtilities;
import com.simba.googlebigquery.dsi.exceptions.BadAttrValException;
import com.simba.googlebigquery.dsi.exceptions.BadAuthException;
import com.simba.googlebigquery.dsi.exceptions.BadPropertyKeyException;
import com.simba.googlebigquery.dsi.exceptions.IncorrectTypeException;
import com.simba.googlebigquery.dsi.exceptions.NumericOverflowException;
import com.simba.googlebigquery.dsi.utilities.DSIMessageKey;
import com.simba.googlebigquery.support.IMessageSource;
import com.simba.googlebigquery.support.IWarningListener;
import com.simba.googlebigquery.support.LogUtilities;
import com.simba.googlebigquery.support.SettingReader;
import com.simba.googlebigquery.support.Warning;
import com.simba.googlebigquery.support.WarningCode;
import com.simba.googlebigquery.support.exceptions.ClientInfoException;
import com.simba.googlebigquery.support.exceptions.ErrorException;
import com.simba.googlebigquery.support.exceptions.ExceptionType;
import com.simba.googlebigquery.support.exceptions.ExceptionUtilities;
import com.simba.googlebigquery.support.exceptions.FailedPropertiesReason;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public abstract class DSIConnection
implements IConnection {
    public static final String REQ_INDICATOR = "?";
    protected ITransactionStateListener m_transactionListener;
    protected AttributeDataMap m_connectionProperties = new AttributeDataMap();
    private IEnvironment m_environment;
    private IWarningListener m_warningListener = null;
    private Locale m_locale = null;
    private boolean m_isBeingReset = false;
    protected Map<String, ClientInfoData> m_clientInfoProperties = this.initializeClientInfoProperties();
    protected Map<Long, ConnectionSettingInfo> m_connectionSettingInfo = new HashMap<Long, ConnectionSettingInfo>();

    protected DSIConnection(IEnvironment iEnvironment) throws ErrorException {
        this.m_environment = iEnvironment;
        try {
            this.loadProperties();
            this.m_locale = ExceptionUtilities.createLocale(SettingReader.readSetting("DriverLocale"));
            LogUtilities.logFunctionEntrance(this.getConnectionLog(), iEnvironment);
        }
        catch (NumericOverflowException numericOverflowException) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_NUMERIC_OVERFLOW.name(), ExceptionType.NON_TRANSIENT_CONNECTION);
        }
        catch (IncorrectTypeException incorrectTypeException) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_VALTYPE_MISMATCH.name(), ExceptionType.NON_TRANSIENT_CONNECTION);
        }
    }

    @Override
    public void beginTransaction() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name(), ExceptionType.FEATURE_NOT_IMPLEMENTED);
    }

    @Override
    public void commit() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name(), ExceptionType.FEATURE_NOT_IMPLEMENTED);
    }

    @Override
    public void createSavepoint(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), string);
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name(), ExceptionType.FEATURE_NOT_IMPLEMENTED);
    }

    public void setClientInfoProperty(ClientInfoData clientInfoData) throws ErrorException {
        this.m_clientInfoProperties.put(clientInfoData.getName(), clientInfoData);
    }

    @Override
    public String getClientInfo(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), string);
        if (null != this.m_clientInfoProperties.get(string)) {
            return this.m_clientInfoProperties.get(string).getValue();
        }
        return null;
    }

    @Override
    public Map<String, ClientInfoData> getClientInfoProperties() {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        return this.m_clientInfoProperties;
    }

    @Override
    public Map<Long, ConnectionSettingInfo> getConnectionSettingInfo() {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        return this.m_connectionSettingInfo;
    }

    @Override
    public Variant getCustomProperty(int n) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), n);
        return null;
    }

    @Override
    public int getCustomPropertyType(int n) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), n);
        return 0;
    }

    @Override
    public String getDataSourceName() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        try {
            return this.getProperty(41).getString();
        }
        catch (BadPropertyKeyException badPropertyKeyException) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_PROPKEY.name(), "Data Source Name", (Throwable)badPropertyKeyException, ExceptionType.DEFAULT);
        }
    }

    @Override
    public Locale getLocale() {
        return this.m_locale;
    }

    @Override
    public void setLocale(Locale locale) {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), locale);
        this.m_locale = locale;
    }

    @Override
    public IMessageSource getMessageSource() {
        return this.m_environment.getMessageSource();
    }

    @Override
    public IEnvironment getParentEnvironment() {
        return this.m_environment;
    }

    @Override
    public Variant getProperty(int n) throws BadPropertyKeyException, ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), n);
        if (null == this.m_connectionProperties) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_PROPMAP.name(), ExceptionType.DEFAULT);
        }
        if (this.m_connectionProperties.isProperty(n)) {
            return this.m_connectionProperties.getProperty(n);
        }
        throw new BadPropertyKeyException(2, DSIMessageKey.INVALID_PROPKEY.name(), String.valueOf(n));
    }

    @Override
    public IWarningListener getWarningListener() {
        return this.m_warningListener;
    }

    @Override
    public boolean isAlive() {
        Variant variant = this.m_connectionProperties.getProperty(20);
        assert (null != variant);
        try {
            return variant.getLong() != 1L;
        }
        catch (IncorrectTypeException incorrectTypeException) {
            return false;
        }
        catch (NumericOverflowException numericOverflowException) {
            return false;
        }
    }

    @Override
    public boolean isCustomProperty(int n) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), n);
        return false;
    }

    @Override
    public boolean promptDialog(ConnSettingResponseMap connSettingResponseMap, ConnSettingRequestMap connSettingRequestMap, long l, PromptType promptType) {
        return false;
    }

    @Override
    public void registerTransactionStateListener(ITransactionStateListener iTransactionStateListener) {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), iTransactionStateListener);
        this.m_transactionListener = iTransactionStateListener;
    }

    @Override
    public void registerWarningListener(IWarningListener iWarningListener) {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), iWarningListener);
        this.m_warningListener = iWarningListener;
    }

    @Override
    public void releaseSavepoint(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), string);
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name(), ExceptionType.FEATURE_NOT_IMPLEMENTED);
    }

    @Override
    public void reset() throws ErrorException {
        assert (!this.m_isBeingReset);
        try {
            this.m_isBeingReset = true;
            try {
                this.loadProperties();
            }
            catch (NumericOverflowException numericOverflowException) {
                throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_NUMERIC_OVERFLOW.name(), ExceptionType.NON_TRANSIENT_CONNECTION);
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_VALTYPE_MISMATCH.name(), ExceptionType.NON_TRANSIENT_CONNECTION);
            }
            this.doReset();
        }
        finally {
            this.m_isBeingReset = false;
        }
    }

    @Override
    public void rollback() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name(), ExceptionType.FEATURE_NOT_IMPLEMENTED);
    }

    @Override
    public void rollback(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), string);
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name(), ExceptionType.FEATURE_NOT_IMPLEMENTED);
    }

    @Override
    public void setClientInfoProperty(String string, String string2) throws ClientInfoException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), string, string2);
        ClientInfoData clientInfoData = this.m_clientInfoProperties.get(string);
        if (null != clientInfoData) {
            if (null == string2 || string2.length() <= clientInfoData.getMaxLength()) {
                clientInfoData.setValue(string2);
            } else {
                String string3 = string2.substring(0, clientInfoData.getMaxLength() - 1);
                clientInfoData.setValue(string3);
                this.m_warningListener.postWarning(new Warning(WarningCode.GENERAL_WARNING, 2, DSIMessageKey.BAD_ATTR_VAL.name(), new String[]{string, string2}));
            }
        } else {
            HashMap<String, FailedPropertiesReason> hashMap = new HashMap<String, FailedPropertiesReason>();
            hashMap.put(string, FailedPropertiesReason.UNKNOWN_PROPERTY);
            throw (ClientInfoException)DSIDriver.s_DSIMessages.createClientInfoException(DSIMessageKey.INVALID_PROPKEY.name(), string, hashMap);
        }
    }

    @Override
    public void setCustomProperty(int n, Variant variant) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), n, variant);
    }

    @Override
    public void setInvokerAndClassLoader(Object object, Object object2) {
    }

    @Override
    public void setProperty(int n, Variant variant) throws BadAttrValException, ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), n, variant);
        if (null == this.m_connectionProperties) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_PROPMAP.name(), ExceptionType.DEFAULT);
        }
        this.m_connectionProperties.setProperty(n, variant);
    }

    @Override
    public String toNativeSQL(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), string);
        return String.valueOf(string);
    }

    protected abstract void doReset() throws ErrorException;

    protected Variant getOptionalSetting(String string, ConnSettingRequestMap connSettingRequestMap) {
        return connSettingRequestMap.getProperty(string);
    }

    protected Variant getRequiredSetting(String string, ConnSettingRequestMap connSettingRequestMap) throws BadAuthException {
        Variant variant = connSettingRequestMap.getProperty(string);
        if (null == variant) {
            throw new BadAuthException(2, DSIMessageKey.REQ_SETTING_NOT_FOUND.name(), string);
        }
        return variant;
    }

    protected boolean isBeingReset() {
        return this.m_isBeingReset;
    }

    protected void verifyOptionalSetting(String string, ConnSettingRequestMap connSettingRequestMap, ConnSettingResponseMap connSettingResponseMap) {
        this.verifyOptionalSetting(string, string, connSettingRequestMap, connSettingResponseMap);
    }

    protected void verifyOptionalSetting(String string, String string2, ConnSettingRequestMap connSettingRequestMap, ConnSettingResponseMap connSettingResponseMap) {
        if (null == connSettingRequestMap.getProperty(string)) {
            ConnectionSetting connectionSetting = new ConnectionSetting(0);
            connectionSetting.setLabel(string2);
            try {
                connectionSetting.insertValue(new Variant(0, REQ_INDICATOR));
            }
            catch (Exception exception) {
                try {
                    LogUtilities.logError(exception, this.getConnectionLog());
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            connSettingResponseMap.setProperty(string, connectionSetting);
        }
    }

    protected void verifyRequiredSetting(String string, ConnSettingRequestMap connSettingRequestMap, ConnSettingResponseMap connSettingResponseMap) {
        this.verifyRequiredSetting(string, string, connSettingRequestMap, connSettingResponseMap);
    }

    protected void verifyRequiredSetting(String string, String string2, ConnSettingRequestMap connSettingRequestMap, ConnSettingResponseMap connSettingResponseMap) {
        if (null == connSettingRequestMap.getProperty(string)) {
            ConnectionSetting connectionSetting = new ConnectionSetting(1);
            connectionSetting.setLabel(string2);
            try {
                connectionSetting.insertValue(new Variant(0, REQ_INDICATOR));
            }
            catch (Exception exception) {
                try {
                    LogUtilities.logError(exception, this.getConnectionLog());
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            connSettingResponseMap.setProperty(string, connectionSetting);
        }
    }

    private Map<String, ClientInfoData> initializeClientInfoProperties() {
        HashMap<String, ClientInfoData> hashMap = new HashMap<String, ClientInfoData>();
        hashMap.put("APPLICATIONNAME", new ClientInfoData("APPLICATIONNAME", 25, null, "The name of the application currently utilizing the connection."));
        hashMap.put("CLIENTUSER", new ClientInfoData("CLIENTUSER", 25, null, "The name of the user that the application using the connection is performing work for."));
        hashMap.put("CLIENTHOSTNAME", new ClientInfoData("CLIENTHOSTNAME", 25, null, "The hostname of the computer the application using the connection is running on."));
        return hashMap;
    }

    private void loadProperties() throws ErrorException, IncorrectTypeException, NumericOverflowException {
        this.m_connectionProperties.setProperty(1, 0, "Y");
        this.m_connectionProperties.setProperty(2, 0, "Y");
        this.m_connectionProperties.setProperty(3, 2, Character.valueOf('\u0000'));
        this.m_connectionProperties.setProperty(4, 3, 127L);
        this.m_connectionProperties.setProperty(5, 3, 1L);
        this.m_connectionProperties.setProperty(6, 3, 256L);
        this.m_connectionProperties.setProperty(7, 3, 0L);
        this.m_connectionProperties.setProperty(8, 2, Character.valueOf('\u0001'));
        this.m_connectionProperties.setProperty(9, 0, "Y");
        this.m_connectionProperties.setProperty(10, 0, ".");
        this.m_connectionProperties.setProperty(11, 0, "catalog");
        this.m_connectionProperties.setProperty(12, 3, 31L);
        this.m_connectionProperties.setProperty(13, 0, "");
        this.m_connectionProperties.setProperty(14, 0, "Y");
        this.m_connectionProperties.setProperty(15, 2, Character.valueOf('\u0000'));
        this.m_connectionProperties.setProperty(16, 3, 0L);
        this.m_connectionProperties.setProperty(17, 6, 0);
        this.m_connectionProperties.setProperty(18, 3, 1L);
        this.m_connectionProperties.setProperty(19, 3, 1L);
        this.m_connectionProperties.setProperty(21, 3, 0L);
        this.m_connectionProperties.setProperty(20, 3, 0L);
        this.m_connectionProperties.setProperty(22, 0, "");
        this.m_connectionProperties.setProperty(26, 3, 1L);
        this.m_connectionProperties.setProperty(23, 3, 0L);
        this.m_connectionProperties.setProperty(24, 3, 1024L);
        this.m_connectionProperties.setProperty(25, 4, 0L);
        this.m_connectionProperties.setProperty(27, 3, 3L);
        this.m_connectionProperties.setProperty(28, 2, Character.valueOf('\u0002'));
        this.m_connectionProperties.setProperty(29, 3, 0L);
        this.m_connectionProperties.setProperty(30, 3, 0L);
        this.m_connectionProperties.setProperty(31, 3, 0L);
        this.m_connectionProperties.setProperty(32, 3, 0L);
        this.m_connectionProperties.setProperty(33, 3, 0L);
        this.m_connectionProperties.setProperty(34, 3, 0L);
        this.m_connectionProperties.setProperty(35, 3, 0L);
        this.m_connectionProperties.setProperty(36, 3, 0L);
        this.m_connectionProperties.setProperty(37, 2, Character.valueOf('\u0001'));
        this.m_connectionProperties.setProperty(38, 2, Character.valueOf('\u0001'));
        this.m_connectionProperties.setProperty(39, 3, 0L);
        this.m_connectionProperties.setProperty(40, 0, "Y");
        this.m_connectionProperties.setProperty(43, 3, 65535L);
        this.m_connectionProperties.setProperty(41, 0, "TEXT");
        this.m_connectionProperties.setProperty(42, 0, "00.00.0000");
        this.m_connectionProperties.setProperty(44, 3, 0L);
        this.m_connectionProperties.setProperty(45, 3, 1L);
        this.m_connectionProperties.setProperty(46, 0, "Y");
        this.m_connectionProperties.setProperty(47, 3, 0L);
        this.m_connectionProperties.setProperty(48, 3, 0L);
        this.m_connectionProperties.setProperty(49, 3, 0L);
        this.m_connectionProperties.setProperty(50, 3, 0L);
        this.m_connectionProperties.setProperty(51, 3, 0L);
        this.m_connectionProperties.setProperty(52, 3, 0L);
        this.m_connectionProperties.setProperty(53, 3, 0L);
        this.m_connectionProperties.setProperty(54, 3, 0L);
        this.m_connectionProperties.setProperty(55, 0, "Y");
        this.m_connectionProperties.setProperty(56, 2, Character.valueOf('\u0002'));
        this.m_connectionProperties.setProperty(57, 2, Character.valueOf('\u0004'));
        this.m_connectionProperties.setProperty(58, 0, "\"");
        this.m_connectionProperties.setProperty(59, 3, 0L);
        this.m_connectionProperties.setProperty(60, 3, 7L);
        this.m_connectionProperties.setProperty(61, 0, "N");
        this.m_connectionProperties.setProperty(62, 0, "");
        this.m_connectionProperties.setProperty(63, 0, "Y");
        this.m_connectionProperties.setProperty(64, 3, 0L);
        this.m_connectionProperties.setProperty(65, 3, 0L);
        this.m_connectionProperties.setProperty(66, 2, Character.valueOf('\u0000'));
        this.m_connectionProperties.setProperty(67, 3, 0L);
        this.m_connectionProperties.setProperty(68, 2, Character.valueOf('\u0000'));
        this.m_connectionProperties.setProperty(69, 2, Character.valueOf('\u0000'));
        this.m_connectionProperties.setProperty(70, 2, Character.valueOf('\u0000'));
        this.m_connectionProperties.setProperty(71, 2, Character.valueOf('\u0000'));
        this.m_connectionProperties.setProperty(72, 2, Character.valueOf('\u0000'));
        this.m_connectionProperties.setProperty(73, 2, Character.valueOf('\u0000'));
        this.m_connectionProperties.setProperty(74, 2, Character.valueOf('\u0000'));
        this.m_connectionProperties.setProperty(75, 2, Character.valueOf('\u0000'));
        this.m_connectionProperties.setProperty(76, 2, Character.valueOf('\u00ff'));
        this.m_connectionProperties.setProperty(77, 3, 0L);
        this.m_connectionProperties.setProperty(78, 2, Character.valueOf('\u0000'));
        this.m_connectionProperties.setProperty(79, 3, 0L);
        this.m_connectionProperties.setProperty(80, 0, "N");
        this.m_connectionProperties.setProperty(81, 2, Character.valueOf('\u0000'));
        this.m_connectionProperties.setProperty(82, 3, 0L);
        this.m_connectionProperties.setProperty(83, 2, Character.valueOf('\u0000'));
        this.m_connectionProperties.setProperty(84, 2, Character.valueOf('\u0000'));
        this.m_connectionProperties.setProperty(85, 2, Character.valueOf('\u0000'));
        this.m_connectionProperties.setProperty(86, 0, "N");
        this.m_connectionProperties.setProperty(87, 0, "Y");
        this.m_connectionProperties.setProperty(88, 2, Character.valueOf('\u0000'));
        this.m_connectionProperties.setProperty(89, 2, Character.valueOf('\u0001'));
        this.m_connectionProperties.setProperty(90, 3, 0xFFFFFFL);
        this.m_connectionProperties.setProperty(91, 5, (short)1);
        this.m_connectionProperties.setProperty(92, 3, 127L);
        this.m_connectionProperties.setProperty(93, 0, "N");
        this.m_connectionProperties.setProperty(94, 0, "F");
        this.m_connectionProperties.setProperty(95, 3, 2L);
        this.m_connectionProperties.setProperty(96, 0, "procedure");
        this.m_connectionProperties.setProperty(97, 0, "Y");
        this.m_connectionProperties.setProperty(98, 2, Character.valueOf('\u0003'));
        this.m_connectionProperties.setProperty(99, 0, "schema");
        this.m_connectionProperties.setProperty(100, 3, 29L);
        this.m_connectionProperties.setProperty(101, 0, "");
        this.m_connectionProperties.setProperty(102, 0, "");
        this.m_connectionProperties.setProperty(103, 3, 1L);
        this.m_connectionProperties.setProperty(104, 3, 0xF77FFFL);
        this.m_connectionProperties.setProperty(105, 3, 31L);
        this.m_connectionProperties.setProperty(106, 3, 14712831L);
        this.m_connectionProperties.setProperty(107, 3, 14946049L);
        this.m_connectionProperties.setProperty(108, 3, 14974975L);
        this.m_connectionProperties.setProperty(109, 3, 31981567L);
        this.m_connectionProperties.setProperty(110, 3, 31458049L);
        this.m_connectionProperties.setProperty(111, 3, 14847745L);
        this.m_connectionProperties.setProperty(112, 3, 10510847L);
        this.m_connectionProperties.setProperty(113, 3, 14712831L);
        this.m_connectionProperties.setProperty(114, 3, 14712831L);
        this.m_connectionProperties.setProperty(115, 3, 14712831L);
        this.m_connectionProperties.setProperty(116, 3, 0L);
        this.m_connectionProperties.setProperty(117, 3, 0L);
        this.m_connectionProperties.setProperty(118, 3, 14946049L);
        this.m_connectionProperties.setProperty(119, 3, 31716351L);
        this.m_connectionProperties.setProperty(120, 3, 10510847L);
        this.m_connectionProperties.setProperty(121, 3, 14712831L);
        this.m_connectionProperties.setProperty(122, 3, 14712831L);
        this.m_connectionProperties.setProperty(123, 3, 14880513L);
        this.m_connectionProperties.setProperty(124, 3, 14913281L);
        this.m_connectionProperties.setProperty(125, 3, 14712831L);
        this.m_connectionProperties.setProperty(126, 3, 14946049L);
        this.m_connectionProperties.setProperty(127, 3, 31981567L);
        this.m_connectionProperties.setProperty(128, 3, 31981567L);
        this.m_connectionProperties.setProperty(129, 3, 31716351L);
        this.m_connectionProperties.setProperty(130, 3, 31981567L);
        this.m_connectionProperties.setProperty(131, 3, 7L);
        this.m_connectionProperties.setProperty(132, 0, "table");
        this.m_connectionProperties.setProperty(133, 3, 511L);
        this.m_connectionProperties.setProperty(134, 3, 511L);
        this.m_connectionProperties.setProperty(135, 3, 1048575L);
        this.m_connectionProperties.setProperty(136, 2, Character.valueOf('\u0000'));
        this.m_connectionProperties.setProperty(137, 3, 1L);
        this.m_connectionProperties.setProperty(138, 3, 3L);
        this.m_connectionProperties.setProperty(139, 0, "");
        this.m_connectionProperties.setProperty(140, 3, 0L);
        this.m_connectionProperties.setProperty(141, 3, 0L);
        this.m_connectionProperties.setProperty(142, 3, 0L);
        this.m_connectionProperties.setProperty(143, 3, 0L);
        this.m_connectionProperties.setProperty(144, 3, 0L);
        this.m_connectionProperties.setProperty(145, 3, 0L);
        this.m_connectionProperties.setProperty(146, 3, 0L);
        this.m_connectionProperties.setProperty(147, 3, 0L);
        this.m_connectionProperties.setProperty(148, 3, 0L);
        this.m_connectionProperties.setProperty(149, 3, 3L);
        this.m_connectionProperties.setProperty(150, 0, "N");
        this.m_connectionProperties.setProperty(151, 0, "\\");
        this.m_connectionProperties.setProperty(152, 3, 0L);
        this.m_connectionProperties.setProperty(153, 3, 0L);
        this.m_connectionProperties.setProperty(154, 3, 7L);
        this.m_connectionProperties.setProperty(155, 3, 0L);
        this.m_connectionProperties.setProperty(156, 3, 0L);
        this.m_connectionProperties.setProperty(159, 3, 16L);
        this.m_connectionProperties.setProperty(157, 3, 0L);
        this.m_connectionProperties.setProperty(158, 3, 16135L);
        this.m_connectionProperties.setProperty(160, 3, 346L);
        this.m_connectionProperties.setProperty(161, 3, 16L);
        this.m_connectionProperties.setProperty(162, 3, 15L);
        this.m_connectionProperties.setProperty(163, 3, 6L);
        this.m_connectionProperties.setProperty(164, 3, 15L);
        this.m_connectionProperties.setProperty(165, 3, 0L);
        this.m_connectionProperties.setProperty(1010, 0, "N");
        this.m_connectionProperties.setProperty(1000, 5, (short)0);
        this.m_connectionProperties.setProperty(1001, 3, 0L);
        this.m_connectionProperties.setProperty(1002, new Variant(3, 0L));
        this.m_connectionProperties.setProperty(1003, 5, (short)0);
        this.m_connectionProperties.setProperty(1004, 6, 0);
        this.m_connectionProperties.setProperty(1005, 6, 0);
        this.m_connectionProperties.setProperty(1006, 0, "N");
        this.m_connectionProperties.setProperty(1007, 6, 32000);
        this.m_connectionProperties.setProperty(1008, 0, "");
        this.m_connectionProperties.setProperty(1009, 6, 0);
        this.m_connectionProperties.setProperty(166, 2, Character.valueOf('\u0000'));
        this.m_connectionProperties.setProperty(167, 0, "");
        this.m_connectionProperties.setProperty(168, 5, (short)1);
        IDriver iDriver = DSIDriverSingleton.getInstance();
        this.m_connectionProperties.setProperty(169, 0, iDriver.getProperty(3).getString());
        this.m_connectionProperties.setProperty(170, 0, iDriver.getProperty(5).getString());
        this.m_connectionProperties.setProperty(171, 0, "");
        this.m_connectionProperties.setProperty(172, 3, 0L);
        this.m_connectionProperties.setProperty(174, 3, 0L);
        this.m_connectionProperties.setProperty(175, 3, 0L);
        this.m_connectionProperties.setProperty(176, 3, 0L);
        this.m_connectionProperties.setProperty(177, 3, this.getStopOnErrorDefaultValue());
        this.m_connectionProperties.setProperty(178, 3, 0L);
        this.m_connectionProperties.setProperty(1012, 5, this.getSupportsUpdateBatchingDefaultValue());
        this.m_connectionProperties.setProperty(1011, 3, 0L);
    }

    @Override
    public IArray createArrayOf(String string, Object[] objectArray) throws ErrorException {
        if (null == string || null == objectArray) {
            throw new NullPointerException();
        }
        ColumnMetadata columnMetadata = new ColumnMetadata(this.createTypeMetadataForSqlType(string));
        ColumnMetadata columnMetadata2 = null;
        columnMetadata2 = new ColumnMetadata(this.createTypeMetadataForSqlType("SQL_ARRAY"));
        int n = this.arrayNesting(objectArray, 0);
        ArrayList<IColumn> arrayList = columnMetadata2.getTypeMetadata().getNestedColumnList();
        for (int i = 0; i < n; ++i) {
            arrayList.add(new ColumnMetadata(this.createTypeMetadataForSqlType("SQL_ARRAY")));
            arrayList = arrayList.get(0).getTypeMetadata().getNestedColumnList();
        }
        arrayList.add(columnMetadata);
        return new DSISimpleArray(objectArray, columnMetadata2);
    }

    private int arrayNesting(Object object, int n) {
        int n2 = Array.getLength(object);
        int n3 = n;
        for (int i = 0; i < n2; ++i) {
            int n4;
            Object object2 = Array.get(object, i);
            if (object2 == null || !object2.getClass().isArray() || (n4 = this.arrayNesting(object2, n + 1)) <= n3) continue;
            n3 = n4;
        }
        return n3;
    }

    private TypeMetadata createTypeMetadataForSqlType(String string) throws ErrorException {
        Integer n = TypeUtilities.getTypeForSqlTypeString(string);
        if (null == n) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.DATA_TYPE_UNSUPPORTED.name(), string, ExceptionType.DATA);
        }
        return TypeMetadata.createTypeMetadata(n);
    }

    private long getStopOnErrorDefaultValue() throws ErrorException, NumericOverflowException, IncorrectTypeException {
        boolean bl;
        boolean bl2 = bl = DSIDriverSingleton.getInstance().getProperty(1001).getShort() == 1;
        if (bl) {
            return 3L;
        }
        return 0L;
    }

    private short getSupportsUpdateBatchingDefaultValue() throws ErrorException, NumericOverflowException, IncorrectTypeException {
        return DSIDriverSingleton.getInstance().getProperty(1002).getShort();
    }
}

