/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.amazonaws.transform;

import com.amazon.redshift.amazonaws.AmazonServiceException;
import com.amazon.redshift.amazonaws.annotation.SdkInternalApi;
import com.amazon.redshift.amazonaws.annotation.ThreadSafe;
import com.amazon.redshift.amazonaws.transform.AbstractErrorUnmarshaller;
import com.amazon.redshift.shaded.fasterxml.jackson.databind.DeserializationFeature;
import com.amazon.redshift.shaded.fasterxml.jackson.databind.JsonNode;
import com.amazon.redshift.shaded.fasterxml.jackson.databind.ObjectMapper;
import com.amazon.redshift.shaded.fasterxml.jackson.databind.PropertyNamingStrategy;

@SdkInternalApi
@ThreadSafe
public class JsonErrorUnmarshaller
extends AbstractErrorUnmarshaller<JsonNode> {
    public static final JsonErrorUnmarshaller DEFAULT_UNMARSHALLER = new JsonErrorUnmarshaller(AmazonServiceException.class, null);
    private static final ObjectMapper MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setPropertyNamingStrategy(new PropertyNamingStrategy.PascalCaseStrategy());
    private final String handledErrorCode;

    public JsonErrorUnmarshaller(Class<? extends AmazonServiceException> exceptionClass, String handledErrorCode) {
        super(exceptionClass);
        this.handledErrorCode = handledErrorCode;
    }

    @Override
    public AmazonServiceException unmarshall(JsonNode jsonContent) throws Exception {
        return (AmazonServiceException)MAPPER.treeToValue(jsonContent, this.exceptionClass);
    }

    public boolean matchErrorCode(String actualErrorCode) {
        if (this.handledErrorCode == null) {
            return true;
        }
        return this.handledErrorCode.equals(actualErrorCode);
    }
}

