/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.util.validation.validator;

import liquibase.repackaged.net.sf.jsqlparser.expression.AnalyticExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.AnyComparisonExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.ArrayConstructor;
import liquibase.repackaged.net.sf.jsqlparser.expression.ArrayExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.BinaryExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.CaseExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.CastExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.CollateExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.ConnectByRootOperator;
import liquibase.repackaged.net.sf.jsqlparser.expression.DateTimeLiteralExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.DateValue;
import liquibase.repackaged.net.sf.jsqlparser.expression.DoubleValue;
import liquibase.repackaged.net.sf.jsqlparser.expression.Expression;
import liquibase.repackaged.net.sf.jsqlparser.expression.ExpressionVisitor;
import liquibase.repackaged.net.sf.jsqlparser.expression.ExtractExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.Function;
import liquibase.repackaged.net.sf.jsqlparser.expression.HexValue;
import liquibase.repackaged.net.sf.jsqlparser.expression.IntervalExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.JdbcNamedParameter;
import liquibase.repackaged.net.sf.jsqlparser.expression.JdbcParameter;
import liquibase.repackaged.net.sf.jsqlparser.expression.JsonAggregateFunction;
import liquibase.repackaged.net.sf.jsqlparser.expression.JsonExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.JsonFunction;
import liquibase.repackaged.net.sf.jsqlparser.expression.KeepExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.LongValue;
import liquibase.repackaged.net.sf.jsqlparser.expression.MySQLGroupConcat;
import liquibase.repackaged.net.sf.jsqlparser.expression.NextValExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.NotExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.NullValue;
import liquibase.repackaged.net.sf.jsqlparser.expression.NumericBind;
import liquibase.repackaged.net.sf.jsqlparser.expression.OracleHierarchicalExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.OracleHint;
import liquibase.repackaged.net.sf.jsqlparser.expression.OracleNamedFunctionParameter;
import liquibase.repackaged.net.sf.jsqlparser.expression.Parenthesis;
import liquibase.repackaged.net.sf.jsqlparser.expression.RowConstructor;
import liquibase.repackaged.net.sf.jsqlparser.expression.RowGetExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.SignedExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.StringValue;
import liquibase.repackaged.net.sf.jsqlparser.expression.TimeKeyExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.TimeValue;
import liquibase.repackaged.net.sf.jsqlparser.expression.TimestampValue;
import liquibase.repackaged.net.sf.jsqlparser.expression.TimezoneExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.UserVariable;
import liquibase.repackaged.net.sf.jsqlparser.expression.ValueListExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.VariableAssignment;
import liquibase.repackaged.net.sf.jsqlparser.expression.WhenClause;
import liquibase.repackaged.net.sf.jsqlparser.expression.WindowElement;
import liquibase.repackaged.net.sf.jsqlparser.expression.WindowOffset;
import liquibase.repackaged.net.sf.jsqlparser.expression.WindowRange;
import liquibase.repackaged.net.sf.jsqlparser.expression.XMLSerializeExpr;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.arithmetic.Addition;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.arithmetic.BitwiseAnd;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.arithmetic.BitwiseLeftShift;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.arithmetic.BitwiseOr;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.arithmetic.BitwiseRightShift;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.arithmetic.BitwiseXor;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.arithmetic.Concat;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.arithmetic.Division;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.arithmetic.IntegerDivision;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.arithmetic.Modulo;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.arithmetic.Multiplication;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.arithmetic.Subtraction;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.conditional.XorExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.Between;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.ExistsExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.FullTextSearch;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.InExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.IsBooleanExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.JsonOperator;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.LikeExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.Matches;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.MinorThan;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.OldOracleJoinBinaryExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.RegExpMatchOperator;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.RegExpMySQLOperator;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.SimilarToExpression;
import liquibase.repackaged.net.sf.jsqlparser.parser.feature.Feature;
import liquibase.repackaged.net.sf.jsqlparser.schema.Column;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.table.ColumnDefinition;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.AllColumns;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.AllTableColumns;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SubSelect;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.ValidationCapability;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.metadata.NamedObject;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.validator.AbstractValidator;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.validator.ItemsListValidator;

public class ExpressionValidator
extends AbstractValidator<Expression>
implements ExpressionVisitor {
    @Override
    public void visit(Addition addition) {
        this.visitBinaryExpression(addition, " + ");
    }

    @Override
    public void visit(AndExpression andExpression) {
        AndExpression andExpression2 = andExpression;
        this.visitBinaryExpression(andExpression2, andExpression2.isUseOperator() ? " && " : " AND ");
    }

    @Override
    public void visit(Between between) {
        between.getLeftExpression().accept(this);
        between.getBetweenExpressionStart().accept(this);
        between.getBetweenExpressionEnd().accept(this);
    }

    @Override
    public void visit(EqualsTo equalsTo) {
        this.visitOldOracleJoinBinaryExpression(equalsTo, " = ");
    }

    @Override
    public void visit(Division division) {
        this.visitBinaryExpression(division, " / ");
    }

    @Override
    public void visit(IntegerDivision integerDivision) {
        this.visitBinaryExpression(integerDivision, " DIV ");
    }

    @Override
    public void visit(DoubleValue doubleValue) {
    }

    @Override
    public void visit(HexValue hexValue) {
    }

    @Override
    public void visit(NotExpression notExpression) {
        notExpression.getExpression().accept(this);
    }

    @Override
    public void visit(BitwiseRightShift bitwiseRightShift) {
        this.visitBinaryExpression(bitwiseRightShift, " >> ");
    }

    @Override
    public void visit(BitwiseLeftShift bitwiseLeftShift) {
        this.visitBinaryExpression(bitwiseLeftShift, " << ");
    }

    public void visitOldOracleJoinBinaryExpression(OldOracleJoinBinaryExpression oldOracleJoinBinaryExpression, String object) {
        for (ValidationCapability validationCapability : this.getCapabilities()) {
            this.validateOptionalExpression(oldOracleJoinBinaryExpression.getLeftExpression(), this);
            if (oldOracleJoinBinaryExpression.getOldOracleJoinSyntax() != 0) {
                this.validateFeature(validationCapability, Feature.oracleOldJoinSyntax);
            }
            this.validateOptionalExpression(oldOracleJoinBinaryExpression.getRightExpression(), this);
            if (oldOracleJoinBinaryExpression.getOraclePriorPosition() == 0) continue;
            this.validateFeature(validationCapability, Feature.oraclePriorPosition);
        }
    }

    @Override
    public void visit(GreaterThan greaterThan) {
        this.visitOldOracleJoinBinaryExpression(greaterThan, " > ");
    }

    @Override
    public void visit(GreaterThanEquals greaterThanEquals) {
        this.visitOldOracleJoinBinaryExpression(greaterThanEquals, " >= ");
    }

    @Override
    public void visit(InExpression inExpression) {
        for (ValidationCapability validationCapability : this.getCapabilities()) {
            this.validateOptionalExpression(inExpression.getLeftExpression(), this);
            if (inExpression.getOldOracleJoinSyntax() == 0) continue;
            this.validateFeature(validationCapability, Feature.oracleOldJoinSyntax);
        }
        this.validateOptionalMultiExpressionList(inExpression.getMultiExpressionList());
        this.validateOptionalExpression(inExpression.getRightExpression(), this);
        this.validateOptionalItemsList(inExpression.getRightItemsList());
    }

    @Override
    public void visit(FullTextSearch fullTextSearch) {
        this.validateOptionalExpressions(fullTextSearch.getMatchColumns());
    }

    @Override
    public void visit(SignedExpression signedExpression) {
        signedExpression.getExpression().accept(this);
    }

    @Override
    public void visit(IsNullExpression isNullExpression) {
        isNullExpression.getLeftExpression().accept(this);
    }

    @Override
    public void visit(IsBooleanExpression isBooleanExpression) {
        isBooleanExpression.getLeftExpression().accept(this);
    }

    @Override
    public void visit(JdbcParameter jdbcParameter) {
        this.validateFeature(Feature.jdbcParameter);
    }

    @Override
    public void visit(LikeExpression likeExpression) {
        this.validateFeature(Feature.exprLike);
        this.visitBinaryExpression(likeExpression, (likeExpression.isNot() ? " NOT" : "") + (likeExpression.isCaseInsensitive() ? " ILIKE " : " LIKE "));
    }

    @Override
    public void visit(ExistsExpression existsExpression) {
        existsExpression.getRightExpression().accept(this);
    }

    @Override
    public void visit(LongValue longValue) {
    }

    @Override
    public void visit(MinorThan minorThan) {
        this.visitOldOracleJoinBinaryExpression(minorThan, " < ");
    }

    @Override
    public void visit(MinorThanEquals minorThanEquals) {
        this.visitOldOracleJoinBinaryExpression(minorThanEquals, " <= ");
    }

    @Override
    public void visit(Multiplication multiplication) {
        this.visitBinaryExpression(multiplication, " * ");
    }

    @Override
    public void visit(NotEqualsTo notEqualsTo) {
        this.visitOldOracleJoinBinaryExpression(notEqualsTo, " " + notEqualsTo.getStringExpression() + " ");
    }

    @Override
    public void visit(NullValue nullValue) {
    }

    @Override
    public void visit(OrExpression orExpression) {
        this.visitBinaryExpression(orExpression, " OR ");
    }

    @Override
    public void visit(XorExpression xorExpression) {
        this.visitBinaryExpression(xorExpression, " XOR ");
    }

    @Override
    public void visit(Parenthesis parenthesis) {
        parenthesis.getExpression().accept(this);
    }

    @Override
    public void visit(StringValue stringValue) {
    }

    @Override
    public void visit(Subtraction subtraction) {
        this.visitBinaryExpression(subtraction, " - ");
    }

    protected void visitBinaryExpression(BinaryExpression binaryExpression, String string) {
        binaryExpression.getLeftExpression().accept(this);
        binaryExpression.getRightExpression().accept(this);
    }

    @Override
    public void visit(SubSelect subSelect) {
        this.validateOptionalFromItem(subSelect);
    }

    @Override
    public void visit(Column column) {
        this.validateName(NamedObject.column, column.getFullyQualifiedName());
    }

    @Override
    public void visit(Function function) {
        this.validateFeature(Feature.function);
        this.validateOptionalItemsList(function.getNamedParameters());
        this.validateOptionalItemsList(function.getParameters());
        this.validateOptionalExpression(function.getAttribute(), this);
        this.validateOptionalExpression(function.getKeep(), this);
        this.validateOptionalOrderByElements(function.getOrderByElements());
    }

    @Override
    public void visit(DateValue dateValue) {
    }

    @Override
    public void visit(TimestampValue timestampValue) {
    }

    @Override
    public void visit(TimeValue timeValue) {
    }

    @Override
    public void visit(CaseExpression expression) {
        Expression expression2 = ((CaseExpression)expression).getSwitchExpression();
        if (expression2 != null) {
            expression2.accept(this);
        }
        ((CaseExpression)expression).getWhenClauses().forEach(whenClause -> whenClause.accept(this));
        expression = ((CaseExpression)expression).getElseExpression();
        if (expression != null) {
            expression.accept(this);
        }
    }

    @Override
    public void visit(WhenClause whenClause) {
        whenClause.getWhenExpression().accept(this);
        whenClause.getThenExpression().accept(this);
    }

    @Override
    public void visit(AnyComparisonExpression anyComparisonExpression) {
        anyComparisonExpression.getSubSelect().accept(this);
    }

    @Override
    public void visit(Concat concat) {
        this.visitBinaryExpression(concat, " || ");
    }

    @Override
    public void visit(Matches matches) {
        this.visitOldOracleJoinBinaryExpression(matches, " @@ ");
    }

    @Override
    public void visit(BitwiseAnd bitwiseAnd) {
        this.visitBinaryExpression(bitwiseAnd, " & ");
    }

    @Override
    public void visit(BitwiseOr bitwiseOr) {
        this.visitBinaryExpression(bitwiseOr, " | ");
    }

    @Override
    public void visit(BitwiseXor bitwiseXor) {
        this.visitBinaryExpression(bitwiseXor, " ^ ");
    }

    @Override
    public void visit(CastExpression castExpression) {
        castExpression.getLeftExpression().accept(this);
    }

    @Override
    public void visit(Modulo modulo) {
        this.visitBinaryExpression(modulo, " % ");
    }

    @Override
    public void visit(AnalyticExpression analyticExpression) {
        this.validateOptionalExpression(analyticExpression.getExpression(), this);
        this.validateOptionalExpression(analyticExpression.getOffset(), this);
        this.validateOptionalExpression(analyticExpression.getDefaultValue(), this);
        this.validateOptionalExpression(analyticExpression.getKeep(), this);
        this.validateOptionalExpressionList(analyticExpression.getPartitionExpressionList());
        this.validateOptionalOrderByElements(analyticExpression.getOrderByElements());
        Object object = analyticExpression.getWindowElement();
        if (object != null) {
            this.validateOptionalWindowOffset(((WindowElement)object).getOffset());
            object = ((WindowElement)object).getRange();
            if (object != null) {
                this.validateOptionalWindowOffset(((WindowRange)object).getStart());
                this.validateOptionalWindowOffset(((WindowRange)object).getEnd());
            }
        }
        this.validateOptionalExpression(analyticExpression.getFilterExpression());
    }

    private void validateOptionalWindowOffset(WindowOffset windowOffset) {
        if (windowOffset != null) {
            this.validateOptionalExpression(windowOffset.getExpression());
        }
    }

    @Override
    public void visit(ExtractExpression extractExpression) {
        extractExpression.getExpression().accept(this);
    }

    @Override
    public void visit(IntervalExpression intervalExpression) {
        this.validateOptionalExpression(intervalExpression.getExpression());
    }

    @Override
    public void visit(JdbcNamedParameter jdbcNamedParameter) {
        this.validateFeature(Feature.jdbcNamedParameter);
    }

    @Override
    public void visit(OracleHierarchicalExpression oracleHierarchicalExpression) {
        this.validateFeature(Feature.oracleHierarchicalExpression);
    }

    @Override
    public void visit(RegExpMatchOperator regExpMatchOperator) {
        this.visitBinaryExpression(regExpMatchOperator, " " + regExpMatchOperator.getStringExpression() + " ");
    }

    @Override
    public void visit(RegExpMySQLOperator regExpMySQLOperator) {
        this.visitBinaryExpression(regExpMySQLOperator, " " + regExpMySQLOperator.getStringExpression() + " ");
    }

    @Override
    public void visit(JsonExpression jsonExpression) {
        this.validateOptionalExpression(jsonExpression.getExpression());
    }

    @Override
    public void visit(JsonOperator jsonOperator) {
        this.visitBinaryExpression(jsonOperator, " " + jsonOperator.getStringExpression() + " ");
    }

    @Override
    public void visit(UserVariable userVariable) {
    }

    @Override
    public void visit(NumericBind numericBind) {
    }

    @Override
    public void visit(KeepExpression keepExpression) {
        this.validateOptionalOrderByElements(keepExpression.getOrderByElements());
    }

    @Override
    public void visit(MySQLGroupConcat mySQLGroupConcat) {
        this.validateOptionalExpressionList(mySQLGroupConcat.getExpressionList());
        this.validateOptionalOrderByElements(mySQLGroupConcat.getOrderByElements());
    }

    private void validateOptionalExpressionList(ExpressionList expressionList) {
        if (expressionList != null) {
            expressionList.accept(this.getValidator(ItemsListValidator.class));
        }
    }

    @Override
    public void visit(ValueListExpression valueListExpression) {
        this.validateOptionalExpressionList(valueListExpression.getExpressionList());
    }

    @Override
    public void visit(RowConstructor object) {
        if (((RowConstructor)object).getColumnDefinitions().isEmpty()) {
            this.validateOptionalExpressionList(((RowConstructor)object).getExprList());
            return;
        }
        for (ColumnDefinition columnDefinition : ((RowConstructor)object).getColumnDefinitions()) {
            this.validateName(NamedObject.column, columnDefinition.getColumnName());
        }
    }

    @Override
    public void visit(RowGetExpression rowGetExpression) {
        rowGetExpression.getExpression().accept(this);
    }

    @Override
    public void visit(OracleHint oracleHint) {
    }

    @Override
    public void visit(TimeKeyExpression timeKeyExpression) {
    }

    @Override
    public void visit(DateTimeLiteralExpression dateTimeLiteralExpression) {
    }

    @Override
    public void visit(NextValExpression nextValExpression) {
        this.validateName(NamedObject.sequence, nextValExpression.getName());
    }

    @Override
    public void visit(CollateExpression collateExpression) {
        this.validateOptionalExpression(collateExpression.getLeftExpression());
    }

    @Override
    public void visit(SimilarToExpression similarToExpression) {
        this.validateFeature(Feature.exprSimilarTo);
        this.visitBinaryExpression(similarToExpression, (similarToExpression.isNot() ? " NOT" : "") + " SIMILAR TO ");
    }

    @Override
    public void visit(ArrayExpression arrayExpression) {
        arrayExpression.getObjExpression().accept(this);
        if (arrayExpression.getIndexExpression() != null) {
            arrayExpression.getIndexExpression().accept(this);
        }
        if (arrayExpression.getStartIndexExpression() != null) {
            arrayExpression.getStartIndexExpression().accept(this);
        }
        if (arrayExpression.getStopIndexExpression() != null) {
            arrayExpression.getStopIndexExpression().accept(this);
        }
    }

    @Override
    public void visit(ArrayConstructor object) {
        object = ((ArrayConstructor)object).getExpressions().iterator();
        while (object.hasNext()) {
            ((Expression)object.next()).accept(this);
        }
    }

    @Override
    public void validate(Expression expression) {
        expression.accept(this);
    }

    @Override
    public void visit(VariableAssignment variableAssignment) {
        this.validateOptionalExpression(variableAssignment.getExpression());
        if (variableAssignment.getVariable() != null) {
            variableAssignment.getVariable().accept(this);
        }
    }

    @Override
    public void visit(TimezoneExpression timezoneExpression) {
        this.validateOptionalExpression(timezoneExpression.getLeftExpression());
    }

    @Override
    public void visit(XMLSerializeExpr xMLSerializeExpr) {
    }

    @Override
    public void visit(JsonAggregateFunction jsonAggregateFunction) {
    }

    @Override
    public void visit(JsonFunction jsonFunction) {
    }

    @Override
    public void visit(ConnectByRootOperator connectByRootOperator) {
        connectByRootOperator.getColumn().accept(this);
    }

    @Override
    public void visit(OracleNamedFunctionParameter oracleNamedFunctionParameter) {
        oracleNamedFunctionParameter.getExpression().accept(this);
    }

    @Override
    public void visit(AllColumns allColumns) {
    }

    @Override
    public void visit(AllTableColumns allTableColumns) {
    }
}

