/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.statement.select;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.ItemsList;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.PlainSelect;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SelectBody;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SelectItem;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SelectVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SubSelect;

public class WithItem
implements SelectBody {
    private String name;
    private List<SelectItem> withItemList;
    private ItemsList itemsList;
    private boolean useValues = true;
    private boolean useBracketsForValues = false;
    private SubSelect subSelect;
    private boolean recursive;

    public ItemsList getItemsList() {
        return this.itemsList;
    }

    public void setItemsList(ItemsList itemsList) {
        this.itemsList = itemsList;
    }

    public boolean isUseValues() {
        return this.useValues;
    }

    public void setUseValues(boolean bl2) {
        this.useValues = bl2;
    }

    public WithItem withItemsList(ItemsList itemsList) {
        this.setItemsList(itemsList);
        return this;
    }

    public WithItem withUseValues(boolean bl2) {
        this.setUseValues(bl2);
        return this;
    }

    public boolean isUsingBracketsForValues() {
        return this.useBracketsForValues;
    }

    public void setUseBracketsForValues(boolean bl2) {
        this.useBracketsForValues = bl2;
    }

    public WithItem withUseBracketsForValues(boolean bl2) {
        this.setUseBracketsForValues(bl2);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean bl2) {
        this.recursive = bl2;
    }

    public SubSelect getSubSelect() {
        return this.subSelect.withUseBrackets(false);
    }

    public void setSubSelect(SubSelect subSelect) {
        this.subSelect = subSelect.withUseBrackets(false);
    }

    public List<SelectItem> getWithItemList() {
        return this.withItemList;
    }

    public void setWithItemList(List<SelectItem> list) {
        this.withItemList = list;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.recursive ? "RECURSIVE " : "");
        stringBuilder.append(this.name);
        stringBuilder.append(this.withItemList != null ? " " + PlainSelect.getStringList(this.withItemList, true, true) : "");
        stringBuilder.append(" AS ");
        if (this.useValues) {
            stringBuilder.append("(VALUES ");
            ExpressionList expressionList = (ExpressionList)this.itemsList;
            stringBuilder.append(PlainSelect.getStringList(expressionList.getExpressions(), true, this.useBracketsForValues));
            stringBuilder.append(")");
        } else {
            stringBuilder.append(this.subSelect.isUseBrackets() ? "" : "(");
            stringBuilder.append(this.subSelect);
            stringBuilder.append(this.subSelect.isUseBrackets() ? "" : ")");
        }
        return stringBuilder.toString();
    }

    @Override
    public void accept(SelectVisitor selectVisitor) {
        selectVisitor.visit(this);
    }

    public WithItem withName(String string) {
        this.setName(string);
        return this;
    }

    public WithItem withWithItemList(List<SelectItem> list) {
        this.setWithItemList(list);
        return this;
    }

    public WithItem withSubSelect(SubSelect subSelect) {
        this.setSubSelect(subSelect);
        return this;
    }

    public WithItem withRecursive(boolean bl2) {
        this.setRecursive(bl2);
        return this;
    }

    public WithItem addWithItemList(SelectItem ... selectItemArray) {
        List list = Optional.ofNullable(this.getWithItemList()).orElseGet(ArrayList::new);
        Collections.addAll(list, selectItemArray);
        return this.withWithItemList(list);
    }

    public WithItem addWithItemList(Collection<? extends SelectItem> collection) {
        List list = Optional.ofNullable(this.getWithItemList()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withWithItemList(list);
    }
}

