/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.statement.create.table;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import liquibase.repackaged.net.sf.jsqlparser.schema.Table;
import liquibase.repackaged.net.sf.jsqlparser.statement.Statement;
import liquibase.repackaged.net.sf.jsqlparser.statement.StatementVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.table.ColumnDefinition;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.table.Index;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.table.RowMovement;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.PlainSelect;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Select;

public class CreateTable
implements Statement {
    private Table table;
    private boolean unlogged = false;
    private List<String> createOptionsStrings;
    private List<String> tableOptionsStrings;
    private List<ColumnDefinition> columnDefinitions;
    private List<String> columns;
    private List<Index> indexes;
    private Select select;
    private Table likeTable;
    private boolean selectParenthesis;
    private boolean ifNotExists = false;
    private RowMovement rowMovement;

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public boolean isUnlogged() {
        return this.unlogged;
    }

    public void setUnlogged(boolean bl2) {
        this.unlogged = bl2;
    }

    public List<ColumnDefinition> getColumnDefinitions() {
        return this.columnDefinitions;
    }

    public void setColumnDefinitions(List<ColumnDefinition> list) {
        this.columnDefinitions = list;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public void setColumns(List<String> list) {
        this.columns = list;
    }

    public List<String> getTableOptionsStrings() {
        return this.tableOptionsStrings;
    }

    public void setTableOptionsStrings(List<String> list) {
        this.tableOptionsStrings = list;
    }

    public List<String> getCreateOptionsStrings() {
        return this.createOptionsStrings;
    }

    public void setCreateOptionsStrings(List<String> list) {
        this.createOptionsStrings = list;
    }

    public List<Index> getIndexes() {
        return this.indexes;
    }

    public void setIndexes(List<Index> list) {
        this.indexes = list;
    }

    public Select getSelect() {
        return this.select;
    }

    public void setSelect(Select select, boolean bl2) {
        this.select = select;
        this.selectParenthesis = bl2;
    }

    public Table getLikeTable() {
        return this.likeTable;
    }

    public void setLikeTable(Table table, boolean bl2) {
        this.likeTable = table;
        this.selectParenthesis = bl2;
    }

    public boolean isIfNotExists() {
        return this.ifNotExists;
    }

    public void setIfNotExists(boolean bl2) {
        this.ifNotExists = bl2;
    }

    public boolean isSelectParenthesis() {
        return this.selectParenthesis;
    }

    public void setSelectParenthesis(boolean bl2) {
        this.selectParenthesis = bl2;
    }

    public RowMovement getRowMovement() {
        return this.rowMovement;
    }

    public void setRowMovement(RowMovement rowMovement) {
        this.rowMovement = rowMovement;
    }

    public String toString() {
        String string;
        String string2 = PlainSelect.getStringList(this.createOptionsStrings, false, false);
        string2 = "CREATE " + (this.unlogged ? "UNLOGGED " : "") + (!"".equals(string2) ? string2 + " " : "") + "TABLE " + (this.ifNotExists ? "IF NOT EXISTS " : "") + this.table;
        if (this.columns != null && !this.columns.isEmpty()) {
            string2 = string2 + " ";
            string2 = string2 + PlainSelect.getStringList(this.columns, true, true);
        }
        if (this.columnDefinitions != null && !this.columnDefinitions.isEmpty()) {
            string2 = string2 + " (";
            string2 = string2 + PlainSelect.getStringList(this.columnDefinitions, true, false);
            if (this.indexes != null && !this.indexes.isEmpty()) {
                string2 = string2 + ", ";
                string2 = string2 + PlainSelect.getStringList(this.indexes);
            }
            string2 = string2 + ")";
        }
        if ((string = PlainSelect.getStringList(this.tableOptionsStrings, false, false)) != null && string.length() > 0) {
            string2 = string2 + " " + string;
        }
        if (this.rowMovement != null) {
            string2 = string2 + " " + this.rowMovement.getMode().toString() + " ROW MOVEMENT";
        }
        if (this.select != null) {
            string2 = string2 + " AS " + (this.selectParenthesis ? "(" : "") + this.select.toString() + (this.selectParenthesis ? ")" : "");
        }
        if (this.likeTable != null) {
            string2 = string2 + " LIKE " + (this.selectParenthesis ? "(" : "") + this.likeTable.toString() + (this.selectParenthesis ? ")" : "");
        }
        return string2;
    }

    public CreateTable withTable(Table table) {
        this.setTable(table);
        return this;
    }

    public CreateTable withUnlogged(boolean bl2) {
        this.setUnlogged(bl2);
        return this;
    }

    public CreateTable withCreateOptionsStrings(List<String> list) {
        this.setCreateOptionsStrings(list);
        return this;
    }

    public CreateTable withSelectParenthesis(boolean bl2) {
        this.setSelectParenthesis(bl2);
        return this;
    }

    public CreateTable withIfNotExists(boolean bl2) {
        this.setIfNotExists(bl2);
        return this;
    }

    public CreateTable withRowMovement(RowMovement rowMovement) {
        this.setRowMovement(rowMovement);
        return this;
    }

    public CreateTable withTableOptionsStrings(List<String> list) {
        this.setTableOptionsStrings(list);
        return this;
    }

    public CreateTable withColumnDefinitions(List<ColumnDefinition> list) {
        this.setColumnDefinitions(list);
        return this;
    }

    public CreateTable withColumns(List<String> list) {
        this.setColumns(list);
        return this;
    }

    public CreateTable withIndexes(List<Index> list) {
        this.setIndexes(list);
        return this;
    }

    public CreateTable addCreateOptionsStrings(String ... stringArray) {
        List list = Optional.ofNullable(this.getCreateOptionsStrings()).orElseGet(ArrayList::new);
        Collections.addAll(list, stringArray);
        return this.withCreateOptionsStrings(list);
    }

    public CreateTable addCreateOptionsStrings(Collection<String> collection) {
        List list = Optional.ofNullable(this.getCreateOptionsStrings()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withCreateOptionsStrings(list);
    }

    public CreateTable addColumnDefinitions(ColumnDefinition ... columnDefinitionArray) {
        List list = Optional.ofNullable(this.getColumnDefinitions()).orElseGet(ArrayList::new);
        Collections.addAll(list, columnDefinitionArray);
        return this.withColumnDefinitions(list);
    }

    public CreateTable addColumnDefinitions(Collection<? extends ColumnDefinition> collection) {
        List list = Optional.ofNullable(this.getColumnDefinitions()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withColumnDefinitions(list);
    }

    public CreateTable addColumns(String ... stringArray) {
        List list = Optional.ofNullable(this.getColumns()).orElseGet(ArrayList::new);
        Collections.addAll(list, stringArray);
        return this.withColumns(list);
    }

    public CreateTable addColumns(Collection<String> collection) {
        List list = Optional.ofNullable(this.getColumns()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withColumns(list);
    }

    public CreateTable addIndexes(Index ... indexArray) {
        List list = Optional.ofNullable(this.getIndexes()).orElseGet(ArrayList::new);
        Collections.addAll(list, indexArray);
        return this.withIndexes(list);
    }

    public CreateTable addIndexes(Collection<? extends Index> collection) {
        List list = Optional.ofNullable(this.getIndexes()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withIndexes(list);
    }
}

