# coding: utf-8

"""
    Model Management Service

    Model Management System (MMS) is a version control system for structured data. It exposes model information through RESTful web services that can be used for CRUD operations, branching, and tagging of the model repository.  # noqa: E501

    OpenAPI spec version: 3.3.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from mms_python_client.api_client import ApiClient


class TicketApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_ticket(self, ticket_id, **kwargs):  # noqa: E501
        """Get ticket  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_ticket(ticket_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str ticket_id: ticket identifier (required)
        :return: TicketResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_ticket_with_http_info(ticket_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_ticket_with_http_info(ticket_id, **kwargs)  # noqa: E501
            return data

    def get_ticket_with_http_info(self, ticket_id, **kwargs):  # noqa: E501
        """Get ticket  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_ticket_with_http_info(ticket_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str ticket_id: ticket identifier (required)
        :return: TicketResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ticket_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ticket" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ticket_id' is set
        if ('ticket_id' not in params or
                params['ticket_id'] is None):
            raise ValueError("Missing the required parameter `ticket_id` when calling `get_ticket`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ticket_id' in params:
            path_params['ticket_id'] = params['ticket_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Basic', 'Ticket']  # noqa: E501

        return self.api_client.call_api(
            '/mms/login/ticket/{ticket_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TicketResponse',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_ticket(self, body, **kwargs):  # noqa: E501
        """Create ticket  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.post_ticket(body, async=True)
        >>> result = thread.get()

        :param async bool
        :param LoginRequest body:  (required)
        :return: LoginResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.post_ticket_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_ticket_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def post_ticket_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create ticket  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.post_ticket_with_http_info(body, async=True)
        >>> result = thread.get()

        :param async bool
        :param LoginRequest body:  (required)
        :return: LoginResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_ticket" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_ticket`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/login', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LoginResponse',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
