# coding: utf-8

"""
    Model Management Service

    Model Management System (MMS) is a version control system for structured data. It exposes model information through RESTful web services that can be used for CRUD operations, branching, and tagging of the model repository.  # noqa: E501

    OpenAPI spec version: 3.3.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from mms_python_client.api_client import ApiClient


class ElementApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_element(self, project_id, ref_id, element_id, **kwargs):  # noqa: E501
        """Delete element  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_element(project_id, ref_id, element_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str project_id: project identifier (required)
        :param str ref_id: ref identifier (required)
        :param str element_id: element identifier (required)
        :return: Elements
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.delete_element_with_http_info(project_id, ref_id, element_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_element_with_http_info(project_id, ref_id, element_id, **kwargs)  # noqa: E501
            return data

    def delete_element_with_http_info(self, project_id, ref_id, element_id, **kwargs):  # noqa: E501
        """Delete element  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_element_with_http_info(project_id, ref_id, element_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str project_id: project identifier (required)
        :param str ref_id: ref identifier (required)
        :param str element_id: element identifier (required)
        :return: Elements
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', 'ref_id', 'element_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_element" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `delete_element`")  # noqa: E501
        # verify the required parameter 'ref_id' is set
        if ('ref_id' not in params or
                params['ref_id'] is None):
            raise ValueError("Missing the required parameter `ref_id` when calling `delete_element`")  # noqa: E501
        # verify the required parameter 'element_id' is set
        if ('element_id' not in params or
                params['element_id'] is None):
            raise ValueError("Missing the required parameter `element_id` when calling `delete_element`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501
        if 'ref_id' in params:
            path_params['ref_id'] = params['ref_id']  # noqa: E501
        if 'element_id' in params:
            path_params['element_id'] = params['element_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Basic', 'Ticket']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_id}/refs/{ref_id}/elements/{element_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Elements',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_elements_in_batch(self, project_id, ref_id, body, **kwargs):  # noqa: E501
        """Delete element(s) in batch  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_elements_in_batch(project_id, ref_id, body, async=True)
        >>> result = thread.get()

        :param async bool
        :param str project_id: project identifier (required)
        :param str ref_id: ref identifier (required)
        :param Elements body:  (required)
        :param str commit_id: commit identifier
        :param bool extended: extended flag
        :return: Elements
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.delete_elements_in_batch_with_http_info(project_id, ref_id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_elements_in_batch_with_http_info(project_id, ref_id, body, **kwargs)  # noqa: E501
            return data

    def delete_elements_in_batch_with_http_info(self, project_id, ref_id, body, **kwargs):  # noqa: E501
        """Delete element(s) in batch  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_elements_in_batch_with_http_info(project_id, ref_id, body, async=True)
        >>> result = thread.get()

        :param async bool
        :param str project_id: project identifier (required)
        :param str ref_id: ref identifier (required)
        :param Elements body:  (required)
        :param str commit_id: commit identifier
        :param bool extended: extended flag
        :return: Elements
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', 'ref_id', 'body', 'commit_id', 'extended']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_elements_in_batch" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `delete_elements_in_batch`")  # noqa: E501
        # verify the required parameter 'ref_id' is set
        if ('ref_id' not in params or
                params['ref_id'] is None):
            raise ValueError("Missing the required parameter `ref_id` when calling `delete_elements_in_batch`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `delete_elements_in_batch`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501
        if 'ref_id' in params:
            path_params['ref_id'] = params['ref_id']  # noqa: E501

        query_params = []
        if 'commit_id' in params:
            query_params.append(('commitId', params['commit_id']))  # noqa: E501
        if 'extended' in params:
            query_params.append(('extended', params['extended']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['Basic', 'Ticket']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_id}/refs/{ref_id}/elements', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Elements',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_element(self, project_id, ref_id, element_id, **kwargs):  # noqa: E501
        """Get element  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_element(project_id, ref_id, element_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str project_id: project identifier (required)
        :param str ref_id: ref identifier (required)
        :param str element_id: element identifier (required)
        :param int depth: 
        :param bool extended: 
        :param str commit_id: 
        :return: Elements
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_element_with_http_info(project_id, ref_id, element_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_element_with_http_info(project_id, ref_id, element_id, **kwargs)  # noqa: E501
            return data

    def get_element_with_http_info(self, project_id, ref_id, element_id, **kwargs):  # noqa: E501
        """Get element  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_element_with_http_info(project_id, ref_id, element_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str project_id: project identifier (required)
        :param str ref_id: ref identifier (required)
        :param str element_id: element identifier (required)
        :param int depth: 
        :param bool extended: 
        :param str commit_id: 
        :return: Elements
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', 'ref_id', 'element_id', 'depth', 'extended', 'commit_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_element" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `get_element`")  # noqa: E501
        # verify the required parameter 'ref_id' is set
        if ('ref_id' not in params or
                params['ref_id'] is None):
            raise ValueError("Missing the required parameter `ref_id` when calling `get_element`")  # noqa: E501
        # verify the required parameter 'element_id' is set
        if ('element_id' not in params or
                params['element_id'] is None):
            raise ValueError("Missing the required parameter `element_id` when calling `get_element`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501
        if 'ref_id' in params:
            path_params['ref_id'] = params['ref_id']  # noqa: E501
        if 'element_id' in params:
            path_params['element_id'] = params['element_id']  # noqa: E501

        query_params = []
        if 'depth' in params:
            query_params.append(('depth', params['depth']))  # noqa: E501
        if 'extended' in params:
            query_params.append(('extended', params['extended']))  # noqa: E501
        if 'commit_id' in params:
            query_params.append(('commitId', params['commit_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Basic', 'Ticket']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_id}/refs/{ref_id}/elements/{element_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Elements',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_element_history(self, project_id, ref_id, element_id, **kwargs):  # noqa: E501
        """Get element history  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_element_history(project_id, ref_id, element_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str project_id: project identifier (required)
        :param str ref_id: ref identifier (required)
        :param str element_id: element identifier (required)
        :return: Commits
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_element_history_with_http_info(project_id, ref_id, element_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_element_history_with_http_info(project_id, ref_id, element_id, **kwargs)  # noqa: E501
            return data

    def get_element_history_with_http_info(self, project_id, ref_id, element_id, **kwargs):  # noqa: E501
        """Get element history  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_element_history_with_http_info(project_id, ref_id, element_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str project_id: project identifier (required)
        :param str ref_id: ref identifier (required)
        :param str element_id: element identifier (required)
        :return: Commits
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', 'ref_id', 'element_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_element_history" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `get_element_history`")  # noqa: E501
        # verify the required parameter 'ref_id' is set
        if ('ref_id' not in params or
                params['ref_id'] is None):
            raise ValueError("Missing the required parameter `ref_id` when calling `get_element_history`")  # noqa: E501
        # verify the required parameter 'element_id' is set
        if ('element_id' not in params or
                params['element_id'] is None):
            raise ValueError("Missing the required parameter `element_id` when calling `get_element_history`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501
        if 'ref_id' in params:
            path_params['ref_id'] = params['ref_id']  # noqa: E501
        if 'element_id' in params:
            path_params['element_id'] = params['element_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Basic', 'Ticket']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_id}/refs/{ref_id}/elements/{element_id}/commits', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Commits',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_elements(self, project_id, ref_id, **kwargs):  # noqa: E501
        """Get elements  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_elements(project_id, ref_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str project_id: project identifier (required)
        :param str ref_id: ref identifier (required)
        :param str commit_id: commit identifier
        :param bool extended: extended flag
        :return: Elements
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_elements_with_http_info(project_id, ref_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_elements_with_http_info(project_id, ref_id, **kwargs)  # noqa: E501
            return data

    def get_elements_with_http_info(self, project_id, ref_id, **kwargs):  # noqa: E501
        """Get elements  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_elements_with_http_info(project_id, ref_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str project_id: project identifier (required)
        :param str ref_id: ref identifier (required)
        :param str commit_id: commit identifier
        :param bool extended: extended flag
        :return: Elements
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', 'ref_id', 'commit_id', 'extended']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_elements" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `get_elements`")  # noqa: E501
        # verify the required parameter 'ref_id' is set
        if ('ref_id' not in params or
                params['ref_id'] is None):
            raise ValueError("Missing the required parameter `ref_id` when calling `get_elements`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501
        if 'ref_id' in params:
            path_params['ref_id'] = params['ref_id']  # noqa: E501

        query_params = []
        if 'commit_id' in params:
            query_params.append(('commitId', params['commit_id']))  # noqa: E501
        if 'extended' in params:
            query_params.append(('extended', params['extended']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Basic', 'Ticket']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_id}/refs/{ref_id}/elements', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Elements',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_elements_in_batch(self, project_id, ref_id, body, **kwargs):  # noqa: E501
        """Get element(s) in batch  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_elements_in_batch(project_id, ref_id, body, async=True)
        >>> result = thread.get()

        :param async bool
        :param str project_id: project identifier (required)
        :param str ref_id: ref identifier (required)
        :param Elements body:  (required)
        :param str commit_id: commit identifier
        :param bool extended: extended flag
        :param int depth: 
        :return: RejectableElements
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_elements_in_batch_with_http_info(project_id, ref_id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.get_elements_in_batch_with_http_info(project_id, ref_id, body, **kwargs)  # noqa: E501
            return data

    def get_elements_in_batch_with_http_info(self, project_id, ref_id, body, **kwargs):  # noqa: E501
        """Get element(s) in batch  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_elements_in_batch_with_http_info(project_id, ref_id, body, async=True)
        >>> result = thread.get()

        :param async bool
        :param str project_id: project identifier (required)
        :param str ref_id: ref identifier (required)
        :param Elements body:  (required)
        :param str commit_id: commit identifier
        :param bool extended: extended flag
        :param int depth: 
        :return: RejectableElements
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', 'ref_id', 'body', 'commit_id', 'extended', 'depth']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_elements_in_batch" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `get_elements_in_batch`")  # noqa: E501
        # verify the required parameter 'ref_id' is set
        if ('ref_id' not in params or
                params['ref_id'] is None):
            raise ValueError("Missing the required parameter `ref_id` when calling `get_elements_in_batch`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `get_elements_in_batch`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501
        if 'ref_id' in params:
            path_params['ref_id'] = params['ref_id']  # noqa: E501

        query_params = []
        if 'commit_id' in params:
            query_params.append(('commitId', params['commit_id']))  # noqa: E501
        if 'extended' in params:
            query_params.append(('extended', params['extended']))  # noqa: E501
        if 'depth' in params:
            query_params.append(('depth', params['depth']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['Basic', 'Ticket']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_id}/refs/{ref_id}/elements', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RejectableElements',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_elements(self, project_id, ref_id, body, **kwargs):  # noqa: E501
        """Create and/or update element(s)  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.post_elements(project_id, ref_id, body, async=True)
        >>> result = thread.get()

        :param async bool
        :param str project_id: project identifier (required)
        :param str ref_id: ref identifier (required)
        :param Elements body:  (required)
        :param str commit_id: commit identifier
        :param bool extended: extended flag
        :param bool overwrite: overwrite existing json
        :return: RejectableElements
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.post_elements_with_http_info(project_id, ref_id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_elements_with_http_info(project_id, ref_id, body, **kwargs)  # noqa: E501
            return data

    def post_elements_with_http_info(self, project_id, ref_id, body, **kwargs):  # noqa: E501
        """Create and/or update element(s)  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.post_elements_with_http_info(project_id, ref_id, body, async=True)
        >>> result = thread.get()

        :param async bool
        :param str project_id: project identifier (required)
        :param str ref_id: ref identifier (required)
        :param Elements body:  (required)
        :param str commit_id: commit identifier
        :param bool extended: extended flag
        :param bool overwrite: overwrite existing json
        :return: RejectableElements
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', 'ref_id', 'body', 'commit_id', 'extended', 'overwrite']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_elements" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `post_elements`")  # noqa: E501
        # verify the required parameter 'ref_id' is set
        if ('ref_id' not in params or
                params['ref_id'] is None):
            raise ValueError("Missing the required parameter `ref_id` when calling `post_elements`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_elements`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501
        if 'ref_id' in params:
            path_params['ref_id'] = params['ref_id']  # noqa: E501

        query_params = []
        if 'commit_id' in params:
            query_params.append(('commitId', params['commit_id']))  # noqa: E501
        if 'extended' in params:
            query_params.append(('extended', params['extended']))  # noqa: E501
        if 'overwrite' in params:
            query_params.append(('overwrite', params['overwrite']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['Basic', 'Ticket']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_id}/refs/{ref_id}/elements', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RejectableElements',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
