import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * Manage a response play in PagerDuty
 *
 * @schema CfnResponsePlayProps
 */
export interface CfnResponsePlayProps {
    /**
     * The email address of a valid user associated with the account making the request.
     *
     * @schema CfnResponsePlayProps#FromEmail
     */
    readonly fromEmail: string;
    /**
     * The name of the response play.
     *
     * @schema CfnResponsePlayProps#Name
     */
    readonly name?: string;
    /**
     * The description of the response play.
     *
     * @schema CfnResponsePlayProps#Description
     */
    readonly description?: string;
    /**
     * @schema CfnResponsePlayProps#Team
     */
    readonly team?: any;
    /**
     * @schema CfnResponsePlayProps#Subscribers
     */
    readonly subscribers?: Subscriber[];
    /**
     * The content of the notification that will be sent to all incident subscribers upon the running of this response play. Note that this includes any users who may have already been subscribed to the incident prior to the running of this response play. If empty, no notifications will be sent.
     *
     * @schema CfnResponsePlayProps#SubscribersMessage
     */
    readonly subscribersMessage?: string;
    /**
     * @schema CfnResponsePlayProps#Responders
     */
    readonly responders?: Responder[];
    /**
     * The content of the notification that will be sent to all incident subscribers upon the running of this response play. Note that this includes any users who may have already been subscribed to the incident prior to the running of this response play. If empty, no notifications will be sent.
     *
     * @schema CfnResponsePlayProps#RespondersMessage
     */
    readonly respondersMessage?: string;
    /**
     * String representing how this response play is allowed to be run. Valid options are:
     *
     * services: This response play cannot be manually run by any users. It will run automatically for new incidents triggered on any services that are configured with this response play.
     * teams: This response play can be run manually on an incident only by members of its configured team. This option can only be selected when the team property for this response play is not empty.
     * responders: This response play can be run manually on an incident by any responders in this account.
     *
     * @schema CfnResponsePlayProps#Runnability
     */
    readonly runnability?: CfnResponsePlayPropsRunnability;
    /**
     * The telephone number that will be set as the conference number for any incident on which this response play is run.
     *
     * @schema CfnResponsePlayProps#ConferenceNumber
     */
    readonly conferenceNumber?: string;
    /**
     * The URL that will be set as the conference URL for any incident on which this response play is run.
     *
     * @schema CfnResponsePlayProps#ConferenceUrl
     */
    readonly conferenceUrl?: string;
    /**
     * This field has three possible values and indicates how the response play was created.
     *
     * none : The response play had no conference_number or conference_url set at time of creation.
     * manual : The response play had one or both of conference_number and conference_url set at time of creation.
     * zoom : Customers with the Zoom-Integration Entitelment can use this value to dynamicly configure conference number and url for zoom
     *
     * @schema CfnResponsePlayProps#ConferenceType
     */
    readonly conferenceType?: CfnResponsePlayPropsConferenceType;
    /**
     * @schema CfnResponsePlayProps#Id
     */
    readonly id?: string;
    /**
     * @schema CfnResponsePlayProps#Summary
     */
    readonly summary?: string;
    /**
     * @schema CfnResponsePlayProps#HtmlUrl
     */
    readonly htmlUrl?: string;
}
/**
 * Converts an object of type 'CfnResponsePlayProps' to JSON representation.
 */
export declare function toJson_CfnResponsePlayProps(obj: CfnResponsePlayProps | undefined): Record<string, any> | undefined;
/**
 * @schema Subscriber
 */
export interface Subscriber {
    /**
     * A string that determines the schema of the object. This must be the standard name for the entity, suffixed by _reference if the object is a reference.
     *
     * @schema Subscriber#Type
     */
    readonly type: SubscriberType;
    /**
     * @schema Subscriber#Id
     */
    readonly id: string;
}
/**
 * Converts an object of type 'Subscriber' to JSON representation.
 */
export declare function toJson_Subscriber(obj: Subscriber | undefined): Record<string, any> | undefined;
/**
 * @schema Responder
 */
export interface Responder {
    /**
     * A string that determines the schema of the object. This must be the standard name for the entity, suffixed by _reference if the object is a reference.
     *
     * @schema Responder#Type
     */
    readonly type: ResponderType;
    /**
     * @schema Responder#Id
     */
    readonly id: string;
}
/**
 * Converts an object of type 'Responder' to JSON representation.
 */
export declare function toJson_Responder(obj: Responder | undefined): Record<string, any> | undefined;
/**
 * String representing how this response play is allowed to be run. Valid options are:
 *
 * services: This response play cannot be manually run by any users. It will run automatically for new incidents triggered on any services that are configured with this response play.
 * teams: This response play can be run manually on an incident only by members of its configured team. This option can only be selected when the team property for this response play is not empty.
 * responders: This response play can be run manually on an incident by any responders in this account.
 *
 * @schema CfnResponsePlayPropsRunnability
 */
export declare enum CfnResponsePlayPropsRunnability {
    /** services */
    SERVICES = "services",
    /** teams */
    TEAMS = "teams",
    /** responders */
    RESPONDERS = "responders"
}
/**
 * This field has three possible values and indicates how the response play was created.
 *
 * none : The response play had no conference_number or conference_url set at time of creation.
 * manual : The response play had one or both of conference_number and conference_url set at time of creation.
 * zoom : Customers with the Zoom-Integration Entitelment can use this value to dynamicly configure conference number and url for zoom
 *
 * @schema CfnResponsePlayPropsConferenceType
 */
export declare enum CfnResponsePlayPropsConferenceType {
    /** none */
    NONE = "none",
    /** manual */
    MANUAL = "manual",
    /** zoom */
    ZOOM = "zoom"
}
/**
 * A string that determines the schema of the object. This must be the standard name for the entity, suffixed by _reference if the object is a reference.
 *
 * @schema SubscriberType
 */
export declare enum SubscriberType {
    /** user_reference */
    USER_REFERENCE = "user_reference",
    /** team_reference */
    TEAM_REFERENCE = "team_reference"
}
/**
 * A string that determines the schema of the object. This must be the standard name for the entity, suffixed by _reference if the object is a reference.
 *
 * @schema ResponderType
 */
export declare enum ResponderType {
    /** user_reference */
    USER_REFERENCE = "user_reference",
    /** escalation_policy_reference */
    ESCALATION_POLICY_REFERENCE = "escalation_policy_reference"
}
/**
 * A CloudFormation `PagerDuty::ResponsePlays::ResponsePlay`
 *
 * @cloudformationResource PagerDuty::ResponsePlays::ResponsePlay
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-pagerduty-resource-providers.git
 */
export declare class CfnResponsePlay extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "PagerDuty::ResponsePlays::ResponsePlay";
    /**
     * Resource props.
     */
    readonly props: CfnResponsePlayProps;
    /**
     * Attribute `PagerDuty::ResponsePlays::ResponsePlay.Type`
     * @link https://github.com/aws-ia/cloudformation-pagerduty-resource-providers.git
     */
    readonly attrType: string;
    /**
     * Create a new `PagerDuty::ResponsePlays::ResponsePlay`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnResponsePlayProps);
}
