<h1>py_everything</h1>

A python module containing all the functions and classes from basic to advanced for Python. From simple calculations  to advanced file encryption. <strong>Everything</strong> is included in this one package.

It allows you to use all of its functions and classes without having to write huge complex code. It is a very simple and easy to use library. 

<img src="https://static.pepy.tech/personalized-badge/py-everything?period=month&units=international_system&left_color=blue&right_color=black&left_text=Downloads/Month" alt="badge">
<img src="https://static.pepy.tech/personalized-badge/py-everything?period=week&units=international_system&left_color=blue&right_color=black&left_text=Downloads/Week" alt="badge">
<img src="https://static.pepy.tech/personalized-badge/py-everything?period=total&units=international_system&left_color=blue&right_color=black&left_text=Total%20Downloads" alt="badge">

<h1>Installation</h1>

py_everything is available on <a href="https://pypi.org/project/py_everything">PyPi</a>, and you can install it as follows:

<code>
$ python -m pip install py_everything
</code>
py_everything officially supports Python 3.5+

<h1>Features</h1>

<ul>
<li>You can make use of the thousands of functions and classes available to you.</li>
<li>Simple and easy to use</li>
<li>You don't have to write all of that code yourself, just call the pre-made functions.</li>
<li>You can inherit from our base class, and make your own with customizations.</li>
<li>There are two variants of most classes, a <code>Base</code> variant and an <code>Advanced</code> variant.</li>
<li>Make your own classes from our pre-provided <code>Base</code> variants. The Advanced ones are not for inheriting, but there is no problem in experimenting.</li>
</ul>

<h1>Documentation and Usage</h1>

The documentation can be found at <a href="https://github.com/play4Tutorials/py_everything/tree/master/docs">GitHub</a>


The basic usage for this library is given below:

<code>>>> import py_everything</code>
<br>
<code>>>> from py_everything import search</code>
<br>
<code>>>> search.search_files('python', 'C:\Programming\\')</code>
<br>
<code>C:\Programming\python.txt</code>
<br>
<code>C:\Programming\python_project.py</code>
<br>
<code>C:\Programming\python_py_everything.docx</code>
<br>
<code>>>> my_list = [2, 4, 5, 3, 7, 5, 6, 3 , 12 , 9, 6]</code>
<br>
<code>>>> py_everything.maths.avg(my_list)</code>
<br>
<code>5.636363636363637</code>
<br>

<h1>Contributing</h1>

For details, on how to contribute, please read <a href="https://github.com/play4Tutorials/py_everything/tree/master/CONTRIBUTING.md">CONTRIBUTING.md</a>
