# Autogenerated file. Do not edit.
from jacdac.bus import Bus, SensorClient
from .constants import *
from typing import Optional


class AcidityClient(SensorClient):
    """
    A sensor measuring water acidity, commonly called pH.
    Implements a client for the `Acidity <https://microsoft.github.io/jacdac-docs/services/acidity>`_ service.

    """

    def __init__(self, bus: Bus, role: str, *, missing_acidity_value: float = None) -> None:
        super().__init__(bus, JD_SERVICE_CLASS_ACIDITY, JD_ACIDITY_PACK_FORMATS, role, preferred_interval = 5000)
        self.missing_acidity_value = missing_acidity_value

    @property
    def acidity(self) -> Optional[float]:
        """
        The acidity, pH, of water., _: pH
        """
        self.refresh_reading()
        return self.register(JD_ACIDITY_REG_ACIDITY).value(self.missing_acidity_value)

    @property
    def acidity_error(self) -> Optional[float]:
        """
        (Optional) Error on the acidity reading., _: pH
        """
        return self.register(JD_ACIDITY_REG_ACIDITY_ERROR).value()

    @property
    def min_acidity(self) -> Optional[float]:
        """
        (Optional) Lowest acidity that can be reported., _: pH
        """
        return self.register(JD_ACIDITY_REG_MIN_ACIDITY).value()

    @property
    def max_humidity(self) -> Optional[float]:
        """
        (Optional) Highest acidity that can be reported., _: pH
        """
        return self.register(JD_ACIDITY_REG_MAX_HUMIDITY).value()

    
