"""SIPPER energetic parameters as NumPy data"""

import numpy as np

sipper_energy = np.array(
    [
        [
            "0.0203",
            "-0.0863",
            "-0.4557",
            "-0.2390",
            "-0.1248",
            "-0.1364",
            "-0.3296",
            "-0.1967",
            "0.0617",
            "-0.1510",
            "0.3005",
            "-0.5890",
            "0.3480",
            "0.3347",
            "-0.3933",
            "-0.0485",
            "-0.5509",
            "-0.1197",
            "-0.0258",
            "0.2342",
        ],
        [
            "-0.0863",
            "-0.1238",
            "0.0758",
            "0.3463",
            "0.0516",
            "0.1506",
            "0.3716",
            "0.1986",
            "0.0733",
            "0.0189",
            "0.0798",
            "-0.2429",
            "0.1691",
            "0.2749",
            "0.0556",
            "0.0307",
            "-0.1641",
            "0.4066",
            "0.3020",
            "-0.1588",
        ],
        [
            "-0.4557",
            "0.0758",
            "0.1364",
            "-0.0668",
            "-0.7083",
            "0.1542",
            "-0.0790",
            "-0.3221",
            "-0.0791",
            "-0.3255",
            "-0.2293",
            "-0.2471",
            "-0.0370",
            "-0.1128",
            "0.0580",
            "-0.2231",
            "0.1560",
            "0.1709",
            "0.2394",
            "-0.2417",
        ],
        [
            "-0.2390",
            "0.3463",
            "-0.0668",
            "-0.3435",
            "-0.6855",
            "-0.3219",
            "-0.4705",
            "-0.1295",
            "0.0531",
            "-0.3258",
            "-0.3965",
            "0.3560",
            "-0.2127",
            "-0.4031",
            "-0.3132",
            "0.0224",
            "-0.3750",
            "-0.2714",
            "0.1343",
            "-0.3264",
        ],
        [
            "-0.1248",
            "0.0516",
            "-0.7083",
            "-0.6855",
            "-0.8104",
            "0.2972",
            "-0.1732",
            "-0.0774",
            "0.2898",
            "-0.0418",
            "0.2815",
            "0.2155",
            "0.1408",
            "0.1201",
            "-1.4258",
            "0.2154",
            "-0.7522",
            "0.4573",
            "0.0093",
            "-0.2817",
        ],
        [
            "-0.1364",
            "0.1506",
            "0.1542",
            "-0.3219",
            "0.2972",
            "-0.0158",
            "-0.1981",
            "-0.0469",
            "-0.3700",
            "0.2238",
            "0.0074",
            "-0.0123",
            "-0.2583",
            "0.0009",
            "0.1196",
            "-0.1580",
            "-0.0776",
            "0.0481",
            "0.2801",
            "0.1851",
        ],
        [
            "-0.3296",
            "0.3716",
            "-0.0790",
            "-0.4705",
            "-0.1732",
            "-0.1981",
            "-0.3159",
            "-0.4593",
            "-0.0476",
            "-0.0528",
            "-0.3962",
            "0.1902",
            "0.0891",
            "-0.2260",
            "-0.2402",
            "-0.1619",
            "-0.0918",
            "-0.1682",
            "-0.0743",
            "-0.2364",
        ],
        [
            "-0.1967",
            "0.1986",
            "-0.3221",
            "-0.1295",
            "-0.0774",
            "-0.0469",
            "-0.4593",
            "-0.1134",
            "0.0774",
            "-0.1675",
            "-0.0427",
            "-0.2603",
            "0.1048",
            "-0.1419",
            "-0.0669",
            "-0.2623",
            "-0.2991",
            "-0.0405",
            "0.0623",
            "-0.1274",
        ],
        [
            "0.0617",
            "0.0733",
            "-0.0791",
            "0.0531",
            "0.2898",
            "-0.3700",
            "-0.0476",
            "0.0774",
            "-0.0065",
            "0.3230",
            "-0.0958",
            "-0.0730",
            "0.5929",
            "0.1252",
            "-0.1376",
            "-0.3582",
            "-0.0609",
            "0.1252",
            "0.1903",
            "-0.0374",
        ],
        [
            "-0.1510",
            "0.0189",
            "-0.3255",
            "-0.3258",
            "-0.0418",
            "0.2238",
            "-0.0528",
            "-0.1675",
            "0.3230",
            "0.1240",
            "0.4622",
            "-0.2669",
            "0.0782",
            "0.4798",
            "-0.0497",
            "-0.0236",
            "-0.1774",
            "0.2025",
            "0.1888",
            "0.2096",
        ],
        [
            "0.3005",
            "0.0798",
            "-0.2293",
            "-0.3965",
            "0.2815",
            "0.0074",
            "-0.3962",
            "-0.0427",
            "-0.0958",
            "0.4622",
            "0.3728",
            "0.0411",
            "0.5373",
            "0.4378",
            "0.1188",
            "-0.1046",
            "-0.2240",
            "0.1605",
            "-0.0031",
            "0.4125",
        ],
        [
            "-0.5890",
            "-0.2429",
            "-0.2471",
            "0.3560",
            "0.2155",
            "-0.0123",
            "0.1902",
            "-0.2603",
            "-0.0730",
            "-0.2669",
            "0.0411",
            "-0.5909",
            "0.0855",
            "-0.0428",
            "-0.3767",
            "-0.0221",
            "-0.2437",
            "0.2437",
            "0.0405",
            "-0.4158",
        ],
        [
            "0.3480",
            "0.1691",
            "-0.0370",
            "-0.2127",
            "0.1408",
            "-0.2583",
            "0.0891",
            "0.1048",
            "0.5929",
            "0.0782",
            "0.5373",
            "0.0855",
            "0.7834",
            "0.2749",
            "0.2739",
            "-0.2994",
            "-0.0021",
            "0.2643",
            "0.1597",
            "0.4304",
        ],
        [
            "0.3347",
            "0.2749",
            "-0.1128",
            "-0.4031",
            "0.1201",
            "0.0009",
            "-0.2260",
            "-0.1419",
            "0.1252",
            "0.4798",
            "0.4378",
            "-0.0428",
            "0.2749",
            "0.6080",
            "0.0835",
            "0.0307",
            "0.0467",
            "0.4828",
            "0.1903",
            "0.1886",
        ],
        [
            "-0.3933",
            "0.0556",
            "0.0580",
            "-0.3132",
            "-1.4258",
            "0.1196",
            "-0.2402",
            "-0.0669",
            "-0.1376",
            "-0.0497",
            "0.1188",
            "-0.3767",
            "0.2739",
            "0.0835",
            "-0.1661",
            "0.1552",
            "-0.0582",
            "0.5238",
            "0.3497",
            "-0.2488",
        ],
        [
            "-0.0485",
            "0.0307",
            "-0.2231",
            "0.0224",
            "0.2154",
            "-0.1580",
            "-0.1619",
            "-0.2623",
            "-0.3582",
            "-0.0236",
            "-0.1046",
            "-0.0221",
            "-0.2994",
            "0.0307",
            "0.1552",
            "-0.2341",
            "-0.1813",
            "-0.1190",
            "0.0475",
            "-0.0925",
        ],
        [
            "-0.5509",
            "-0.1641",
            "0.1560",
            "-0.3750",
            "-0.7522",
            "-0.0776",
            "-0.0918",
            "-0.2991",
            "-0.0609",
            "-0.1774",
            "-0.2240",
            "-0.2437",
            "-0.0021",
            "0.0467",
            "-0.0582",
            "-0.1813",
            "-0.1036",
            "0.0086",
            "0.0089",
            "0.1553",
        ],
        [
            "-0.1197",
            "0.4066",
            "0.1709",
            "-0.2714",
            "0.4573",
            "0.0481",
            "-0.1682",
            "-0.0405",
            "0.1252",
            "0.2025",
            "0.1605",
            "0.2437",
            "0.2643",
            "0.4828",
            "0.5238",
            "-0.1190",
            "0.0086",
            "0.2568",
            "0.4536",
            "0.0098",
        ],
        [
            "-0.0258",
            "0.3020",
            "0.2394",
            "0.1343",
            "0.0093",
            "0.2801",
            "-0.0743",
            "0.0623",
            "0.1903",
            "0.1888",
            "-0.0031",
            "0.0405",
            "0.1597",
            "0.1903",
            "0.3497",
            "0.0475",
            "0.0089",
            "0.4536",
            "-0.0037",
            "0.1134",
        ],
        [
            "0.2342",
            "-0.1588",
            "-0.2417",
            "-0.3264",
            "-0.2817",
            "0.1851",
            "-0.2364",
            "-0.1274",
            "-0.0374",
            "0.2096",
            "0.4125",
            "-0.4158",
            "0.4304",
            "0.1886",
            "-0.2488",
            "-0.0925",
            "0.1553",
            "0.0098",
            "0.1134",
            "0.1246",
        ],
    ],
    dtype=np.float64,
)

res_to_index = {
    "ALA": 0,
    "ARG": 1,
    "ASN": 2,
    "ASP": 3,
    "CYS": 4,
    "GLN": 5,
    "GLU": 6,
    "GLY": 7,
    "HIS": 8,
    "HIP": 8,
    "HID": 8,
    "ILE": 9,
    "LEU": 10,
    "LYS": 11,
    "MET": 12,
    "PHE": 13,
    "PRO": 14,
    "SER": 15,
    "THR": 16,
    "TRP": 17,
    "TYR": 18,
    "VAL": 19,
}
