import { Grant, IGrantable } from '@aws-cdk/aws-iam';
import { IResource, Resource } from '@aws-cdk/core';
import { Construct } from 'constructs';
/**
 * (experimental) The compute platform of the profiling group.
 *
 * @experimental
 */
export declare enum ComputePlatform {
    /**
     * (experimental) Use AWS_LAMBDA if your application runs on AWS Lambda.
     *
     * @experimental
     */
    AWS_LAMBDA = "AWSLambda",
    /**
     * (experimental) Use Default if your application runs on a compute platform that is not AWS Lambda, such an Amazon EC2 instance, an on-premises server, or a different platform.
     *
     * @experimental
     */
    DEFAULT = "Default"
}
/**
 * (experimental) IResource represents a Profiling Group.
 *
 * @experimental
 */
export interface IProfilingGroup extends IResource {
    /**
     * (experimental) A name for the profiling group.
     *
     * @experimental
     * @attribute true
     */
    readonly profilingGroupName: string;
    /**
     * (experimental) Grant access to publish profiling information to the Profiling Group to the given identity.
     *
     * This will grant the following permissions:
     *
     *   - codeguru-profiler:ConfigureAgent
     *   - codeguru-profiler:PostAgentProfile
     *
     * @param grantee Principal to grant publish rights to.
     * @experimental
     */
    grantPublish(grantee: IGrantable): Grant;
    /**
     * (experimental) Grant access to read profiling information from the Profiling Group to the given identity.
     *
     * This will grant the following permissions:
     *
     *   - codeguru-profiler:GetProfile
     *   - codeguru-profiler:DescribeProfilingGroup
     *
     * @param grantee Principal to grant read rights to.
     * @experimental
     */
    grantRead(grantee: IGrantable): Grant;
}
declare abstract class ProfilingGroupBase extends Resource implements IProfilingGroup {
    abstract readonly profilingGroupName: string;
    abstract readonly profilingGroupArn: string;
    /**
     * (experimental) Grant access to publish profiling information to the Profiling Group to the given identity.
     *
     * This will grant the following permissions:
     *
     *   - codeguru-profiler:ConfigureAgent
     *   - codeguru-profiler:PostAgentProfile
     *
     * @param grantee Principal to grant publish rights to.
     * @experimental
     */
    grantPublish(grantee: IGrantable): Grant;
    /**
     * (experimental) Grant access to read profiling information from the Profiling Group to the given identity.
     *
     * This will grant the following permissions:
     *
     *   - codeguru-profiler:GetProfile
     *   - codeguru-profiler:DescribeProfilingGroup
     *
     * @param grantee Principal to grant read rights to.
     * @experimental
     */
    grantRead(grantee: IGrantable): Grant;
}
/**
 * (experimental) Properties for creating a new Profiling Group.
 *
 * @experimental
 */
export interface ProfilingGroupProps {
    /**
     * (experimental) A name for the profiling group.
     *
     * @default - automatically generated name.
     * @experimental
     */
    readonly profilingGroupName?: string;
    /**
     * (experimental) The compute platform of the profiling group.
     *
     * @default ComputePlatform.DEFAULT
     * @experimental
     */
    readonly computePlatform?: ComputePlatform;
}
/**
 * (experimental) A new Profiling Group.
 *
 * @experimental
 */
export declare class ProfilingGroup extends ProfilingGroupBase {
    /**
     * (experimental) Import an existing Profiling Group provided a Profiling Group Name.
     *
     * @param scope The parent creating construct.
     * @param id The construct's name.
     * @param profilingGroupName Profiling Group Name.
     * @experimental
     */
    static fromProfilingGroupName(scope: Construct, id: string, profilingGroupName: string): IProfilingGroup;
    /**
     * (experimental) Import an existing Profiling Group provided an ARN.
     *
     * @param scope The parent creating construct.
     * @param id The construct's name.
     * @param profilingGroupArn Profiling Group ARN.
     * @experimental
     */
    static fromProfilingGroupArn(scope: Construct, id: string, profilingGroupArn: string): IProfilingGroup;
    /**
     * (experimental) The name of the Profiling Group.
     *
     * @experimental
     * @attribute true
     */
    readonly profilingGroupName: string;
    /**
     * (experimental) The ARN of the Profiling Group.
     *
     * @experimental
     * @attribute true
     */
    readonly profilingGroupArn: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: ProfilingGroupProps);
    private generateUniqueId;
}
export {};
