from enum import Enum


class SoundFile(Enum):
    """
    Paths to standard EV3 sounds.

    Note:
        Expressions: BOING, BOO, CHEERING, CRUNCHING, CRYING, FANFARE, KUNG_FU, LAUGHING_1, LAUGHING_2, MAGIC_WAND, OUCH, SHOUTING, SMACK, SNEEZING, SNORING, UH_OH

        Information: ACTIVATE, ANALYZE, BACKWARDS, COLOR, DETECTED, DOWN, ERROR, ERROR_ALARM, FLASHING, FORWARD, LEFT, OBJECT, RIGHT, SEARCHING, START, STOP, TOUCH, TURN, UP

        Communication: BRAVO, EV3, FANTASTIC, GAME_OVER, GO, GOOD_JOB, GOOD, GOODBYE, HELLO, HI, LEGO, MINDSTORMS,MORNING, NO, OKAY, OKEY_DOKEY, SORRY, THANK_YOU, YES

        Movements: SPEED_DOWN, SPEED_IDLE, SPEED_UP

        Color: BLACK, BLUE, BROWN, GREEN, RED, WHITE, YELLOW

        Mechanical: AIR_RELEASE, AIRBRAKE, BACKING_ALERT, HORN_1, HORN_2, LASER, MOTOR_IDLE, MOTOR_START, MOTOR_STOP, RATCHET, SONAR, TICK_TACK

        Animal sounds: CAT_PURR, DOG_BARK_1, DOG_BARK_2, DOG_GROWL, DOG_SNIFF, DOG_WHINE, ELEPHANT_CALL, INSECT_BUZZ_1,INSECT_BUZZ_2, INSECT_CHIRP, SNAKE_HISS, SNAKE_RATTLE, T_REX_ROAR

        Numbers: ZERO, ONE, TWO, THREE, FOUR, FIVE, SIX, SEVEN, EIGHT, NINE, TEN

        System sounds: CLICK, CONFIRM, GENERAL_ALERT, OVERPOWER, READY
    """
    BOING = ...
    BOO = ...
    CHEERING = ...
    CRUNCHING = ...
    CRYING = ...
    FANFARE = ...
    KUNG_FU = ...
    LAUGHING_1 = ...
    LAUGHING_2 = ...
    MAGIC_WAND = ...
    OUCH = ...
    SHOUTING = ...
    SMACK = ...
    SNEEZING = ...
    SNORING = ...
    UH_OH = ...

    ACTIVATE = ...
    ANALYZE = ...
    BACKWARDS = ...
    COLOR = ...
    DETECTED = ...
    DOWN = ...
    ERROR = ...
    ERROR_ALARM = ...
    FLASHING = ...
    FORWARD = ...
    LEFT = ...
    OBJECT = ...
    RIGHT = ...
    SEARCHING = ...
    START = ...
    STOP = ...
    TOUCH = ...
    TURN = ...
    UP = ...

    BRAVO = ...
    EV3 = ...
    FANTASTIC = ...
    GAME_OVER = ...
    GO = ...
    GOOD_JOB = ...
    GOOD = ...
    GOODBYE = ...
    HELLO = ...
    HI = ...
    LEGO = ...
    MINDSTORMS = ...
    MORNING = ...
    NO = ...
    OKAY = ...
    OKEY_DOKEY = ...
    SORRY = ...
    THANK_YOU = ...
    YES = ...

    SPEED_DOWN = ...
    SPEED_IDLE = ...
    SPEED_UP = ...

    BLACK = ...
    BLUE = ...
    BROWN = ...
    GREEN = ...
    RED = ...
    WHITE = ...
    YELLOW = ...

    AIR_RELEASE = ...
    AIRBRAKE = ...
    BACKING_ALERT = ...
    HORN_1 = ...
    HORN_2 = ...
    LASER = ...
    MOTOR_IDLE = ...
    MOTOR_START = ...
    MOTOR_STOP = ...
    RATCHET = ...
    SONAR = ...
    TICK_TACK = ...

    CAT_PURR = ...
    DOG_BARK_1 = ...
    DOG_BARK_2 = ...
    DOG_GROWL = ...
    DOG_SNIFF = ...
    DOG_WHINE = ...
    ELEPHANT_CALL = ...
    INSECT_BUZZ_1 = ...
    INSECT_BUZZ_2 = ...
    INSECT_CHIRP = ...
    SNAKE_HISS = ...
    SNAKE_RATTLE = ...
    T_REX_ROAR = ...

    ZERO = ...
    ONE = ...
    TWO = ...
    THREE = ...
    FOUR = ...
    FIVE = ...
    SIX = ...
    SEVEN = ...
    EIGHT = ...
    NINE = ...
    TEN = ...

    CLICK = ...
    CONFIRM = ...
    GENERAL_ALERT = ...
    OVERPOWER = ...
    READY = ...
