#!/bin/bash
# coding=utf-8

set -eo pipefail

virtualenv -p python3 proto_env
# shellcheck disable=SC1091
source proto_env/bin/activate
pip install grpcio-tools==1.7.0

function cleanup() {
    # shellcheck disable=SC1091
    rm -rf proto_env
}
trap cleanup EXIT

echo "Generating dictation Python protobuf/grpc sources."
path_i="../proto"
path_o="service"
python3 -m grpc_tools.protoc \
	        -I${path_i} \
            -I../submodules/googleapis \
            --python_out=${path_o} \
            --grpc_python_out=${path_o} \
            ${path_i}/dictation_asr.proto

# Fix buggy autogenerated GRPC import
sed -i 's/.*import dictation_asr_pb2 as dictation__asr__pb2.*/from . import dictation_asr_pb2 as dictation__asr__pb2/' ${path_o}/dictation_asr_pb2_grpc.py
