"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TrafficControl = exports.TrafficControlProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const apigateway_generated_1 = require("./apigateway.generated");
Object.defineProperty(exports, "TrafficControlProperty", { enumerable: true, get: function () { return apigateway_generated_1.RosTrafficControl; } });
/**
 * A ROS resource type:  `ALIYUN::ApiGateway::TrafficControl`
 */
class TrafficControl extends ros.Resource {
    /**
     * Create a new `ALIYUN::ApiGateway::TrafficControl`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosTrafficControl = new apigateway_generated_1.RosTrafficControl(this, id, {
            description: props.description,
            trafficControlUnit: props.trafficControlUnit,
            trafficControlName: props.trafficControlName,
            appDefault: props.appDefault,
            special: props.special,
            userDefault: props.userDefault,
            apiDefault: props.apiDefault,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosTrafficControl;
        this.attrTrafficControlId = rosTrafficControl.attrTrafficControlId;
    }
}
exports.TrafficControl = TrafficControl;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidHJhZmZpY2NvbnRyb2wuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJ0cmFmZmljY29udHJvbC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSw4Q0FBOEM7QUFDOUMsaUVBQTJEO0FBRTdCLHVHQUZyQix3Q0FBaUIsT0FFMEI7QUEyQ3BEOztHQUVHO0FBQ0gsTUFBYSxjQUFlLFNBQVEsR0FBRyxDQUFDLFFBQVE7SUFZNUM7Ozs7OztPQU1HO0lBQ0gsWUFBWSxLQUFvQixFQUFFLEVBQVUsRUFBRSxLQUEwQixFQUFFLG1DQUEyQyxJQUFJO1FBQ3JILEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFFakIsTUFBTSxpQkFBaUIsR0FBRyxJQUFJLHdDQUFpQixDQUFDLElBQUksRUFBRSxFQUFFLEVBQUc7WUFDdkQsV0FBVyxFQUFFLEtBQUssQ0FBQyxXQUFXO1lBQzlCLGtCQUFrQixFQUFFLEtBQUssQ0FBQyxrQkFBa0I7WUFDNUMsa0JBQWtCLEVBQUUsS0FBSyxDQUFDLGtCQUFrQjtZQUM1QyxVQUFVLEVBQUUsS0FBSyxDQUFDLFVBQVU7WUFDNUIsT0FBTyxFQUFFLEtBQUssQ0FBQyxPQUFPO1lBQ3RCLFdBQVcsRUFBRSxLQUFLLENBQUMsV0FBVztZQUM5QixVQUFVLEVBQUUsS0FBSyxDQUFDLFVBQVU7U0FDL0IsRUFBRSxnQ0FBZ0MsSUFBSSxJQUFJLENBQUMsS0FBSyxDQUFDLGdDQUFnQyxDQUFDLENBQUM7UUFDcEYsSUFBSSxDQUFDLFFBQVEsR0FBRyxpQkFBaUIsQ0FBQztRQUNsQyxJQUFJLENBQUMsb0JBQW9CLEdBQUcsaUJBQWlCLENBQUMsb0JBQW9CLENBQUM7SUFDdkUsQ0FBQztDQUNKO0FBbENELHdDQWtDQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIHJvcyBmcm9tICdAYWxpY2xvdWQvcm9zLWNkay1jb3JlJztcclxuaW1wb3J0IHsgUm9zVHJhZmZpY0NvbnRyb2wgfSBmcm9tICcuL2FwaWdhdGV3YXkuZ2VuZXJhdGVkJztcclxuLy8gR2VuZXJhdGVkIGZyb20gdGhlIEFsaUNsb3VkIFJPUyBSZXNvdXJjZSBTcGVjaWZpY2F0aW9uXHJcbmV4cG9ydCB7IFJvc1RyYWZmaWNDb250cm9sIGFzIFRyYWZmaWNDb250cm9sUHJvcGVydHkgfTtcclxuXHJcbi8qKlxyXG4gKiBQcm9wZXJ0aWVzIGZvciBkZWZpbmluZyBhIGBBTElZVU46OkFwaUdhdGV3YXk6OlRyYWZmaWNDb250cm9sYFxyXG4gKi9cclxuZXhwb3J0IGludGVyZmFjZSBUcmFmZmljQ29udHJvbFByb3BzIHtcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBhcGlEZWZhdWx0OiBEZWZhdWx0IEFQSSB0cmFmZmljIHZhbHVlLlxyXG4gICAgICovXHJcbiAgICByZWFkb25seSBhcGlEZWZhdWx0OiBudW1iZXI7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgdHJhZmZpY0NvbnRyb2xOYW1lOiBUaGUgbmFtZSBvZiB0aGUgdHJhZmZpYyBjb250cm9sLk5lZWQgWzQsIDUwXSBDaGluZXNlXFxFbmdsaXNoXFxOdW1iZXIgY2hhcmFjdGVycyBvciBcIl9cIixhbmQgc2hvdWxkIHN0YXJ0IHdpdGggQ2hpbmVzZS9FbmdsaXNoIGNoYXJhY3Rlci5cclxuICAgICAqL1xyXG4gICAgcmVhZG9ubHkgdHJhZmZpY0NvbnRyb2xOYW1lOiBzdHJpbmc7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgdHJhZmZpY0NvbnRyb2xVbml0OiBUcmFmZmljIGNvbnRyb2wgdW5pdCwgREFZL0hPVVIvTUlOVVRFLlxyXG4gICAgICovXHJcbiAgICByZWFkb25seSB0cmFmZmljQ29udHJvbFVuaXQ6IHN0cmluZztcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBhcHBEZWZhdWx0OiBEZWZhdWx0IEFQUCB0cmFmZmljIHZhbHVlLlxyXG4gICAgICovXHJcbiAgICByZWFkb25seSBhcHBEZWZhdWx0Pzogc3RyaW5nO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IGRlc2NyaXB0aW9uOiBEZXNjcmlwdGlvbiBvZiB0aGUgdHJhZmZpYyBjb250cm9sLCBsZXNzIHRoYW4gMTgwIGNoYXJhY3RlcnMuXHJcbiAgICAgKi9cclxuICAgIHJlYWRvbmx5IGRlc2NyaXB0aW9uPzogc3RyaW5nO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IHNwZWNpYWw6IFNwZWNpYWwgdHJhZmZpYyBjb250cm9scy5cclxuICAgICAqL1xyXG4gICAgcmVhZG9ubHkgc3BlY2lhbD86IEFycmF5PFJvc1RyYWZmaWNDb250cm9sLlNwZWNpYWxQcm9wZXJ0eSB8IHJvcy5JUmVzb2x2YWJsZT4gfCByb3MuSVJlc29sdmFibGU7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgdXNlckRlZmF1bHQ6IERlZmF1bHQgdXNlciB0cmFmZmljIHZhbHVlLlxyXG4gICAgICovXHJcbiAgICByZWFkb25seSB1c2VyRGVmYXVsdD86IHN0cmluZztcclxufVxyXG5cclxuLyoqXHJcbiAqIEEgUk9TIHJlc291cmNlIHR5cGU6ICBgQUxJWVVOOjpBcGlHYXRld2F5OjpUcmFmZmljQ29udHJvbGBcclxuICovXHJcbmV4cG9ydCBjbGFzcyBUcmFmZmljQ29udHJvbCBleHRlbmRzIHJvcy5SZXNvdXJjZSB7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBBIGZhY3RvcnkgbWV0aG9kIHRoYXQgY3JlYXRlcyBhIG5ldyBpbnN0YW5jZSBvZiB0aGlzIGNsYXNzIGZyb20gYW4gb2JqZWN0XHJcbiAgICAgKiBjb250YWluaW5nIHRoZSBwcm9wZXJ0aWVzIG9mIHRoaXMgUk9TIHJlc291cmNlLCB3aGljaCB3aWxsIGJlIGFzc2lnbmVkIHRvIFJPUyByZXNvdXJjZS5cclxuICAgICAqL1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQEF0dHJpYnV0ZSBUcmFmZmljQ29udHJvbElkOiBUaGUgaWQgb2YgdGhlIHRyYWZmaWMgY29udHJvbFxyXG4gICAgICovXHJcbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0clRyYWZmaWNDb250cm9sSWQ6IGFueTtcclxuXHJcbiAgICAvKipcclxuICAgICAqIENyZWF0ZSBhIG5ldyBgQUxJWVVOOjpBcGlHYXRld2F5OjpUcmFmZmljQ29udHJvbGAuXHJcbiAgICAgKlxyXG4gICAgICogQHBhcmFtIHNjb3BlIC0gc2NvcGUgaW4gd2hpY2ggdGhpcyByZXNvdXJjZSBpcyBkZWZpbmVkXHJcbiAgICAgKiBAcGFyYW0gaWQgICAgLSBzY29wZWQgaWQgb2YgdGhlIHJlc291cmNlXHJcbiAgICAgKiBAcGFyYW0gcHJvcHMgLSByZXNvdXJjZSBwcm9wZXJ0aWVzXHJcbiAgICAgKi9cclxuICAgIGNvbnN0cnVjdG9yKHNjb3BlOiByb3MuQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogVHJhZmZpY0NvbnRyb2xQcm9wcywgZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQ6Ym9vbGVhbiA9IHRydWUpIHtcclxuICAgICAgICBzdXBlcihzY29wZSwgaWQpO1xyXG5cclxuICAgICAgICBjb25zdCByb3NUcmFmZmljQ29udHJvbCA9IG5ldyBSb3NUcmFmZmljQ29udHJvbCh0aGlzLCBpZCwgIHtcclxuICAgICAgICAgICAgZGVzY3JpcHRpb246IHByb3BzLmRlc2NyaXB0aW9uLFxyXG4gICAgICAgICAgICB0cmFmZmljQ29udHJvbFVuaXQ6IHByb3BzLnRyYWZmaWNDb250cm9sVW5pdCxcclxuICAgICAgICAgICAgdHJhZmZpY0NvbnRyb2xOYW1lOiBwcm9wcy50cmFmZmljQ29udHJvbE5hbWUsXHJcbiAgICAgICAgICAgIGFwcERlZmF1bHQ6IHByb3BzLmFwcERlZmF1bHQsXHJcbiAgICAgICAgICAgIHNwZWNpYWw6IHByb3BzLnNwZWNpYWwsXHJcbiAgICAgICAgICAgIHVzZXJEZWZhdWx0OiBwcm9wcy51c2VyRGVmYXVsdCxcclxuICAgICAgICAgICAgYXBpRGVmYXVsdDogcHJvcHMuYXBpRGVmYXVsdCxcclxuICAgICAgICB9LCBlbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludCAmJiB0aGlzLnN0YWNrLmVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50KTtcclxuICAgICAgICB0aGlzLnJlc291cmNlID0gcm9zVHJhZmZpY0NvbnRyb2w7XHJcbiAgICAgICAgdGhpcy5hdHRyVHJhZmZpY0NvbnRyb2xJZCA9IHJvc1RyYWZmaWNDb250cm9sLmF0dHJUcmFmZmljQ29udHJvbElkO1xyXG4gICAgfVxyXG59XHJcbiJdfQ==