"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LogConfig = exports.LogConfigProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const apigateway_generated_1 = require("./apigateway.generated");
Object.defineProperty(exports, "LogConfigProperty", { enumerable: true, get: function () { return apigateway_generated_1.RosLogConfig; } });
/**
 * A ROS resource type:  `ALIYUN::ApiGateway::LogConfig`
 */
class LogConfig extends ros.Resource {
    /**
     * Create a new `ALIYUN::ApiGateway::LogConfig`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosLogConfig = new apigateway_generated_1.RosLogConfig(this, id, {
            slsLogStore: props.slsLogStore,
            slsProject: props.slsProject,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosLogConfig;
        this.attrSlsLogStore = rosLogConfig.attrSlsLogStore;
        this.attrSlsProject = rosLogConfig.attrSlsProject;
    }
}
exports.LogConfig = LogConfig;
//# sourceMappingURL=data:application/json;base64,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