"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Deployment = exports.DeploymentProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const apigateway_generated_1 = require("./apigateway.generated");
Object.defineProperty(exports, "DeploymentProperty", { enumerable: true, get: function () { return apigateway_generated_1.RosDeployment; } });
/**
 * A ROS resource type:  `ALIYUN::ApiGateway::Deployment`
 */
class Deployment extends ros.Resource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the properties of this ROS resource, which will be assigned to ROS resource.
     */
    /**
     * Create a new `ALIYUN::ApiGateway::Deployment`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosDeployment = new apigateway_generated_1.RosDeployment(this, id, {
            description: props.description,
            stageName: props.stageName,
            apiId: props.apiId,
            historyVersion: props.historyVersion,
            groupId: props.groupId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDeployment;
    }
}
exports.Deployment = Deployment;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGVwbG95bWVudC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImRlcGxveW1lbnQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsOENBQThDO0FBQzlDLGlFQUF1RDtBQUU3QixtR0FGakIsb0NBQWEsT0FFc0I7QUFpQzVDOztHQUVHO0FBQ0gsTUFBYSxVQUFXLFNBQVEsR0FBRyxDQUFDLFFBQVE7SUFFeEM7OztPQUdHO0lBRUg7Ozs7OztPQU1HO0lBQ0gsWUFBWSxLQUFvQixFQUFFLEVBQVUsRUFBRSxLQUFzQixFQUFFLG1DQUEyQyxJQUFJO1FBQ2pILEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFFakIsTUFBTSxhQUFhLEdBQUcsSUFBSSxvQ0FBYSxDQUFDLElBQUksRUFBRSxFQUFFLEVBQUc7WUFDL0MsV0FBVyxFQUFFLEtBQUssQ0FBQyxXQUFXO1lBQzlCLFNBQVMsRUFBRSxLQUFLLENBQUMsU0FBUztZQUMxQixLQUFLLEVBQUUsS0FBSyxDQUFDLEtBQUs7WUFDbEIsY0FBYyxFQUFFLEtBQUssQ0FBQyxjQUFjO1lBQ3BDLE9BQU8sRUFBRSxLQUFLLENBQUMsT0FBTztTQUN6QixFQUFFLGdDQUFnQyxJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsZ0NBQWdDLENBQUMsQ0FBQztRQUNwRixJQUFJLENBQUMsUUFBUSxHQUFHLGFBQWEsQ0FBQztJQUNsQyxDQUFDO0NBQ0o7QUExQkQsZ0NBMEJDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgcm9zIGZyb20gJ0BhbGljbG91ZC9yb3MtY2RrLWNvcmUnO1xyXG5pbXBvcnQgeyBSb3NEZXBsb3ltZW50IH0gZnJvbSAnLi9hcGlnYXRld2F5LmdlbmVyYXRlZCc7XHJcbi8vIEdlbmVyYXRlZCBmcm9tIHRoZSBBbGlDbG91ZCBST1MgUmVzb3VyY2UgU3BlY2lmaWNhdGlvblxyXG5leHBvcnQgeyBSb3NEZXBsb3ltZW50IGFzIERlcGxveW1lbnRQcm9wZXJ0eSB9O1xyXG5cclxuLyoqXHJcbiAqIFByb3BlcnRpZXMgZm9yIGRlZmluaW5nIGEgYEFMSVlVTjo6QXBpR2F0ZXdheTo6RGVwbG95bWVudGBcclxuICovXHJcbmV4cG9ydCBpbnRlcmZhY2UgRGVwbG95bWVudFByb3BzIHtcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBhcGlJZDogVGhlIGlkIG9mIHRoZSBBUEkuXHJcbiAgICAgKi9cclxuICAgIHJlYWRvbmx5IGFwaUlkOiBzdHJpbmc7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgZ3JvdXBJZDogVGhlIGlkIG9mIHRoZSBHcm91cC5cclxuICAgICAqL1xyXG4gICAgcmVhZG9ubHkgZ3JvdXBJZDogc3RyaW5nO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IHN0YWdlTmFtZTogQmluZCB0cmFmZmljIGluIHRoaXMgc3RhZ2UuXHJcbiAgICAgKi9cclxuICAgIHJlYWRvbmx5IHN0YWdlTmFtZTogc3RyaW5nO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IGRlc2NyaXB0aW9uOiBEZXNjcmlwdGlvbiBvZiB0aGUgZGVwbG95bWVudCwgbGVzcyB0aGFuIDE4MCBjaGFyYWN0ZXJzLlxyXG4gICAgICovXHJcbiAgICByZWFkb25seSBkZXNjcmlwdGlvbj86IHN0cmluZztcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBoaXN0b3J5VmVyc2lvbjogVGhlIGhpc3RvcnkgdmVyc2lvbi5cclxuICAgICAqL1xyXG4gICAgcmVhZG9ubHkgaGlzdG9yeVZlcnNpb24/OiBzdHJpbmc7XHJcbn1cclxuXHJcbi8qKlxyXG4gKiBBIFJPUyByZXNvdXJjZSB0eXBlOiAgYEFMSVlVTjo6QXBpR2F0ZXdheTo6RGVwbG95bWVudGBcclxuICovXHJcbmV4cG9ydCBjbGFzcyBEZXBsb3ltZW50IGV4dGVuZHMgcm9zLlJlc291cmNlIHtcclxuXHJcbiAgICAvKipcclxuICAgICAqIEEgZmFjdG9yeSBtZXRob2QgdGhhdCBjcmVhdGVzIGEgbmV3IGluc3RhbmNlIG9mIHRoaXMgY2xhc3MgZnJvbSBhbiBvYmplY3RcclxuICAgICAqIGNvbnRhaW5pbmcgdGhlIHByb3BlcnRpZXMgb2YgdGhpcyBST1MgcmVzb3VyY2UsIHdoaWNoIHdpbGwgYmUgYXNzaWduZWQgdG8gUk9TIHJlc291cmNlLlxyXG4gICAgICovXHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBDcmVhdGUgYSBuZXcgYEFMSVlVTjo6QXBpR2F0ZXdheTo6RGVwbG95bWVudGAuXHJcbiAgICAgKlxyXG4gICAgICogQHBhcmFtIHNjb3BlIC0gc2NvcGUgaW4gd2hpY2ggdGhpcyByZXNvdXJjZSBpcyBkZWZpbmVkXHJcbiAgICAgKiBAcGFyYW0gaWQgICAgLSBzY29wZWQgaWQgb2YgdGhlIHJlc291cmNlXHJcbiAgICAgKiBAcGFyYW0gcHJvcHMgLSByZXNvdXJjZSBwcm9wZXJ0aWVzXHJcbiAgICAgKi9cclxuICAgIGNvbnN0cnVjdG9yKHNjb3BlOiByb3MuQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogRGVwbG95bWVudFByb3BzLCBlbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludDpib29sZWFuID0gdHJ1ZSkge1xyXG4gICAgICAgIHN1cGVyKHNjb3BlLCBpZCk7XHJcblxyXG4gICAgICAgIGNvbnN0IHJvc0RlcGxveW1lbnQgPSBuZXcgUm9zRGVwbG95bWVudCh0aGlzLCBpZCwgIHtcclxuICAgICAgICAgICAgZGVzY3JpcHRpb246IHByb3BzLmRlc2NyaXB0aW9uLFxyXG4gICAgICAgICAgICBzdGFnZU5hbWU6IHByb3BzLnN0YWdlTmFtZSxcclxuICAgICAgICAgICAgYXBpSWQ6IHByb3BzLmFwaUlkLFxyXG4gICAgICAgICAgICBoaXN0b3J5VmVyc2lvbjogcHJvcHMuaGlzdG9yeVZlcnNpb24sXHJcbiAgICAgICAgICAgIGdyb3VwSWQ6IHByb3BzLmdyb3VwSWQsXHJcbiAgICAgICAgfSwgZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQgJiYgdGhpcy5zdGFjay5lbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludCk7XHJcbiAgICAgICAgdGhpcy5yZXNvdXJjZSA9IHJvc0RlcGxveW1lbnQ7XHJcbiAgICB9XHJcbn1cclxuIl19