"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Api = exports.ApiProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const apigateway_generated_1 = require("./apigateway.generated");
Object.defineProperty(exports, "ApiProperty", { enumerable: true, get: function () { return apigateway_generated_1.RosApi; } });
/**
 * A ROS resource type:  `ALIYUN::ApiGateway::Api`
 */
class Api extends ros.Resource {
    /**
     * Create a new `ALIYUN::ApiGateway::Api`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosApi = new apigateway_generated_1.RosApi(this, id, {
            requestConfig: props.requestConfig,
            description: props.description,
            resultSample: props.resultSample,
            apiName: props.apiName,
            resultType: props.resultType ? props.resultType : 'JSON',
            failResultSample: props.failResultSample,
            errorCodeSamples: props.errorCodeSamples,
            serviceParametersMap: props.serviceParametersMap,
            groupId: props.groupId,
            requestParameters: props.requestParameters,
            appCodeAuthType: props.appCodeAuthType,
            serviceConfig: props.serviceConfig,
            constParameters: props.constParameters,
            systemParameters: props.systemParameters,
            openIdConnectConfig: props.openIdConnectConfig,
            visibility: props.visibility,
            serviceParameters: props.serviceParameters,
            authType: props.authType,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosApi;
        this.attrApiId = rosApi.attrApiId;
    }
}
exports.Api = Api;
//# sourceMappingURL=data:application/json;base64,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