# AUTOGENERATED! DO NOT EDIT! File to edit: ../01_deck.ipynb.

# %% auto 0
__all__ = ['Deck', 'draw_n']

# %% ../01_deck.ipynb 1
from fastcore.utils import *

# %% ../01_deck.ipynb 3
from .card import *

# %% ../01_deck.ipynb 5
class Deck:
    "A deck of 52 cards"
    def __init__(self): self.cards =[Card(suit=s,rank=r) for s in range(4) for r in range(1,14)] 
    def __len__(self): return len(self.cards)
    def __str__(self): return "; ".join(map(str,self.cards))
    def __contains__(self,card:Card): return card in self.cards
    __repr__ = __str__
    
    def shuffle(self):
        "Shuffles the cards in the deck"
        random.shuffle(self.cards)

# %% ../01_deck.ipynb 13
@patch
def pop(self:Deck,
        idx: int = -1): # The index of the card to remove, defaulting to the last one.
    "Remove one card from the deck"
    return self.cards.pop(idx)

# %% ../01_deck.ipynb 17
@patch
def remove(self:Deck,
        card: Card):
    "Removes `card` from the deck. Raises an exception if it is not there"
    return self.cards.remove(card)

# %% ../01_deck.ipynb 20
def draw_n(n:int, # number of cards to draw
           replace:bool=True): # whether or not draw with replacement
    "Draw `n` cards, with replacement if `replace`"
    d = Deck()
    d.shuffle()
    if replace: return [d.cards[random.choice(range(len(d.cards)))] for _ in range(n)]
    else: return d.cards[:n]
