# swagger-client
This API is intended to be used in conjunction with the Unity Cloud Build service. A tool for building your Unity projects in the Cloud.  See https://developer.cloud.unity3d.com for more information.  ## Making requests This website is built to allow requests to be made against the API. If you are currently logged into Cloud Build you should be able to make requests without entering an API key.   You can find your API key in the Unity Cloud Services portal by clicking on 'Cloud Build Preferences' in the sidebar. Copy the API Key and paste it into the upper left corner of this website. It will be used in all subsequent requests.  ## Clients The Unity Cloud Build API is based upon Swagger. Client libraries to integrate with your projects can easily be generated with the [Swagger Code Generator](https://github.com/swagger-api/swagger-codegen).  The JSON schema required to generate a client for this API version is located here:  ``` [API_URL][BASE_PATH]/api.json ```  ## Authorization The Unity Cloud Build API requires an access token from your Unity Cloud Build account, which can be found at https://build.cloud.unity3d.com/login/me  To authenticate requests, include a Basic Authentication header with your API key as the value. e.g.  ``` Authorization: Basic [YOUR API KEY] ```  ## Pagination Paged results will take two parameters. A page number that is calculated based upon the per_page amount. For instance if there are 40 results and you specify page 2 with per_page set to 10 you will receive records 11-20.  Paged results will also return a Content-Range header. For the example above the content range header would look like this:  ``` Content-Range: items 11-20/40 ```  ## Versioning The API version is indicated in the request URL. Upgrading to a newer API version can be done by changing the path.  The API will receive a new version in the following cases:    * removal of a path or request type   * addition of a required field   * removal of a required field  The following changes are considered backwards compatible and will not trigger a new API version:    * addition of an endpoint or request type   * addition of an optional field   * removal of an optional field   * changes to the format of ids  ## Identifiers It should not be assumed that any of the identifiers used in paths will be a perfect match for your user-entered information. If you see unexpected 403s or 404s from API calls then check your identifiers match the ones used by the API. In particular, `projectId` does NOT typically change when the project is renamed and in fact may not be a direct match for the project name even at initial creation time.  To avoid confusion we recommend that instead of using the human-readable autogenerated orgId and projectId available from the API you should instead use:   * org foreign key for `orgId` (available from project APIs as `orgFk` and org APIs as `coreForeignKey`)   * `guid` for `projectId`  All links generated by the API and the Dashboard should follow this format already, making it easy to figure out the correct parameters by making a comparison.  ## Rate Limiting Requests against the Cloud Build API are limited to a rate of 100 per minute. To preserve the quality of service throughout Cloud Build, additional rate limits may apply to some actions. For example, polling aggressively instead of using webhooks or making API calls with a high concurrency may result in rate limiting.  It is not intended for these rate limits to interfere with any legitimate use of the API. Please contact support at <cloudbuild@unity3d.com> if your use is affected by this rate limit.  You can check the returned HTTP headers for any API request to see your current rate limit status.   * __X-RateLimit-Limit:__ maximum number of requests per minute   * __X-RateLimit-Remaining:__ remaining number of requests in the current window   * __X-RateLimit-Reset:__ time at which the current window will reset (UTC epoch seconds)  Once you go over the rate limit you will receive an error response: ``` HTTP Status: 429 {   \"error\": \"Rate limit exceeded, retry in XX seconds\" } ``` 

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.0.0
- Package version: 1.0.0
- Build package: io.swagger.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com//.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com//.git`)

Then import the package:
```python
import swagger_client 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import swagger_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import swagger_client
from swagger_client.rest import ApiException
from pprint import pprint

# Configure HTTP basic authorization: apikey
configuration = swagger_client.Configuration()
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'
# Configure OAuth2 access token for authorization: permissions
configuration = swagger_client.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = swagger_client.BuildsApi(swagger_client.ApiClient(configuration))
orgid = 'orgid_example' # str | Organization identifier
projectid = 'projectid_example' # str | Project identifier
options = swagger_client.Options8() # Options8 | Options to specify what builds to delete

try:
    # Delete artifacts for a batch of builds
    api_response = api_instance.batch_delete_build_artifacts(orgid, projectid, options)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BuildsApi->batch_delete_build_artifacts: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://localhost/api/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*BuildsApi* | [**batch_delete_build_artifacts**](docs/BuildsApi.md#batch_delete_build_artifacts) | **POST** /orgs/{orgid}/projects/{projectid}/artifacts/delete | Delete artifacts for a batch of builds
*BuildsApi* | [**cancel_all_builds**](docs/BuildsApi.md#cancel_all_builds) | **DELETE** /orgs/{orgid}/projects/{projectid}/buildtargets/{buildtargetid}/builds | Cancel all builds
*BuildsApi* | [**cancel_build**](docs/BuildsApi.md#cancel_build) | **DELETE** /orgs/{orgid}/projects/{projectid}/buildtargets/{buildtargetid}/builds/{number} | Cancel build
*BuildsApi* | [**cancel_builds_for_org**](docs/BuildsApi.md#cancel_builds_for_org) | **DELETE** /orgs/{orgid}/builds | Cancel builds for org
*BuildsApi* | [**create_share**](docs/BuildsApi.md#create_share) | **POST** /orgs/{orgid}/projects/{projectid}/buildtargets/{buildtargetid}/builds/{number}/share | Create a new link to share a project
*BuildsApi* | [**delete_all_build_artifacts**](docs/BuildsApi.md#delete_all_build_artifacts) | **DELETE** /orgs/{orgid}/projects/{projectid}/buildtargets/{buildtargetid}/builds/artifacts | Delete all artifacts associated with all non-favorited builds for a specified buildtargetid (_all is allowed).
*BuildsApi* | [**delete_build_artifacts**](docs/BuildsApi.md#delete_build_artifacts) | **DELETE** /orgs/{orgid}/projects/{projectid}/buildtargets/{buildtargetid}/builds/{number}/artifacts | Delete all artifacts associated with a specific build
*BuildsApi* | [**get_audit_log**](docs/BuildsApi.md#get_audit_log) | **GET** /orgs/{orgid}/projects/{projectid}/buildtargets/{buildtargetid}/builds/{number}/auditlog | Get audit log
*BuildsApi* | [**get_audit_log_for_build_target**](docs/BuildsApi.md#get_audit_log_for_build_target) | **GET** /orgs/{orgid}/projects/{projectid}/buildtargets/{buildtargetid}/auditlog | Get audit log
*BuildsApi* | [**get_build**](docs/BuildsApi.md#get_build) | **GET** /orgs/{orgid}/projects/{projectid}/buildtargets/{buildtargetid}/builds/{number} | Build Status
*BuildsApi* | [**get_build_log**](docs/BuildsApi.md#get_build_log) | **GET** /orgs/{orgid}/projects/{projectid}/buildtargets/{buildtargetid}/builds/{number}/log | Get build log
*BuildsApi* | [**get_build_steps**](docs/BuildsApi.md#get_build_steps) | **GET** /orgs/{orgid}/projects/{projectid}/buildtargets/{buildtargetid}/builds/{number}/steps | Get the build steps for a given build
*BuildsApi* | [**get_builds**](docs/BuildsApi.md#get_builds) | **GET** /orgs/{orgid}/projects/{projectid}/buildtargets/{buildtargetid}/builds | List all builds
*BuildsApi* | [**get_builds_for_org**](docs/BuildsApi.md#get_builds_for_org) | **GET** /orgs/{orgid}/builds | List all builds for org
*BuildsApi* | [**get_share**](docs/BuildsApi.md#get_share) | **GET** /orgs/{orgid}/projects/{projectid}/buildtargets/{buildtargetid}/builds/{number}/share | Get the share link
*BuildsApi* | [**resign_build_artifact**](docs/BuildsApi.md#resign_build_artifact) | **POST** /orgs/{orgid}/projects/{projectid}/buildtargets/{buildtargetid}/builds/{number}/resign | Re-sign a build artifact
*BuildsApi* | [**revoke_share**](docs/BuildsApi.md#revoke_share) | **DELETE** /orgs/{orgid}/projects/{projectid}/buildtargets/{buildtargetid}/builds/{number}/share | Revoke a shared link
*BuildsApi* | [**start_builds**](docs/BuildsApi.md#start_builds) | **POST** /orgs/{orgid}/projects/{projectid}/buildtargets/{buildtargetid}/builds | Create new build
*BuildsApi* | [**update_build**](docs/BuildsApi.md#update_build) | **PUT** /orgs/{orgid}/projects/{projectid}/buildtargets/{buildtargetid}/builds/{number} | Update build information
*BuildtargetsApi* | [**add_build_target**](docs/BuildtargetsApi.md#add_build_target) | **POST** /orgs/{orgid}/projects/{projectid}/buildtargets | Create build target for a project
*BuildtargetsApi* | [**delete_build_target**](docs/BuildtargetsApi.md#delete_build_target) | **DELETE** /orgs/{orgid}/projects/{projectid}/buildtargets/{buildtargetid} | Delete build target
*BuildtargetsApi* | [**get_build_target**](docs/BuildtargetsApi.md#get_build_target) | **GET** /orgs/{orgid}/projects/{projectid}/buildtargets/{buildtargetid} | Get a build target
*BuildtargetsApi* | [**get_build_targets**](docs/BuildtargetsApi.md#get_build_targets) | **GET** /orgs/{orgid}/projects/{projectid}/buildtargets | List all build targets for a project
*BuildtargetsApi* | [**get_build_targets_for_org**](docs/BuildtargetsApi.md#get_build_targets_for_org) | **GET** /orgs/{orgid}/buildtargets | List all build targets for an org
*BuildtargetsApi* | [**get_env_variables_for_build_target**](docs/BuildtargetsApi.md#get_env_variables_for_build_target) | **GET** /orgs/{orgid}/projects/{projectid}/buildtargets/{buildtargetid}/envvars | Get environment variables
*BuildtargetsApi* | [**get_stats_for_build_target**](docs/BuildtargetsApi.md#get_stats_for_build_target) | **GET** /orgs/{orgid}/projects/{projectid}/buildtargets/{buildtargetid}/stats | Get build target statistics
*BuildtargetsApi* | [**set_env_variables_for_build_target**](docs/BuildtargetsApi.md#set_env_variables_for_build_target) | **PUT** /orgs/{orgid}/projects/{projectid}/buildtargets/{buildtargetid}/envvars | Set environment variables
*BuildtargetsApi* | [**update_build_target**](docs/BuildtargetsApi.md#update_build_target) | **PUT** /orgs/{orgid}/projects/{projectid}/buildtargets/{buildtargetid} | Update build target details
*ConfigApi* | [**get_version**](docs/ConfigApi.md#get_version) | **GET** /versions/unity/{key} | Get a unity version by value
*ConfigApi* | [**list_scms_supporting_version_auto_detect**](docs/ConfigApi.md#list_scms_supporting_version_auto_detect) | **GET** /versions/auto_detect_supported_scms | List all SCM types supporting auto detecting the project Unity version
*ConfigApi* | [**list_unity_versions**](docs/ConfigApi.md#list_unity_versions) | **GET** /versions/unity | List all unity versions
*ConfigApi* | [**list_xcode_versions**](docs/ConfigApi.md#list_xcode_versions) | **GET** /versions/xcode | List all xcode versions
*CredentialsApi* | [**add_credentials_android**](docs/CredentialsApi.md#add_credentials_android) | **POST** /orgs/{orgid}/projects/{projectid}/credentials/signing/android | Upload Android Credentials
*CredentialsApi* | [**add_credentials_android_for_org**](docs/CredentialsApi.md#add_credentials_android_for_org) | **POST** /orgs/{orgid}/credentials/signing/android | Upload Android Credentials
*CredentialsApi* | [**add_credentials_ios**](docs/CredentialsApi.md#add_credentials_ios) | **POST** /orgs/{orgid}/projects/{projectid}/credentials/signing/ios | Upload iOS Credentials
*CredentialsApi* | [**add_credentials_ios_for_org**](docs/CredentialsApi.md#add_credentials_ios_for_org) | **POST** /orgs/{orgid}/credentials/signing/ios | Upload iOS Credentials for organization
*CredentialsApi* | [**add_credentials_osx**](docs/CredentialsApi.md#add_credentials_osx) | **POST** /orgs/{orgid}/projects/{projectid}/credentials/signing/osx | Upload OSX Credentials
*CredentialsApi* | [**add_credentials_osx_for_org**](docs/CredentialsApi.md#add_credentials_osx_for_org) | **POST** /orgs/{orgid}/credentials/signing/osx | Upload OSX Credentials for organization
*CredentialsApi* | [**delete_android**](docs/CredentialsApi.md#delete_android) | **DELETE** /orgs/{orgid}/projects/{projectid}/credentials/signing/android/{credentialid} | Delete Android Credentials
*CredentialsApi* | [**delete_android_for_org**](docs/CredentialsApi.md#delete_android_for_org) | **DELETE** /orgs/{orgid}/credentials/signing/android/{credentialid} | Delete Android Credentials for organization
*CredentialsApi* | [**delete_ios**](docs/CredentialsApi.md#delete_ios) | **DELETE** /orgs/{orgid}/projects/{projectid}/credentials/signing/ios/{credentialid} | Delete iOS Credentials
*CredentialsApi* | [**delete_ios_for_org**](docs/CredentialsApi.md#delete_ios_for_org) | **DELETE** /orgs/{orgid}/credentials/signing/ios/{credentialid} | Delete iOS Credentials for organization
*CredentialsApi* | [**delete_osx**](docs/CredentialsApi.md#delete_osx) | **DELETE** /orgs/{orgid}/projects/{projectid}/credentials/signing/osx/{credentialid} | Delete OSX Credentials
*CredentialsApi* | [**delete_osx_for_org**](docs/CredentialsApi.md#delete_osx_for_org) | **DELETE** /orgs/{orgid}/credentials/signing/osx/{credentialid} | Delete OSX Credentials for organization
*CredentialsApi* | [**get_all_android**](docs/CredentialsApi.md#get_all_android) | **GET** /orgs/{orgid}/projects/{projectid}/credentials/signing/android | Get All Android Credentials
*CredentialsApi* | [**get_all_android_for_org**](docs/CredentialsApi.md#get_all_android_for_org) | **GET** /orgs/{orgid}/credentials/signing/android | Get All Android Credentials for an organization
*CredentialsApi* | [**get_all_ios**](docs/CredentialsApi.md#get_all_ios) | **GET** /orgs/{orgid}/projects/{projectid}/credentials/signing/ios | Get All iOS Credentials
*CredentialsApi* | [**get_all_ios_for_org**](docs/CredentialsApi.md#get_all_ios_for_org) | **GET** /orgs/{orgid}/credentials/signing/ios | Get All iOS Credentials for an oganization
*CredentialsApi* | [**get_all_osx**](docs/CredentialsApi.md#get_all_osx) | **GET** /orgs/{orgid}/projects/{projectid}/credentials/signing/osx | Get All OSX Credentials
*CredentialsApi* | [**get_all_osx_for_org**](docs/CredentialsApi.md#get_all_osx_for_org) | **GET** /orgs/{orgid}/credentials/signing/osx | Get All OSX Credentials for an oganization
*CredentialsApi* | [**get_one_android**](docs/CredentialsApi.md#get_one_android) | **GET** /orgs/{orgid}/projects/{projectid}/credentials/signing/android/{credentialid} | Get Android Credential Details
*CredentialsApi* | [**get_one_android_for_org**](docs/CredentialsApi.md#get_one_android_for_org) | **GET** /orgs/{orgid}/credentials/signing/android/{credentialid} | Get Android Credential Details for organization
*CredentialsApi* | [**get_one_ios**](docs/CredentialsApi.md#get_one_ios) | **GET** /orgs/{orgid}/projects/{projectid}/credentials/signing/ios/{credentialid} | Get iOS Credential Details
*CredentialsApi* | [**get_one_ios_for_org**](docs/CredentialsApi.md#get_one_ios_for_org) | **GET** /orgs/{orgid}/credentials/signing/ios/{credentialid} | Get iOS Credential Details for organization
*CredentialsApi* | [**get_one_osx**](docs/CredentialsApi.md#get_one_osx) | **GET** /orgs/{orgid}/projects/{projectid}/credentials/signing/osx/{credentialid} | Get OSX Credential Details
*CredentialsApi* | [**get_one_osx_for_org**](docs/CredentialsApi.md#get_one_osx_for_org) | **GET** /orgs/{orgid}/credentials/signing/osx/{credentialid} | Get OSX Credential Details for organization
*CredentialsApi* | [**update_android**](docs/CredentialsApi.md#update_android) | **PUT** /orgs/{orgid}/projects/{projectid}/credentials/signing/android/{credentialid} | Update Android Credentials
*CredentialsApi* | [**update_android_for_org**](docs/CredentialsApi.md#update_android_for_org) | **PUT** /orgs/{orgid}/credentials/signing/android/{credentialid} | Update Android Credentials for organization
*CredentialsApi* | [**update_ios**](docs/CredentialsApi.md#update_ios) | **PUT** /orgs/{orgid}/projects/{projectid}/credentials/signing/ios/{credentialid} | Update iOS Credentials
*CredentialsApi* | [**update_ios_for_org**](docs/CredentialsApi.md#update_ios_for_org) | **PUT** /orgs/{orgid}/credentials/signing/ios/{credentialid} | Update iOS Credentials for organization
*CredentialsApi* | [**update_osx**](docs/CredentialsApi.md#update_osx) | **PUT** /orgs/{orgid}/projects/{projectid}/credentials/signing/osx/{credentialid} | Update OSX Credentials
*CredentialsApi* | [**update_osx_for_org**](docs/CredentialsApi.md#update_osx_for_org) | **PUT** /orgs/{orgid}/credentials/signing/osx/{credentialid} | Update OSX Credentials for organization
*OrgsApi* | [**get_billing_plans**](docs/OrgsApi.md#get_billing_plans) | **GET** /orgs/{orgid}/billingplan | Get billing plan
*OrgsApi* | [**get_ssh_key_for_org**](docs/OrgsApi.md#get_ssh_key_for_org) | **GET** /orgs/{orgid}/sshkey | Get SSH Key
*OrgsApi* | [**regenerate_ssh_key**](docs/OrgsApi.md#regenerate_ssh_key) | **POST** /orgs/{orgid}/sshkey | Regenerate SSH Key
*ProjectsApi* | [**add_project**](docs/ProjectsApi.md#add_project) | **POST** /orgs/{orgid}/projects | Create project
*ProjectsApi* | [**archive_project**](docs/ProjectsApi.md#archive_project) | **DELETE** /orgs/{orgid}/projects/{projectid} | Archive project
*ProjectsApi* | [**get_audit_log_for_project**](docs/ProjectsApi.md#get_audit_log_for_project) | **GET** /orgs/{orgid}/projects/{projectid}/auditlog | Get audit log
*ProjectsApi* | [**get_billing_plans_for_project**](docs/ProjectsApi.md#get_billing_plans_for_project) | **GET** /orgs/{orgid}/projects/{projectid}/billingplan | Get billing plan
*ProjectsApi* | [**get_env_variables_for_project**](docs/ProjectsApi.md#get_env_variables_for_project) | **GET** /orgs/{orgid}/projects/{projectid}/envvars | Get environment variables
*ProjectsApi* | [**get_project**](docs/ProjectsApi.md#get_project) | **GET** /orgs/{orgid}/projects/{projectid} | Get project details
*ProjectsApi* | [**get_project_by_upid**](docs/ProjectsApi.md#get_project_by_upid) | **GET** /projects/{projectupid} | Get project details
*ProjectsApi* | [**get_ssh_key_for_project**](docs/ProjectsApi.md#get_ssh_key_for_project) | **GET** /orgs/{orgid}/projects/{projectid}/sshkey | Get SSH Key
*ProjectsApi* | [**get_stats_for_project**](docs/ProjectsApi.md#get_stats_for_project) | **GET** /orgs/{orgid}/projects/{projectid}/stats | Get project statistics
*ProjectsApi* | [**list_projects_for_org**](docs/ProjectsApi.md#list_projects_for_org) | **GET** /orgs/{orgid}/projects | List all projects (org)
*ProjectsApi* | [**list_projects_for_user**](docs/ProjectsApi.md#list_projects_for_user) | **GET** /projects | List all projects (user)
*ProjectsApi* | [**set_env_variables_for_project**](docs/ProjectsApi.md#set_env_variables_for_project) | **PUT** /orgs/{orgid}/projects/{projectid}/envvars | Set environment variables
*ProjectsApi* | [**update_project**](docs/ProjectsApi.md#update_project) | **PUT** /orgs/{orgid}/projects/{projectid} | Update project details
*PublicApi* | [**get_change_logs**](docs/PublicApi.md#get_change_logs) | **GET** /changelogs | Get the Unity Cloud Build changelogs
*SharesApi* | [**get_share_metadata**](docs/SharesApi.md#get_share_metadata) | **GET** /shares/{shareid} | Get details on shared build including download link
*StatusApi* | [**get_status**](docs/StatusApi.md#get_status) | **GET** /status | Get Cloud Build Status
*UserdevicesApi* | [**create_device**](docs/UserdevicesApi.md#create_device) | **POST** /users/me/devices | Create iOS device profile
*UserdevicesApi* | [**list_devices_for_user**](docs/UserdevicesApi.md#list_devices_for_user) | **GET** /users/me/devices | List iOS device profiles
*UsersApi* | [**get_user_api_key**](docs/UsersApi.md#get_user_api_key) | **GET** /users/me/apikey | Get current user&#39;s API key
*UsersApi* | [**get_user_self**](docs/UsersApi.md#get_user_self) | **GET** /users/me | Get current user
*UsersApi* | [**regen_api_key**](docs/UsersApi.md#regen_api_key) | **POST** /users/me/apikey | Regenerate API Key
*UsersApi* | [**update_user_self**](docs/UsersApi.md#update_user_self) | **PUT** /users/me | Update current user
*WebhooksApi* | [**add_hook_for_org**](docs/WebhooksApi.md#add_hook_for_org) | **POST** /orgs/{orgid}/hooks | Add hook for organization
*WebhooksApi* | [**add_hook_for_project**](docs/WebhooksApi.md#add_hook_for_project) | **POST** /orgs/{orgid}/projects/{projectid}/hooks | Add hook for project
*WebhooksApi* | [**delete_hook_for_org**](docs/WebhooksApi.md#delete_hook_for_org) | **DELETE** /orgs/{orgid}/hooks/{id} | Delete organization hook
*WebhooksApi* | [**delete_hook_for_project**](docs/WebhooksApi.md#delete_hook_for_project) | **DELETE** /orgs/{orgid}/projects/{projectid}/hooks/{id} | Delete project hook
*WebhooksApi* | [**get_hook_for_org**](docs/WebhooksApi.md#get_hook_for_org) | **GET** /orgs/{orgid}/hooks/{id} | Get organization hook details
*WebhooksApi* | [**get_hook_for_project**](docs/WebhooksApi.md#get_hook_for_project) | **GET** /orgs/{orgid}/projects/{projectid}/hooks/{id} | Get project hook details
*WebhooksApi* | [**list_hooks_for_org**](docs/WebhooksApi.md#list_hooks_for_org) | **GET** /orgs/{orgid}/hooks | List hooks for organization
*WebhooksApi* | [**list_hooks_for_project**](docs/WebhooksApi.md#list_hooks_for_project) | **GET** /orgs/{orgid}/projects/{projectid}/hooks | List hooks for project
*WebhooksApi* | [**ping_hook_for_org**](docs/WebhooksApi.md#ping_hook_for_org) | **POST** /orgs/{orgid}/hooks/{id}/ping | Ping an org hook
*WebhooksApi* | [**ping_hook_for_project**](docs/WebhooksApi.md#ping_hook_for_project) | **POST** /orgs/{orgid}/projects/{projectid}/hooks/{id}/ping | Ping a project hook
*WebhooksApi* | [**update_hook_for_org**](docs/WebhooksApi.md#update_hook_for_org) | **PUT** /orgs/{orgid}/hooks/{id} | Update hook for organization
*WebhooksApi* | [**update_hook_for_project**](docs/WebhooksApi.md#update_hook_for_project) | **PUT** /orgs/{orgid}/projects/{projectid}/hooks/{id} | Update hook for project


## Documentation For Models

 - [InlineResponse200](docs/InlineResponse200.md)
 - [InlineResponse2001](docs/InlineResponse2001.md)
 - [InlineResponse20010](docs/InlineResponse20010.md)
 - [InlineResponse20011](docs/InlineResponse20011.md)
 - [InlineResponse20012](docs/InlineResponse20012.md)
 - [InlineResponse2002](docs/InlineResponse2002.md)
 - [InlineResponse2003](docs/InlineResponse2003.md)
 - [InlineResponse2004](docs/InlineResponse2004.md)
 - [InlineResponse2005](docs/InlineResponse2005.md)
 - [InlineResponse2006](docs/InlineResponse2006.md)
 - [InlineResponse2007](docs/InlineResponse2007.md)
 - [InlineResponse2008](docs/InlineResponse2008.md)
 - [InlineResponse2009](docs/InlineResponse2009.md)
 - [Options](docs/Options.md)
 - [Options1](docs/Options1.md)
 - [Options10](docs/Options10.md)
 - [Options2](docs/Options2.md)
 - [Options3](docs/Options3.md)
 - [Options4](docs/Options4.md)
 - [Options5](docs/Options5.md)
 - [Options6](docs/Options6.md)
 - [Options7](docs/Options7.md)
 - [Options8](docs/Options8.md)
 - [Options9](docs/Options9.md)
 - [OrgsorgidcredentialssigningandroidKeystore](docs/OrgsorgidcredentialssigningandroidKeystore.md)
 - [OrgsorgidcredentialssigningiosProvisioningProfile](docs/OrgsorgidcredentialssigningiosProvisioningProfile.md)
 - [OrgsorgidcredentialssigningosxCertificate](docs/OrgsorgidcredentialssigningosxCertificate.md)
 - [OrgsorgidprojectsprojectidartifactsdeleteBuilds](docs/OrgsorgidprojectsprojectidartifactsdeleteBuilds.md)
 - [OrgsorgidprojectsprojectidauditlogLines](docs/OrgsorgidprojectsprojectidauditlogLines.md)
 - [OrgsorgidprojectsprojectidbuildtargetsBuildReport](docs/OrgsorgidprojectsprojectidbuildtargetsBuildReport.md)
 - [OrgsorgidprojectsprojectidbuildtargetsBuilds](docs/OrgsorgidprojectsprojectidbuildtargetsBuilds.md)
 - [OrgsorgidprojectsprojectidbuildtargetsCredentials](docs/OrgsorgidprojectsprojectidbuildtargetsCredentials.md)
 - [OrgsorgidprojectsprojectidbuildtargetsCredentials1](docs/OrgsorgidprojectsprojectidbuildtargetsCredentials1.md)
 - [OrgsorgidprojectsprojectidbuildtargetsCredentials1Signing](docs/OrgsorgidprojectsprojectidbuildtargetsCredentials1Signing.md)
 - [OrgsorgidprojectsprojectidbuildtargetsCredentialsSigning](docs/OrgsorgidprojectsprojectidbuildtargetsCredentialsSigning.md)
 - [OrgsorgidprojectsprojectidbuildtargetsCredentialsSigningCredentialResourceRef](docs/OrgsorgidprojectsprojectidbuildtargetsCredentialsSigningCredentialResourceRef.md)
 - [OrgsorgidprojectsprojectidbuildtargetsCredentialsSigningCredentialResourceRefCertificate](docs/OrgsorgidprojectsprojectidbuildtargetsCredentialsSigningCredentialResourceRefCertificate.md)
 - [OrgsorgidprojectsprojectidbuildtargetsCredentialsSigningCredentialResourceRefKeystore](docs/OrgsorgidprojectsprojectidbuildtargetsCredentialsSigningCredentialResourceRefKeystore.md)
 - [OrgsorgidprojectsprojectidbuildtargetsCredentialsSigningCredentialResourceRefProvisioningProfile](docs/OrgsorgidprojectsprojectidbuildtargetsCredentialsSigningCredentialResourceRefProvisioningProfile.md)
 - [OrgsorgidprojectsprojectidbuildtargetsFailureDetails](docs/OrgsorgidprojectsprojectidbuildtargetsFailureDetails.md)
 - [OrgsorgidprojectsprojectidbuildtargetsLastBuilt](docs/OrgsorgidprojectsprojectidbuildtargetsLastBuilt.md)
 - [OrgsorgidprojectsprojectidbuildtargetsLinks](docs/OrgsorgidprojectsprojectidbuildtargetsLinks.md)
 - [OrgsorgidprojectsprojectidbuildtargetsProjectVersion](docs/OrgsorgidprojectsprojectidbuildtargetsProjectVersion.md)
 - [OrgsorgidprojectsprojectidbuildtargetsSettings](docs/OrgsorgidprojectsprojectidbuildtargetsSettings.md)
 - [OrgsorgidprojectsprojectidbuildtargetsSettingsAdvanced](docs/OrgsorgidprojectsprojectidbuildtargetsSettingsAdvanced.md)
 - [OrgsorgidprojectsprojectidbuildtargetsSettingsAdvancedAndroid](docs/OrgsorgidprojectsprojectidbuildtargetsSettingsAdvancedAndroid.md)
 - [OrgsorgidprojectsprojectidbuildtargetsSettingsAdvancedUnity](docs/OrgsorgidprojectsprojectidbuildtargetsSettingsAdvancedUnity.md)
 - [OrgsorgidprojectsprojectidbuildtargetsSettingsAdvancedUnityAddressables](docs/OrgsorgidprojectsprojectidbuildtargetsSettingsAdvancedUnityAddressables.md)
 - [OrgsorgidprojectsprojectidbuildtargetsSettingsAdvancedUnityAddressablesContentUpdateSettings](docs/OrgsorgidprojectsprojectidbuildtargetsSettingsAdvancedUnityAddressablesContentUpdateSettings.md)
 - [OrgsorgidprojectsprojectidbuildtargetsSettingsAdvancedUnityAssetBundles](docs/OrgsorgidprojectsprojectidbuildtargetsSettingsAdvancedUnityAssetBundles.md)
 - [OrgsorgidprojectsprojectidbuildtargetsSettingsAdvancedUnityEditorUserBuildSettings](docs/OrgsorgidprojectsprojectidbuildtargetsSettingsAdvancedUnityEditorUserBuildSettings.md)
 - [OrgsorgidprojectsprojectidbuildtargetsSettingsAdvancedUnityPlayerExporter](docs/OrgsorgidprojectsprojectidbuildtargetsSettingsAdvancedUnityPlayerExporter.md)
 - [OrgsorgidprojectsprojectidbuildtargetsSettingsAdvancedUnityPlayerSettings](docs/OrgsorgidprojectsprojectidbuildtargetsSettingsAdvancedUnityPlayerSettings.md)
 - [OrgsorgidprojectsprojectidbuildtargetsSettingsAdvancedUnityPlayerSettingsAndroid](docs/OrgsorgidprojectsprojectidbuildtargetsSettingsAdvancedUnityPlayerSettingsAndroid.md)
 - [OrgsorgidprojectsprojectidbuildtargetsSettingsAdvancedXcode](docs/OrgsorgidprojectsprojectidbuildtargetsSettingsAdvancedXcode.md)
 - [OrgsorgidprojectsprojectidbuildtargetsSettingsPlatform](docs/OrgsorgidprojectsprojectidbuildtargetsSettingsPlatform.md)
 - [OrgsorgidprojectsprojectidbuildtargetsSettingsScm](docs/OrgsorgidprojectsprojectidbuildtargetsSettingsScm.md)
 - [OrgsorgidprojectsprojectidbuildtargetsTestResults](docs/OrgsorgidprojectsprojectidbuildtargetsTestResults.md)
 - [OrgsorgidprojectsprojectidbuildtargetsbuildtargetidbuildsnumberstepsMessages](docs/OrgsorgidprojectsprojectidbuildtargetsbuildtargetidbuildsnumberstepsMessages.md)


## Documentation For Authorization


## apikey

- **Type**: HTTP basic authentication

## filetoken

- **Type**: HTTP basic authentication

## permissions

- **Type**: OAuth
- **Flow**: implicit
- **Authorization URL**: https://build.cloud.unity3d.com/login/
- **Scopes**: 
 - **org:user**: must have at least user permissions in the organization
 - **org:manager**: must have at least manager permissions in the organization
 - **project:user**: must have at least user permissions in the project
 - **project:manager**: must have at least manager permissions in the project
 - **admin**: administrative privileges
 - **admin_readstats**: administrative read stats privileges


## Author



