# -*- coding: utf-8 -*-

# imprint: a program for creating documents from data and content templates
#
# Copyright (C) 2019  Joseph R. Fox-Rabinovitz <jfoxrabinovitz at gmail dot com>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.

# Author: Joseph Fox-Rabinovitz <jfoxrabinovitz at gmail dot com>
# Version: 13 Apr 2019: Initial Coding


""" Configuration file for the Sphinx documentation builder. """

# -- Path setup --------------------------------------------------------------

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
import os
import sys
sys.path.insert(0, os.path.abspath('../src'))


# -- Project information -----------------------------------------------------

project = 'Imprint'
copyright = '2019, Joseph R. Fox-Rabinovitz'
author = 'Joseph R. Fox-Rabinovitz <jfoxrabinovitz at gmail dot com>'

from imprint.version import __version__
# The short X.Y version
version = '.'.join(__version__.split('.')[:2])
# The full version, including alpha/beta/rc tags
release = __version__


# -- General configuration ---------------------------------------------------

# Minimal Sphinx version requirement.
#
needs_sphinx = '1.7.1'

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    'sphinx.ext.autodoc',
    'sphinx.ext.doctest',
    'sphinx.ext.intersphinx',
    'sphinx.ext.todo',
    'sphinx.ext.imgmath',
    'sphinx.ext.napoleon'
]

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
#
# source_suffix = ['.rst', '.md']
source_suffix = '.rst'

# The master toctree document.
master_doc = 'index'

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = None

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = ['_build', '_src', '_intersphinx', 'Thumbs.db', '.DS_Store']

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'sphinx'


# -- Options for HTML output -------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
try:
    import sphinx_rtd_theme
except ImportError:
    html_theme = 'alabaster'
else:
    html_theme = 'sphinx_rtd_theme'

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
#
# html_theme_options = {}

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static', 'demos']

# Custom sidebar templates, must be a dictionary that maps document names
# to template names.
#
# The default sidebars (for documents that don't match any pattern) are
# defined by theme itself.  Builtin themes are using these templates by
# default: ``['localtoc.html', 'relations.html', 'sourcelink.html',
# 'searchbox.html']``.
#
# html_sidebars = {}


# -- Options for HTMLHelp output ---------------------------------------------

# Output file base name for HTML help builder.
htmlhelp_basename = 'ImprintDoc'


# -- Options for LaTeX output ------------------------------------------------

latex_elements = {
    # The paper size ('letterpaper' or 'a4paper').
    #
    # 'papersize': 'letterpaper',

    # The font size ('10pt', '11pt' or '12pt').
    #
    # 'pointsize': '10pt',

    # Additional stuff for the LaTeX preamble.
    #
    # 'preamble': '',

    # Latex figure (float) alignment
    #
    # 'figure_align': 'htbp',
}

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title,
#  author, documentclass [howto, manual, or own class]).
latex_documents = [
    (master_doc, 'Imprint.tex', 'Imprint Documentation',
     'Joseph R. Fox-Rabinovitz', 'manual'),
]


# -- Options for manual page output ------------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [
    (master_doc, 'imprint', 'Imprint Documentation',
     [author], 1)
]


# -- Options for Texinfo output ----------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
    (master_doc, 'Imprint', 'Imprint Documentation',
     author, 'Imprint', 'MS Word Document Generator',
     'Miscellaneous'),
]


# -- Extension configuration -------------------------------------------------

# -- Options for intersphinx extension ---------------------------------------

# Intersphinx configuration: attempt to download object listings from the
# official documentations, use a (possibly outdated) local backup if that fails.
intersphinx_mapping = {
    'docx': (
        'https://python-docx.readthedocs.io/en/latest/',
        (None, '_intersphinx/docx.inv')
    ),
    'haggis': (
        'https://haggis.readthedocs.io/en/latest/',
        (None, '_intersphinx/haggis.inv')
    ),
    'matplotlib': (
        'https://matplotlib.org/',
        (None, '_intersphinx/matplotlib.inv')
    ),
    'openpyxl': (
        'https://openpyxl.readthedocs.io/en/stable/',
        (None, 'openpyxl.inv')
    ),
    'pandas': (
        'http://pandas.pydata.org/pandas-docs/stable/',
        (None, '_intersphinx/pandas.inv')
    ),
    'python': (
        'https://docs.python.org/3/',
        (None, '_intersphinx/python.inv')
    ),
}

# -- Options for todo extension ----------------------------------------------

# If true, `todo` and `todoList` produce output, else they produce nothing.
todo_include_todos = True

# Suppress trailing parentheses
add_function_parentheses = False


import collections, pathlib, zipfile
import haggis.load, haggis.os

def update_zips():
    config_ext = ('.ipc', '.idc', '.iif', '.xml', '.docx')
    content_ext = ('.jpg', '.png', '.csv')

    root = pathlib.Path('demos')
    for folder in root.iterdir():
        if not folder.is_dir():
            continue
        try:
            config_file = next(folder.glob('*.ipc'))
        except StopIteration:
            continue

        with haggis.os.chdir_context(folder):
            config = haggis.load.module_as_dict(
                config_file.name, name='config', include_var='includes'
            )

        output_docx = (folder / config.get('output_docx', '')).resolve()
        dstack = collections.deque([folder])
        with zipfile.ZipFile(folder.with_suffix('.zip'), 'w',
                             zipfile.ZIP_DEFLATED) as zf:
            while dstack:
                directory = dstack.popleft()
                for path in directory.iterdir():
                    if path.name.startswith('.') or path.name.startswith('__'):
                        continue
                    if path.is_dir():
                        dstack.append(path)
                        continue
                    if path.resolve() == output_docx:
                        continue
                    if path.suffix in content_ext:
                        if not path.relative_to(folder).parent.name:
                            continue
                    elif path.suffix not in config_ext:
                        continue
                    zf.write(path, path.relative_to(root))


update_zips()
del update_zips
