import logging
from _typeshed import Incomplete
from arelle import ModelManager as ModelManager, PackageManager as PackageManager, PluginManager as PluginManager
from arelle.Locale import getLanguageCodes as getLanguageCodes, setDisableRTL as setDisableRTL
from arelle.ModelXbrl import ModelXbrl as ModelXbrl
from arelle.WebCache import WebCache as WebCache
from arelle.typing import TypeGetText as TypeGetText
from typing import Any, TextIO

osPrcs: Incomplete
LOG_TEXT_MAX_LENGTH: int
cxFrozen: Incomplete

def resourcesDir() -> str: ...

class Cntlr:
    hasWin32gui: bool
    hasGui: bool
    hasFileSystem: bool
    isGAE: bool
    isCGI: bool
    systemWordSize: int
    uiLang: str
    uiLangDir: str
    updateURL: Union[str, None]
    configDir: str
    imagesDir: str
    localeDir: str
    pluginDir: str
    userAppDir: str
    isMac: bool
    isMSW: bool
    hasClipboard: bool
    contextMenuClick: str
    hasWebServer: bool
    config: Union[dict[str, Any], None]
    configJsonFile: str
    webCache: WebCache
    modelManager: ModelManager.ModelManager
    logger: Union[logging.Logger, None]
    logHandler: logging.Handler
    def __init__(self, hasGui: bool = ..., logFileName: Union[str, None] = ..., logFileMode: Union[str, None] = ..., logFileEncoding: Union[str, None] = ..., logFormat: Union[str, None] = ...) -> None: ...
    def setUiLanguage(self, lang: str, fallbackToDefault: bool = ...) -> None: ...
    def startLogging(self, logFileName: Union[str, None] = ..., logFileMode: Union[str, None] = ..., logFileEncoding: Union[str, None] = ..., logFormat: Union[str, None] = ..., logLevel: Union[str, None] = ..., logHandler: Union[logging.Handler, None] = ..., logToBuffer: bool = ..., logTextMaxLength: Union[int, None] = ..., logRefObjectProperties: bool = ...) -> None: ...
    def setLogLevelFilter(self, logLevelFilter: str) -> None: ...
    def setLogCodeFilter(self, logCodeFilter: str) -> None: ...
    def addToLog(self, message: str, messageCode: str = ..., messageArgs: Union[dict[str, Any], None] = ..., file: str = ..., refs: Union[list[dict[str, Any]], None] = ..., level: Union[int, str] = ...) -> None: ...
    def showStatus(self, message: str, clearAfter: Union[int, None] = ...) -> None: ...
    def close(self, saveConfig: bool = ...) -> None: ...
    def saveConfig(self) -> None: ...
    def viewModelObject(self, modelXbrl: ModelXbrl, objectId: str) -> None: ...
    def reloadViews(self, modelXbrl: ModelXbrl) -> None: ...
    def rssWatchUpdateOption(self, **args: Any) -> None: ...
    def onPackageEnablementChanged(self) -> None: ...
    def internet_user_password(self, host: str, realm: str) -> tuple[str, str]: ...
    def internet_logon(self, url: str, quotedUrl: str, dialogCaption: str, dialogText: str) -> str: ...
    def clipboardData(self, text: Union[str, None] = ...) -> Any: ...
    @property
    def memoryUsed(self) -> Union[float, None]: ...

def logRefsFileLines(refs: list[dict[str, Any]]) -> str: ...

class LogFormatter(logging.Formatter):
    def __init__(self, fmt: Union[str, None] = ..., datefmt: Union[str, None] = ...) -> None: ...
    def fileLines(self, record: logging.LogRecord) -> str: ...
    def format(self, record: logging.LogRecord) -> str: ...

class LogToPrintHandler(logging.Handler):
    logFile: Union[str, TextIO, None]
    def __init__(self, logOutput: str) -> None: ...
    def emit(self, logRecord: logging.LogRecord) -> None: ...

class LogHandlerWithXml(logging.Handler):
    logTextMaxLength: int
    def __init__(self) -> None: ...
    def recordToXml(self, logRec: logging.LogRecord) -> str: ...
    def recordToJson(self, logRec: logging.LogRecord) -> dict[str, Any]: ...

class LogToXmlHandler(LogHandlerWithXml):
    logRecordBuffer: list[logging.LogRecord]
    filename: Union[str, None]
    filemode: str
    def __init__(self, filename: Union[str, None] = ..., mode: str = ...) -> None: ...
    def flush(self) -> None: ...
    def clearLogBuffer(self) -> None: ...
    def getXml(self, clearLogBuffer: bool = ...) -> str: ...
    def getJson(self, clearLogBuffer: bool = ...) -> str: ...
    def getLines(self, clearLogBuffer: bool = ...) -> list[str]: ...
    def getText(self, separator: str = ..., clearLogBuffer: bool = ...) -> str: ...
    def emit(self, logRecord: logging.LogRecord) -> None: ...

class LogToBufferHandler(LogToXmlHandler):
    def __init__(self) -> None: ...
    def flush(self) -> None: ...
