#pragma once
/**********************************************************
 *					Dfinition de la page de garde DOxygen
 **********************************************************/
/**
 * \mainpage Implementation de l'algorithme de compression de RICE du projet DESIR
 * \image html logo.jpg
 * \section Info Informations
 * \author Loc Gueguen
 * \version 1.0
 * \date
 * \section Description Description de la bibliothque
 * Bibliothque de compression et de dcompression base sur l'agorithme de RICE du CCSDS (SZIP)
 * L'algorithme est adapt aux spcficits du projet DESIR,  savoir:
 *	- Les pixels sont cods sur 16 bits
 *	- Le nombre de pixels est un multiple de 16
 */

/**********************************************************
 *					Dfinition des sections DOxygen
 **********************************************************/
/**
 * \defgroup Exposed  Fonctions et types exposs dans la DLL
 * \defgroup NotExposed  Fonctions et types non exposs dans la DLL
 * \defgroup NotExposedCompressor  Fonctions et variables lies  la compression
			* \ingroup NotExposed
 * \defgroup NotExposedUncompressor Fonctions et variables lies  la decompression
			* \ingroup NotExposed
 * \defgroup Constantes  Constantes et macros prdfinies
 */


/**
 * \ingroup Exposed
* @{
*/
#include "GsrPreprocessMode.h"

int postprocessor(unsigned int* data,int nbInput,unsigned short* postProcessed,PreprocessMode mode);
/**
 * \brief Fonction effectuant la decompression d'un bloc de donnes
 * \param compressed Tableau en entre contenant les donnes compresses
 * \param compressedLen Taille du tableau en entre
 * \param data Tableau de retour pour les donnes dcompresses.
 * \param nbInput Taille du tableau
 * \return nombre d'octets dcompresss ou -1 en cas d'erreur
 */
int uncompress(unsigned char* compressed,int compressedLen,unsigned int* data,int nbInput);
/**@}*/ // End of group Exposed
