from .dtypes import (
    BorderSide as BorderSide,
    BorderSolid as BorderSolid,
    BorderStyle as BorderStyle,
    UserEnteredFmt as UserEnteredFmt,
)
from pathlib import Path
from typing import Any, Dict, Iterator, Mapping, Optional, Tuple, TypeVar, Union

DEFAULT_TOKEN: str
DEFAULT_CREDS: str
_T = TypeVar("_T")

class ParseRangeError(Exception):
    def __init__(
        self, rng: str, msg_addon: Union[str, None] = ..., *args: object
    ) -> None: ...

class AuthConfig:
    secrets_config: Any = ...
    _token_filepath: Any = ...
    _creds_filepath: Any = ...
    def __init__(
        self,
        secrets_config: Union[Dict[str, Any], None] = ...,
        token_filepath: Union[str, Path] = ...,
        creds_filepath: Union[str, Path] = ...,
    ) -> None: ...
    @property
    def token_filepath(self) -> Path: ...
    @property
    def creds_filepath(self) -> Path: ...

class _Interface(Mapping[str, _T]):
    def to_dict(self) -> Dict[str, _T]: ...
    def __iter__(self) -> Iterator[str]: ...
    def __getitem__(self, k: str) -> _T: ...
    def __len__(self) -> int: ...

class _RangeInterface(_Interface[int]):
    tab_title: Any = ...
    def __init__(self, tab_title: Union[str, None] = ...) -> None: ...
    def to_dict(self) -> Dict[str, int]: ...
    @classmethod
    def _construct_range_str(
        cls: Any,
        start_row: int = ...,
        start_col: int = ...,
        end_row: Optional[int] = ...,
        end_col: Optional[int] = ...,
    ) -> str: ...
    @staticmethod
    def _parse_range_str(rng: str) -> Tuple[Optional[str], str, Optional[str]]: ...
    @staticmethod
    def _parse_cell_str(cell_str: str) -> Tuple[str, Optional[str]]: ...
    @classmethod
    def _convert_cell_str_to_coord(
        cls: Any, cell_str: str
    ) -> Tuple[int, Optional[int]]: ...
    @staticmethod
    def _convert_alpha_col_to_idx(alpha_col: str) -> int: ...
    @staticmethod
    def _convert_col_idx_to_alpha(idx: int) -> str: ...
    @classmethod
    def _parse_idx(cls: Any, idx: Union[str, int], base0_idxs: bool = ...) -> int: ...

class HalfRange(_RangeInterface):
    start_idx: Any = ...
    end_idx: Any = ...
    column: Any = ...
    def __init__(
        self,
        start_idx: Union[str, int, None] = ...,
        end_idx: Union[str, int, None] = ...,
        *,
        tab_title: Union[str, None] = ...,
        base0_idxs: bool = ...,
        column: bool = ...
    ) -> None: ...
    def to_dict(self) -> Dict[str, int]: ...
    def __str__(self) -> str: ...

class FullRange(_RangeInterface):
    _single_cell: bool = ...
    tab_title: Any = ...
    start_row: Any = ...
    end_row: Any = ...
    start_col: Any = ...
    end_col: Any = ...
    def __init__(
        self,
        range_str: Union[str, None] = ...,
        *,
        start_row: Union[int, None] = ...,
        end_row: Union[int, None] = ...,
        start_col: Union[int, str, None] = ...,
        end_col: Union[int, str, None] = ...,
        base0_idxs: bool = ...,
        tab_title: Union[str, None] = ...
    ) -> None: ...
    @property
    def row_range(self) -> HalfRange: ...
    @property
    def col_range(self) -> HalfRange: ...
    def __str__(self) -> str: ...
    def to_dict(self) -> Dict[str, int]: ...

class BorderFormat(_Interface[Any]):
    side: Any = ...
    color: Any = ...
    style: Any = ...
    def __init__(
        self,
        side: BorderSide,
        color: Union[Color, None] = ...,
        style: Union[BorderStyle, None] = ...,
    ) -> None: ...
    def to_dict(self) -> Dict[str, Any]: ...

class Color(_Interface[float]):
    red: Any = ...
    green: Any = ...
    blue: Any = ...
    alpha: Any = ...
    def __init__(
        self,
        red: Union[int, float] = ...,
        green: Union[int, float] = ...,
        blue: Union[int, float] = ...,
        alpha: Union[int, float] = ...,
    ) -> None: ...
    @staticmethod
    def _ensure_valid_input(input: Union[int, float], intmax: int = ...) -> float: ...
    def to_dict(self) -> Dict[str, float]: ...
    @classmethod
    def from_hex(cls: Any, hex_code: str, alpha: Union[int, float] = ...) -> Color: ...

class Format(_Interface[Any]):
    _format_key: Any = ...
    def __init__(self, format_key: str) -> None: ...
    @property
    def format_key(self) -> str: ...
    def __str__(self) -> str: ...
    def _fmt_contents(self) -> Dict[str, Any]: ...
    def to_dict(self) -> Dict[str, Any]: ...

class TextFormat(Format):
    font: Any = ...
    color: Any = ...
    font_size: Any = ...
    bold: Any = ...
    italic: Any = ...
    underline: Any = ...
    strikethrough: Any = ...
    def __init__(
        self,
        *,
        font: Union[str, None] = ...,
        color: Union[Color, None] = ...,
        font_size: Union[int, None] = ...,
        bold: Union[bool, None] = ...,
        italic: Union[bool, None] = ...,
        underline: Union[bool, None] = ...,
        strikethrough: Union[bool, None] = ...
    ) -> None: ...
    def _fmt_contents(self) -> Dict[str, Union[bool, str, int, Dict[str, float]]]: ...

class NumericFormat(Format):
    type: str = ...
    pattern: Any = ...
    def __init__(self, pattern: str = ...) -> None: ...
    def _fmt_contents(self) -> Dict[str, str]: ...

AutomaticFormat: Any
NumberFormat: Any
AccountingFormat: Any
PercentFormat: Any
ScientificFormat: Any
FinancialFormat: Any
CurrencyFormat: Any
CurRoundFormat: Any
DateFormat: Any
TimeFormat: Any
DatetimeFormat: Any
DurationFormat: Any
