from .connection import (
    AuthConfig as AuthConfig,
    DriveConnection as DriveConnection,
    FileUpload as FileUpload,
    SheetsConnection as SheetsConnection,
)
from .gsheet import GSheet as GSheet
from pathlib import Path
from typing import Any, Dict, List, Optional, Union

class Folder:
    _id: Any = ...
    _name: Any = ...
    _parents: Any = ...
    _conn: Any = ...
    _sheets_conn: Any = ...
    def __init__(
        self,
        folder_id: str,
        name: str,
        *,
        parents: Union[List[str], None] = ...,
        auth_config: Union[AuthConfig, None] = ...,
        drive_conn: Union[DriveConnection, None] = ...,
        sheets_conn: Union[SheetsConnection, None] = ...
    ) -> None: ...
    @property
    def id(self) -> str: ...
    @property
    def name(self) -> str: ...
    @property
    def parent_ids(self) -> List[str]: ...
    def create_folder(self, folder_name: str) -> Folder: ...
    def create_gsheet(self, gsheet_name: str) -> GSheet: ...
    def upload_files(
        self, *filepaths: Union[Path, str, FileUpload]
    ) -> Dict[str, str]: ...

class Drive:
    _conn: Any = ...
    _sheets_conn: Any = ...
    def __init__(
        self,
        *,
        auth_config: Union[AuthConfig, None] = ...,
        drive_conn: Union[DriveConnection, None] = ...,
        sheets_conn: Union[SheetsConnection, None] = ...
    ) -> None: ...
    def create_folder(
        self, folder_name: str, parent: Union[str, Folder, None] = ...
    ) -> Folder: ...
    def create_gsheet(
        self, gsheet_name: str, parent: Union[str, Folder, None] = ...
    ) -> GSheet: ...
    def find_gsheet(self, gsheet_name: str) -> List[GSheet]: ...
    def find_folder(
        self, folder_name: str, shared_drive_id: Union[str, None] = ...
    ) -> List[Folder]: ...
    def upload_files(
        self, *filepaths: Union[Path, str, FileUpload]
    ) -> Dict[str, str]: ...
    @staticmethod
    def _ensure_parent_id(parent: Union[str, Folder, None] = ...) -> Optional[str]: ...
