# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TransitGatewayPeeringArgs', 'TransitGatewayPeering']

@pulumi.input_type
class TransitGatewayPeeringArgs:
    def __init__(__self__, *,
                 core_network_id: pulumi.Input[str],
                 transit_gateway_arn: pulumi.Input[str],
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['TransitGatewayPeeringTagArgs']]]] = None):
        """
        The set of arguments for constructing a TransitGatewayPeering resource.
        :param pulumi.Input[str] core_network_id: The Id of the core network that you want to peer a transit gateway to.
        :param pulumi.Input[str] transit_gateway_arn: The ARN (Amazon Resource Name) of the transit gateway that you will peer to a core network
        :param pulumi.Input[Sequence[pulumi.Input['TransitGatewayPeeringTagArgs']]] tags: An array of key-value pairs to apply to this resource.
        """
        pulumi.set(__self__, "core_network_id", core_network_id)
        pulumi.set(__self__, "transit_gateway_arn", transit_gateway_arn)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="coreNetworkId")
    def core_network_id(self) -> pulumi.Input[str]:
        """
        The Id of the core network that you want to peer a transit gateway to.
        """
        return pulumi.get(self, "core_network_id")

    @core_network_id.setter
    def core_network_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "core_network_id", value)

    @property
    @pulumi.getter(name="transitGatewayArn")
    def transit_gateway_arn(self) -> pulumi.Input[str]:
        """
        The ARN (Amazon Resource Name) of the transit gateway that you will peer to a core network
        """
        return pulumi.get(self, "transit_gateway_arn")

    @transit_gateway_arn.setter
    def transit_gateway_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "transit_gateway_arn", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TransitGatewayPeeringTagArgs']]]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TransitGatewayPeeringTagArgs']]]]):
        pulumi.set(self, "tags", value)


class TransitGatewayPeering(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 core_network_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TransitGatewayPeeringTagArgs']]]]] = None,
                 transit_gateway_arn: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        AWS::NetworkManager::TransitGatewayPeering Resoruce Type.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] core_network_id: The Id of the core network that you want to peer a transit gateway to.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TransitGatewayPeeringTagArgs']]]] tags: An array of key-value pairs to apply to this resource.
        :param pulumi.Input[str] transit_gateway_arn: The ARN (Amazon Resource Name) of the transit gateway that you will peer to a core network
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TransitGatewayPeeringArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        AWS::NetworkManager::TransitGatewayPeering Resoruce Type.

        :param str resource_name: The name of the resource.
        :param TransitGatewayPeeringArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TransitGatewayPeeringArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 core_network_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TransitGatewayPeeringTagArgs']]]]] = None,
                 transit_gateway_arn: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TransitGatewayPeeringArgs.__new__(TransitGatewayPeeringArgs)

            if core_network_id is None and not opts.urn:
                raise TypeError("Missing required property 'core_network_id'")
            __props__.__dict__["core_network_id"] = core_network_id
            __props__.__dict__["tags"] = tags
            if transit_gateway_arn is None and not opts.urn:
                raise TypeError("Missing required property 'transit_gateway_arn'")
            __props__.__dict__["transit_gateway_arn"] = transit_gateway_arn
            __props__.__dict__["core_network_arn"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["edge_location"] = None
            __props__.__dict__["owner_account_id"] = None
            __props__.__dict__["peering_id"] = None
            __props__.__dict__["peering_type"] = None
            __props__.__dict__["resource_arn"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["transit_gateway_peering_attachment_id"] = None
        super(TransitGatewayPeering, __self__).__init__(
            'aws-native:networkmanager:TransitGatewayPeering',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'TransitGatewayPeering':
        """
        Get an existing TransitGatewayPeering resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = TransitGatewayPeeringArgs.__new__(TransitGatewayPeeringArgs)

        __props__.__dict__["core_network_arn"] = None
        __props__.__dict__["core_network_id"] = None
        __props__.__dict__["created_at"] = None
        __props__.__dict__["edge_location"] = None
        __props__.__dict__["owner_account_id"] = None
        __props__.__dict__["peering_id"] = None
        __props__.__dict__["peering_type"] = None
        __props__.__dict__["resource_arn"] = None
        __props__.__dict__["state"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["transit_gateway_arn"] = None
        __props__.__dict__["transit_gateway_peering_attachment_id"] = None
        return TransitGatewayPeering(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="coreNetworkArn")
    def core_network_arn(self) -> pulumi.Output[str]:
        """
        The ARN (Amazon Resource Name) of the core network that you want to peer a transit gateway to.
        """
        return pulumi.get(self, "core_network_arn")

    @property
    @pulumi.getter(name="coreNetworkId")
    def core_network_id(self) -> pulumi.Output[str]:
        """
        The Id of the core network that you want to peer a transit gateway to.
        """
        return pulumi.get(self, "core_network_id")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        The creation time of the transit gateway peering
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="edgeLocation")
    def edge_location(self) -> pulumi.Output[str]:
        """
        The location of the transit gateway peering
        """
        return pulumi.get(self, "edge_location")

    @property
    @pulumi.getter(name="ownerAccountId")
    def owner_account_id(self) -> pulumi.Output[str]:
        """
        Peering owner account Id
        """
        return pulumi.get(self, "owner_account_id")

    @property
    @pulumi.getter(name="peeringId")
    def peering_id(self) -> pulumi.Output[str]:
        """
        The Id of the transit gateway peering
        """
        return pulumi.get(self, "peering_id")

    @property
    @pulumi.getter(name="peeringType")
    def peering_type(self) -> pulumi.Output[str]:
        """
        Peering type (TransitGatewayPeering)
        """
        return pulumi.get(self, "peering_type")

    @property
    @pulumi.getter(name="resourceArn")
    def resource_arn(self) -> pulumi.Output[str]:
        """
        The ARN (Amazon Resource Name) of the resource that you will peer to a core network
        """
        return pulumi.get(self, "resource_arn")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The state of the transit gateway peering
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.TransitGatewayPeeringTag']]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="transitGatewayArn")
    def transit_gateway_arn(self) -> pulumi.Output[str]:
        """
        The ARN (Amazon Resource Name) of the transit gateway that you will peer to a core network
        """
        return pulumi.get(self, "transit_gateway_arn")

    @property
    @pulumi.getter(name="transitGatewayPeeringAttachmentId")
    def transit_gateway_peering_attachment_id(self) -> pulumi.Output[str]:
        """
        The ID of the TransitGatewayPeeringAttachment
        """
        return pulumi.get(self, "transit_gateway_peering_attachment_id")

