# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['DataRepositoryAssociationArgs', 'DataRepositoryAssociation']

@pulumi.input_type
class DataRepositoryAssociationArgs:
    def __init__(__self__, *,
                 data_repository_path: pulumi.Input[str],
                 file_system_id: pulumi.Input[str],
                 file_system_path: pulumi.Input[str],
                 batch_import_meta_data_on_create: Optional[pulumi.Input[bool]] = None,
                 imported_file_chunk_size: Optional[pulumi.Input[int]] = None,
                 s3: Optional[pulumi.Input['DataRepositoryAssociationS3Args']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['DataRepositoryAssociationTagArgs']]]] = None):
        """
        The set of arguments for constructing a DataRepositoryAssociation resource.
        :param pulumi.Input[str] data_repository_path: The path to the Amazon S3 data repository that will be linked to the file system. The path can be an S3 bucket or prefix in the format s3://myBucket/myPrefix/ . This path specifies where in the S3 data repository files will be imported from or exported to.
        :param pulumi.Input[str] file_system_id: The globally unique ID of the file system, assigned by Amazon FSx.
        :param pulumi.Input[str] file_system_path: This path specifies where in your file system files will be exported from or imported to. This file system directory can be linked to only one Amazon S3 bucket, and no other S3 bucket can be linked to the directory.
        :param pulumi.Input[bool] batch_import_meta_data_on_create: A boolean flag indicating whether an import data repository task to import metadata should run after the data repository association is created. The task runs if this flag is set to true.
        :param pulumi.Input[int] imported_file_chunk_size: For files imported from a data repository, this value determines the stripe count and maximum amount of data per file (in MiB) stored on a single physical disk. The maximum number of disks that a single file can be striped across is limited by the total number of disks that make up the file system.
        :param pulumi.Input['DataRepositoryAssociationS3Args'] s3: The configuration for an Amazon S3 data repository linked to an Amazon FSx Lustre file system with a data repository association. The configuration defines which file events (new, changed, or deleted files or directories) are automatically imported from the linked data repository to the file system or automatically exported from the file system to the data repository.
        :param pulumi.Input[Sequence[pulumi.Input['DataRepositoryAssociationTagArgs']]] tags: A list of Tag values, with a maximum of 50 elements.
        """
        pulumi.set(__self__, "data_repository_path", data_repository_path)
        pulumi.set(__self__, "file_system_id", file_system_id)
        pulumi.set(__self__, "file_system_path", file_system_path)
        if batch_import_meta_data_on_create is not None:
            pulumi.set(__self__, "batch_import_meta_data_on_create", batch_import_meta_data_on_create)
        if imported_file_chunk_size is not None:
            pulumi.set(__self__, "imported_file_chunk_size", imported_file_chunk_size)
        if s3 is not None:
            pulumi.set(__self__, "s3", s3)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="dataRepositoryPath")
    def data_repository_path(self) -> pulumi.Input[str]:
        """
        The path to the Amazon S3 data repository that will be linked to the file system. The path can be an S3 bucket or prefix in the format s3://myBucket/myPrefix/ . This path specifies where in the S3 data repository files will be imported from or exported to.
        """
        return pulumi.get(self, "data_repository_path")

    @data_repository_path.setter
    def data_repository_path(self, value: pulumi.Input[str]):
        pulumi.set(self, "data_repository_path", value)

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> pulumi.Input[str]:
        """
        The globally unique ID of the file system, assigned by Amazon FSx.
        """
        return pulumi.get(self, "file_system_id")

    @file_system_id.setter
    def file_system_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "file_system_id", value)

    @property
    @pulumi.getter(name="fileSystemPath")
    def file_system_path(self) -> pulumi.Input[str]:
        """
        This path specifies where in your file system files will be exported from or imported to. This file system directory can be linked to only one Amazon S3 bucket, and no other S3 bucket can be linked to the directory.
        """
        return pulumi.get(self, "file_system_path")

    @file_system_path.setter
    def file_system_path(self, value: pulumi.Input[str]):
        pulumi.set(self, "file_system_path", value)

    @property
    @pulumi.getter(name="batchImportMetaDataOnCreate")
    def batch_import_meta_data_on_create(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean flag indicating whether an import data repository task to import metadata should run after the data repository association is created. The task runs if this flag is set to true.
        """
        return pulumi.get(self, "batch_import_meta_data_on_create")

    @batch_import_meta_data_on_create.setter
    def batch_import_meta_data_on_create(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "batch_import_meta_data_on_create", value)

    @property
    @pulumi.getter(name="importedFileChunkSize")
    def imported_file_chunk_size(self) -> Optional[pulumi.Input[int]]:
        """
        For files imported from a data repository, this value determines the stripe count and maximum amount of data per file (in MiB) stored on a single physical disk. The maximum number of disks that a single file can be striped across is limited by the total number of disks that make up the file system.
        """
        return pulumi.get(self, "imported_file_chunk_size")

    @imported_file_chunk_size.setter
    def imported_file_chunk_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "imported_file_chunk_size", value)

    @property
    @pulumi.getter
    def s3(self) -> Optional[pulumi.Input['DataRepositoryAssociationS3Args']]:
        """
        The configuration for an Amazon S3 data repository linked to an Amazon FSx Lustre file system with a data repository association. The configuration defines which file events (new, changed, or deleted files or directories) are automatically imported from the linked data repository to the file system or automatically exported from the file system to the data repository.
        """
        return pulumi.get(self, "s3")

    @s3.setter
    def s3(self, value: Optional[pulumi.Input['DataRepositoryAssociationS3Args']]):
        pulumi.set(self, "s3", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DataRepositoryAssociationTagArgs']]]]:
        """
        A list of Tag values, with a maximum of 50 elements.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DataRepositoryAssociationTagArgs']]]]):
        pulumi.set(self, "tags", value)


class DataRepositoryAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 batch_import_meta_data_on_create: Optional[pulumi.Input[bool]] = None,
                 data_repository_path: Optional[pulumi.Input[str]] = None,
                 file_system_id: Optional[pulumi.Input[str]] = None,
                 file_system_path: Optional[pulumi.Input[str]] = None,
                 imported_file_chunk_size: Optional[pulumi.Input[int]] = None,
                 s3: Optional[pulumi.Input[pulumi.InputType['DataRepositoryAssociationS3Args']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DataRepositoryAssociationTagArgs']]]]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::FSx::DataRepositoryAssociation

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] batch_import_meta_data_on_create: A boolean flag indicating whether an import data repository task to import metadata should run after the data repository association is created. The task runs if this flag is set to true.
        :param pulumi.Input[str] data_repository_path: The path to the Amazon S3 data repository that will be linked to the file system. The path can be an S3 bucket or prefix in the format s3://myBucket/myPrefix/ . This path specifies where in the S3 data repository files will be imported from or exported to.
        :param pulumi.Input[str] file_system_id: The globally unique ID of the file system, assigned by Amazon FSx.
        :param pulumi.Input[str] file_system_path: This path specifies where in your file system files will be exported from or imported to. This file system directory can be linked to only one Amazon S3 bucket, and no other S3 bucket can be linked to the directory.
        :param pulumi.Input[int] imported_file_chunk_size: For files imported from a data repository, this value determines the stripe count and maximum amount of data per file (in MiB) stored on a single physical disk. The maximum number of disks that a single file can be striped across is limited by the total number of disks that make up the file system.
        :param pulumi.Input[pulumi.InputType['DataRepositoryAssociationS3Args']] s3: The configuration for an Amazon S3 data repository linked to an Amazon FSx Lustre file system with a data repository association. The configuration defines which file events (new, changed, or deleted files or directories) are automatically imported from the linked data repository to the file system or automatically exported from the file system to the data repository.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DataRepositoryAssociationTagArgs']]]] tags: A list of Tag values, with a maximum of 50 elements.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DataRepositoryAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::FSx::DataRepositoryAssociation

        :param str resource_name: The name of the resource.
        :param DataRepositoryAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DataRepositoryAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 batch_import_meta_data_on_create: Optional[pulumi.Input[bool]] = None,
                 data_repository_path: Optional[pulumi.Input[str]] = None,
                 file_system_id: Optional[pulumi.Input[str]] = None,
                 file_system_path: Optional[pulumi.Input[str]] = None,
                 imported_file_chunk_size: Optional[pulumi.Input[int]] = None,
                 s3: Optional[pulumi.Input[pulumi.InputType['DataRepositoryAssociationS3Args']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DataRepositoryAssociationTagArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DataRepositoryAssociationArgs.__new__(DataRepositoryAssociationArgs)

            __props__.__dict__["batch_import_meta_data_on_create"] = batch_import_meta_data_on_create
            if data_repository_path is None and not opts.urn:
                raise TypeError("Missing required property 'data_repository_path'")
            __props__.__dict__["data_repository_path"] = data_repository_path
            if file_system_id is None and not opts.urn:
                raise TypeError("Missing required property 'file_system_id'")
            __props__.__dict__["file_system_id"] = file_system_id
            if file_system_path is None and not opts.urn:
                raise TypeError("Missing required property 'file_system_path'")
            __props__.__dict__["file_system_path"] = file_system_path
            __props__.__dict__["imported_file_chunk_size"] = imported_file_chunk_size
            __props__.__dict__["s3"] = s3
            __props__.__dict__["tags"] = tags
            __props__.__dict__["association_id"] = None
            __props__.__dict__["resource_arn"] = None
        super(DataRepositoryAssociation, __self__).__init__(
            'aws-native:fsx:DataRepositoryAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'DataRepositoryAssociation':
        """
        Get an existing DataRepositoryAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = DataRepositoryAssociationArgs.__new__(DataRepositoryAssociationArgs)

        __props__.__dict__["association_id"] = None
        __props__.__dict__["batch_import_meta_data_on_create"] = None
        __props__.__dict__["data_repository_path"] = None
        __props__.__dict__["file_system_id"] = None
        __props__.__dict__["file_system_path"] = None
        __props__.__dict__["imported_file_chunk_size"] = None
        __props__.__dict__["resource_arn"] = None
        __props__.__dict__["s3"] = None
        __props__.__dict__["tags"] = None
        return DataRepositoryAssociation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="associationId")
    def association_id(self) -> pulumi.Output[str]:
        """
        The system-generated, unique ID of the data repository association.
        """
        return pulumi.get(self, "association_id")

    @property
    @pulumi.getter(name="batchImportMetaDataOnCreate")
    def batch_import_meta_data_on_create(self) -> pulumi.Output[Optional[bool]]:
        """
        A boolean flag indicating whether an import data repository task to import metadata should run after the data repository association is created. The task runs if this flag is set to true.
        """
        return pulumi.get(self, "batch_import_meta_data_on_create")

    @property
    @pulumi.getter(name="dataRepositoryPath")
    def data_repository_path(self) -> pulumi.Output[str]:
        """
        The path to the Amazon S3 data repository that will be linked to the file system. The path can be an S3 bucket or prefix in the format s3://myBucket/myPrefix/ . This path specifies where in the S3 data repository files will be imported from or exported to.
        """
        return pulumi.get(self, "data_repository_path")

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> pulumi.Output[str]:
        """
        The globally unique ID of the file system, assigned by Amazon FSx.
        """
        return pulumi.get(self, "file_system_id")

    @property
    @pulumi.getter(name="fileSystemPath")
    def file_system_path(self) -> pulumi.Output[str]:
        """
        This path specifies where in your file system files will be exported from or imported to. This file system directory can be linked to only one Amazon S3 bucket, and no other S3 bucket can be linked to the directory.
        """
        return pulumi.get(self, "file_system_path")

    @property
    @pulumi.getter(name="importedFileChunkSize")
    def imported_file_chunk_size(self) -> pulumi.Output[Optional[int]]:
        """
        For files imported from a data repository, this value determines the stripe count and maximum amount of data per file (in MiB) stored on a single physical disk. The maximum number of disks that a single file can be striped across is limited by the total number of disks that make up the file system.
        """
        return pulumi.get(self, "imported_file_chunk_size")

    @property
    @pulumi.getter(name="resourceARN")
    def resource_arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify Amazon Web Services resources. We require an ARN when you need to specify a resource unambiguously across all of Amazon Web Services. For more information, see Amazon Resource Names (ARNs) in the Amazon Web Services General Reference.
        """
        return pulumi.get(self, "resource_arn")

    @property
    @pulumi.getter
    def s3(self) -> pulumi.Output[Optional['outputs.DataRepositoryAssociationS3']]:
        """
        The configuration for an Amazon S3 data repository linked to an Amazon FSx Lustre file system with a data repository association. The configuration defines which file events (new, changed, or deleted files or directories) are automatically imported from the linked data repository to the file system or automatically exported from the file system to the data repository.
        """
        return pulumi.get(self, "s3")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.DataRepositoryAssociationTag']]]:
        """
        A list of Tag values, with a maximum of 50 elements.
        """
        return pulumi.get(self, "tags")

