# alvin-api-client
No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.1.0
- Package version: 0.7.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python >= 3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import alvin_api_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import alvin_api_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import alvin_api_client
from pprint import pprint
from alvin_api_client.api import default_api
from alvin_api_client.model.admin_config import AdminConfig
from alvin_api_client.model.alvin_description_request import AlvinDescriptionRequest
from alvin_api_client.model.auth_provider import AuthProvider
from alvin_api_client.model.client_config import ClientConfig
from alvin_api_client.model.client_config_post_auth import ClientConfigPostAuth
from alvin_api_client.model.connection_direction import ConnectionDirection
from alvin_api_client.model.connection_type import ConnectionType
from alvin_api_client.model.connection_usage_classification import ConnectionUsageClassification
from alvin_api_client.model.data_entity_delete_tag_connection_request import DataEntityDeleteTagConnectionRequest
from alvin_api_client.model.data_entity_get import DataEntityGet
from alvin_api_client.model.data_entity_id import DataEntityID
from alvin_api_client.model.data_entity_lineage_v2_request import DataEntityLineageV2Request
from alvin_api_client.model.data_entity_lineage_v2_response import DataEntityLineageV2Response
from alvin_api_client.model.data_entity_numerical_stat_response import DataEntityNumericalStatResponse
from alvin_api_client.model.data_entity_save_tag_connection_request import DataEntitySaveTagConnectionRequest
from alvin_api_client.model.data_entity_type import DataEntityType
from alvin_api_client.model.data_entity_usage_stats_report import DataEntityUsageStatsReport
from alvin_api_client.model.data_entity_usage_stats_request import DataEntityUsageStatsRequest
from alvin_api_client.model.data_platform_big_query_create import DataPlatformBigQueryCreate
from alvin_api_client.model.data_platform_delete import DataPlatformDelete
from alvin_api_client.model.data_platform_full import DataPlatformFull
from alvin_api_client.model.data_platform_get import DataPlatformGet
from alvin_api_client.model.data_platform_hive_create import DataPlatformHiveCreate
from alvin_api_client.model.data_platform_hive_glue_create import DataPlatformHiveGlueCreate
from alvin_api_client.model.data_platform_job_step import DataPlatformJobStep
from alvin_api_client.model.data_platform_job_step_aggregated_report import DataPlatformJobStepAggregatedReport
from alvin_api_client.model.data_platform_job_step_report_type import DataPlatformJobStepReportType
from alvin_api_client.model.data_platform_job_step_request import DataPlatformJobStepRequest
from alvin_api_client.model.data_platform_job_step_user import DataPlatformJobStepUser
from alvin_api_client.model.data_platform_looker_create import DataPlatformLookerCreate
from alvin_api_client.model.data_platform_mode_create import DataPlatformModeCreate
from alvin_api_client.model.data_platform_my_sql_create import DataPlatformMySQLCreate
from alvin_api_client.model.data_platform_postgres_create import DataPlatformPostgresCreate
from alvin_api_client.model.data_platform_power_bi_create import DataPlatformPowerBICreate
from alvin_api_client.model.data_platform_redshift_create import DataPlatformRedshiftCreate
from alvin_api_client.model.data_platform_snowflake_create import DataPlatformSnowflakeCreate
from alvin_api_client.model.data_platform_tableau_create import DataPlatformTableauCreate
from alvin_api_client.model.data_platform_type import DataPlatformType
from alvin_api_client.model.data_tag_bulk_apply import DataTagBulkApply
from alvin_api_client.model.data_tag_bulk_delete import DataTagBulkDelete
from alvin_api_client.model.data_tag_request import DataTagRequest
from alvin_api_client.model.data_tag_request_delete import DataTagRequestDelete
from alvin_api_client.model.data_tag_rules_request_delete import DataTagRulesRequestDelete
from alvin_api_client.model.data_tag_type import DataTagType
from alvin_api_client.model.data_taxonomy_classification import DataTaxonomyClassification
from alvin_api_client.model.email_login_request import EmailLoginRequest
from alvin_api_client.model.exchange_token_request import ExchangeTokenRequest
from alvin_api_client.model.experience import Experience
from alvin_api_client.model.experience_data import ExperienceData
from alvin_api_client.model.filter_options import FilterOptions
from alvin_api_client.model.filters_response import FiltersResponse
from alvin_api_client.model.http_validation_error import HTTPValidationError
from alvin_api_client.model.impact_analysis_query_validation import ImpactAnalysisQueryValidation
from alvin_api_client.model.impact_analysis_request import ImpactAnalysisRequest
from alvin_api_client.model.impact_analysis_v2_response import ImpactAnalysisV2Response
from alvin_api_client.model.impact_analysis_validation_payload import ImpactAnalysisValidationPayload
from alvin_api_client.model.job_query_v1_response import JobQueryV1Response
from alvin_api_client.model.limit_offset_page_api_keys_response import LimitOffsetPageAPIKeysResponse
from alvin_api_client.model.limit_offset_page_data_entity_get import LimitOffsetPageDataEntityGet
from alvin_api_client.model.limit_offset_page_data_entity_numerical_stat import LimitOffsetPageDataEntityNumericalStat
from alvin_api_client.model.limit_offset_page_data_entity_usage_stat_raw import LimitOffsetPageDataEntityUsageStatRaw
from alvin_api_client.model.limit_offset_page_data_entity_usage_stats_report import LimitOffsetPageDataEntityUsageStatsReport
from alvin_api_client.model.limit_offset_page_data_platform_job import LimitOffsetPageDataPlatformJob
from alvin_api_client.model.limit_offset_page_data_platform_job_entity_aggregated_report import LimitOffsetPageDataPlatformJobEntityAggregatedReport
from alvin_api_client.model.limit_offset_page_data_tag_connection_get import LimitOffsetPageDataTagConnectionGet
from alvin_api_client.model.limit_offset_page_data_tag_get import LimitOffsetPageDataTagGet
from alvin_api_client.model.limit_offset_page_data_tag_rule_get import LimitOffsetPageDataTagRuleGet
from alvin_api_client.model.notification import Notification
from alvin_api_client.model.processed_lineage_graph_data import ProcessedLineageGraphData
from alvin_api_client.model.search_node import SearchNode
from alvin_api_client.model.search_v2_response import SearchV2Response
from alvin_api_client.model.tiny_url_response import TinyURLResponse
from alvin_api_client.model.token import Token
from alvin_api_client.model.unknownbasetype import UNKNOWNBASETYPE
from alvin_api_client.model.user_activity_request import UserActivityRequest
from alvin_api_client.model.user_activity_response import UserActivityResponse
from alvin_api_client.model.user_get import UserGet
from alvin_api_client.model.user_organization_api_key_request import UserOrganizationAPIKeyRequest
from alvin_api_client.model.user_organization_api_key_response import UserOrganizationAPIKeyResponse
# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = alvin_api_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization: HTTPBearer
configuration = alvin_api_client.Configuration(
    access_token = 'YOUR_BEARER_TOKEN'
)


# Enter a context with an instance of the API client
with alvin_api_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = default_api.DefaultApi(api_client)
    user_activity_request = UserActivityRequest(
        event_type=UserActivityType("ASSET_VIEW"),
        event_payload=None,
    ) # UserActivityRequest |  (optional)

    try:
        # Add User Stat
        api_response = api_instance.add_user_stat_api_v2_user_analytics_add_post(user_activity_request=user_activity_request)
        pprint(api_response)
    except alvin_api_client.ApiException as e:
        print("Exception when calling DefaultApi->add_user_stat_api_v2_user_analytics_add_post: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**add_user_stat_api_v2_user_analytics_add_post**](docs/DefaultApi.md#add_user_stat_api_v2_user_analytics_add_post) | **POST** /api/v2/user/analytics/add | Add User Stat
*DefaultApi* | [**bulk_apply_api_v1_tags_bulk_apply_post**](docs/DefaultApi.md#bulk_apply_api_v1_tags_bulk_apply_post) | **POST** /api/v1/tags/bulk-apply | Bulk Apply
*DefaultApi* | [**bulk_delete_api_v1_tags_bulk_delete_delete**](docs/DefaultApi.md#bulk_delete_api_v1_tags_bulk_delete_delete) | **DELETE** /api/v1/tags/bulk-delete | Bulk Delete
*DefaultApi* | [**create_api_key_api_v1_api_key_post**](docs/DefaultApi.md#create_api_key_api_v1_api_key_post) | **POST** /api/v1/api-key | Create Api Key
*DefaultApi* | [**create_bigquery_platform_api_v1_platforms_bigquery_post**](docs/DefaultApi.md#create_bigquery_platform_api_v1_platforms_bigquery_post) | **POST** /api/v1/platforms/bigquery | Create Bigquery Platform
*DefaultApi* | [**create_hive_platform_api_v1_platforms_hive_post**](docs/DefaultApi.md#create_hive_platform_api_v1_platforms_hive_post) | **POST** /api/v1/platforms/hive | Create Hive Platform
*DefaultApi* | [**create_hiveglue_platform_api_v1_platforms_hiveglue_post**](docs/DefaultApi.md#create_hiveglue_platform_api_v1_platforms_hiveglue_post) | **POST** /api/v1/platforms/hiveglue | Create Hiveglue Platform
*DefaultApi* | [**create_looker_platform_api_v1_platforms_looker_post**](docs/DefaultApi.md#create_looker_platform_api_v1_platforms_looker_post) | **POST** /api/v1/platforms/looker | Create Looker Platform
*DefaultApi* | [**create_mode_platform_api_v1_platforms_mode_post**](docs/DefaultApi.md#create_mode_platform_api_v1_platforms_mode_post) | **POST** /api/v1/platforms/mode | Create Mode Platform
*DefaultApi* | [**create_mysql_platform_api_v1_platforms_mysql_post**](docs/DefaultApi.md#create_mysql_platform_api_v1_platforms_mysql_post) | **POST** /api/v1/platforms/mysql | Create Mysql Platform
*DefaultApi* | [**create_postgres_platform_api_v1_platforms_postgres_post**](docs/DefaultApi.md#create_postgres_platform_api_v1_platforms_postgres_post) | **POST** /api/v1/platforms/postgres | Create Postgres Platform
*DefaultApi* | [**create_powerbi_platform_api_v1_platforms_powerbi_post**](docs/DefaultApi.md#create_powerbi_platform_api_v1_platforms_powerbi_post) | **POST** /api/v1/platforms/powerbi | Create Powerbi Platform
*DefaultApi* | [**create_redshift_platform_api_v1_platforms_redshift_post**](docs/DefaultApi.md#create_redshift_platform_api_v1_platforms_redshift_post) | **POST** /api/v1/platforms/redshift | Create Redshift Platform
*DefaultApi* | [**create_snowflake_platform_api_v1_platforms_snowflake_post**](docs/DefaultApi.md#create_snowflake_platform_api_v1_platforms_snowflake_post) | **POST** /api/v1/platforms/snowflake | Create Snowflake Platform
*DefaultApi* | [**create_tableau_platform_api_v1_platforms_tableau_post**](docs/DefaultApi.md#create_tableau_platform_api_v1_platforms_tableau_post) | **POST** /api/v1/platforms/tableau | Create Tableau Platform
*DefaultApi* | [**create_update_entity_description_api_v1_entity_alvin_description_post**](docs/DefaultApi.md#create_update_entity_description_api_v1_entity_alvin_description_post) | **POST** /api/v1/entity/alvin-description | Create Update Entity Description
*DefaultApi* | [**delete_api_key_api_v1_api_keys_api_key_prefix_delete**](docs/DefaultApi.md#delete_api_key_api_v1_api_keys_api_key_prefix_delete) | **DELETE** /api/v1/api-keys/{api_key_prefix} | Delete Api Key
*DefaultApi* | [**delete_platform_api_v1_platforms_platform_id_delete**](docs/DefaultApi.md#delete_platform_api_v1_platforms_platform_id_delete) | **DELETE** /api/v1/platforms/{platform_id} | Delete Platform
*DefaultApi* | [**delete_tag_rules_api_v1_tags_rules_delete**](docs/DefaultApi.md#delete_tag_rules_api_v1_tags_rules_delete) | **DELETE** /api/v1/tags/rules | Delete Tag Rules
*DefaultApi* | [**delete_tags_api_v1_tags_delete**](docs/DefaultApi.md#delete_tags_api_v1_tags_delete) | **DELETE** /api/v1/tags | Delete Tags
*DefaultApi* | [**delete_tags_entity_connections_api_v1_entity_tags_delete**](docs/DefaultApi.md#delete_tags_entity_connections_api_v1_entity_tags_delete) | **DELETE** /api/v1/entity/tags | Delete Tags Entity Connections
*DefaultApi* | [**email_login_api_v1_auth_email_login_post**](docs/DefaultApi.md#email_login_api_v1_auth_email_login_post) | **POST** /api/v1/auth/email-login | Email Login
*DefaultApi* | [**exchange_token_api_v1_auth_exchange_token_post**](docs/DefaultApi.md#exchange_token_api_v1_auth_exchange_token_post) | **POST** /api/v1/auth/exchange-token | Exchange Token
*DefaultApi* | [**expand_node_children_api_v1_lineage_node_expand_children_post**](docs/DefaultApi.md#expand_node_children_api_v1_lineage_node_expand_children_post) | **POST** /api/v1/lineage/node/expand-children | Expand Node Children
*DefaultApi* | [**find_data_entity_dependencies_api_v1_entity_dependency_get**](docs/DefaultApi.md#find_data_entity_dependencies_api_v1_entity_dependency_get) | **GET** /api/v1/entity/dependency | Find Data Entity Dependencies
*DefaultApi* | [**find_entity_by_id_api_v1_entity_find_get**](docs/DefaultApi.md#find_entity_by_id_api_v1_entity_find_get) | **GET** /api/v1/entity/find | Find Entity By Id
*DefaultApi* | [**get_admin_config_api_v1_admin_config_get**](docs/DefaultApi.md#get_admin_config_api_v1_admin_config_get) | **GET** /api/v1/admin-config | Get Admin Config
*DefaultApi* | [**get_all_taxonomy_classifications_api_v1_taxonomy_all_get**](docs/DefaultApi.md#get_all_taxonomy_classifications_api_v1_taxonomy_all_get) | **GET** /api/v1/taxonomy/all | Get All Taxonomy Classifications
*DefaultApi* | [**get_api_key_info_api_v1_api_keys_get**](docs/DefaultApi.md#get_api_key_info_api_v1_api_keys_get) | **GET** /api/v1/api-keys | Get Api Key Info
*DefaultApi* | [**get_bigquery_platform_api_v1_platforms_bigquery_platform_id_get**](docs/DefaultApi.md#get_bigquery_platform_api_v1_platforms_bigquery_platform_id_get) | **GET** /api/v1/platforms/bigquery/{platform_id} | Get Bigquery Platform
*DefaultApi* | [**get_child_taxonomy_classification_api_v1_taxonomy_children_classification_get**](docs/DefaultApi.md#get_child_taxonomy_classification_api_v1_taxonomy_children_classification_get) | **GET** /api/v1/taxonomy/children/{classification} | Get Child Taxonomy Classification
*DefaultApi* | [**get_client_config_api_v1_client_config_get**](docs/DefaultApi.md#get_client_config_api_v1_client_config_get) | **GET** /api/v1/client-config | Get Client Config
*DefaultApi* | [**get_client_config_post_auth_api_v1_client_config_post_auth_get**](docs/DefaultApi.md#get_client_config_post_auth_api_v1_client_config_post_auth_get) | **GET** /api/v1/client-config-post-auth | Get Client Config Post Auth
*DefaultApi* | [**get_data_entity_run_facets_api_v1_entity_runs_run_id_facets_get**](docs/DefaultApi.md#get_data_entity_run_facets_api_v1_entity_runs_run_id_facets_get) | **GET** /api/v1/entity/runs/{runId}/facets | Get Data Entity Run Facets
*DefaultApi* | [**get_data_entity_runs_api_v1_entity_runs_get**](docs/DefaultApi.md#get_data_entity_runs_api_v1_entity_runs_get) | **GET** /api/v1/entity/runs | Get Data Entity Runs
*DefaultApi* | [**get_data_entity_runs_by_id_api_v1_entity_runs_run_id_get**](docs/DefaultApi.md#get_data_entity_runs_by_id_api_v1_entity_runs_run_id_get) | **GET** /api/v1/entity/runs/{runId} | Get Data Entity Runs By Id
*DefaultApi* | [**get_entities_usage_stats_post_api_v1_entities_usage_stats_post**](docs/DefaultApi.md#get_entities_usage_stats_post_api_v1_entities_usage_stats_post) | **POST** /api/v1/entities/usage-stats | Get Entities Usage Stats Post
*DefaultApi* | [**get_entity_api_v1_entity_get**](docs/DefaultApi.md#get_entity_api_v1_entity_get) | **GET** /api/v1/entity | Get Entity
*DefaultApi* | [**get_entity_children_api_v1_entity_children_get**](docs/DefaultApi.md#get_entity_children_api_v1_entity_children_get) | **GET** /api/v1/entity-children | Get Entity Children
*DefaultApi* | [**get_entity_children_api_v1_most_recent_entity_numerical_stats_get**](docs/DefaultApi.md#get_entity_children_api_v1_most_recent_entity_numerical_stats_get) | **GET** /api/v1/most-recent-entity-numerical-stats | Get Entity Children
*DefaultApi* | [**get_entity_data_taxonomy_api_v1_entity_taxonomy_get**](docs/DefaultApi.md#get_entity_data_taxonomy_api_v1_entity_taxonomy_get) | **GET** /api/v1/entity/taxonomy | Get Entity Data Taxonomy
*DefaultApi* | [**get_entity_jobs_api_v1_entity_jobs_get**](docs/DefaultApi.md#get_entity_jobs_api_v1_entity_jobs_get) | **GET** /api/v1/entity-jobs | Get Entity Jobs
*DefaultApi* | [**get_entity_lineage_api_v2_lineage_post**](docs/DefaultApi.md#get_entity_lineage_api_v2_lineage_post) | **POST** /api/v2/lineage | Get Entity Lineage
*DefaultApi* | [**get_entity_numerical_stats_api_v1_get_entity_numerical_stats_get**](docs/DefaultApi.md#get_entity_numerical_stats_api_v1_get_entity_numerical_stats_get) | **GET** /api/v1/get-entity-numerical-stats | Get Entity Numerical Stats
*DefaultApi* | [**get_entity_owner_id_api_v1_entity_owner_get**](docs/DefaultApi.md#get_entity_owner_id_api_v1_entity_owner_get) | **GET** /api/v1/entity/owner | Get Entity Owner Id
*DefaultApi* | [**get_entity_parents_api_v1_entity_parents_get**](docs/DefaultApi.md#get_entity_parents_api_v1_entity_parents_get) | **GET** /api/v1/entity-parents | Get Entity Parents
*DefaultApi* | [**get_entity_schema_api_v1_entity_entity_schema_get**](docs/DefaultApi.md#get_entity_schema_api_v1_entity_entity_schema_get) | **GET** /api/v1/entity/entity-schema | Get Entity Schema
*DefaultApi* | [**get_entity_siblings_api_v1_entity_siblings_get**](docs/DefaultApi.md#get_entity_siblings_api_v1_entity_siblings_get) | **GET** /api/v1/entity-siblings | Get Entity Siblings
*DefaultApi* | [**get_entity_tags_api_v1_entity_tags_get**](docs/DefaultApi.md#get_entity_tags_api_v1_entity_tags_get) | **GET** /api/v1/entity/tags | Get Entity Tags
*DefaultApi* | [**get_entity_usage_stats_api_v1_entity_usage_stats_get**](docs/DefaultApi.md#get_entity_usage_stats_api_v1_entity_usage_stats_get) | **GET** /api/v1/entity/usage-stats | Get Entity Usage Stats
*DefaultApi* | [**get_entity_usage_stats_raw_api_v1_entity_usage_stats_raw_get**](docs/DefaultApi.md#get_entity_usage_stats_raw_api_v1_entity_usage_stats_raw_get) | **GET** /api/v1/entity/usage-stats-raw | Get Entity Usage Stats Raw
*DefaultApi* | [**get_experiences_api_v1_experience_get**](docs/DefaultApi.md#get_experiences_api_v1_experience_get) | **GET** /api/v1/experience | Get Experiences
*DefaultApi* | [**get_filter_api_v2_filters_get**](docs/DefaultApi.md#get_filter_api_v2_filters_get) | **GET** /api/v2/filters | Get Filter
*DefaultApi* | [**get_filters_config_api_v1_filters_config_get**](docs/DefaultApi.md#get_filters_config_api_v1_filters_config_get) | **GET** /api/v1/filters/config | Get Filters Config
*DefaultApi* | [**get_hive_platform_api_v1_platforms_hive_platform_id_get**](docs/DefaultApi.md#get_hive_platform_api_v1_platforms_hive_platform_id_get) | **GET** /api/v1/platforms/hive/{platform_id} | Get Hive Platform
*DefaultApi* | [**get_hiveglue_platform_api_v1_platforms_hiveglue_platform_id_get**](docs/DefaultApi.md#get_hiveglue_platform_api_v1_platforms_hiveglue_platform_id_get) | **GET** /api/v1/platforms/hiveglue/{platform_id} | Get Hiveglue Platform
*DefaultApi* | [**get_impact_by_query_api_v2_impact_analysis_query_post**](docs/DefaultApi.md#get_impact_by_query_api_v2_impact_analysis_query_post) | **POST** /api/v2/impact-analysis/query | Get Impact By Query
*DefaultApi* | [**get_impact_from_validation_payload_api_v2_impact_analysis_query_entities_post**](docs/DefaultApi.md#get_impact_from_validation_payload_api_v2_impact_analysis_query_entities_post) | **POST** /api/v2/impact-analysis/query-entities | Get Impact From Validation Payload
*DefaultApi* | [**get_job_steps_aggregated_stats_api_v1_job_steps_aggregated_stats_get**](docs/DefaultApi.md#get_job_steps_aggregated_stats_api_v1_job_steps_aggregated_stats_get) | **GET** /api/v1/job/steps/aggregated-stats | Get Job Steps Aggregated Stats
*DefaultApi* | [**get_job_steps_api_v1_jobs_steps_post**](docs/DefaultApi.md#get_job_steps_api_v1_jobs_steps_post) | **POST** /api/v1/jobs/steps | Get Job Steps
*DefaultApi* | [**get_jobs_steps_aggregated_stats_api_v1_jobs_steps_aggregated_stats_get**](docs/DefaultApi.md#get_jobs_steps_aggregated_stats_api_v1_jobs_steps_aggregated_stats_get) | **GET** /api/v1/jobs/steps/aggregated-stats | Get Jobs Steps Aggregated Stats
*DefaultApi* | [**get_jobs_users_api_v1_jobs_users_post**](docs/DefaultApi.md#get_jobs_users_api_v1_jobs_users_post) | **POST** /api/v1/jobs/users | Get Jobs Users
*DefaultApi* | [**get_last_job_query_api_v1_job_query_get**](docs/DefaultApi.md#get_last_job_query_api_v1_job_query_get) | **GET** /api/v1/job/query | Get Last Job Query
*DefaultApi* | [**get_lineage_job_steps_api_v1_lineage_jobs_steps_get**](docs/DefaultApi.md#get_lineage_job_steps_api_v1_lineage_jobs_steps_get) | **GET** /api/v1/lineage/jobs/steps | Get Lineage Job Steps
*DefaultApi* | [**get_looker_platform_api_v1_platforms_looker_platform_id_get**](docs/DefaultApi.md#get_looker_platform_api_v1_platforms_looker_platform_id_get) | **GET** /api/v1/platforms/looker/{platform_id} | Get Looker Platform
*DefaultApi* | [**get_mode_platform_api_v1_platforms_mode_platform_id_get**](docs/DefaultApi.md#get_mode_platform_api_v1_platforms_mode_platform_id_get) | **GET** /api/v1/platforms/mode/{platform_id} | Get Mode Platform
*DefaultApi* | [**get_mysql_platform_api_v1_platforms_mysql_platform_id_get**](docs/DefaultApi.md#get_mysql_platform_api_v1_platforms_mysql_platform_id_get) | **GET** /api/v1/platforms/mysql/{platform_id} | Get Mysql Platform
*DefaultApi* | [**get_notifications_api_v1_notifications_get**](docs/DefaultApi.md#get_notifications_api_v1_notifications_get) | **GET** /api/v1/notifications | Get Notifications
*DefaultApi* | [**get_parent_taxonomy_classifications_api_v1_taxonomy_parents_get**](docs/DefaultApi.md#get_parent_taxonomy_classifications_api_v1_taxonomy_parents_get) | **GET** /api/v1/taxonomy/parents | Get Parent Taxonomy Classifications
*DefaultApi* | [**get_platform_api_v1_platforms_platform_id_get**](docs/DefaultApi.md#get_platform_api_v1_platforms_platform_id_get) | **GET** /api/v1/platforms/{platform_id} | Get Platform
*DefaultApi* | [**get_platforms_api_v1_platforms_get**](docs/DefaultApi.md#get_platforms_api_v1_platforms_get) | **GET** /api/v1/platforms | Get Platforms
*DefaultApi* | [**get_popular_user_entities_api_v2_user_entities_popular_get**](docs/DefaultApi.md#get_popular_user_entities_api_v2_user_entities_popular_get) | **GET** /api/v2/user/entities/popular | Get Popular User Entities
*DefaultApi* | [**get_postgres_platform_api_v1_platforms_postgres_platform_id_get**](docs/DefaultApi.md#get_postgres_platform_api_v1_platforms_postgres_platform_id_get) | **GET** /api/v1/platforms/postgres/{platform_id} | Get Postgres Platform
*DefaultApi* | [**get_powerbi_platform_api_v1_platforms_powerbi_platform_id_get**](docs/DefaultApi.md#get_powerbi_platform_api_v1_platforms_powerbi_platform_id_get) | **GET** /api/v1/platforms/powerbi/{platform_id} | Get Powerbi Platform
*DefaultApi* | [**get_recent_user_entities_api_v2_user_entities_recent_get**](docs/DefaultApi.md#get_recent_user_entities_api_v2_user_entities_recent_get) | **GET** /api/v2/user/entities/recent | Get Recent User Entities
*DefaultApi* | [**get_redshift_platform_api_v1_platforms_redshift_platform_id_get**](docs/DefaultApi.md#get_redshift_platform_api_v1_platforms_redshift_platform_id_get) | **GET** /api/v1/platforms/redshift/{platform_id} | Get Redshift Platform
*DefaultApi* | [**get_snowflake_platform_api_v1_platforms_snowflake_platform_id_get**](docs/DefaultApi.md#get_snowflake_platform_api_v1_platforms_snowflake_platform_id_get) | **GET** /api/v1/platforms/snowflake/{platform_id} | Get Snowflake Platform
*DefaultApi* | [**get_tableau_platform_api_v1_platforms_tableau_platform_id_get**](docs/DefaultApi.md#get_tableau_platform_api_v1_platforms_tableau_platform_id_get) | **GET** /api/v1/platforms/tableau/{platform_id} | Get Tableau Platform
*DefaultApi* | [**get_tag_rules_api_v1_tags_rules_get**](docs/DefaultApi.md#get_tag_rules_api_v1_tags_rules_get) | **GET** /api/v1/tags/rules | Get Tag Rules
*DefaultApi* | [**get_tags_api_v1_tags_get**](docs/DefaultApi.md#get_tags_api_v1_tags_get) | **GET** /api/v1/tags | Get Tags
*DefaultApi* | [**get_top_level_entities_api_v1_top_entities_get**](docs/DefaultApi.md#get_top_level_entities_api_v1_top_entities_get) | **GET** /api/v1/top-entities | Get Top Level Entities
*DefaultApi* | [**get_top_level_entities_by_platform_api_v1_top_entities_platform_id_get**](docs/DefaultApi.md#get_top_level_entities_by_platform_api_v1_top_entities_platform_id_get) | **GET** /api/v1/top-entities/{platformId} | Get Top Level Entities By Platform
*DefaultApi* | [**get_user_id_api_v1_user_id_get**](docs/DefaultApi.md#get_user_id_api_v1_user_id_get) | **GET** /api/v1/user/id | Get User Id
*DefaultApi* | [**get_user_info_api_v1_me_get**](docs/DefaultApi.md#get_user_info_api_v1_me_get) | **GET** /api/v1/me | Get User Info
*DefaultApi* | [**get_user_popular_searches_api_v2_user_search_popular_get**](docs/DefaultApi.md#get_user_popular_searches_api_v2_user_search_popular_get) | **GET** /api/v2/user/search/popular | Get User Popular Searches
*DefaultApi* | [**get_user_recent_searches_api_v2_user_search_recent_get**](docs/DefaultApi.md#get_user_recent_searches_api_v2_user_search_recent_get) | **GET** /api/v2/user/search/recent | Get User Recent Searches
*DefaultApi* | [**get_users_by_id_api_v1_users_get**](docs/DefaultApi.md#get_users_by_id_api_v1_users_get) | **GET** /api/v1/users | Get Users By Id
*DefaultApi* | [**get_users_in_org_api_v1_org_users_get**](docs/DefaultApi.md#get_users_in_org_api_v1_org_users_get) | **GET** /api/v1/org-users | Get Users In Org
*DefaultApi* | [**lineage_api_v1_lineage_post**](docs/DefaultApi.md#lineage_api_v1_lineage_post) | **POST** /api/v1/lineage | Lineage
*DefaultApi* | [**metadata_api_v1_metadata_post**](docs/DefaultApi.md#metadata_api_v1_metadata_post) | **POST** /api/v1/metadata | Metadata
*DefaultApi* | [**register_interest_api_v1_experiences_register_interest_post**](docs/DefaultApi.md#register_interest_api_v1_experiences_register_interest_post) | **POST** /api/v1/experiences/register-interest | Register Interest
*DefaultApi* | [**request_access_api_v1_experiences_request_access_post**](docs/DefaultApi.md#request_access_api_v1_experiences_request_access_post) | **POST** /api/v1/experiences/request-access | Request Access
*DefaultApi* | [**save_tag_api_v1_tags_post**](docs/DefaultApi.md#save_tag_api_v1_tags_post) | **POST** /api/v1/tags | Save Tag
*DefaultApi* | [**save_tags_entity_connections_api_v1_entity_tags_post**](docs/DefaultApi.md#save_tags_entity_connections_api_v1_entity_tags_post) | **POST** /api/v1/entity/tags | Save Tags Entity Connections
*DefaultApi* | [**search_api_v2_search_all_post**](docs/DefaultApi.md#search_api_v2_search_all_post) | **POST** /api/v2/search/all | Search
*DefaultApi* | [**search_entities_api_v2_search_get**](docs/DefaultApi.md#search_entities_api_v2_search_get) | **GET** /api/v2/search | Search Entities
*DefaultApi* | [**search_entities_stats_post_api_v1_search_entities_usage_stats_post**](docs/DefaultApi.md#search_entities_stats_post_api_v1_search_entities_usage_stats_post) | **POST** /api/v1/search/entities/usage-stats | Search Entities Stats Post
*DefaultApi* | [**search_with_nodes_api_v2_search_nodes_post**](docs/DefaultApi.md#search_with_nodes_api_v2_search_nodes_post) | **POST** /api/v2/search_nodes | Search With Nodes
*DefaultApi* | [**sync_platform_rpc_api_v1_platforms_platform_id_rpc_sync_get**](docs/DefaultApi.md#sync_platform_rpc_api_v1_platforms_platform_id_rpc_sync_get) | **GET** /api/v1/platforms/{platform_id}/rpc-sync | Sync Platform Rpc
*DefaultApi* | [**sync_sheet_api_v1_sync_sheet_get**](docs/DefaultApi.md#sync_sheet_api_v1_sync_sheet_get) | **GET** /api/v1/sync-sheet | Sync Sheet
*DefaultApi* | [**test_bigquery_platform_api_v1_platforms_bigquery_test_post**](docs/DefaultApi.md#test_bigquery_platform_api_v1_platforms_bigquery_test_post) | **POST** /api/v1/platforms/bigquery-test | Test Bigquery Platform
*DefaultApi* | [**test_hive_platform_api_v1_platforms_hive_test_post**](docs/DefaultApi.md#test_hive_platform_api_v1_platforms_hive_test_post) | **POST** /api/v1/platforms/hive-test | Test Hive Platform
*DefaultApi* | [**test_hiveglue_platform_api_v1_platforms_hiveglue_test_post**](docs/DefaultApi.md#test_hiveglue_platform_api_v1_platforms_hiveglue_test_post) | **POST** /api/v1/platforms/hiveglue-test | Test Hiveglue Platform
*DefaultApi* | [**test_looker_platform_api_v1_platforms_looker_test_post**](docs/DefaultApi.md#test_looker_platform_api_v1_platforms_looker_test_post) | **POST** /api/v1/platforms/looker-test | Test Looker Platform
*DefaultApi* | [**test_mode_platform_api_v1_platforms_mode_test_post**](docs/DefaultApi.md#test_mode_platform_api_v1_platforms_mode_test_post) | **POST** /api/v1/platforms/mode-test | Test Mode Platform
*DefaultApi* | [**test_mysql_platform_api_v1_platforms_mysql_test_post**](docs/DefaultApi.md#test_mysql_platform_api_v1_platforms_mysql_test_post) | **POST** /api/v1/platforms/mysql-test | Test Mysql Platform
*DefaultApi* | [**test_postgres_platform_api_v1_platforms_postgres_test_post**](docs/DefaultApi.md#test_postgres_platform_api_v1_platforms_postgres_test_post) | **POST** /api/v1/platforms/postgres-test | Test Postgres Platform
*DefaultApi* | [**test_powerbi_platform_api_v1_platforms_powerbi_test_post**](docs/DefaultApi.md#test_powerbi_platform_api_v1_platforms_powerbi_test_post) | **POST** /api/v1/platforms/powerbi-test | Test Powerbi Platform
*DefaultApi* | [**test_redshift_platform_api_v1_platforms_redshift_test_post**](docs/DefaultApi.md#test_redshift_platform_api_v1_platforms_redshift_test_post) | **POST** /api/v1/platforms/redshift-test | Test Redshift Platform
*DefaultApi* | [**test_snowflake_platform_api_v1_platforms_snowflake_test_post**](docs/DefaultApi.md#test_snowflake_platform_api_v1_platforms_snowflake_test_post) | **POST** /api/v1/platforms/snowflake-test | Test Snowflake Platform
*DefaultApi* | [**test_tableau_platform_api_v1_platforms_tableau_test_post**](docs/DefaultApi.md#test_tableau_platform_api_v1_platforms_tableau_test_post) | **POST** /api/v1/platforms/tableau-test | Test Tableau Platform
*DefaultApi* | [**tinyurl_api_v1_tinyurl_get**](docs/DefaultApi.md#tinyurl_api_v1_tinyurl_get) | **GET** /api/v1/tinyurl | Tinyurl
*DefaultApi* | [**validate_impact_analysis_query_api_v2_impact_analysis_validate_query_post**](docs/DefaultApi.md#validate_impact_analysis_query_api_v2_impact_analysis_validate_query_post) | **POST** /api/v2/impact-analysis/validate-query | Validate Impact Analysis Query


## Documentation For Models

 - [APIKeyScope](docs/APIKeyScope.md)
 - [APIKeyStatus](docs/APIKeyStatus.md)
 - [APIKeysResponse](docs/APIKeysResponse.md)
 - [AdminConfig](docs/AdminConfig.md)
 - [AlterParseResult](docs/AlterParseResult.md)
 - [AlterType](docs/AlterType.md)
 - [AlvinDescriptionRequest](docs/AlvinDescriptionRequest.md)
 - [AuthProvider](docs/AuthProvider.md)
 - [BiPlatform](docs/BiPlatform.md)
 - [BigQueryAccountDetails](docs/BigQueryAccountDetails.md)
 - [BigQueryAdditionalConfig](docs/BigQueryAdditionalConfig.md)
 - [ClassificationMatchType](docs/ClassificationMatchType.md)
 - [ClassificationType](docs/ClassificationType.md)
 - [ClientAuthConfig](docs/ClientAuthConfig.md)
 - [ClientConfig](docs/ClientConfig.md)
 - [ClientConfigPostAuth](docs/ClientConfigPostAuth.md)
 - [ColumnAlter](docs/ColumnAlter.md)
 - [ColumnTarget](docs/ColumnTarget.md)
 - [ComparisonOperator](docs/ComparisonOperator.md)
 - [ConfigType](docs/ConfigType.md)
 - [ConnectionDirection](docs/ConnectionDirection.md)
 - [ConnectionType](docs/ConnectionType.md)
 - [ConnectionUsageClassification](docs/ConnectionUsageClassification.md)
 - [DataEntityConnection](docs/DataEntityConnection.md)
 - [DataEntityConnectionGet](docs/DataEntityConnectionGet.md)
 - [DataEntityConnectionType](docs/DataEntityConnectionType.md)
 - [DataEntityDeleteTagConnectionRequest](docs/DataEntityDeleteTagConnectionRequest.md)
 - [DataEntityDetail](docs/DataEntityDetail.md)
 - [DataEntityGet](docs/DataEntityGet.md)
 - [DataEntityID](docs/DataEntityID.md)
 - [DataEntityJobStep](docs/DataEntityJobStep.md)
 - [DataEntityLineage](docs/DataEntityLineage.md)
 - [DataEntityLineageData](docs/DataEntityLineageData.md)
 - [DataEntityLineageGraphEdge](docs/DataEntityLineageGraphEdge.md)
 - [DataEntityLineageGraphNode](docs/DataEntityLineageGraphNode.md)
 - [DataEntityLineageResult](docs/DataEntityLineageResult.md)
 - [DataEntityLineageV2Request](docs/DataEntityLineageV2Request.md)
 - [DataEntityLineageV2Response](docs/DataEntityLineageV2Response.md)
 - [DataEntityNumericalStat](docs/DataEntityNumericalStat.md)
 - [DataEntityNumericalStatResponse](docs/DataEntityNumericalStatResponse.md)
 - [DataEntityNumericalStatType](docs/DataEntityNumericalStatType.md)
 - [DataEntitySaveTagConnectionRequest](docs/DataEntitySaveTagConnectionRequest.md)
 - [DataEntitySubType](docs/DataEntitySubType.md)
 - [DataEntityType](docs/DataEntityType.md)
 - [DataEntityUsageStat](docs/DataEntityUsageStat.md)
 - [DataEntityUsageStatRaw](docs/DataEntityUsageStatRaw.md)
 - [DataEntityUsageStatsReport](docs/DataEntityUsageStatsReport.md)
 - [DataEntityUsageStatsRequest](docs/DataEntityUsageStatsRequest.md)
 - [DataEntityUsageType](docs/DataEntityUsageType.md)
 - [DataPlatformAggregatedJobStat](docs/DataPlatformAggregatedJobStat.md)
 - [DataPlatformBigQueryCreate](docs/DataPlatformBigQueryCreate.md)
 - [DataPlatformDelete](docs/DataPlatformDelete.md)
 - [DataPlatformFull](docs/DataPlatformFull.md)
 - [DataPlatformGet](docs/DataPlatformGet.md)
 - [DataPlatformHiveCreate](docs/DataPlatformHiveCreate.md)
 - [DataPlatformHiveGlueCreate](docs/DataPlatformHiveGlueCreate.md)
 - [DataPlatformJob](docs/DataPlatformJob.md)
 - [DataPlatformJobEntityAggregatedReport](docs/DataPlatformJobEntityAggregatedReport.md)
 - [DataPlatformJobExecutionStatus](docs/DataPlatformJobExecutionStatus.md)
 - [DataPlatformJobStat](docs/DataPlatformJobStat.md)
 - [DataPlatformJobStep](docs/DataPlatformJobStep.md)
 - [DataPlatformJobStepAggregatedReport](docs/DataPlatformJobStepAggregatedReport.md)
 - [DataPlatformJobStepExecutionStatus](docs/DataPlatformJobStepExecutionStatus.md)
 - [DataPlatformJobStepId](docs/DataPlatformJobStepId.md)
 - [DataPlatformJobStepReportType](docs/DataPlatformJobStepReportType.md)
 - [DataPlatformJobStepRequest](docs/DataPlatformJobStepRequest.md)
 - [DataPlatformJobStepSubType](docs/DataPlatformJobStepSubType.md)
 - [DataPlatformJobStepUser](docs/DataPlatformJobStepUser.md)
 - [DataPlatformJobType](docs/DataPlatformJobType.md)
 - [DataPlatformLookerCreate](docs/DataPlatformLookerCreate.md)
 - [DataPlatformModeCreate](docs/DataPlatformModeCreate.md)
 - [DataPlatformMySQLCreate](docs/DataPlatformMySQLCreate.md)
 - [DataPlatformPostgresCreate](docs/DataPlatformPostgresCreate.md)
 - [DataPlatformPowerBICreate](docs/DataPlatformPowerBICreate.md)
 - [DataPlatformRedshiftCreate](docs/DataPlatformRedshiftCreate.md)
 - [DataPlatformSnowflakeCreate](docs/DataPlatformSnowflakeCreate.md)
 - [DataPlatformStatus](docs/DataPlatformStatus.md)
 - [DataPlatformTableauCreate](docs/DataPlatformTableauCreate.md)
 - [DataPlatformType](docs/DataPlatformType.md)
 - [DataTag](docs/DataTag.md)
 - [DataTagBulkApply](docs/DataTagBulkApply.md)
 - [DataTagBulkDelete](docs/DataTagBulkDelete.md)
 - [DataTagClassificationType](docs/DataTagClassificationType.md)
 - [DataTagConnectionGet](docs/DataTagConnectionGet.md)
 - [DataTagCreatedIn](docs/DataTagCreatedIn.md)
 - [DataTagGet](docs/DataTagGet.md)
 - [DataTagRequest](docs/DataTagRequest.md)
 - [DataTagRequestDelete](docs/DataTagRequestDelete.md)
 - [DataTagRule](docs/DataTagRule.md)
 - [DataTagRuleEntityType](docs/DataTagRuleEntityType.md)
 - [DataTagRuleGet](docs/DataTagRuleGet.md)
 - [DataTagRulePropagation](docs/DataTagRulePropagation.md)
 - [DataTagRuleType](docs/DataTagRuleType.md)
 - [DataTagRulesRequestDelete](docs/DataTagRulesRequestDelete.md)
 - [DataTagStatus](docs/DataTagStatus.md)
 - [DataTagType](docs/DataTagType.md)
 - [DataTaxonomyClassification](docs/DataTaxonomyClassification.md)
 - [DatadogSettings](docs/DatadogSettings.md)
 - [DeleteParseResult](docs/DeleteParseResult.md)
 - [DropParseResult](docs/DropParseResult.md)
 - [DropType](docs/DropType.md)
 - [ElementPosition](docs/ElementPosition.md)
 - [EmailLoginRequest](docs/EmailLoginRequest.md)
 - [EntityGraphConnectorEdge](docs/EntityGraphConnectorEdge.md)
 - [EntityGraphNode](docs/EntityGraphNode.md)
 - [EntityGraphNodeConnector](docs/EntityGraphNodeConnector.md)
 - [EnvironmentConfig](docs/EnvironmentConfig.md)
 - [EventType](docs/EventType.md)
 - [ExchangeTokenRequest](docs/ExchangeTokenRequest.md)
 - [Experience](docs/Experience.md)
 - [ExperienceData](docs/ExperienceData.md)
 - [ExperienceStatus](docs/ExperienceStatus.md)
 - [ExperienceUser](docs/ExperienceUser.md)
 - [ExperiencesSettings](docs/ExperiencesSettings.md)
 - [ExtractedSimpleColumn](docs/ExtractedSimpleColumn.md)
 - [ExtractedSimpleTable](docs/ExtractedSimpleTable.md)
 - [FilterDataPayload](docs/FilterDataPayload.md)
 - [FilterMatch](docs/FilterMatch.md)
 - [FilterOptions](docs/FilterOptions.md)
 - [FilterType](docs/FilterType.md)
 - [FilterView](docs/FilterView.md)
 - [FiltersResponse](docs/FiltersResponse.md)
 - [FirebaseAuthProvider](docs/FirebaseAuthProvider.md)
 - [FirebaseAuthUIConfig](docs/FirebaseAuthUIConfig.md)
 - [GroupType](docs/GroupType.md)
 - [HTMLValues](docs/HTMLValues.md)
 - [HTTPValidationError](docs/HTTPValidationError.md)
 - [HiveAccountDetails](docs/HiveAccountDetails.md)
 - [HiveAdditionalConfig](docs/HiveAdditionalConfig.md)
 - [HiveGlueAccountDetails](docs/HiveGlueAccountDetails.md)
 - [HiveGlueAdditionalConfig](docs/HiveGlueAdditionalConfig.md)
 - [ImpactAnalysisPlatformRequest](docs/ImpactAnalysisPlatformRequest.md)
 - [ImpactAnalysisQueryReport](docs/ImpactAnalysisQueryReport.md)
 - [ImpactAnalysisQueryRequest](docs/ImpactAnalysisQueryRequest.md)
 - [ImpactAnalysisQueryValidation](docs/ImpactAnalysisQueryValidation.md)
 - [ImpactAnalysisRequest](docs/ImpactAnalysisRequest.md)
 - [ImpactAnalysisSidebarDataNode](docs/ImpactAnalysisSidebarDataNode.md)
 - [ImpactAnalysisV2EntityRow](docs/ImpactAnalysisV2EntityRow.md)
 - [ImpactAnalysisV2JobRow](docs/ImpactAnalysisV2JobRow.md)
 - [ImpactAnalysisV2Response](docs/ImpactAnalysisV2Response.md)
 - [ImpactAnalysisV2ResponseStatus](docs/ImpactAnalysisV2ResponseStatus.md)
 - [ImpactAnalysisValidationPayload](docs/ImpactAnalysisValidationPayload.md)
 - [ImpactStatus](docs/ImpactStatus.md)
 - [JobEntityID](docs/JobEntityID.md)
 - [JobEntityUsageStatsReport](docs/JobEntityUsageStatsReport.md)
 - [JobQueryV1Response](docs/JobQueryV1Response.md)
 - [JobStepsAggResponseModel](docs/JobStepsAggResponseModel.md)
 - [KnownColumn](docs/KnownColumn.md)
 - [KnownTable](docs/KnownTable.md)
 - [KnownTableType](docs/KnownTableType.md)
 - [LimitOffsetPageAPIKeysResponse](docs/LimitOffsetPageAPIKeysResponse.md)
 - [LimitOffsetPageDataEntityGet](docs/LimitOffsetPageDataEntityGet.md)
 - [LimitOffsetPageDataEntityNumericalStat](docs/LimitOffsetPageDataEntityNumericalStat.md)
 - [LimitOffsetPageDataEntityUsageStatRaw](docs/LimitOffsetPageDataEntityUsageStatRaw.md)
 - [LimitOffsetPageDataEntityUsageStatsReport](docs/LimitOffsetPageDataEntityUsageStatsReport.md)
 - [LimitOffsetPageDataPlatformJob](docs/LimitOffsetPageDataPlatformJob.md)
 - [LimitOffsetPageDataPlatformJobEntityAggregatedReport](docs/LimitOffsetPageDataPlatformJobEntityAggregatedReport.md)
 - [LimitOffsetPageDataTagConnectionGet](docs/LimitOffsetPageDataTagConnectionGet.md)
 - [LimitOffsetPageDataTagGet](docs/LimitOffsetPageDataTagGet.md)
 - [LimitOffsetPageDataTagRuleGet](docs/LimitOffsetPageDataTagRuleGet.md)
 - [LineageConnectionType](docs/LineageConnectionType.md)
 - [LookerAdditionalConfig](docs/LookerAdditionalConfig.md)
 - [LookerCredentials](docs/LookerCredentials.md)
 - [LookerQueryComment](docs/LookerQueryComment.md)
 - [ModeAdditionalConfig](docs/ModeAdditionalConfig.md)
 - [ModeCredentials](docs/ModeCredentials.md)
 - [MySQLAccountDetails](docs/MySQLAccountDetails.md)
 - [MySQLAdditionalConfig](docs/MySQLAdditionalConfig.md)
 - [Notification](docs/Notification.md)
 - [NotificationConfig](docs/NotificationConfig.md)
 - [NotificationProvider](docs/NotificationProvider.md)
 - [NotificationType](docs/NotificationType.md)
 - [OnboardingLevel](docs/OnboardingLevel.md)
 - [OperatorType](docs/OperatorType.md)
 - [PageSearchDisplayPayload](docs/PageSearchDisplayPayload.md)
 - [PlatformBuildData](docs/PlatformBuildData.md)
 - [PlatformBuildType](docs/PlatformBuildType.md)
 - [PopularityValues](docs/PopularityValues.md)
 - [Position](docs/Position.md)
 - [PostgresAccountDetails](docs/PostgresAccountDetails.md)
 - [PostgresAdditionalConfig](docs/PostgresAdditionalConfig.md)
 - [PowerBIAdditionalConfig](docs/PowerBIAdditionalConfig.md)
 - [PowerBICredentials](docs/PowerBICredentials.md)
 - [PredefinedFilter](docs/PredefinedFilter.md)
 - [ProcessedLineageGraphData](docs/ProcessedLineageGraphData.md)
 - [ProductConfig](docs/ProductConfig.md)
 - [QueryBuilder](docs/QueryBuilder.md)
 - [QueryComment](docs/QueryComment.md)
 - [QueryCreateMode](docs/QueryCreateMode.md)
 - [QueryFingerprint](docs/QueryFingerprint.md)
 - [QueryLineageParseResult](docs/QueryLineageParseResult.md)
 - [QueryParseResult](docs/QueryParseResult.md)
 - [QueryType](docs/QueryType.md)
 - [RedshiftAccountDetails](docs/RedshiftAccountDetails.md)
 - [RedshiftAdditionalConfig](docs/RedshiftAdditionalConfig.md)
 - [RuleElement](docs/RuleElement.md)
 - [RuleElementValueType](docs/RuleElementValueType.md)
 - [RuleType](docs/RuleType.md)
 - [RuleValue](docs/RuleValue.md)
 - [SearchDisplayPayload](docs/SearchDisplayPayload.md)
 - [SearchNode](docs/SearchNode.md)
 - [SearchPrefix](docs/SearchPrefix.md)
 - [SearchUsageStatType](docs/SearchUsageStatType.md)
 - [SearchV2Response](docs/SearchV2Response.md)
 - [SearchV2ResponsePayload](docs/SearchV2ResponsePayload.md)
 - [SeenTableAtLevel](docs/SeenTableAtLevel.md)
 - [SheetSettings](docs/SheetSettings.md)
 - [SnowflakeAccountDetails](docs/SnowflakeAccountDetails.md)
 - [SnowflakeAdditionalConfig](docs/SnowflakeAdditionalConfig.md)
 - [SqlTable](docs/SqlTable.md)
 - [StatDataPayload](docs/StatDataPayload.md)
 - [TableAlter](docs/TableAlter.md)
 - [TableExistence](docs/TableExistence.md)
 - [TableInsert](docs/TableInsert.md)
 - [TableMerge](docs/TableMerge.md)
 - [TableMergeAction](docs/TableMergeAction.md)
 - [TableMergeMatchActionType](docs/TableMergeMatchActionType.md)
 - [TableMergeMatchType](docs/TableMergeMatchType.md)
 - [TableUpdate](docs/TableUpdate.md)
 - [TableauAdditionalConfig](docs/TableauAdditionalConfig.md)
 - [TableauCredentials](docs/TableauCredentials.md)
 - [TaxonomyClassificationConfig](docs/TaxonomyClassificationConfig.md)
 - [TinyURLResponse](docs/TinyURLResponse.md)
 - [Token](docs/Token.md)
 - [TreeResultClassification](docs/TreeResultClassification.md)
 - [TruncateResult](docs/TruncateResult.md)
 - [UserActivityRequest](docs/UserActivityRequest.md)
 - [UserActivityResponse](docs/UserActivityResponse.md)
 - [UserActivityType](docs/UserActivityType.md)
 - [UserGet](docs/UserGet.md)
 - [UserNameUsageStat](docs/UserNameUsageStat.md)
 - [UserOrganizationAPIKeyRequest](docs/UserOrganizationAPIKeyRequest.md)
 - [UserOrganizationAPIKeyResponse](docs/UserOrganizationAPIKeyResponse.md)
 - [UserPersona](docs/UserPersona.md)
 - [UserRole](docs/UserRole.md)
 - [ValidationError](docs/ValidationError.md)


## Documentation For Authorization


## HTTPBearer

- **Type**: Bearer authentication


## Author




## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in alvin_api_client.apis and alvin_api_client.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from alvin_api_client.api.default_api import DefaultApi`
- `from alvin_api_client.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import alvin_api_client
from alvin_api_client.apis import *
from alvin_api_client.models import *
```

