# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['jml']

package_data = \
{'': ['*']}

entry_points = \
{'console_scripts': ['jml = jml.jml:main']}

setup_kwargs = {
    'name': 'jml',
    'version': '0.3.2',
    'description': 'Ein Tool um Projektversionen zu generieren',
    'long_description': '=======================\nJava Musterlösung (jml)\n=======================\n\nJava Musterlösung (kurz ``jml``) ist ein kleines Skript mit dem mehrere Projektversionen aus einer Musterlösung generiert werden können.\n\n``jml`` wurde ursprünglich für Java-Projekte entwickelt, kann aber durch diverse Optionen auch für andere Projekte genutzt werden.\n\nMotivation\n----------\n\nZur Differenzierung im Informatikunterricht erstelle ich gerne mehrere Projektversionen mit mehr oder weniger Hilfestellungen, um dem Leistungsstand der Schülerinnen und Schüler besser gerecht zu werden. Inklusive einer Musterlösung können so schnell drei bis vier Projektversionen entstehen, die parallel weiterentwickelt werden müssen.\n\nBefindet sich ein Fehler im Code, sollen die Aufgaben angepasst werden oder hat sich einfach ein Rechtschreibfehler in einen Kommentar eingeschlichen, müssen alle Projektversionen angepasst werden. Dabei habe ich schnell mal eine Version vergessen oder einen neuen Fehler eingebaut.\n\nVor einigen Jahren habe ich den Prozess mit ``jml`` vereinfacht. Das Skript generiert aus einer Basisversion, die mit Markierungen für Aufgaben und Lösungen versehen ist, die verschiedenen Projektversionen, die für den Unterricht nötig sind. Anpassungen sind nur noch im Basisprojekt notwendig.\n\nBeispiele zur Verwendung finden sich in `meinen Projekt-Repository`_ und den\ndazugehörigen `Projektversionen`_.\n\n.. _meinen Projekt-Repository: http://github.com/jneug/schule-projekte\n.. _Projektversionen: http://github.com/jneug/schule-versionen\n\nInstallation\n------------\n\nDie Installation wird wie gewohnt mit pypi durchgeführt:\n\n.. code-block:: console\n\n   $ pip3 install jml\n\nBei erfolgreicher Installation ist nun das ``jml`` Kommando verfügbar.\n\n.. code-block:: console\n\n   $ jml --version\n   jml, version 0.3.2\n\nManuelle Installation\n^^^^^^^^^^^^^^^^^^^^^\n\n``jml`` kann auch ohne ``pip`` einfach als Skriptdatei genutzt werden. Dazu die aktuelle Version der Datei `jml.py <https://github.com/jneug/jml/blob/main/src/jml/jml.py>`_ aus dem Repository kopieren und auf der Festplatte speichern. Das Skript kann dann mit Python 3 ausgeführt werden:\n\n.. code-block:: console\n\n   $ python3 jml.py --version\n   jml, version 0.3.2\n\n\nBenutzung\n---------\n\n``jml`` benötigt im einfachsten Fall den Pfad des Basisprojektes und den Pfad des Ausgabeordners:\n\n.. code-block:: console\n\n   $ jml pfad/zum/Basisprojekt --out pfad/zum/ausgabeordner\n\nNach Ausführung befinden sich in ``pfad/zum/ausgabeordner`` die Musterlösung und die Projektversionen.\n\nDie Inhalte und Anzahl an Versionen werden durch die Inhalte der Dateien im Basisprojekt bestimmt.\n\nAngenommen in ``Basisprojekt`` liegt eine Datei mit dem Namen ``Beispiel.java`` mit folgendem Inhalt:\n\n.. code-block:: java\n\n    class Beispiel {\n        /*aufg*\n        // TODO: Erstelle eine Objektvariable "zahl" vom Typ int\n        *aufg*/\n        //ml*\n        private int zahl;\n        //*ml\n\n        public int add( int pAndereZahl ) {\n            /*aufg*\n            // TODO: Gib die Summe aus der Objektvariablen "zahl" und "pAndereZahl" zurück.\n            return 0;\n            *aufg*/\n            //ml*\n            return zahl + pAndereZahl;\n            //*ml\n        }\n    }\n\nDann erzeugt ``jml`` diese Ordnerstruktur in ``pfad/zum/ausgabeordner``::\n\n    pfad/zum/ausgabeordner/\n    ├── Basisprojekt/\n    │   └── Beispiel.java\n    └── Basisprojekt_ML/\n        └── Beispiel.java\n\nInhalt von ``Basisprojekt_ML/Beispiel.java``:\n\n.. code-block:: java\n\n    class Beispiel {\n        private int zahl;\n\n        public int add( int pAndereZahl ) {\n            return zahl + pAndereZahl;\n        }\n    }\n\nInhalt von ``Basisprojekt/Beispiel.java``:\n\n.. code-block:: java\n\n    class Beispiel {\n        // TODO: Erstelle eine Objektvariable "zahl" vom Typ int\n\n        public int add( int pAndereZahl ) {\n            // TODO: Gib die Summe aus der Objektvariablen "zahl" und "pAndereZahl" zurück.\n            return 0;\n        }\n    }\n\n\nMehrere Versionen\n^^^^^^^^^^^^^^^^^\n\nAls Standard wird wie oben nur die Projektversion ``0`` erstellt. ``jml`` kann aber auch mehrere Projekte erstellen, wenn die Aufgaben-Markierungen mit einer entsprechenden Nummer versehen werden.\n\nAngenommen die ``Beispiel.java`` von oben sieht so aus:\n\n.. code-block:: java\n\n    class Beispiel {\n        /*aufg*\n        // TODO: Erstelle eine Objektvariable "zahl" vom Typ int\n        *aufg*/\n        //ml*\n        private int zahl;\n        //*ml\n\n        public int add( int pAndereZahl ) {\n            /*aufg*\n            // TODO: Gib die Summe aus der Objektvariablen "zahl" und "pSummand" zurück.\n            return 0;\n            *aufg*/\n            //ml*\n            return zahl + pAndereZahl;\n            //*ml\n        }\n\n        /*aufg* 2\n        public int sub( int pAndereZahl ) {\n            // TODO: Gib die Differenz aus der Objektvariablen "zahl" und "pSummand" zurück.\n            return 0;\n        }\n        *aufg*/\n\n    }\n\nDann werden statt der Version ``0`` die Projektversionen ``1`` und ``2`` erzeugt, da im zweiten Aufgaben-Marker eine konkrete Versionsnummer angegeben wurde::\n\n    pfad/zum/ausgabeordner/\n    ├── Basisprojekt_1/\n    │   └── Beispiel.java\n    ├── Basisprojekt_2/\n    │   └── Beispiel.java\n    └── Basisprojekt_ML/\n        └── Beispiel.java\n\nEs ist auch möglich eine Markierung für mehrere Projektversionen zu nutzen:\n\n.. code-block:: java\n\n    /*aufg* >1\n    // Taucht nur in Projektversionen nach Version 1 auf.\n    *aufg*/\n\n    /*aufg* !=2\n    // Taucht in allen Projektversionen außer 2 auf.\n    *aufg*/\n\n    /*aufg* <=2\n    // Taucht nur in Projektversionen 1 und 2 auf.\n    *aufg*/\n\n\nOptionen\n--------\n\nDie Funktion von ``jml`` ist durch eine Vielzahl von Optionen anpassbar. Die Optionen können als Kommandozeilen-Argumente übergeben, oder in Konfigurationsdateien gespeichert werden.\n\nEine Übersicht der verfügbaren Kommandozeilen-Argumente ist mit ``-h`` abrufbar\n\n.. code-block:: console\n\n   $ jml -h\n\nAlle Optionen (und noch eine Handvoll mehr) lassen sich auch in einer von mehreren Konfigurationsdateien festlegen. ``jml`` sucht dazu bei jedem Start nach ``.jml`` Dateien im Basisprojekt, im Wurzelverzeichnis (``--project-root``) und im Home-Ordner des angemeldeten Nutzers (``~/.jml``).\n\nDie Konfigurationen werden dann in umgekehrter Reihenfolge geladen, die Einstellungen im Basisprojekt haben also die höchste Priorität. Sie werden nur noch von Kommandozeilen-Argumente überschrieben.\n\nFür das Beispiel oben könnte der Aufbau so aussehen::\n\n    ~/\n    ├── .jml\n    ├── pfad/zur/wurzel/\n    │   ├── .jml\n    │   └── Basisprojekt/\n    │       ├── .jml\n    │       └── Beispiel.java\n    └── pfad/zum/ausgabeordner\n\nInhalt von ``~/.jml``:\n\n.. code-block:: ini\n\n   [settings]\n   task open=/*<aufgabe>\n   task close=</aufgabe>*/\n   solution open=//<loesung>\n   solution close=//</loesung>\n\nInhalt von ``~/pfad/zur/wurzel/.jml``:\n\n.. code-block:: ini\n\n   [settings]\n   zip = yes\n   ml suffix = Loesung\n   name format = {project}-{version}\n   include = *.java,*.txt\n\nInhalt von ``~/pfad/zur/wurzel/Basisprojekt/.jml``:\n\n.. code-block:: ini\n\n   [settings]\n   task open=/*aufgabe*\n   task close=*aufgabe*/\n   encoding = iso-8859-1\n   name = Maeusekampf\n\nDer Aufruf von ``jml`` sieht dann so aus:\n\n.. code-block:: console\n\n   $ jml --project-root "~/pfad/zur/wurzel" "~/pfad/zur/wurzel/Basisprojekt"  --out "pfad/zum/ausgabeordner"\n\n``jml`` lädt nun zunächst ``~/.jml`` und setzt die Start- und Endmarkierungen auf eine XML-Variante.\n\nDanach wird ``~/pfad/zur/wurzel/.jml`` geladen, da dies per ``--project-root`` Argument als Wurzelverzeichnis gesetzt wurde. Für diese Projektgruppe werden ZIP-Dateien der Projektversionen erzeugt, außerdem wird das Suffix für die Musterlösung von ``ML`` auf ``Loesung`` geändert. Das Format der Projektnamen wird angepasst (``_`` durch ``-`` ersetzt) und es werden auch ``.txt`` Dateien nach den Aufgaben- und Lösungs-Markierungen durchsucht.\n\nAls drittes wird ``~/pfad/zur/wurzel/Basisprojekt/.jml`` geladen. Hier werden speziell für dieses eine Projekt die Aufgaben-Marker erneut verändert und die Datei-Codierung auf ``iso-8859-1`` (statt ``utf-8``) festgelegt. Schließlich wird noch der Projektname auf ``Maeusekampf`` festgelgt, anstatt den Ordnernamen ``Basisprojekt`` zu verwenden.\n\nDie Ausgabe sieht dann so aus (sofern die Aufgaben- und Lösungs-Markierungen in ``Beispiel.java`` angepasst wurden)::\n\n    ~/\n    ├── .jml\n    ├── pfad/zur/wurzel/\n    │   ├── .jml\n    │   └── Basisprojekt/\n    │       ├── .jml\n    │       └── Beispiel.java\n    └── pfad/zum/ausgabeordner/\n        ├── Maeusekampf-Loesung/\n        │   └── Beispiel.java\n        ├── Maeusekampf-1/\n        │   └── Beispiel.java\n        ├── Maeusekampf-2/\n        │   └── Beispiel.java\n        ├── Maeusekampf-Loesung.zip\n        ├── Maeusekampf-1.zip\n        └── Maeusekampf-2.zip\n\nListe der Optionen\n^^^^^^^^^^^^^^^^^^\n\nDie Tabelle zeigt eine Übersicht aller Optionen, die in einer Konfigurationsdatei oder per Kommandozeilen-Argument gesetzt werden können.\n\n+---------------------------------------+-------------------------+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n|  Optionsname in Konfigurationsdateien | Kommandozeilen-Argument | Beschreibung                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |\n+=======================================+=========================+========================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================+\n| output dir                            | -o / --out              | Legt den Zielordner für die Ausgabe der Projektversionen fest. Beachte, dass der finale Ausgabeordner unterhalb von ``outdir`` abhängig von ``--project-root`` noch variieren kann.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |\n+---------------------------------------+-------------------------+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| name                                  | -n / --name             | Setzt den Namen der erstellten Projektversionen. Im Namensformat wird ``{project}`` durch den Namen ersetzt. Als Standard wird der Ordnername des Basisprojektes verwendet.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            |\n+---------------------------------------+-------------------------+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| name format                           | --name-format           | Legt das Format fest, nach dem die Projektversionen benannt werden. Der Wert ist ein Python-Formatierungsstring und kann die Variablen ``{project}``  für den Namen, ``{version}`` für die Versionsnummer und ``{date}`` für das aktuelle Datum enthalten. Auf diese Weise können Projekte beispielsweise mit einer Jahreszahl versehen werden (``name format = {date:%Y}_{project}-v{version}``). Standard ist ``{project}_{version}``.                                                                                                                                                                                                                                                                                                                                                                                                                               |\n+---------------------------------------+-------------------------+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| task open                             | -to / --tag-open        | Setzt die Anfangsmarkierung für Aufgaben. Die Markierung sollte nach einem öffnenden Block-Kommentar stehen, damit die Aufgabenstellung in der Basisversion auskommentiert ist. Standard ist ``/*aufg*``.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |\n+---------------------------------------+-------------------------+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| task close                            | -tc / --tag-close       | Setzt die Endmarkierung für Aufgaben. Die Markierung sollte vor einem schließenden Block-Kommentar stehen, damit die Aufgabenstellung in der Basisversion auskommentiert ist. Standard ist ``*aufg*/``.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |\n+---------------------------------------+-------------------------+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| task comment prefix                   |                         | Diese Option erlaubt die Modifikation der Zeilen in einer Aufgabe. Wenn die Option auf eine Zeichenkette gesetzt wird, wird in jeder Zeile in einer Aufgabe das erste vorkommen der Zeichenkette entfernt. Auf diese Weise können Aufgaben auch für Programmiersprachen, die keine Blockkommentare unterstützen, aaskommentiert werden. ``task comment prefix = #`` würde zum Beispiel Zeilenkommentare in Python entfernen. Beginnt die Zeichenkette allerdings mit einem ``/``, dann wird in den fortgeschrittenen Modus geschaltet. Hier wird direkt ein regulärer Ausdruck und eine Ersetzung angegeben. Dazu muss der Wert das Format ``/regex/replace/`` haben. ``/`` muss durch ``\\/`` maskiert werden. In jeder Zeile wird dann ``regex`` durch ``replace`` ersetzt. Details sind in der `Python Dokumentation zu regulären Ausdrücken`_ zu finden.            |\n+---------------------------------------+-------------------------+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| solution open                         | -mlo / --ml-open        | Setzt die Anfangsmarkierung für Lösungen. Die Markierung sollte nach einem Zeilen-Kommentar stehen, damit die Musterlösung in der Basisversion lauffähig bleibt. Standard ist ``/ml*``.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |\n+---------------------------------------+-------------------------+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| solution close                        | -mlc / --ml-close       | Setzt die Endmarkierung für Lösungen. Die Markierung sollte nach einem Zeilen-Kommentar stehen, damit die Musterlösung in der Basisversion lauffähig bleibt. Standard ist ``//*ml``.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |\n+---------------------------------------+-------------------------+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| solution comment prefix               |                         | Wie ``task comment prefix`` für Lösungen.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |\n+---------------------------------------+-------------------------+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| solution suffix                       | -mls / --ml-suffix      | Setzt die Versionsnummer der Musterlösung. Standard ist ``ML``.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        |\n+---------------------------------------+-------------------------+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| clear                                 | --no-clear              | Verhindert, dass die Ordner der Projektversionen zuerst vollständig gelöscht werden. Vorhandene Dateien werden dann überschrieben, aber Dateien, die nicht im Basisprojekt sind (oder in den Excludes stehen) werden nicht berührt und verbleiben in den Projektversionen.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |\n+---------------------------------------+-------------------------+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| project root                          | --project-root          | Setzt das Wurzelverzeichnis, anhand dessen die Ordnerstruktur im Zielordner festgelegt wird. Das Verzeichnis sollte ein Elternverzeichnis des Basisprojektes sein. Im Wurzelverzeichnis wird außerdem nach einer ``.jml`` Datei gesucht, die vor der Konfigurationsdatei im Basisprojekt geladen wird.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |\n+---------------------------------------+-------------------------+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| include                               | -i / --include          | Setzt die Liste der `Suchmuster für Dateien`_, in denen nach Aufgaben- und Lösungs-Markierungen gesucht werden soll. Standard ist ``*.java``.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |\n+---------------------------------------+-------------------------+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| +include                              |                         | Auftauchen und ergänzt die Liste der Includes um weitere Suchmuster, anstatt sie zu ersetzen.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |\n+---------------------------------------+-------------------------+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| -include                              |                         | Auftauchen und entfernt Suchmuster aus der Liste der Includes.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |\n+---------------------------------------+-------------------------+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| exclude                               | -e / --exclude          | Setzt die Liste der `Suchmuster für Dateien`_, die komplett ignoriert werden soll. Diese Dateien tauchen nicht in den Projektverisonen auf. Excludes haben Vorrang vor Includes. Standard ist ``*.class,*.ctxt,.DS_Store,Thumbs.db,.vscode,.eclipse,*.iml``.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |\n+---------------------------------------+-------------------------+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| +exclude                              |                         | Ergänzt die Liste der Excludes um weitere Suchmuster, anstatt sie zu ersetzen.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |\n+---------------------------------------+-------------------------+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| -exclude                              |                         | Entfernt Suchmuster aus der Liste der Excludes.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        |\n+---------------------------------------+-------------------------+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| additional files                      |                         | Eine Liste von Dateien, die zusätzlich in alle Projektversionen kopiert werden sollen. Die Dateien werden nicht nach Markierungen durchsucht und exakt kopiert.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        |\n+---------------------------------------+-------------------------+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| +additional files                     |                         | Ergänzt die Liste der zusätzlichen Dateien um weitere Dateien, anstatt sie zu ersetzen.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |\n+---------------------------------------+-------------------------+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| -additional files                     |                         | Entfernt Dateien aus der Liste der zusätzlichen Dateien.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |\n+---------------------------------------+-------------------------+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n|                                       | -v / --versions         | Liste von Versionsnummern von Projektversionen, die erstellt werden sollen. Bezieht sich nicht auf die Musterlösung. Diese kann mit ``--delete-ml`` abgestellt werden.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |\n+---------------------------------------+-------------------------+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| encoding                              | --encoding              | Zeichenkodierung der Dateien. Standard ist ``utf-8``.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |\n+---------------------------------------+-------------------------+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| delete empty files                    | --delete-empty          | Wenn gesetzt werden Dateien, die nach dem kompilieren keinen Inhalt mehr haben, nicht in die Projektversionen kopiert.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |\n+---------------------------------------+-------------------------+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| create zip                            | -z / --zip              | Erstellt zu jeder Projektversion zusätzlich eine ZIP-Datei mit demselben Namen.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        |\n+---------------------------------------+-------------------------+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| create zip only                       |                         | Erstellt nur die ZIP-Dateien. Impliziert ``create zip = yes``.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |\n+---------------------------------------+-------------------------+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| creat zip dir                         |                         | Ausgabeverzeichnis für die ZIP-Dateien, falls dieses von OUT abweicht. Standard ist dasselbe Verzeichnis wie für die Ausgabe der Projektversionen. (Also OUT bzw. ein Unterverzeichnis von OUT, wenn ein Wurzelverzeichnis angegeben wurde.)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |\n+---------------------------------------+-------------------------+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| delete solution                       | --no-ml                 | Löscht die Musterlösung nach Ablauf des Programms. Unabhängig von dieser Einstellung wird die Musterlösung immer als erstes erstellt, um in den Dateien nach Aufgaben-Markierungen zu suchen und so die zu erstellenden Projektversionen zu ermitteln. Diese Einstellung löscht den Ordner der Musterlösung aber danach wieder. Es wird dann auch keine ZIP-Datei mehr erstellt.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |\n+---------------------------------------+-------------------------+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n|                                       | --debug                 | Schaltet die Debug-Ausgaben ein.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |\n+---------------------------------------+-------------------------+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n|                                       | --dry-run               | Schaltet den Debug-Modus ein und gibt alle Änderungen auf der Konsole aus. Es werden aber keine Ordner und Dateien erstellt. Mit dieser Option kann vor der Ausführung geprüft werden, ob die Konfiguration korrekt ist.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |\n+---------------------------------------+-------------------------+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n\n.. _Suchmuster für Dateien: https://docs.python.org/3/library/fnmatch.html\n.. _Python Dokumentation zu regulären Ausdrücken: https://docs.python.org/3/library/re.html\n\nBeispiele\n^^^^^^^^^\n\nDas folgende Beispiel kopiert die ``.class`` Dateien mit in die Projektversionen und ignoriert dafür einige ausgewählte ``.java`` Quelltexte. Dies kann sinnvoll sein, wenn das Projekt einige vordefinierte Klassen enthält (zum Beispiel eine fertige GUI), die von den Schüler:innen aber nicht bearbeitet werden sollen.\n\n.. code-block:: text\n\n    ~/\n    ├── wurzel/verzeichnis/\n    │   ├── .jml\n    │   ├── files/\n    │   │   ├── .gitignore\n    │   │   └── package.bluej\n    │   └── Basisprojekt/\n    │       └── .jml\n    └── ausgabe/ordner\n\nInhalt von ``~/wurzel/verzeichnis/.jml``:\n\n.. code-block:: ini\n\n    [settings]\n    output dir = ~/ausgabe/ordner\n    task open = /*<aufg>\n    task close = </aufg>*/\n    solution open = //<ml>\n    solution close = //</ml>\n    name format = {project}-v{version}\n    create zip only = yes\n    additional files = ~/wurzel/verzeichnis/files/.gitignore,\n        ~/wurzel/verzeichnis/files/package.bluej\n\nInhalt von ``~/wurzel/verzeichnis/Basisprojekt/.jml``:\n\n.. code-block:: ini\n\n    project root = ~/wurzel/verzeichnis\n    +exclude = MyMailGUI.java,MyMailSettingsGUI.java\n    -exclude = *.class\n\nAndere Sprachen\n"""""""""""""""\n\nMit diesen Einstellungen kann ``jml`` zum Beispiel auch für ein HTML-Projekt genutzt werden:\n\n.. code-block:: text\n\n    ~/\n    ├── wurzel/verzeichnis/\n    │   ├── files/\n    │   │   ├── .gitignore\n    │   │   └── package.bluej\n    │   └── Basisprojekt/\n    │   │   ├── .jml\n    │       └── index.html\n    └── ausgabe/ordner\n\nInhalt von ``~/wurzel/verzeichnis/Basisprojekt/.jml``:\n\n.. code-block:: ini\n\n    [settings]\n    task open = <!--aufg\n    task close = aufg-->\n    solution open = <!--ml\n    solution close = ml-->\n    include = *.html,*.htm\n\n\nSprachen ohne Blockkommentare\n"""""""""""""""""""""""""""""\n\nEinige Programmiersprachen (wie Python oder TeX) besitzen keine\nBlock-, sondern nur Zeilenkommentare. Für diese Fälle gibt es die\nOptionen ``task comment prefix`` und ``solution comment prefix``,\nmit denen eine Zeichenkette festgelegt werden kann, die am Anfang\njeder Zeile entfernt wird.\n\n.. code-block:: text\n\n    ~/\n    ├── wurzel/verzeichnis/\n    │   ├── files/\n    │   │   ├── .gitignore\n    │   │   └── package.bluej\n    │   └── Basisprojekt/\n    │   │   ├── .jml\n    │       └── beispiel.py\n    └── ausgabe/ordner\n\nInhalt von ``~/wurzel/verzeichnis/Basisprojekt/.jml``:\n\n.. code-block:: ini\n\n    [settings]\n    task open = # aufgb:\n    task close = # aufg\n    task comment prefix = #\n    solution open = # ml:\n    solution close = # ml\n    include = *.py\n\nErweiterte Ersetzungen\n""""""""""""""""""""""\n\n``task comment prefix`` und ``solution comment prefix`` können auch in einem\nerweiterten Modus genutzt werden. Wenn die Optionen auf einen Wert im Format::\n\n    /regex/replace/\n\ngesetzt wird, wird ``regex`` als regulärer Ausdruck benutzt und die erste\nFundstelle durch ``replace`` ersetzt. Dabei lassen sich auch Gruppen aus\n``regex`` in ``replace`` mit ``\\1``, ``\\2``, usw. referenzieren.\n\nEin Slash ``/`` muss durch ``\\/`` maskiert werden, wenn er in ``regex`` oder\n``replace`` vorkommen soll.\n\nDieser Modus kann hilfreich sein, um komplexere Kommentar-Syntax oder ganz\nandere Einsatzzwecke zu ermöglichen.\n\nDiese ``.jml`` Datei würde die Aufgaben-Markierungen auf ein HTML-Format\nändern und innerhalb des Aufgaben-Blocks in jeder Zeile die Kommentare\nentfernen, die ein ``TODO:`` enthalten.\n\n.. code-block:: ini\n\n    [settings]\n    task open = <!--aufg start-->\n    task close = <!--aufg end-->\n    task comment prefix = /<!-- TODO: (.+) -->/\\\\1/\n\nZum Beispiel würde aus\n\n\n.. code-block:: html\n\n    <!--aufg start-->\n    <!-- Füge hier deine Lösung ein -->\n    <!-- TODO: <div></div> -->\n    <!--aufg end-->\n\ndann die Ausgabe\n\n.. code-block:: html\n\n    <!-- Füge hier deine Lösung ein -->\n    <div></div>\n\nWie man sieht, bleibt der Kommentar ohne ``TODO:`` erhalten.\n\n\nIntegration in IDEs\n-------------------\n\nIn Entwicklungsumgebungen wie `Eclipse`_, `IntelliJ`_ und `vscode`_ lässt\nsich ``jml`` relativ einfach als externes Tool einbinden. Die IDEs erlauben\nin der Regel die Verwendung von Platzhaltervariablen, mit denen der Aufruf\nvon ``jml`` angepasst werden kann.\n\n.. _Eclipse: https://www.eclipse.org\n.. _IntelliJ: https://www.jetbrains.com/idea/\n.. _vscode: https://vscodium.com\n',
    'author': 'J. Neugebauer',
    'author_email': 'ngb@helmholtz-bi.de',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'http://github.com/jneug/jml',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
