/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.html;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import org.owasp.html.AttributePolicy;
import org.owasp.html.ElementPolicy;
import org.owasp.html.HtmlPolicyBuilder;
import org.owasp.html.HtmlTextEscapingMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ElementAndAttributePolicies {
    final String elementName;
    final boolean isVoid;
    final ElementPolicy elPolicy;
    final ImmutableMap<String, AttributePolicy> attrPolicies;
    final boolean skipIfEmpty;

    ElementAndAttributePolicies(String elementName, ElementPolicy elPolicy, Map<? extends String, ? extends AttributePolicy> attrPolicies, boolean skipIfEmpty) {
        this.elementName = elementName;
        this.isVoid = HtmlTextEscapingMode.isVoidElement(elementName);
        this.elPolicy = elPolicy;
        this.attrPolicies = ImmutableMap.copyOf(attrPolicies);
        this.skipIfEmpty = skipIfEmpty;
    }

    ElementAndAttributePolicies and(ElementAndAttributePolicies p) {
        String attrName;
        assert (this.elementName.equals(p.elementName)) : this.elementName + " != " + p.elementName;
        ImmutableMap.Builder<String, AttributePolicy> joinedAttrPolicies = ImmutableMap.builder();
        for (Map.Entry e : this.attrPolicies.entrySet()) {
            attrName = (String)e.getKey();
            AttributePolicy a = (AttributePolicy)e.getValue();
            AttributePolicy b = p.attrPolicies.get(attrName);
            if (b != null) {
                a = AttributePolicy.Util.join(a, b);
            }
            joinedAttrPolicies.put(attrName, a);
        }
        for (Map.Entry e : p.attrPolicies.entrySet()) {
            attrName = (String)e.getKey();
            if (this.attrPolicies.containsKey(attrName)) continue;
            joinedAttrPolicies.put(attrName, (AttributePolicy)e.getValue());
        }
        boolean combinedSkipIfEmpty = HtmlPolicyBuilder.DEFAULT_SKIP_IF_EMPTY.contains(this.elementName) ? this.skipIfEmpty && p.skipIfEmpty : this.skipIfEmpty || p.skipIfEmpty;
        return new ElementAndAttributePolicies(this.elementName, ElementPolicy.Util.join(this.elPolicy, p.elPolicy), joinedAttrPolicies.build(), combinedSkipIfEmpty);
    }

    ElementAndAttributePolicies andGlobals(Map<String, AttributePolicy> globalAttrPolicies) {
        String attrName;
        if (globalAttrPolicies.isEmpty()) {
            return this;
        }
        LinkedHashMap<String, AttributePolicy> anded = null;
        for (Map.Entry<String, AttributePolicy> e : this.attrPolicies.entrySet()) {
            attrName = (String)e.getKey();
            AttributePolicy globalAttrPolicy = globalAttrPolicies.get(attrName);
            if (globalAttrPolicy == null) continue;
            AttributePolicy attrPolicy = e.getValue();
            AttributePolicy joined = AttributePolicy.Util.join(attrPolicy, globalAttrPolicy);
            if (joined.equals(attrPolicy)) continue;
            if (anded == null) {
                anded = Maps.newLinkedHashMap();
                anded.putAll(this.attrPolicies);
            }
            anded.put(attrName, joined);
        }
        for (Map.Entry<String, AttributePolicy> e : globalAttrPolicies.entrySet()) {
            attrName = e.getKey();
            if (this.attrPolicies.containsKey(attrName)) continue;
            if (anded == null) {
                anded = Maps.newLinkedHashMap();
                anded.putAll(this.attrPolicies);
            }
            anded.put(attrName, e.getValue());
        }
        if (anded == null) {
            return this;
        }
        return new ElementAndAttributePolicies(this.elementName, this.elPolicy, anded, this.skipIfEmpty);
    }
}

