/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.generic.log;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.commons.logging.Log;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.app.VelocityEngine;

public class LogSystemCommonsLog
implements Log {
    protected static VelocityEngine handler = null;
    private boolean printStackTrace = false;

    public static void setVelocityEngine(VelocityEngine engine) {
        handler = engine;
    }

    public LogSystemCommonsLog() {
        this("");
    }

    public LogSystemCommonsLog(String name) {
        if (name == null) {
            throw new NullPointerException("Log name cannot be null");
        }
    }

    public LogSystemCommonsLog(boolean pst) {
        this(pst, null);
    }

    public LogSystemCommonsLog(boolean pst, String name) {
        this(name);
        this.printStackTrace = pst;
    }

    private void log(int level, Object message) {
        if (handler != null) {
            switch (level) {
                case 2: {
                    handler.warn(message);
                    break;
                }
                case 1: {
                    handler.info(message);
                    break;
                }
                case 0: {
                    handler.debug(message);
                    break;
                }
                case 3: {
                    handler.error(message);
                    break;
                }
                default: {
                    handler.debug(message);
                    break;
                }
            }
        } else {
            switch (level) {
                case 2: {
                    Velocity.warn(message);
                    break;
                }
                case 1: {
                    Velocity.info(message);
                    break;
                }
                case 0: {
                    Velocity.debug(message);
                    break;
                }
                case 3: {
                    Velocity.error(message);
                    break;
                }
                default: {
                    Velocity.debug(message);
                }
            }
        }
    }

    private void log(int level, Object message, Throwable t) {
        if (this.printStackTrace) {
            StringWriter sw = new StringWriter();
            sw.write(String.valueOf(message));
            t.printStackTrace(new PrintWriter(sw));
            this.log(level, sw);
        } else {
            StringBuffer buffer = new StringBuffer(String.valueOf(message));
            buffer.append(" - ");
            buffer.append(t.getMessage());
            this.log(level, buffer);
        }
    }

    public void trace(Object message) {
        this.log(0, message);
    }

    public void trace(Object message, Throwable t) {
        this.log(0, message, t);
    }

    public void debug(Object message) {
        this.log(0, message);
    }

    public void debug(Object message, Throwable t) {
        this.log(0, message, t);
    }

    public void info(Object message) {
        this.log(1, message);
    }

    public void info(Object message, Throwable t) {
        this.log(1, message, t);
    }

    public void warn(Object message) {
        this.log(2, message);
    }

    public void warn(Object message, Throwable t) {
        this.log(2, message, t);
    }

    public void error(Object message) {
        this.log(3, message);
    }

    public void error(Object message, Throwable t) {
        this.log(3, message, t);
    }

    public void fatal(Object message) {
        this.log(3, message);
    }

    public void fatal(Object message, Throwable t) {
        this.log(3, message, t);
    }

    public boolean isTraceEnabled() {
        return true;
    }

    public boolean isDebugEnabled() {
        return true;
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public boolean isFatalEnabled() {
        return true;
    }
}

